#!/usr/bin/env python

""" This is the src of system level shutdown and reboot module of SSC MSP platform """

import os, sys
import gtk

import locale
import gettext

sys.path.append('./scripts')
import ssc_widget

APP_NAME = "ssc_exit"
# MUSTFIXME  app name must be split out from BIG sc2.

class ccm_exit(gtk.Window):
    btn_poweroff = None
    btn_reboot = None
    lable_tips = None
    lable_status = None
    
    def destroy(*args):
        gtk.main_quit()

    def btn_press_event_cancel(self, widget, event):
        self.destroy()
        return True

    def btn_press_event_poweroff(self, widget, event):
        self.btn_poweroff.set_sensitive(False)
        self.btn_reboot.set_sensitive(False)
        self.btn_cancel.hide()
        self.label_status.set_markup(_("StarOS will be poweroff in several seconds."))
        os.system("poweroff")
        return True

    def btn_press_event_reboot(self, widget, event):
        self.btn_poweroff.set_sensitive(False)
        self.btn_reboot.set_sensitive(False)
        self.btn_cancel.hide()
        self.label_status.set_markup(_("StarOS will be reboot in several seconds."))
        os.system("reboot")
        return True

    def __init__(self):
        # window = gtk.Window(gtk.WINDOW_POPUP)
        # window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        window = gtk.Window()
        # window.set_size_request(320, 205);
        window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
        window.set_decorated(False)
        # window.set_modal(True)
        window.set_keep_above(True)
        window.set_resizable(False)

        window.connect("destroy", self.destroy)

        bg = gtk.Image()
        bg.set_from_file("res/ssc_exit_bg.jpg")
        pixbuf = bg.get_pixbuf()
        window.set_size_request(pixbuf.get_width(), pixbuf.get_height())

        layout = gtk.Layout()
        layout.add(bg)
        
        # cancel button
        btn_img_cancel_1 = gtk.Image()
        btn_img_cancel_2 = gtk.Image()
        btn_img_cancel_3 = gtk.Image()

        btn_img_cancel_1.set_from_file("res/ssc_generic_cancel_1.jpg")
        btn_img_cancel_2.set_from_file("res/ssc_generic_cancel_2.jpg")
        btn_img_cancel_3.set_from_file("res/ssc_generic_cancel_3.jpg")

        self.btn_cancel = ssc_widget.ssc_button(btn_img_cancel_1, btn_img_cancel_2, btn_img_cancel_3)
        self.btn_cancel.connect("button-press-event", self.btn_press_event_cancel)
        
        # poweroff button
        btn_img_poweroff_1 = gtk.Image()
        btn_img_poweroff_2 = gtk.Image()
        btn_img_poweroff_3 = gtk.Image()

        btn_img_poweroff_1.set_from_file("res/ssc_exit_shutdown.jpg")
        btn_img_poweroff_2.set_from_file("res/ssc_exit_shutdown.jpg")
        btn_img_poweroff_3.set_from_file("res/ssc_exit_shutdown.jpg")

        self.btn_poweroff = ssc_widget.ssc_button(btn_img_poweroff_1, btn_img_poweroff_2, btn_img_poweroff_3)

        self.btn_poweroff.connect("button-press-event", self.btn_press_event_poweroff)
        
        # reboot button
        btn_img_reboot_1 = gtk.Image()
        btn_img_reboot_2 = gtk.Image()
        btn_img_reboot_3 = gtk.Image()

        btn_img_reboot_1.set_from_file("res/ssc_exit_reboot.jpg")
        btn_img_reboot_2.set_from_file("res/ssc_exit_reboot.jpg")
        btn_img_reboot_3.set_from_file("res/ssc_exit_reboot.jpg")

        self.btn_reboot = ssc_widget.ssc_button(btn_img_reboot_1, btn_img_reboot_2, btn_img_reboot_3)

        self.btn_reboot.connect("button-press-event", self.btn_press_event_reboot)

        # labels
        label_poweroff = gtk.Label(_("Turn Off (U)"))
        label_reboot = gtk.Label(_("Restart (R)"))
        self.label_status = gtk.Label()
        self.label_tips = gtk.Label()
        self.label_tips.set_markup(_("Exit StarOS."))

        # build layout
        layout.put(self.btn_cancel, 220, 175)
        layout.put(self.btn_poweroff, 60, 78)
        layout.put(label_poweroff, 55, 120)        
        layout.put(self.btn_reboot, 210, 78)
        layout.put(label_reboot, 205, 120)
        layout.put(self.label_status, 90, 175)
        layout.put(self.label_tips, 30, 25)

        window.add(layout)

        window.show_all()

        gtk.main()

if __name__ == '__main__':
    gettext.bindtextdomain(APP_NAME, "/usr/local/share/locale/")
    gettext.textdomain(APP_NAME)
    _ = gettext.gettext
    ccm_exit()
