#!/usr/bin/env python

""" This is the src of system level shutdown and reboot module of SSC MSP platform """

import os
import gtk

import locale
import gettext

import ssc_widget

APP_NAME = "client"
# MUSTFIXME  app name must be split out from BIG sc2.

class ccm_exit(gtk.Window):
    def destroy(*args):
        gtk.main_quit()

    def btn_press_event_cancel(self, widget, event):
        self.destroy()
        return True

    def btn_press_event_poweroff(self, widget, event):
        os.system("poweroff")
        return True

    def btn_press_event_reboot(self, widget, event):
        os.system("reboot")
        return True

    def __init__(self):
        # window = gtk.Window(gtk.WINDOW_POPUP)
        # window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        window = gtk.Window()
        window.set_size_request(320, 205);
        window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
        window.set_decorated(False)
        # window.set_modal(True)
        window.set_keep_above(True)
        window.set_resizable(False)

        window.connect("destroy", self.destroy)

        bg = gtk.Image()
        bg.set_from_file("res/ssc_exit_bg.jpg")

        layout = gtk.Layout()
        layout.add(bg)
        
        # cancel button
        btn_img_cancel_1 = gtk.Image()
        btn_img_cancel_2 = gtk.Image()
        btn_img_cancel_3 = gtk.Image()

        btn_img_cancel_1.set_from_file("res/ssc_generic_cancel_1.jpg")
        btn_img_cancel_2.set_from_file("res/ssc_generic_cancel_2.jpg")
        btn_img_cancel_3.set_from_file("res/ssc_generic_cancel_3.jpg")

        btn_cancel = ssc_widget.ssc_button(btn_img_cancel_1, btn_img_cancel_2, btn_img_cancel_3)

        btn_cancel.connect("button-press-event", self.btn_press_event_cancel)
        
        # poweroff button
        btn_img_poweroff_1 = gtk.Image()
        btn_img_poweroff_2 = gtk.Image()
        btn_img_poweroff_3 = gtk.Image()

        btn_img_poweroff_1.set_from_file("res/ssc_exit_shutdown.jpg")
        btn_img_poweroff_2.set_from_file("res/ssc_exit_shutdown.jpg")
        btn_img_poweroff_3.set_from_file("res/ssc_exit_shutdown.jpg")

        btn_poweroff = ssc_widget.ssc_button(btn_img_poweroff_1, btn_img_poweroff_2, btn_img_poweroff_3)

        btn_poweroff.connect("button-press-event", self.btn_press_event_poweroff)
        
        # reboot button
        btn_img_reboot_1 = gtk.Image()
        btn_img_reboot_2 = gtk.Image()
        btn_img_reboot_3 = gtk.Image()

        btn_img_reboot_1.set_from_file("res/ssc_exit_reboot.jpg")
        btn_img_reboot_2.set_from_file("res/ssc_exit_reboot.jpg")
        btn_img_reboot_3.set_from_file("res/ssc_exit_reboot.jpg")

        btn_reboot = ssc_widget.ssc_button(btn_img_reboot_1, btn_img_reboot_2, btn_img_reboot_3)

        btn_reboot.connect("button-press-event", self.btn_press_event_reboot)

        # labels
        label_poweroff = gtk.Label(_("Turn Off (U)"))
        label_reboot = gtk.Label(_("Restart (R)"))

        # build layout
        layout.put(btn_cancel, 220, 175)
        layout.put(btn_poweroff, 60, 78)
        layout.put(label_poweroff, 55, 120)        
        layout.put(btn_reboot, 210, 78)
        layout.put(label_reboot, 205, 120)

        window.add(layout)

        window.show_all()

        gtk.main()

if __name__ == '__main__':
    gettext.bindtextdomain(APP_NAME, "/usr/local/share/locale/")
    gettext.textdomain(APP_NAME)
    _ = gettext.gettext
    ccm_exit()
