"SSC defined widgets"

import gtk

class ssc_button(gtk.EventBox):
    "SSC defined tri-state button from gtk.EventBox"

    enter_handler = None
    leave_handler = None
    press_handler = None
    release_handler = None
    
    b_normal = False
    b_enter = False
    b_press = False
    
    normal_img = gtk.Image() 
    enter_img = gtk.Image() 
    press_img = gtk.Image()
   
    def __init__(self, i1, i2, i3):
        self.normal_img = i1
        self.enter_img = i2
        self.press_img = i3
        
        gtk.EventBox.__init__(self)
        
        # self.connect("enter-notify-event", self.enter_notify)
        # self.connect("leave-notify-event", self.leave_notify)
        # self.connect("button-press-event", self.button_press_notify)
        # self.connect("button-release-event", self.button_release_notify)
        self.connect_all()
        
        self.b_normal = True
        self.add(self.normal_img)

        self.normal_img.show()
        self.enter_img.show()
        self.press_img.show()

    def clear_flag(self):
        self.b_normal = False
        self.b_enter = False
        self.b_press = False

    def clear_img(self):
#        print "b_enter = ", self.b_enter, "b_normal = ", self.b_normal, "b_press = ", self.b_press
    	if self.b_enter:
            self.remove(self.enter_img)
        elif self.b_normal:
            self.remove(self.normal_img)
        elif self.b_press:
            self.remove(self.press_img)
            
    def connect_all(self):
        self.enter_handler = self.connect("enter-notify-event", self.enter_notify)
        self.leave_handler = self.connect("leave-notify-event", self.leave_notify)
        self.press_handler = self.connect("button-press-event", self.press_notify)
        self.release_handler = self.connect("button-release-event", self.release_notify)
        
    def disconnect_all(self):
        self.disconnect(self.enter_handler)
        self.disconnect(self.leave_handler)
        self.disconnect(self.press_handler)
        self.disconnect(self.release_handler)
        
    def enter_notify(self, event, arg3):
        cursor = gtk.gdk.Cursor(gtk.gdk.HAND2)
        self.window.set_cursor(cursor)
        if not self.b_press:
            #        print "enter_notify"
            self.clear_img()
            self.clear_flag()
            self.b_enter = True
            self.add(self.enter_img)

    def leave_notify(self, event, arg3):
        if not self.b_press:
            #        print "leave_notify"
            self.clear_img()
            self.clear_flag()
            self.b_normal = True
            self.add(self.normal_img)

    def press_notify(self, event, arg3):
#        print "button_press_notify"
        self.clear_img()
        self.clear_flag()
        self.b_press = True
        self.add(self.press_img)

    def release_notify(self, event, arg3):
        if not self.b_press:
            #        print "button_release_notify"
            self.clear_img()
            self.clear_flag()
            self.b_enter = True
            self.add(self.enter_img)
    def reset(self):
            self.clear_img()
            self.clear_flag()
            self.b_normal = True
            self.add(self.normal_img)

        





        
