#!/bin/bash

. /mnt/hidpart/StarOS/scripts/shell/scriptlib.sh

FILENAME="/mnt/hidpart/Data/DriverList" 
cd /opt/ccm/
cd scripts/ovt
# ./svunload
# ./svload


#get the right windows partition
if [ ! -d "/mnt/win" ]; then
	mkdir /mnt/win
fi
#treat the active paritition as the windows partition with "*" flagged
win_partition=`get_system_part`

#mount_partition $win_partition /mnt/win 
mount -t ufsd $win_partition /mnt/win 1>/dev/null 2>/dev/null
if [ $? -ne 0 ]; then
	mount -t vfat -o iocharset=utf8,shortname=winnt $win_partition /mnt/win 1>/dev/null
fi

if [ -f /mnt/win/WINDOWS/scbkbmp.dat ]; then
	#for XP
	OFFSET=`./testaddr /mnt/win/WINDOWS/scbkbmp.dat`
fi
if [ -f /mnt/win/Windows/scbkbmp.dat ]; then
	#for Vista
	OFFSET=`./testaddr /mnt/win/Windows/scbkbmp.dat`
fi
umount /mnt/win


# add the virtual volume device into /proc/devices
./testio 3 $win_partition $OFFSET

echo "Active & Windows Partition: $i SV_OFFSET:$OFFSET"

cd - #return to scripts directory


SVBLK_DEV=`cat /proc/partitions | grep "svblk[a-z]" | awk '{print $4,"b",$1,$2}'`
SVBLK_DEV_NODE="/dev/`cat /proc/partitions | grep "svblk[a-z]" | awk '{print $4}'`"
if [ ! -f "/dev/$SVBLK_DEV" ]; then
	mknod /dev/$SVBLK_DEV
fi

echo "[VirtualVolume]" >> /BootDisk.ini

if [ "${SVBLK_DEV_NODE}" != "/dev/" ]; then
	echo "VirtualVolume=$SVBLK_DEV_NODE" >> /BootDisk.ini
else
	
	echo "VirtualVolume=$win_partition" >> /BootDisk.ini
fi
echo "VirtualVolume_Phy=$win_partition" >> /BootDisk.ini

function is_valid()
{
	BOOTDISK=`grep BootDisk= /BootDisk.ini| sed "s/BootDisk=//"`
	ROOT_BLOCK_DEVICE=`basename $BOOTDISK`
	echo -n "">/tmp/DriverStart
	for i in /sys/block/$ROOT_BLOCK_DEVICE/${ROOT_BLOCK_DEVICE}*; do
		START=`cat $i/start`
		echo "/dev/`basename $i` $START"  >>/tmp/DriverStart
	done

	while read START DRIVER; do
		grep $START /tmp/DriverStart
		if [ $? -gt 0 ]; then
			echo "Never find $START $DRIVER, so it is invalid"
			return 1
		fi
	done < $FILENAME
}

function valid_mount()
{
	VirtualVolume_Phy=`grep VirtualVolume_Phy= /BootDisk.ini | tail -n 1 | sed "s/VirtualVolume_Phy=//"`
	HidPart=`grep HidPart= /BootDisk.ini | tail -n 1 | sed "s/HidPart=//"`
	TYPE=`test_hidpart_type`
	
	while read START DRIVER; do
		DEVICE=`grep "\ ${START}$" /tmp/DriverStart| awk '{print $1}' | tail -n 1`
		echo "$DEVICE $DRIVER" 
		if [ "$DEVICE" != "$VirtualVolume_Phy" ]; then
			if [ "$DEVICE" != "$HidPart" ]; then
				echo "1 mount_partition $DEVICE /media/harddrive/StarOVT/channel0001/$DRIVER"
				mount_partition $DEVICE /media/harddrive/StarOVT/channel0001/$DRIVER
			elif [ "$TYPE" = "PARTITION_TYPE=1" ]; then
				echo "1 mount_partition $DEVICE /media/harddrive/StarOVT/channel0001/$DRIVER"
				mount_partition $DEVICE /media/harddrive/StarOVT/channel0001/$DRIVER
			fi
		else
			if [ -e "/dev/svblka" ]; then
				echo "mount_partition /dev/svblka /media/harddrive/StarOVT/channel0001/$DRIVER"
				mount_partition /dev/svblka /media/harddrive/StarOVT/channel0001/$DRIVER
			else
				echo "2 mount_partition $DEVICE /media/harddrive/StarOVT/channel0001/$DRIVER"
				mount_partition $DEVICE /media/harddrive/StarOVT/channel0001/$DRIVER
			fi
		fi
	done < $FILENAME	
	
}

function invalid_mount()
{
	num="0"
		device=()
		driver=(C D E F G H I J K L M N O P Q R S T U V W X Y Z)
		cdrom=`readlink /dev/cdrom`
		hidpart=`grep "HidPart=" /BootDisk.ini | sed "s/HidPart=//"`
		for dev in /dev/hd* /dev/sd*; do
			echo "Mounting $dev"
				if [ "$dev" != "/dev/${cdrom}" -a "$hidpart" != "$dev" ]; then
					result=1  
						vol_id -t $dev 1>/dev/null 2>/dev/null && result=$?
						if [ $result -eq 0 ]; then
							if [ "$dev" != "${win_partition}" ]; then
								mount_partition ${dev} /media/harddrive/StarOVT/channel0001/${driver[$num]}
							else
								mount_partition /dev/svblka /media/harddrive/StarOVT/channel0001/${driver[$num]}
	fi
		num=`expr $num + 1` 
		fi
		fi 
		done
}

is_valid
IS_VALID=$?
if [ $IS_VALID -eq 0 ]; then
echo "It is valid"
valid_mount
else
echo "It is invalid"
invalid_mount
fi
