#!/bin/bash


WHICH_AV=$1
METHOD=$2

TARGET_VIRUSLIB_PATH="/opt/ccm/VirusLib"
KVLIB_LISTFILE="$TARGET_VIRUSLIB_PATH/kvlib.txt"
USB_SEARCH_PATH="/media/usb"

WHICH_AV=JiangMin

if [ "$WHICH_AV" == "JiangMin" ]; then
	KV_UPDATE_URL="http://kvup.jiangmin.com/ruantong"
#	KV_UPDATE_URL="http://192.168.128.116/test/jm"
#	KV_UPDATE_URL="http://192.168.128.75/ruantong"
fi

down_eth_interface()
{
#	ifconfig eth0 down
#	ifconfig eth1 down
    return 
}

fail_exit()
{
	down_eth_interface
	exit 1
}

success_exit()
{
	down_eth_interface
	exit 0
}

func_compare_version()
{
	echo "Comparing Virus Version"
	if [ "$WHICH_AV" = "JiangMin" ]; then
		OLD_VIRUSLIB_VERSION=`grep "#date=" ${KVLIB_LISTFILE} | sed "s/^.*#date=//"`
		NEW_VIRUSLIB_VERSION=`grep "#date=" /tmp/VirusLib/kvlib.txt | sed "s/^.*#date=//"`

		echo "VERSION OLD $OLD_VIRUSLIB_VERSION"
		echo "VERSION NEW $NEW_VIRUSLIB_VERSION"
		if [ "$OLD_VIRUSLIB_VERSION" = "$NEW_VIRUSLIB_VERSION" ]; then
		    if [ -z $NEW_VIRUSLIB_VERSION ]; then
			exit 1
		    else
			return 0
		    fi
		else
			return 1
		fi
	fi
}

func_download_new_kvlib_listfile()
{
	if [ "$METHOD" = "USB" ]; then
		for i in ${USB_SEARCH_PATH}/*; do
			USB_DISK_PATH=$i
			if [ -d $USB_DISK_PATH/VirusLib ]; then
			    echo $USB_DISK_PATH/VirusLib
			    KV_UPDATE_URL=$USB_DISK_PATH/VirusLib
			    rm -rf /tmp/VirusLib; mkdir /tmp/VirusLib
			    cp -f $USB_DISK_PATH/VirusLib/kvlib.txt /tmp/VirusLib
			    break
			elif [ -d $USB_DISK_PATH/virusLib ]; then
			    echo $USB_DISK_PATH/virusLib
			    KV_UPDATE_URL=$USB_DISK_PATH/virusLib
			    rm -rf /tmp/VirusLib; mkdir /tmp/VirusLib
			    cp -f $USB_DISK_PATH/virusLib/kvlib.txt /tmp/VirusLib
			    break
			else
			    continue
			fi
		done
	fi


	if [ "$METHOD" = "NETWORK" ]; then
		rm -rf /tmp/VirusLib; mkdir /tmp/VirusLib
		wget -t 10 ${KV_UPDATE_URL}/kvlib.txt -P /tmp/VirusLib || fail_exit
	fi
	
	if [ "$METHOD" = "LOCAL" ]; then
		rm -rf /tmp/VirusLib; mkdir /tmp/VirusLib
		KV_UPDATE_URL="/media/harddrive/StarOVT/channel0001/C/Program Files/JiangMin/Kernel"
		cp -f "$KV_UPDATE_URL/kvlib.txt" -P /tmp/VirusLib || fail_exit
	fi
}

func_get_file()
{
	SOURCE_PATH=$1
	FILENAME=$2
	DEST_PATH=$3

	if [ "$METHOD" = "NETWORK" ]; then
		rm -rf $DEST_PATH/$FILENAME
		wget -t 10 ${SOURCE_PATH}/$FILENAME -P ${DEST_PATH} || fail_exit
	elif [ "$METHOD" = "USB" ]; then
		rm -rf $DEST_PATH/$FILENAME
	    	cp -f ${SOURCE_PATH}/$FILENAME ${DEST_PATH} || fail_exit
	elif [ "$METHOD" = "LOCAL" ]; then
		rm -rf $DEST_PATH/$FILENAME
	    	cp -f "${SOURCE_PATH}/$FILENAME" ${DEST_PATH} || fail_exit
	fi
}

func_real_update()
{
	rm -rf "${TARGET_VIRUSLIB_PATH}.old"
	mv "$TARGET_VIRUSLIB_PATH" "${TARGET_VIRUSLIB_PATH}.old"
	rm -rf "$TARGET_VIRUSLIB_PATH"
	mv /tmp/VirusLib "$TARGET_VIRUSLIB_PATH"
}


func_update()
{
	if [ "$WHICH_AV" = "JiangMin" ]; then
		echo "JiangMin Update"
		func_download_new_kvlib_listfile
		func_compare_version
		result=$?

		if [ $result -eq 1 ]; then
			echo "Different VirusLib Version"
			content=`/bin/grep -v "^#.*\|^$" /tmp/VirusLib/kvlib.txt | tr "=" " " | awk '{print $1}'` 
			for filename in $content; do
				echo "Downloading ${KV_UPDATE_URL}/${filename}"
				func_get_file "${KV_UPDATE_URL}" "${filename}" /tmp/VirusLib
			done
			func_real_update
		else
			echo "Same VirusLib Version"
		fi
	fi
}

func_update

success_exit
