#!/bin/sh


# $1, NetworkName
# $2, Validation Way
# $3, Crypt, just not blank. Always use "WEP" as parameter value
# $4, Network Key
echo "Usage: wirelesscfg.sh NetworkName Validation Crypt Key" 

ESSID=$1
VALATATION=$2
CRYPT="WEP"
PASSWORD=$4


WIRELESS_PATH="/mnt/hidpart/StarOS/other/wireless"
CHECK_INTERVAL=1
TIMEOUT=30
COUNT=`expr $TIMEOUT / $CHECK_INTERVAL`

echo "nameserver 202.106.116.1">>/etc/resolv.conf

#prepare firmware
rm /etc/hotplug/firmware.agent
cp $WIRELESS_PATH/firmware/firmware.agent /etc/hotplug/
mkdir /firmware
cp $WIRELESS_PATH/firmware/* /firmware

#Some computer need to set timeout to 100
echo 100 > /sys/class/firmware/timeout


WIRELESS_CARD=`lspci -n -i $WIRELESS_PATH/pci.ids | grep 0280 | awk '{print $4}'`
echo $WIRELESS_CARD
if [ "$WIRELESS_CARD" = "8086:4227" ]; then
	WIRELESS_TYPE="IPW3945"
fi

if [ "$WIRELESS_CARD" = "8086:4222" ]; then
	WIRELESS_TYPE="IPW3945"
fi

if [ "$WIRELESS_CARD" = "8086:4220" ]; then
	WIRELESS_TYPE="IPW2200"
fi
echo $WIRELESS_TYPE

if [ "$WIRELESS_TYPE" = "IPW3945" ]; then
	echo "This computer has a IPW3945 wireless card."
	insmod $WIRELESS_PATH/modules/ieee80211_crypt.ko
	insmod $WIRELESS_PATH/modules/ieee80211_crypt_wep.ko
	insmod $WIRELESS_PATH/modules/ieee80211.ko

	insmod $WIRELESS_PATH/modules/ipw3945.ko

	if [ ! -e "/var/run/ipw3945d.pid" ]; then
		$WIRELESS_PATH/ipw3945d
		sleep 3
	fi
fi

if [ "$WIRELESS_TYPE" = "IPW2200" ]; then
	echo "This computer has a IPW2200 wireless card."
	insmod $WIRELESS_PATH/modules/ieee80211_crypt.ko
	insmod $WIRELESS_PATH/modules/ieee80211_crypt_wep.ko
	insmod $WIRELESS_PATH/modules/ieee80211.ko

	insmod $WIRELESS_PATH/modules/ipw2200.ko
fi

#set some options
export LD_LIBRARY_PATH=/mnt/hidpart/StarOS/other/wireless/

INTERFACE=`$WIRELESS_PATH/iwconfig 2>/dev/null | grep ESSID | awk '{print $1}'`

echo $INTERFACE

$WIRELESS_PATH/iwconfig $INTERFACE key $PASSWORD essid $ESSID
ifconfig $INTERFACE up
$WIRELESS_PATH/dhcpcd $INTERFACE

let Iterator=0
while [ $Iterator -le $COUNT ]
do
	echo -n .
	sleep $CHECK_INTERVAL	
	GATEWAY=`route | grep default | awk '{print $2}'`	
	if [ "$GATEWAY" != "" ]; then
		RET=`ping $GATEWAY -c 3`
		if [ $? -eq 0 ]; then
			exit 0 
		fi #ping gateway
	fi #check GATEWAY	
	let Iterator=Iterator+1
	done 
exit 1	
