#!/usr/bin/env python

import xml.dom.minidom
from xml.dom.minidom import Node
from datetime import datetime
from time import strptime


class LicFile:
	def __init__(self, LicFileNode):
		self.ID = LicFileNode.attributes["ID"]
		self.expired_time = LicFileNode.attributes["Expired"].value
		self.is_expired = expiredTimeWithNow(self.expired_time)


def findInstalledActiveLicWithID(doc, ID):
	for item in doc.getElementsByTagName("plugin"):
		for lf in item.childNodes:
			if lf.nodeName == "LicFile":
				if lf.attributes["ID"].value == ID:
					return lf
	
def findActiveLicWithID(doc, ID):
	for item in doc.getElementsByTagName("iac"):
		for lf in  item.childNodes:
			if lf.attributes["ID"].value == ID:
				return lf

def expiredTimeWithNow(target):
	t = datetime(*strptime(target, "%Y-%m-%d %H:%M")[0:5])
	timedelta = t-t.now()
	if timedelta.days*86400 + timedelta.seconds < 0:
		return True
	else:
		return False

def findLicFileWithID(ACTIVE_XML, ID):
	try:
		doc = xml.dom.minidom.parse(ACTIVE_XML)
		#LicFileNode = findActiveLicWithID(doc, ID)
		#if LicFileNode != None:
		#	LicFileObject  = LicFile(LicFileNode)
		#	print "Found an Active LicFile"
		#	return LicFileObject
		LicFileNode = findInstalledActiveLicWithID(doc, ID)
		if LicFileNode != None:
			LicFileObject = LicFile(LicFileNode)
			print "Found an Installed LicFile"
			return LicFileObject

	except xml.parsers.expat.ExpatError:
		print "xml parser error"

if __name__ == "__main__":
	ob = findLicFileWithID("/tmp/decrypt_active.xml", "XNl0K0Y7iGa24fTRK74sRUZMqTreYcId")
	if ob != None:
		print ob.is_expired
	
