#!/usr/bin/env python

""" StarSoftComm MSP plug-in mgr """

import os
import ConfigParser
import parse_active

PLUGIN_DIR = "/opt"

class ssc_plugin:
	def __init__(self, plugin, cfg):
		self.cfg = cfg
		parser = ConfigParser.ConfigParser()
		parser.read(cfg)
		
		self.name = parser.get("Desktop Entry", "Name")
		self.icon = parser.get("Desktop Entry", "Icon")
		self.command = parser.get("Desktop Entry", "Exec")
		self.comment = parser.get("Desktop Entry", "Comment")
		self.ID = ""
		self.guid = ""
		self.expired_comment = ""
		
		try:
			self.ID = parser.get("Desktop Entry" , "ID")
			self.guid = parser.get("Desktop Entry", "GUID")
			self.expired_comment = parser.get("Desktop Entry", "Expired_Comment")
		except ConfigParser.NoOptionError:
			self.expired_comment = None
		
		self.is_expired = self.plugin_is_expired()
	
	def plugin_is_expired(self):
		try:
			if self.ID != "":
				ob = parse_active.findLicFileWithID("/tmp/decrypt_active.xml", self.ID)
				if ob != None:
					return ob.is_expired
				else:
					return False
			else:
				return False
		except IOError:
			return False

class ssc_plugin_mgr:
	""" Plug-in mgr workhorse class """

	plugin_list = list()

	def __init__(self):
		# enum plug-in dir
		dirs=sorted(os.listdir(PLUGIN_DIR))
		for plugin in dirs:
			if os.path.isdir(PLUGIN_DIR + "/" + plugin):
				cfg = PLUGIN_DIR + "/" + plugin + "/" + plugin + ".desktop"
				if os.path.isfile(cfg):
					plugin_object = ssc_plugin(plugin, cfg)
					#item = [plugin,
					#		plugin_object.name,
					#		plugin_object.icon,
					#		plugin_object.command,
					#		plugin_object.comment,
					#		plugin_object.expired_comment,
					#		]
					#self.plugin_list.append(item);
					self.plugin_list.append(plugin_object)
		self.plugin_list=sorted(self.plugin_list)
		for i in self.plugin_list:
			print i.command
		return

if __name__ ==  '__main__':
	ssc_plugin_mgr()
	
