#!/usr/bin/env python

""" This is the main src of SSC MSP platform framework """

import os, sys
import gobject
import gtk
import time

# import locale
import gettext

from ssc_widget import *

APP_NAME = "ssc_messge_window"

gettext.bindtextdomain(APP_NAME, "/usr/local/share/locale/")
gettext.textdomain(APP_NAME)
_ = gettext.gettext

def state_pipe(file, command):
	os.system("[ -e %s ] && %s" % (file, command));

# class ssc_message_window(buttons):
class ssc_message_window:
	
	response_id = None

	window = None
	
	btn_yes = None
	btn_no = None
	
	def on_btn(self, widget, event, cmd):
		if widget == self.btn_yes:
			self.response_id = gtk.RESPONSE_YES
		elif widget == self.btn_no:
			self.response_id = gtk.RESPONSE_NO
		gtk.main_quit()
		self.window.hide()
		
	def __init__(self, parent, flags, icon_type, buttons, message_format):
		layout = gtk.Layout()

		self.btn_yes = ssc_button("./res/ssc_msp_button_small_1.png",
							"./res/ssc_msp_button_small_2.png",
							"./res/ssc_msp_button_small_3.png",
							None,
							_("Yes"))
		self.btn_no = ssc_button("./res/ssc_msp_button_small_1.png",
							"./res/ssc_msp_button_small_2.png",
							"./res/ssc_msp_button_small_3.png",
							None,
							_("No"))
		# self.btn_yes = gtk.Button(_("Yes"))
		# self.btn_no = gtk.Button(_("No"))
		# self.btn_yes.set_size_request(60, 30)
		# self.btn_no.set_size_request(60, 30)

		self.btn_yes.connect("button-press-event", self.on_btn, None)
		self.btn_no.connect("button-press-event", self.on_btn, None)

		label = gtk.Label()
		label.set_markup(message_format)
		
		self.window = gtk.Window()		
		self.window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
		self.window.set_keep_above(True)
		self.window.set_decorated(False)
		self.window.set_resizable(False)
		self.window.set_size_request(413, 220)

		self.window.add(layout)

		img_bg = gtk.Image()
		img_bg.set_from_file("./res/ssc_msp_message_window_bg.png")
		
		img_icon = gtk.Image()
		img_icon.set_from_file("./res/ssc_msp_message_window_icon_question.png")
		
		layout.put(img_bg, 0, 0)
		layout.put(img_icon, 40, 100)
		layout.put(label, 100, 115)
		if buttons == gtk.BUTTONS_YES_NO:
			layout.put(self.btn_yes, 180, 175)
			layout.put(self.btn_no, 260, 175)
		
	def run(self):
		self.window.show_all()
		gtk.main()
	
class splash_window:
	response_id = None

	window = None
   
	   
	def __init__(self, parent, flags, icon_type, message_format):
		layout = gtk.Layout()

		self.label = gtk.Label()
		self.label.set_markup(message_format)
		self.statelabel = gtk.Label()
		self.statelabel.set_markup(_("Start Initilizing..."))
		
		self.window = gtk.Window()		
		self.window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
		self.window.set_keep_above(True)
		self.window.set_decorated(False)
		self.window.set_resizable(False)
		self.window.set_size_request(413, 220)

		self.window.add(layout)

		img_bg = gtk.Image()
		img_bg.set_from_file("./res/ssc_msp_message_window_bg.png")
		
		img_icon = gtk.Image()
		img_icon.set_from_file("./res/ssc_msp_message_window_icon_question.png")
		
		layout.put(img_bg, 0, 0)
		layout.put(img_icon, 40, 100)
		layout.put(self.label, 100, 115)
		layout.put(self.statelabel, 100, 200)
	
	def timer_func(self):
		self.index = self.index+1

		f = open("/tmp/startup_splash", "r")
		state = f.readline()
		print "%d:%s" % (self.index, state[0:-1])
		self.statelabel.set_markup(state[0:-1])
		if self.index > 20:
			self.window.hide()
			try:
				os.remove("/tmp/startup_splash")
				return
			except OSError:
				print "remove /tmp/startup_splash forcely"
				return
		if state[0:-1] == "completed":
			self.window.hide()
			return
		gobject.timeout_add(1000,self.timer_func)
	
	def timeout_completed(self):
		state_pipe("/tmp/startup_splash", "echo completed > /tmp/startup_splash")
		
	def run(self):
		self.window.show_all()
		self.index=0
		try:
			os.remove("/tmp/startup_splash")
			os.mkfifo("/tmp/startup_splash")
		except OSError:
			print "existd fifo"
		self.timer = gobject.timeout_add(1000,self.timer_func)
		#time.sleep(5)
		#self.window.hide()
		#gtk.main()

if __name__ == '__main__':
	win = ssc_message_window(None, 0, None, gtk.BUTTONS_YES_NO, "message_format")
	win.run()
	gtk.main()
	
