"SSC defined widgets"

import gtk

import locale
import gettext

_ = gettext.gettext

class ssc_button(gtk.EventBox):
    "SSC defined tri-state button from gtk.EventBox"

    normal_img = None
    enter_img = None
    press_img = None
    
    icon_img = None

    label = None
    label_x_pos = None
    label_y_pos = None

    enter_handler = None
    leave_handler = None
    press_handler = None
    release_handler = None
    
    b_normal = False
    b_enter = False
    b_press = False

    fixed = None

    def __init__(self, bg1, bg2, bg3, icon = None, label_str = None):
        gtk.EventBox.__init__(self)

        self.fixed = gtk.Fixed()
        # self.fixed = gtk.Layout()

        self.normal_img = gtk.Image() 
        self.enter_img = gtk.Image() 
        self.press_img = gtk.Image()

        self.normal_img.set_from_file(bg1)
        self.enter_img.set_from_file(bg2)
        self.press_img.set_from_file(bg3)
        
        if label_str != None:
            self.label = gtk.Label()
            self.label.set_markup(_(label_str))
        
        # self.connect("enter-notify-event", self.enter_notify)
        # self.connect("leave-notify-event", self.leave_notify)
        # self.connect("button-press-event", self.button_press_notify)
        # self.connect("button-release-event", self.button_release_notify)
        self.connect_all()
        
        self.b_normal = True
        self.fixed.put(self.normal_img, 0, 0)

        if icon != None:
            self.icon_img = gtk.Image()        
            self.icon_img.set_from_file(icon)
            self.fixed.put(self.icon_img, 5, 5)
            
        if self.label != None:
            if icon != None:
                self.label_x_pos = 45
                self.label_y_pos = 10
            else:
                self.label_x_pos = 25
                self.label_y_pos = 0
            self.fixed.put(self.label, self.label_x_pos, self.label_y_pos)
                
        self.add(self.fixed)
        # self.add(self.normal_img)

        self.normal_img.show()
        self.enter_img.show()
        self.press_img.show()
        # self.fixed.show()
        # self.fixed.show_all()

    def clear_flag(self):
        self.b_normal = False
        self.b_enter = False
        self.b_press = False

    def clear_img(self):
#        print "b_enter = ", self.b_enter, "b_normal = ", self.b_normal, "b_press = ", self.b_press
    	if self.b_enter:
            self.fixed.remove(self.enter_img)
        elif self.b_normal:
            self.fixed.remove(self.normal_img)
        elif self.b_press:
            self.fixed.remove(self.press_img)
            
        if self.icon_img != None:
            self.fixed.remove(self.icon_img)
        if self.label != None:
            self.fixed.remove(self.label)        
            
    def connect_all(self):
        self.enter_handler = self.connect("enter-notify-event", self.enter_notify)
        self.leave_handler = self.connect("leave-notify-event", self.leave_notify)
        self.press_handler = self.connect("button-press-event", self.press_notify)
        self.release_handler = self.connect("button-release-event", self.release_notify)
        
    def disconnect_all(self):
        self.disconnect(self.enter_handler)
        self.disconnect(self.leave_handler)
        self.disconnect(self.press_handler)
        self.disconnect(self.release_handler)
        
    def enter_notify(self, event, arg3):
        cursor = gtk.gdk.Cursor(gtk.gdk.HAND2)
        self.window.set_cursor(cursor)
        if not self.b_press:
            #        print "enter_notify"
            self.clear_img()
            self.clear_flag()
            self.b_enter = True
            self.fixed.put(self.enter_img, 0, 0)
            if self.icon_img != None:
                self.fixed.put(self.icon_img, 5, 5)
            self.fixed.put(self.label, self.label_x_pos, self.label_y_pos)

    def leave_notify(self, event, arg3):
        if not self.b_press:
            #        print "leave_notify"
            self.clear_img()
            self.clear_flag()
            self.b_normal = True
            self.fixed.put(self.normal_img, 0, 0)
            if self.icon_img != None:
                self.fixed.put(self.icon_img, 5, 5)
            self.fixed.put(self.label, self.label_x_pos, self.label_y_pos)

    def press_notify(self, event, arg3):
#        print "button_press_notify"
        self.clear_img()
        self.clear_flag()
        self.b_press = True
        self.fixed.put(self.press_img, 0, 0)
        if self.icon_img != None:
            self.fixed.put(self.icon_img, 5, 5)
        self.fixed.put(self.label, self.label_x_pos, self.label_y_pos)

    def release_notify(self, event, arg3):
        if not self.b_press:
            #        print "button_release_notify"
            self.clear_img()
            self.clear_flag()
            self.b_enter = True
            self.add(self.enter_img)
    def reset(self):
            self.clear_img()
            self.clear_flag()
            self.b_normal = True
            self.add(self.normal_img)
        
