#!/usr/bin/env python

""" This is the src of system level auth mgr module of SSC MSP platform """

import os, sys
import gtk
import xml.dom.minidom
from xml.dom.minidom import Node
import string
import md5

import locale
import gettext

import ConfigParser, os

sys.path.append('./scripts')
import ssc_widget

APP_NAME = "ssc_auth_mgr"
SSC_AUTH_FILE = "./Password.ini"

class CSConfigParser(ConfigParser.ConfigParser): # CaseSensitive ConfigParser
    def optionxform(self, optionstr):
        return optionstr
    
class auth_mgr_win(gtk.Window):

    try_num = 0
    entry_passwd = None
    label_caption = None
    label_info = None
    button_ok = None
#    button_reboot = None
    
    def destroy(*args):
        print "destroy"
        gtk.main_quit()

    def get_auth_info(self, name):
        val = None
        parser = CSConfigParser()
        try:
            parser.optionxform(str())
            parser.read(SSC_AUTH_FILE)
            val = parser.get("Password", name)
        except:
            pass
        return val

    def restore_passwd(self):
        val = None
        parser = CSConfigParser()
        try:
            parser.optionxform(str())
            parser.read(SSC_AUTH_FILE)
            parser.set("Password", "VerifyFlag", "1")
            parser.write(open(SSC_AUTH_FILE, "w"))
        except:
            pass
        return

    def clear_user_passwd(self):
        val = None
        parser = CSConfigParser()
        try:
            parser.optionxform(str())
            parser.read(SSC_AUTH_FILE)
            parser.set("Password", "VerifyFlag", "0")
            parser.set("Password", "UserPassword", "")
            parser.write(open(SSC_AUTH_FILE, "w"))
        except:
            pass
        return

    def button_press_event_ok(self, widget, event):
        self.try_num += 1
        m = md5.new()
        passwd_input = self.entry_passwd.get_text()
        m.update(passwd_input)
        passwd_user_digest = self.get_auth_info("UserPassword")
        passwd_super_digest = self.get_auth_info("SuperPassword")

        if m.hexdigest().lower() == passwd_user_digest.lower():
            self.label_info.set_markup(_("Password user!"))
            self.restore_passwd()
            sys.exit(0)
        elif m.hexdigest().lower() == passwd_super_digest.lower():
            self.label_info.set_markup(_("Password super!"))
            self.clear_user_passwd()
            sys.exit(0)
        else:
            self.label_info.set_markup(_("Password error, please try again!"))
#             if self.try_num == 3:
#                 self.entry_passwd.set_sensitive(False)
#                 self.label_info.set_markup(_("You've tried to much times, please try later!"))
#             elif self.try_num > 3:
#                 gtk.main_quit(3)
#                 sys.exit(4)
#             else:
#                 self.label_info.set_markup(_("Password error, please try again!"))

        self.entry_passwd.set_text("")
        self.button_ok.reset()
        return True
    
    def button_press_event_cancel(self, widget, event):
        sys.exit(1)
        return True

    def button_press_event_reboot(self, widget, event):
        os.system("reboot")
        return True

    def __init__(self):
        if self.get_auth_info("UserPassword") == "":
            sys.exit(0)
        else:
            if self.get_auth_info("VerifyFlag") == "0":
                self.restore_passwd()
                sys.exit(0)

        window = gtk.Window()
        window.set_size_request(320, 205);
        window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
        window.set_decorated(False)
        # window.set_modal(True)
        window.set_keep_above(True)
        window.set_resizable(False)

        window.connect("destroy", self.destroy)

        bg = gtk.Image()
        bg.set_from_file("res/ssc_auth_mgr_win_bg.jpg")

        layout = gtk.Layout()
        layout.add(bg)

        self.entry_passwd = gtk.Entry()
        self.entry_passwd.set_size_request(180, 25)
        self.entry_passwd.set_visibility(False)
        self.entry_passwd.set_invisible_char('*')
        # self.entry_passwd.set_max_length(24)
        
        
        # OK button
        self.button_ok = ssc_widget.ssc_button("./res/ssc_msp_button_small_1.png",
                   "./res/ssc_msp_button_small_2.png",
                   "./res/ssc_msp_button_small_3.png",
                   None,
                   _("OK"))
        
        # Cancel button
        self.button_cancel = ssc_widget.ssc_button("./res/ssc_msp_button_small_1.png",
                   "./res/ssc_msp_button_small_2.png",
                   "./res/ssc_msp_button_small_3.png",
                   None,
                   _("Cancel"))        
        # = ssc_widget.ssc_button(button_img_ok_1, button_img_ok_2, button_img_ok_3)
        self.button_ok.connect("button-press-event", self.button_press_event_ok)
        self.button_cancel.connect("button-press-event", self.button_press_event_cancel)

        # reboot button
#         button_img_reboot_1 = gtk.Image()
#         button_img_reboot_2 = gtk.Image()
#         button_img_reboot_3 = gtk.Image()
#         button_img_reboot_1.set_from_file("res/ssc_generic_reboot_1.jpg")
#         button_img_reboot_2.set_from_file("res/ssc_generic_reboot_2.jpg")
#         button_img_reboot_3.set_from_file("res/ssc_generic_reboot_3.jpg")
#         self.button_reboot = ssc_widget.ssc_button(button_img_reboot_1, button_img_reboot_2, button_img_reboot_3)
#         self.button_reboot.connect("button-press-event", self.button_press_event_reboot)

        self.label_caption = gtk.Label(_("Input password"))
        self.label_info = gtk.Label(_("Please input your password."))

        # build layout
        layout.put(self.label_caption, 5, 3)
        layout.put(self.label_info, 45, 75)
        layout.put(self.entry_passwd, 45, 110)
        layout.put(self.button_ok, 70, 160)
        layout.put(self.button_cancel, 170, 160)
        # layout.put(self.button_reboot, 180, 170)
        
        if os.path.isfile("res/ssc_auth_mgr.xml"):
            doc = xml.dom.minidom.parse("res/ssc_auth_mgr.xml")
        
            node = doc.getElementsByTagName("label_info")        
            if node:
                layout.move(self.label_info, string.atoi(node[0].getAttribute("x-coordinate")), string.atoi(node[0].getAttribute("y-coordinate")))
            
            node = doc.getElementsByTagName("entry_passwd")        
            if node:
                layout.move(self.entry_passwd, string.atoi(node[0].getAttribute("x-coordinate")), string.atoi(node[0].getAttribute("y-coordinate")))
            
            node = doc.getElementsByTagName("button_ok")
            if node:
                layout.move(self.button_ok, string.atoi(node[0].getAttribute("x-coordinate")), string.atoi(node[0].getAttribute("y-coordinate")))
            
            node = doc.getElementsByTagName("button_reboot")
            if node:
                layout.move(self.button_reboot, string.atoi(node[0].getAttribute("x-coordinate")), string.atoi(node[0].getAttribute("y-coordinate")))

        window.add(layout)
        
        window.show_all()

        gtk.main()

if __name__ == '__main__':
    if not os.path.isfile(SSC_AUTH_FILE):
        sys.exit()
    gettext.bindtextdomain(APP_NAME, "./po")
    gettext.textdomain(APP_NAME)
    _ = gettext.gettext
    auth_mgr_win()
