#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" This is the main UI src of Windows System Recovery plug-in """

import os, sys
import gobject
import gtk

import xml.dom.minidom
from xml.dom.minidom import Node

import string
import time
import thread

import ConfigParser

import gettext

import subprocess
import pipes

import ssc_win_sys_restore_sec_utils
import ssc_disk
from ssc_widget import *
import ssc_message_window

APP_NAME = "ssc_win_sys_restore_sec"
APP_GUID = "51BD3259-61F0-4E1C-9F34-09C7C060EBA5"
DATA_DIR = "/opt/wsysrt"
ACTION_INI = "/opt/wsysrt/Action.ini"
FLAG_INI = "/opt/wsysrt/Flag.ini"

RECOVER_CFG = "/opt/wsysrt/recover.cfg"
RECOVER_IMG_DIR = "/opt/wsysrt"

TASK_CONF = "/mnt/hidpart/Data/task.conf"

SSC_TASK_RUNNING	 = 0x00000001
SSC_TASK_COMPLETED   = 0x00000002
SSC_TASK_UNCOMPLETED   = 0x00000004

#   columns
(
	COLUMN_TIME_STAMP,
	COLUMN_DESCRIPTION,
	COLUMN_TYPE,
	COLUMN_SIZE,
	COLUMN_IMAGE_SIZE,
	COLUMN_IMAGE_FILE,
	COLUMN_UNIQUE_ID,
	COLUMN_FULL_UNIQUE_ID,
) = range(8)

AutoReboot = True

def state_pipe(file, command):
	os.system("[ -e %s ] && %s" % (file, command));

class software_list_window:

	window = None
	scroll_win = None
	treeview = None
	btn_exit = None

	def btn_exit_press_event(self, widget, event, cmd):
		self.window.hide()

	def __create_model(self, recover_img):
		model = gtk.ListStore(
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING
			)
		try:
			doc = xml.dom.minidom.parse(recover_img[0:len(recover_img) - 4] + ".xml")
			node = doc.getElementsByTagName("item")
			for i in node:
				if len(i.getAttribute("DisplayName")) == 0:
					continue
				estimated_size = i.getAttribute("EstimatedSize")
				if estimated_size != "0":
					#if ((string.atoi(estimated_size)) > 1024):
					estimated_size = (float(string.atoi(estimated_size)) / 1024)
					unit = "MB"
					if (estimated_size > 1024):
						estimated_size = (float(estimated_size) / 1024)
						unit = "GB"
					estimated_size = ("%0.2f" % estimated_size) + unit
				else:
					estimated_size = ""

				install_date = i.getAttribute("InstallDate")
				# if install_date != "0":
				#	install_date = time.ctime(string.atoi(install_date))
				# else:
				#	 install_date = ""
				iter = model.append()			
				model.set(iter,
						  0, i.getAttribute("DisplayName"),
						  1, i.getAttribute("DisplayVersion"),
						  2, estimated_size,
						  3, install_date
						  )
		except:
			pass
		return model

	def __add_columns(self, treeview):
		model = treeview.get_model()
		column = gtk.TreeViewColumn(_("App Name"), gtk.CellRendererText(), text = 0)
		column.set_resizable(True)
		column.set_fixed_width(30)
		column.set_min_width(30)
		self.treeview.append_column(column)
		column = gtk.TreeViewColumn(_("App Ver"), gtk.CellRendererText(), text = 1)
		column.set_resizable(True)
		self.treeview.append_column(column)
		column = gtk.TreeViewColumn(_("App Size"), gtk.CellRendererText(), text = 2)
		column.set_resizable(True)
		self.treeview.append_column(column)
		column = gtk.TreeViewColumn(_("Install Date"), gtk.CellRendererText(), text = 3)
		column.set_resizable(True)
		self.treeview.append_column(column)

	def show(self, recover_img, type_full, full_img):		
		self.window = gtk.Window(gtk.WINDOW_POPUP)
		self.window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
		self.window.set_decorated(False)
		self.window.set_resizable(False)
		self.window.set_size_request(549, 352)

		img_bg = gtk.Image()
		img_bg.set_from_file("./res/ssc_sw_list_win_bg.png")

		self.scroll_win = gtk.ScrolledWindow()
		self.scroll_win.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		self.scroll_win.set_shadow_type (gtk.SHADOW_IN);
		self.scroll_win.set_size_request(510, 220)

		model = self.__create_model(recover_img)
		self.treeview = gtk.TreeView(model)
		self.treeview.columns_autosize()
		self.__add_columns(self.treeview)
		self.scroll_win.add(self.treeview)

		self.btn_exit = gtk.Button(_("Exit"))
		self.btn_exit.set_size_request(60, 25)
		self.btn_exit.connect("button-press-event", self.btn_exit_press_event, None)

		label_caption = gtk.Label()
		label_caption.set_markup(_("Details caption"))
		
		label_des = gtk.Label()
		des = None
		utils = ssc_win_sys_restore_sec_utils.ssc_win_sys_restore_sec_utils()
		recover_img_info = utils.get_image_info(recover_img)
		if type_full == _("Full backup"):
			des = _("Full backup") + ", " + recover_img_info[COLUMN_TIME_STAMP] + "\n"
		else:
			full_img_info = utils.get_image_info(full_img)
			des = _("Delta backup") + ", " + recover_img_info[COLUMN_TIME_STAMP] + \
				  _(" depend on: ") +  full_img_info[COLUMN_TIME_STAMP] + "\n"
		des += _("the following software in this recover image")
		label_des.set_markup(des)
		
		layout = gtk.Layout()

		layout.put(img_bg, 0, 0)
		layout.put(label_caption, 10, 5)
		layout.put(label_des, 20, 40)
		layout.put(self.scroll_win, 20, 80)
		layout.put(self.btn_exit, 470, 305)
		
		self.window.add(layout)

		self.window.show_all()

class recovery_ui(gtk.Window):
	once = False
	step = 1
	progress = 0.0
	window = None
	layout = None
	model = None
	label_des = None
	label_status = None

	interrupted = False

	btn_next = None
	btn_cancel = None
	btn_halt = None
	btn_reboot = None

	progressbar = None
	pipein = None
	pipeout = None
	utils = None
	recover_img = None
	img_list = None
	timeout_id = 0
	image_dir = "/opt/wsysrt"
	mediatype = "harddisk"

	def recover_thread(self):
		disk = ssc_disk.ssc_disk()
		disk.set_action_type(ssc_disk.ACTION_TYPE_LINUX)

		try:
			f = open(TASK_CONF, "w")
			content = "GUID={%s}\nStatus=0x%x\n" % (APP_GUID, SSC_TASK_RUNNING)
			f.write(content)
			f.close()
		except:
			pass

		f = open(FLAG_INI, "w")
		content = "[flag]\ndate=%s\nresult=fail\n" % (time.strftime("%Y-%m-%d %H:%M:%S"))
		f.write(content)				
		f.close()

		utils2 = ssc_win_sys_restore_sec_utils.ssc_win_sys_restore_sec_utils()
		recover_img_info2 = utils2.get_image_info(self.recover_img)

		subprocess.Popen(
			["./win_sys_restore_sec", self.recover_img, self.utils.get_system_partition()],
			stdout = self.pipeout,
			stderr = self.pipein)

	def destroy(*args):
		gtk.main_quit()

	def timeout(self):
		buf = os.read(self.pipein, 256)
		if buf.find("SSC_SYS_RECOVER_PROGRESS_INFO:") != -1:
			buf = buf[buf.find("SSC_SYS_RECOVER_PROGRESS_INFO:"):]
			self.progress = buf.replace("SSC_SYS_RECOVER_PROGRESS_INFO:", "")
		else:
			return True
		self.progress = self.progress.split()[-1]
		self.progress.strip()

		try:
			if float(self.progress) == 0:
				return True
		except:
			self.progress = "0.0"

		self.label_status.set_label(_("Finished:") + " %.2f" % (float(self.progress) * 100) + "%" )
		self.progressbar.set_fraction(float(self.progress))
		if (float(self.progress) >= 1.0) and (self.timeout_id is not None):
			disk = ssc_disk.ssc_disk()		
			disk.set_action_type(ssc_disk.ACTION_TYPE_NORMAL)

			f = open(FLAG_INI, "w")
			content = "[flag]\ndate=%s\nimg_file=%s\nresult=success\n" % ((time.strftime("%Y-%m-%d %H:%M:%S")), self.recover_img)
			f.write(content)				
			f.close()

			try:
				f = open(TASK_CONF, "w")
				content = "GUID={%s}\nStatus=0x%x\n" % (APP_GUID, SSC_TASK_COMPLETED)
				f.write(content)
				f.close()
			except:
				pass

			gobject.source_remove(self.timeout_id)
			self.timeout_id = None
			try:
				os.remove(ACTION_INI)
				os.remove(RECOVER_CFG)
			except:
				pass
			print "Finished"
			if self.once:
				#创建一次文件
				print "Create once.flg"
				os.system("touch '%s/once.flg'" % self.image_dir)
			if AutoReboot == True:
				# restore disk signature
				cmd1="dd if=/tmp/disk_sign_file of=%s obs=1 seek=440 bs=1 count=4 conv=notrunc; sync" % self.utils.get_system_partition()[0:-1]
				print cmd1
				os.system("dos2unix /opt/wsysrt/Global.bcf")
				cmd2="sed -i \"s,VolumeSize.*,VolumeSize=$(cat /tmp/volume_size_file),\" /opt/wsysrt/Global.bcf"
				print cmd2
				cmd3="sed -i \"s,CurrentFullBackupUniqueId.*,CurrentFullBackupUniqueId=$(cat /tmp/full_backup_id_file),\" /opt/wsysrt/Global.bcf"
				print cmd3
				os.system(cmd1)
				#os.system(cmd2)
				os.system(cmd3)
				os.system("unix2dos /opt/wsysrt/Global.bcf")
				os.system("reboot")
				return False
			self.btn_next_press_event(None, None, None)
			self.btn_next.hide()
			self.btn_quit.hide()
			return False
		return True

	def set_all_btn_sensitive(self, sensitive):
		self.btn_next.set_sensitive(sensitive)
		self.btn_cancel.set_sensitive(sensitive)
		self.btn_halt.set_sensitive(sensitive)
		self.btn_reboot.set_sensitive(sensitive)

	def btn_cancel_press_event(self, widget, event, cmd):
		if(self.step == 3):
			self.destroy()
		else:
			self.window.hide()
		return True

	def clear(self):
		if self.mediatype == "harddisk":
			#must clear
			os.system("rm")

	def btn_halt_press_event(self, widget, event, cmd):
		self.clear()
		self.set_all_btn_sensitive(False)
		os.system("poweroff")
		return True
	
	def btn_reboot_press_event(self, widget, event, cmd):
		self.clear()
		self.set_all_btn_sensitive(False)
		os.system("reboot")
		return True
	
	def btn_next_press_event(self, widget, event, cmd):
		print "step:%d" % self.step
		print "304 ONCE: %s " % self.once
		print self.image_dir

		if self.step == 1: # present step 2
			self.btn_next.set_sensitive(False)
			self.btn_cancel.set_sensitive(False)
			self.btn_quit.set_sensitive(False)
			self.timeout_id = gobject.timeout_add(2000, self.timeout)
			self.pipein, self.pipeout = os.pipe()

			if not os.path.exists(ACTION_INI):
				f = open(ACTION_INI, "w")
				content = "[ACTION]\nSectorRec=Rec\nAutoReboot=False\n"
				f.write(content)				
				f.close()

			if not os.path.exists(RECOVER_CFG):
				f = open(RECOVER_CFG, "w")
				content = "*,%s\n" % self.recover_img
				f.write(content)
				f.close()

			thread.start_new_thread(self.recover_thread, ())
			utils = ssc_win_sys_restore_sec_utils.ssc_win_sys_restore_sec_utils()
			recover_img_info = utils.get_image_info(self.recover_img)
			# img_des = self.recover_img
			# img_des = img_des.replace(DATA_DIR, "")
			# img_des = img_des.replace(".bcf", "")
			# img_des = img_des.strip("/")
			# img_des = img_des.replace("-", ":")
			self.label_des.set_markup(_("Restore your Windows system to img point dated: %s, please wait...") % recover_img_info[COLUMN_TIME_STAMP])
			self.label_status.show()
			self.progressbar.show()
		elif self.step == 2: # present step 3
			# restore disk signature
			cmd1="dd if=/tmp/disk_sign_file of=%s obs=1 seek=440 bs=1 count=4 conv=notrunc; sync" % self.utils.get_system_partition()[0:-1]
			print cmd1
			os.system("dos2unix /opt/wsysrt/Global.bcf")
			cmd2="sed -i \"s,VolumeSize.*,VolumeSize=$(cat /tmp/volume_size_file),\" /opt/wsysrt/Global.bcf"
			print cmd2
			cmd3="sed -i \"s,CurrentFullBackupUniqueId.*,CurrentFullBackupUniqueid=$(cat /tmp/full_backup_id_file),\" /opt/wsysrt/Global.bcf"
			print cmd3
			os.system(cmd1)
			#os.system(cmd2)
			os.system(cmd3)
			os.system("unix2dos /opt/wsysrt/Global.bcf")
			self.btn_cancel.set_markup(_("Enter StarOS"))
			self.btn_cancel.set_sensitive(True)
			self.btn_halt.show()
			self.btn_reboot.show()
			self.label_status.hide()
			self.progressbar.hide()
			self.label_des.set_markup(_("Restore your Windows system finished successfully."))
		print "step", self.step
		self.step += 1
		#self.btn_quit.hide()
		self.btn_quit.set_sensitive(False)
		return True

	def __init__(self, recover_img, auto_start=False, image_dir="/opt/wsysrt", once=False, mediatype="harddisk"):
		self.recover_img = recover_img
		self.image_dir = image_dir
		self.once = once
		#self.window = gtk.Window(gtk.WINDOW_POPUP)
		self.window = gtk.Window()
		self.window.set_modal(True)
		self.window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
		self.mediatype = mediatype
		if mediatype == "harddisk":
			self.window.set_keep_above(True)
		else:
			pass
		self.window.set_decorated(False)
		self.window.set_resizable(False)

		self.layout = gtk.Layout()
		self.layout_scr = gtk.Layout()

		self.utils = ssc_win_sys_restore_sec_utils.ssc_win_sys_restore_sec_utils()

		bg = gtk.Image()
		doc = xml.dom.minidom.parse("res/" + "ssc_win_sys_restore_sec_recovery.xml")
		node = doc.getElementsByTagName("window_main")
		if node:
			bg.set_from_file(node[0].getAttribute("background"))
			self.window.set_size_request(
				string.atoi(node[0].getAttribute("width")),
				string.atoi(node[0].getAttribute("height")))
		self.layout.add(bg)

		node = doc.getElementsByTagName("label_description")
		if node:
			utils = ssc_win_sys_restore_sec_utils.ssc_win_sys_restore_sec_utils()
			recover_img_info = utils.get_image_info(self.recover_img)
			self.label_des = gtk.Label("")
			self.label_des.set_markup(_("System will be rollback to: %s.\n\nClick next to continue.") % recover_img_info[COLUMN_TIME_STAMP])
			self.label_des.set_line_wrap(True)
			self.label_des.set_size_request(string.atoi(node[0].getAttribute("width")),
											string.atoi(node[0].getAttribute("height"))+20)
			self.layout.put(self.label_des, string.atoi(node[0].getAttribute("x-coordinate")),
											string.atoi(node[0].getAttribute("y-coordinate")))
		
		self.label_status = gtk.Label(_("Finished:"))		

		node = doc.getElementsByTagName("button_next")
		if node:
			self.btn_next = ssc_button("./res/ssc_msp_button_small_1.png",
									   "./res/ssc_msp_button_small_2.png",
									   "./res/ssc_msp_button_small_3.png",
									   None,
									   _("Immediately"))
			self.btn_next.connect("button-press-event", self.btn_next_press_event, None)
			self.layout.put(self.btn_next,
							string.atoi(node[0].getAttribute("x-coordinate")),
							string.atoi(node[0].getAttribute("y-coordinate")))
		
		node = doc.getElementsByTagName("button_cancel")
		if node:
			self.btn_cancel = ssc_button("./res/ssc_msp_button_small_1.png",
										 "./res/ssc_msp_button_small_2.png",
										 "./res/ssc_msp_button_small_3.png",
										 None,
										 _("Cancel"))
			self.btn_cancel.connect("button-press-event", self.btn_cancel_press_event, None)
			self.layout.put(self.btn_cancel,
							string.atoi(node[0].getAttribute("x-coordinate")),
							string.atoi(node[0].getAttribute("y-coordinate")))
		self.btn_quit = ssc_button("./res/ssc_msp_button_small_1.png",
									 "./res/ssc_msp_button_small_2.png",
									 "./res/ssc_msp_button_small_3.png",
									 None,
									 "退出")
		self.btn_quit.connect("button-press-event", self.destroy, None)
		#self.layout.put(self.btn_quit, 415, 290)

		node = doc.getElementsByTagName("button_halt")
		if node:
			self.btn_halt = ssc_button("./res/ssc_msp_button_small_1.png",
									   "./res/ssc_msp_button_small_2.png",
									   "./res/ssc_msp_button_small_3.png",
									   None,
									   _("Halt"))
			self.btn_halt.connect("button-press-event", self.btn_halt_press_event, None)
			self.layout.put(self.btn_halt,
							string.atoi(node[0].getAttribute("x-coordinate")),
							string.atoi(node[0].getAttribute("y-coordinate")))
			
		node = doc.getElementsByTagName("button_reboot")
		if node:
			self.btn_reboot = ssc_button("./res/ssc_msp_button_small_1.png",
										 "./res/ssc_msp_button_small_2.png",
										 "./res/ssc_msp_button_small_3.png",
										 None,
										 _("Reboot"))
			self.btn_reboot.connect("button-press-event", self.btn_reboot_press_event, None)
			self.layout.put(self.btn_reboot,
							string.atoi(node[0].getAttribute("x-coordinate")),
							string.atoi(node[0].getAttribute("y-coordinate")))

		node = doc.getElementsByTagName("scrollwin_list")
		if node:
			self.scroll_win = gtk.ScrolledWindow()
			self.scroll_win.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
			self.scroll_win.set_shadow_type (gtk.SHADOW_IN);
			self.scroll_win.set_size_request(string.atoi(node[0].getAttribute("width")),
											 string.atoi(node[0].getAttribute("height")))

			model = self.__create_model()
			self.treeview = gtk.TreeView(model)
			self.__add_columns(self.treeview)
			self.scroll_win.add(self.treeview)
			self.layout.put(self.scroll_win,
							string.atoi(node[0].getAttribute("x-coordinate")),
							string.atoi(node[0].getAttribute("y-coordinate")))
			
		self.progressbar = gtk.ProgressBar()
		self.progressbar.set_size_request(400, 20)
		
		self.layout.put(self.label_status, 60, 180)
		self.layout.put(self.progressbar, 60, 200)

		self.window.connect("destroy", self.destroy)
		
		self.window.add(self.layout)
		
		gtk.gdk.threads_init()

		self.window.show_all()

		self.btn_halt.hide()
		self.btn_reboot.hide()
		
		self.progressbar.hide()
		self.label_status.hide()
		if(auto_start == True):
			self.btn_next_press_event(None, None, None)

class main_ui(gtk.Window):
	image_dir = ""
	once = False
	window = None
	layout = None
	model = None
	treeview = None
	label_des = None
	evtbox_help = None
	evtbox_details = None
	label_details = None

	recover_img = None
	interrupted = False

	btn_help = None
	btn_next = None
	btn_exit = None
	btn_cancel = None
	btn_focus = None
	
	utils = None
	img_list = None
	btn_help_handler = None
	mediatype = None

	def have_task(self):
		if os.path.exists(FLAG_INI):
			parser = ConfigParser.ConfigParser()
			try:
				parser.read(FLAG_INI)
				status = parser.get("flag", "result")
				if (status == "fail"):
					self.interrupted = True
			except:
				pass

		if os.path.exists(ACTION_INI):
			global AutoReboot
			parser = ConfigParser.ConfigParser()
			try:
				parser.read(ACTION_INI)
				val = parser.get("ACTION", "AutoReboot")
				if (val == "False"):
					AutoReboot = False
			except:
				pass
			return True

		return False

	def init_task(self):
		if not os.path.exists(RECOVER_CFG):
			return False
		f = open(RECOVER_CFG)
		for line in f.readlines():
			if line.rfind("/opt/") == -1:
				continue
			self.recover_img = line[line.rfind("/opt/"):].strip()

	def help_thread(self):
		pid = os.fork()
		if not pid:
			os.execlp("dillo", "dillo", "/opt/wsysrt/help/default.htm")
		os.waitpid(pid, 0)
		self.btn_focus.b_press = False
		self.btn_focus.leave_notify(None, None)
		self.btn_help_handler = self.btn_help.connect("button-press-event", self.btn_help_press_event, None)
		gobject.idle_add(self.window.set_keep_above, True)
		
	def destroy(*args):
		gtk.main_quit()
			
	def btn_exit_press_event(self, widget, event, cmd):
		self.destroy()
		return True
		
	def btn_autosearch_press_event(self, widget, event, cmd):
		self.destroy()
		return True

	def btn_help_press_event(self, widget, event, cmd):
		self.btn_focus = widget
		self.window.set_keep_above(False)
		self.btn_help.disconnect(self.btn_help_handler)
		thread.start_new_thread(self.help_thread, ())
		return True

	def evtbox_details_press_event(self, widget, event, cmd):
		model, iter = self.treeview.get_selection().get_selected()
		sw_list = software_list_window()
		sw_list.show(model[iter][COLUMN_IMAGE_FILE], model[iter][COLUMN_TYPE], self.utils.get_full_backup(model[iter][COLUMN_IMAGE_FILE]))
		return True

	def btn_next_press_event(self, widget, event, cmd):
		self.btn_focus = widget
		try:
			p = subprocess.Popen(["./rtp_util", "--get-state", self.utils.get_system_partition()])
			p.wait()
			if p.poll():
				win = ssc_message_window.ssc_message_window(None, 0, None, gtk.BUTTONS_YES_NO, _("RTP enabled on your system partition, would you like to disable it to continue?"))
				win.set_btn_yes_label(_("Disable RTP"));
				win.set_btn_no_label(_("Abort"));
				self.window.set_keep_above(False)
				win.run()
				self.window.set_keep_above(True)
				if win.response_id == gtk.RESPONSE_YES:
					p = subprocess.Popen(["./rtp_util", "--stop", self.utils.get_system_partition()])
					os.waitpid(p.pid, 0)
				else:
					return
		except:
			pass
	
		model, iter = self.treeview.get_selection().get_selected()
		if self.recover_img == None:
			self.recover_img = model[iter][COLUMN_IMAGE_FILE]
		utils = ssc_win_sys_restore_sec_utils.ssc_win_sys_restore_sec_utils()
		recover_img_info = utils.get_image_info(self.recover_img)
		
		print "size:%d\n" % recover_img_info[COLUMN_SIZE]
		f=os.popen("fdisk -s %s" % self.utils.get_system_partition(), "r")
		syspart_size=string.atoi(f.readline())*2+1
		f.close()
		original_size=self.utils.get_original_system_partition_size(self.recover_img)
		print "current system partition: %ld sectors" % syspart_size
		print "original system partition: %ld sectors" % original_size
		original_size_G=original_size*512.0/1024/1024/1024
		print "original system partition:%.2f G" % original_size_G
		if original_size > syspart_size and syspart_size>0:
			print "error"
			win = ssc_message_window.ssc_message_window_ok(None, 0, None, gtk.BUTTONS_YES_NO, _("Smaller! Original Size is %.2fGB") % original_size_G)
			self.window.set_keep_above(False)
			win.run()
			widget.b_press = False
	   		widget.leave_notify(None, None)
			return
		
		recovery_ui(self.recover_img, False, self.image_dir, once=self.once)
		widget.b_press = False
		widget.leave_notify(None, None)
	
	def __create_model(self):
		model = gtk.ListStore(
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING,
			gobject.TYPE_STRING
			)
		self.utils = ssc_win_sys_restore_sec_utils.ssc_win_sys_restore_sec_utils()
		self.img_list = self.utils.get_image_list()
		for item in self.img_list:
			size = item[COLUMN_SIZE] / 2 # unit: sector to KB
			unit = "sector"
			if size > 1024:
				size = float(size) / 1024
				unit = "MB"
			if size > 1024:
				size = size / 1024
				unit = "GB"

			if size == 0:
				continue
			
			size = "%.2f" % size + unit
			
			img_size = item[COLUMN_IMAGE_SIZE] / 1024 # unit: Byte
			unit = "KB"
			if img_size > 1024:
				img_size = float(img_size) / 1024
				unit = "MB"
			if img_size > 1024:
				img_size = img_size / 1024
				unit = "GB"
			img_size = "%.2f" % img_size + unit

			img_type = "Unknown"
			if item[COLUMN_TYPE] == True:
				img_type = _("Full backup")
			else:
				img_type = _("Delta backup")
			iter = model.append()
			model.set(iter,
					  COLUMN_TIME_STAMP, item[COLUMN_TIME_STAMP],
					  COLUMN_DESCRIPTION, item[COLUMN_DESCRIPTION],
					  COLUMN_TYPE, img_type,
					  COLUMN_SIZE, size,
					  COLUMN_IMAGE_SIZE, img_size,
					  COLUMN_IMAGE_FILE, item[COLUMN_IMAGE_FILE],
					  COLUMN_UNIQUE_ID, repr(item[COLUMN_UNIQUE_ID]),
					  COLUMN_FULL_UNIQUE_ID, repr(item[COLUMN_FULL_UNIQUE_ID])
					  )
			
		if len(self.img_list) == 0:
			self.btn_next.set_sensitive(False)
		return model

	def __add_columns(self, treeview):
		model = treeview.get_model()
		column = gtk.TreeViewColumn(_("Time-stamp"), gtk.CellRendererText(), text = COLUMN_TIME_STAMP)
		self.treeview.append_column(column)
		column = gtk.TreeViewColumn(_("Descriptions"), gtk.CellRendererText(), text = COLUMN_DESCRIPTION)
		self.treeview.append_column(column)
		column = gtk.TreeViewColumn(_("Type"), gtk.CellRendererText(), text = COLUMN_TYPE)
		self.treeview.append_column(column)
		column = gtk.TreeViewColumn(_("Size"), gtk.CellRendererText(), text = COLUMN_SIZE)
		self.treeview.append_column(column)
		column = gtk.TreeViewColumn(_("Image Size"), gtk.CellRendererText(), text = COLUMN_IMAGE_SIZE)
		self.treeview.append_column(column)
		column = gtk.TreeViewColumn(_("Image File"), gtk.CellRendererText(), text = COLUMN_IMAGE_FILE)
		# self.treeview.append_column(column) #
		column = gtk.TreeViewColumn(_("Unique ID"), gtk.CellRendererText(), text = COLUMN_UNIQUE_ID)
		# self.treeview.append_column(column) #
		column = gtk.TreeViewColumn(_("Full Backup Unique ID"), gtk.CellRendererText(), text = COLUMN_FULL_UNIQUE_ID)
		# self.treeview.append_column(column) #

	def __init__(self, image_dir=RECOVER_IMG_DIR, once="False", mediatype="harddisk"):
		self.image_dir=image_dir
		
		if once[0:4] == "True":
			self.once=True

		self.window = gtk.Window()
		self.window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
		self.mediatype = mediatype
		if mediatype == "livecd":
			self.window.set_keep_below(True)
		else:
			self.window.set_keep_above(True)
		self.window.set_decorated(False)
		self.window.set_resizable(False)

		self.layout = gtk.Layout()
		self.layout_scr = gtk.Layout()

		bg = gtk.Image()
		doc = xml.dom.minidom.parse("/opt/wsysrt/res/" + "ssc_win_sys_restore_sec_main.xml")
		node = doc.getElementsByTagName("window_main")
		if node:
			bg.set_from_file(node[0].getAttribute("background"))
			self.window.set_size_request(
				string.atoi(node[0].getAttribute("width")),
				string.atoi(node[0].getAttribute("height")))
		self.layout.add(bg)

		node = doc.getElementsByTagName("label_description")
		if node:
			self.label_des = gtk.Label(_("Please choose on restore image to continue."))
			self.label_des.set_line_wrap(True)
			self.label_des.set_size_request(string.atoi(node[0].getAttribute("width")),
											string.atoi(node[0].getAttribute("height")))
			self.layout.put(self.label_des, string.atoi(node[0].getAttribute("x-coordinate")),
											string.atoi(node[0].getAttribute("y-coordinate")))
	   
		node = doc.getElementsByTagName("button_help")
		if node:
			self.btn_help = ssc_button("./res/ssc_msp_toolbar_button_1.png",
										 "./res/ssc_msp_toolbar_button_2.png",
										 "./res/ssc_msp_toolbar_button_3.png",
										 "./res/ssc_msp_toolbar_help.png",
										 _("Help"))
			self.btn_help_handler = self.btn_help.connect("button-press-event", self.btn_help_press_event, None)
			#self.layout.put(self.btn_help,
			#				string.atoi(node[0].getAttribute("x-coordinate")),
			#				string.atoi(node[0].getAttribute("y-coordinate")))

		node = doc.getElementsByTagName("label_details")
		if node:
			self.label_details = gtk.Label()
			self.label_details.set_markup(_("Details"))
			self.label_details.set_use_underline(True)
			self.evtbox_details = gtk.EventBox()
			self.evtbox_details.add(self.label_details)
			self.evtbox_details.set_visible_window(False)
			self.evtbox_details.connect("button-press-event", self.evtbox_details_press_event, None)
			#self.layout.put(self.evtbox_details,
			#				string.atoi(node[0].getAttribute("x-coordinate")),
			#				string.atoi(node[0].getAttribute("y-coordinate")))
		
		node = doc.getElementsByTagName("button_next")
		if node:
			self.btn_next = ssc_button("./res/ssc_msp_button_1.png",
									   "./res/ssc_msp_button_2.png",
									   "./res/ssc_msp_button_3.png",
									   None,
									   _("Next"))
			self.btn_next.connect("button-press-event", self.btn_next_press_event, None)
			self.layout.put(self.btn_next,
							string.atoi(node[0].getAttribute("x-coordinate")),
							string.atoi(node[0].getAttribute("y-coordinate")))
			
		node = doc.getElementsByTagName("button_exit")
		if node:
			self.btn_exit = ssc_button("./res/ssc_msp_button_tiny_1.png",
									   "./res/ssc_msp_button_tiny_2.png",
									   "./res/ssc_msp_button_tiny_3.png",
									   "./res/ssc_msp_exit.png",
									   None)
			self.btn_exit.connect("button-press-event", self.btn_exit_press_event, None)
			#self.layout.put(self.btn_exit,
			#				string.atoi(node[0].getAttribute("x-coordinate")),
			#				string.atoi(node[0].getAttribute("y-coordinate")))
		
		node = doc.getElementsByTagName("button_cancel")
		if node:
			self.btn_cancel = ssc_button("./res/ssc_msp_button_1.png",
										 "./res/ssc_msp_button_2.png",
										 "./res/ssc_msp_button_3.png",
										 None,
										 _("Cancel"))
			self.btn_cancel.connect("button-press-event", self.btn_exit_press_event, None)
			self.layout.put(self.btn_cancel,
							string.atoi(node[0].getAttribute("x-coordinate")),
							string.atoi(node[0].getAttribute("y-coordinate")))

		#node = doc.getElementsByTagName("button_cancel")
		#if node:
			#self.btn_autosearch = ssc_button("./res/ssc_msp_button_1.png",
										 #"./res/ssc_msp_button_2.png",
										 #"./res/ssc_msp_button_3.png",
										 #None,
										 #_("AutoSearch"))
			#self.btn_autosearch.connect("button-press-event", self.btn_autosearch_press_event, None)
			#self.layout.put(self.btn_autosearch,
							#string.atoi(node[0].getAttribute("x-coordinate")),
							#string.atoi(node[0].getAttribute("y-coordinate"))+76)

		node = doc.getElementsByTagName("scrollwin_list")
		if node:
			self.scroll_win = gtk.ScrolledWindow()
			self.scroll_win.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
			self.scroll_win.set_shadow_type (gtk.SHADOW_IN);
			self.scroll_win.set_size_request(string.atoi(node[0].getAttribute("width")),
											 string.atoi(node[0].getAttribute("height")))

			model = self.__create_model()
			self.treeview = gtk.TreeView(model)
			self.__add_columns(self.treeview)
			self.scroll_win.add(self.treeview)
			self.layout.put(self.scroll_win,
							string.atoi(node[0].getAttribute("x-coordinate")),
							string.atoi(node[0].getAttribute("y-coordinate")))
			
		self.window.connect("destroy", self.destroy)
		
		self.window.add(self.layout)
		
		gtk.gdk.threads_init()

		self.window.show_all()

		#state_pipe("/tmp/startup_splash", "echo completed > /tmp/startup_splash")
		if self.have_task():
			if self.interrupted == True:
				self.window.hide()
				win = ssc_message_window.ssc_message_window(None, 0, None, gtk.BUTTONS_YES_NO, _("System recovery interrupted abnormally, are you sure want to continue?"))
				win.run()
				self.window.show()
				if win.response_id == gtk.RESPONSE_NO:
					os.remove(ACTION_INI)
					os.remove(RECOVER_CFG)
				else:
					self.init_task()
					print "844 self.once: %s" % self.once
					recovery_ui(self.recover_img, True, self.image_dir, self.once, self.mediatype)
			else:
				self.init_task()				
				print "848 self.once: %s" % self.once
				recovery_ui(self.recover_img, True, self.image_dir, self.once, self.mediatype)
		else:
			global AutoReboot
			AutoReboot = False

if __name__ == '__main__':
	gettext.bindtextdomain(APP_NAME, "./po")
	gettext.textdomain(APP_NAME)
	_ = gettext.gettext
	p = subprocess.Popen("/opt/wsysrt/auth_mgr/auth_mgr.py")
	p.wait()
	if p.poll():
		if p.returncode:
			exit(1)
	if len(sys.argv) > 1:
		print sys.argv
		main_ui(sys.argv[1], sys.argv[2], sys.argv[3])
	else:
		main_ui()
	gtk.main()

