#!/usr/bin/env python

""" SSC hard disk module """

import os, sys
import struct

APP_NAME = "ssc_disk"

BOOTDISK_INI = "/BootDisk.ini"

INFO_SECTOR_LBA = 3

# ACTION_TYPE_WINDOWS = 0x1
ACTION_TYPE_NORMAL = 0x0
ACTION_TYPE_LINUX  = 0x1
ACTION_TYPE_DOS_KV = 0x3

class ssc_disk:
    
    bootdisk = None
    
    def get_boot_disk(self):
        f = open(BOOTDISK_INI)
	for line in f.readlines():
		if line.find("BootDisk=") != -1:
                        self.bootdisk = line[line.find("BootDisk=") + len("BootDisk="):].strip()
			break
	f.close()
        # print self.bootdisk

    def set_action_type(self, action_type):
        f = open(self.bootdisk, "r+b", 0)
        # f = open("/root/staros.mbr.128.bin", "r+b", 0)
	f.seek(512 * INFO_SECTOR_LBA, 0)
	info_sector = f.read(512)
	if info_sector[0:11] != "$InfoSector":
		print "SignFlag error"
	i = 0
	crc = 0L
	new_info_sector = info_sector[0:14] + struct.pack('B', action_type) + info_sector[15:]
	info_sector = new_info_sector
	while i < 508:
		crc += (ord(info_sector[i]) << 0) + (ord(info_sector[i + 1]) << 8) + (ord(info_sector[i + 2]) << 16) + (ord(info_sector[i + 3]) << 24)
		i += 4
# 	print "CRC32 = ", hex((crc))
# 	print "CRC32 = ", hex((crc & 0x000000FFL))
# 	print "CRC32 = ", hex((crc & 0x0000FF00L) >> 8)
# 	print "CRC32 = ", hex((crc & 0x00FF0000L) >> 16)
# 	print "CRC32 = ", hex((crc & 0xFF000000L) >> 24)
	rcrc = 0 - crc
	new_info_sector = info_sector[0:508] + struct.pack('BBBB', (rcrc & 0x000000FFL), ((rcrc & 0x0000FF00L) >> 8), ((rcrc & 0x00FF0000L) >> 16), ((rcrc & 0xFF000000L) >> 24))
	info_sector = new_info_sector
	crc += (ord(info_sector[508]) << 0) + (ord(info_sector[509]) << 8) + (ord(info_sector[510]) << 16) + (ord(info_sector[511]) << 24)
# 	print "CRC32 = ", hex(crc)
 	# print "CRC32 = ", hex(crc & 0xFFFFFFFFL)
# 	print "SignFlag: ", info_sector[0:11]	
# 	print "VersionMajor: ", ord(info_sector[12])
# 	print "VersionMinor: ", ord(info_sector[13])
# 	print "ActionType: ",  ord(info_sector[14])
# 	print "TempType: ",  ord(info_sector[15])
# 	print "HiddenStart: ",  repr(info_sector[16:16 + 4])
#  	print "BootDate: ",  info_sector[20:20 + 4]
#  	print "Hpa: ", ord(info_sector[24])
#  	print "HpaFail: ", ord(info_sector[25])
#  	print "Debug: ",  repr(info_sector[26:26 + 2])
#  	print "Remain: ",  repr(info_sector[28:28 + 4])
#  	print "Sectors: ",  repr(info_sector[32:32 + 4])
#  	print "Reserved: ",  repr(info_sector[36:36 + 472 + 8])	
# 	print "CRC32 = ", hex(ord(info_sector[508]))
# 	print "CRC32 = ", hex(ord(info_sector[509]))
# 	print "CRC32 = ", hex(ord(info_sector[510]))
# 	print "CRC32 = ", hex(ord(info_sector[511]))
	f.seek(512 * INFO_SECTOR_LBA, 0)
	f.write(info_sector)
        f.flush()
        os.fsync(f.fileno())
	f.close()

    def check_info_sector(self):
        # f = open("/root/staros.mbr.128.bin", "r+b", 0)
        f = open(self.bootdisk, "r+b", 0)
	f.seek(512 * INFO_SECTOR_LBA, 0)
	info_sector = f.read(512)
	if info_sector[0:11] != "$InfoSector":
		print "SignFlag error"
	i = 0
	crc = 0L
	while i < 512:
		crc += (ord(info_sector[i]) << 0) + (ord(info_sector[i + 1]) << 8) + (ord(info_sector[i + 2]) << 16) + (ord(info_sector[i + 3]) << 24)
		i += 4
 	# print "CRC32 = ", hex(crc)
 	# print "CRC32 = ", hex(crc & 0xFFFFFFFFL)
        if (crc & 0xFFFFFFFFL) != 0:
            print "CRC32 error"

	f.close()        
        
    def __init__(self):
        self.get_boot_disk()
        # self.set_action_type(ACTION_TYPE_LINUX)
        # self.set_action_type(ACTION_TYPE_NORMAL)
        self.check_info_sector()


if __name__ == '__main__':
    sd = ssc_disk()
