#!/usr/bin/env python

""" This is the main src of SSC MSP platform framework """

import os, sys
import gobject
import gtk

# import locale
import gettext

from ssc_widget import *

APP_NAME = "ssc_messge_window"

gettext.bindtextdomain(APP_NAME, "/usr/local/share/locale/")
gettext.textdomain(APP_NAME)
_ = gettext.gettext

# class ssc_message_window(buttons):
class ssc_message_window:
    
    response_id = None

    window = None
    
    btn_yes = None
    btn_no = None
    
    def on_btn(self, widget, event, cmd):
        if widget == self.btn_yes:
            self.response_id = gtk.RESPONSE_YES
        elif widget == self.btn_no:
            self.response_id = gtk.RESPONSE_NO
        gtk.main_quit()
        self.window.hide()

    def set_btn_yes_label(self, label):
        self.btn_yes.set_markup(label);
        
    def set_btn_no_label(self, label):
        self.btn_no.set_markup(label);
        
    def __init__(self, parent, flags, icon_type, buttons, message_format):
        layout = gtk.Layout()

        self.btn_yes = ssc_button("./res/ssc_msp_button_small_1.png",
                            "./res/ssc_msp_button_small_2.png",
                            "./res/ssc_msp_button_small_3.png",
                            None,
                            _("Yes"))
        self.btn_no = ssc_button("./res/ssc_msp_button_small_1.png",
                            "./res/ssc_msp_button_small_2.png",
                            "./res/ssc_msp_button_small_3.png",
                            None,
                            _("No"))
        # self.btn_yes = gtk.Button(_("Yes"))
        # self.btn_no = gtk.Button(_("No"))
        # self.btn_yes.set_size_request(60, 30)
        # self.btn_no.set_size_request(60, 30)

        self.btn_yes.connect("button-press-event", self.on_btn, None)
        self.btn_no.connect("button-press-event", self.on_btn, None)

        label = gtk.Label()
        label.set_line_wrap(True)
        label.set_markup(message_format)
        
        self.window = gtk.Window()        
        self.window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
        self.window.set_decorated(False)
        self.window.set_resizable(False)
        self.window.set_size_request(413, 220)

        self.window.add(layout)

        img_bg = gtk.Image()
        img_bg.set_from_file("./res/ssc_msp_message_window_bg.png")
        
        img_icon = gtk.Image()
        img_icon.set_from_file("./res/ssc_msp_message_window_icon_question.png")
        
        layout.put(img_bg, 0, 0)
        layout.put(img_icon, 5, 80)
        layout.put(label, 60, 70)
        if buttons == gtk.BUTTONS_YES_NO:
            layout.put(self.btn_yes, 180, 170)
            layout.put(self.btn_no, 280, 170)
        
    def run(self):
        self.window.show_all()
        gtk.main()
    
class ssc_message_window_ok:
    
    response_id = None

    window = None
    
    btn_yes = None
    btn_no = None
    
    def on_btn(self, widget, event, cmd):
        if widget == self.btn_yes:
            self.response_id = gtk.RESPONSE_YES
        elif widget == self.btn_no:
            self.response_id = gtk.RESPONSE_NO
        gtk.main_quit()
        self.window.hide()

    def set_btn_yes_label(self, label):
        self.btn_yes.set_markup(label);
        
    def set_btn_no_label(self, label):
        self.btn_no.set_markup(label);
        
    def __init__(self, parent, flags, icon_type, buttons, message_format):
        layout = gtk.Layout()

        self.btn_no = ssc_button("./res/ssc_msp_button_small_1.png",
                            "./res/ssc_msp_button_small_2.png",
                            "./res/ssc_msp_button_small_3.png",
                            None,
                            _("Ok"))
        self.btn_no.connect("button-press-event", self.on_btn, None)

        label = gtk.Label()
        label.set_line_wrap(True)
        label.set_markup(message_format)
        
        self.window = gtk.Window()        
        self.window.set_position(gtk.WIN_POS_CENTER_ALWAYS)
        self.window.set_decorated(False)
        self.window.set_resizable(False)
        self.window.set_size_request(413, 220)

        self.window.add(layout)

        img_bg = gtk.Image()
        img_bg.set_from_file("./res/ssc_msp_message_window_bg.png")
        
        img_icon = gtk.Image()
        img_icon.set_from_file("./res/ssc_msp_message_window_icon_question.png")
        
        layout.put(img_bg, 0, 0)
        layout.put(img_icon, 5, 80)
        layout.put(label, 60, 70)
        layout.put(self.btn_no, 280, 170)
        
    def run(self):
        self.window.show_all()
        gtk.main()

if __name__ == '__main__':
    win = ssc_message_window(None, 0, None, gtk.BUTTONS_YES_NO, "message_format")
    win.run()
    gtk.main()
    
