#!/usr/bin/env python

""" Utils for Windows System Recovery plug-in """

import os, sys
import ConfigParser
import glob
import string
import binascii
import time
from stat import *

APP_NAME = "ssc_win_sys_restore_sec_utils"
RECOVER_IMG_DIR = "/opt/wsysrt"

class BACKUP_POINT_CONFIG:
	UniqueId = long 
	BackupTime = long 
	FullBackupUniqueId = long 
	CompressInfo = long 
	SectorsPerBlock = long 
	FullSize = long 
	BackupInfo = [512] # char[512]
	VolumeSize = long 
	FsType = [1]
	FactoryBackup = long # char
	Reserved = [2] # char
	BitmapSize = long 
	BitmapCRC = long 
	CompressHdrSize = long 
	BytesPerCompressBlock = long 
	Reserved2 = [464] # char

class ssc_win_sys_restore_sec_utils:

	def get_system_partition(self):
		parser = ConfigParser.ConfigParser()
		parser.read("/BootDisk.ini")
		return parser.get("SysPart", "SysPart")
	
	def get_original_system_partition_size(self, fn):
		bpc = [1024]
		img_list = []
		f = open(fn, "rb", 0)
		# print fn
		bpc = f.read(1024)
		f.close()
		volume_size = ((ord(bpc[539]) << 24) + (ord(bpc[538]) << 16) + (ord(bpc[537]) << 8) + ord(bpc[536]))
		print "volume_size: %ld\n" % volume_size
		return volume_size
			
	def get_image_list(self):
		bpc = [1024]
		img_list = []
		file_list = glob.glob(RECOVER_IMG_DIR + "/" + "1*-*.bcf") + glob.glob(RECOVER_IMG_DIR + "/" + "2*-*.bcf")
		for fn in file_list:
			img_list.append(self.get_image_info(fn))
			print "--"
		return img_list

	def get_image_size(self, fn):
		img_size = 0
		for i in glob.glob(fn.replace(".bcf", ".bc*")):
			img_size = img_size + os.stat(i)[ST_SIZE]
		return img_size
	
	def get_image_info(self, fn):
		bpc = [1024]
		img_list = []
		f = open(fn, "rb", 0)
		# print fn
		bpc = f.read(1024)
		f.close()
		tm = time.localtime((ord(bpc[7]) << 24) + (ord(bpc[6]) << 16) + (ord(bpc[5]) << 8) + (ord(bpc[4])))
		# print "BackupInfo: ", unicode(bpc[24:536], 'gb2312')			
		# print "FullSize: ", ((ord(bpc[23]) << 24) + (ord(bpc[22]) << 16) + (ord(bpc[21]) << 8) + (ord(bpc[20])))
		str_uni = bpc[24:24+256].decode('UTF-16')
		str_utf8 = str_uni.encode("utf8")
		disk_sign_value = (ord(bpc[563:564]) << 24) + (ord(bpc[562:563]) << 16) + (ord(bpc[561:562]) << 8) + (ord(bpc[560:561]))
		print "utils: disk signature: %x %x %x %x \n value: %x" % ( ord(bpc[560:561]), ord(bpc[561:562]), ord(bpc[562:563]), ord(bpc[563:564]), disk_sign_value )
		disk_sign_file = open("/tmp/disk_sign_file","wb")
		format = "L"
		import struct
		disk_sign_data=struct.pack(format, disk_sign_value)
		disk_sign_file.write(disk_sign_data)
		disk_sign_file.close()
		uniqu_backup_id = (ord(bpc[3:4]) << 24) + (ord(bpc[2:3]) << 16) + (ord(bpc[1:2])<<8) + (ord(bpc[0:1]))
		full_backup_id = (ord(bpc[11:12]) << 24) + (ord(bpc[10:11]) << 16 ) + (ord(bpc[9:10]) << 8) + (ord(bpc[8:9])) 
		if full_backup_id == 0:
			full_backup_id = uniqu_backup_id
		print "full_backup_id: %d\n" % full_backup_id
		full_backup_id_file=open("/tmp/full_backup_id_file","w")
		full_backup_id_file.write("%d" % full_backup_id)
		full_backup_id_file.close()
		
		volume_size_back = (ord(bpc[539]) << 24) + (ord(bpc[538]) << 16 ) + (ord(bpc[537]) << 8) + (ord(bpc[536])) 
		print "volume_size_back: %d\n" % volume_size_back
		volume_size_file=open("/tmp/volume_size_file","w")
		volume_size_file.write("%d" % volume_size_back)
		volume_size_file.close()
		return ["%04d/%02d/%02d-%02d:%02d:%02d" % (tm.tm_year,  tm.tm_mon, tm.tm_mday, tm.tm_hour, tm.tm_min, tm.tm_sec),
				str_utf8,
				(repr(bpc[8]) == repr('\0')),
				((ord(bpc[23]) << 24) + (ord(bpc[22]) << 16) + (ord(bpc[21]) << 8) + (ord(bpc[20]))),
				self.get_image_size(fn),
				fn,
				bpc[0:4],
				bpc[8:12],
				]
	
	def get_image_list1(self):
		bpc = [1024]
		img_list = []
		file_list = glob.glob(RECOVER_IMG_DIR + "/" + "1*-*.bcf") + glob.glob(RECOVER_IMG_DIR + "/" + "2*-*.bcf")
		for fn in file_list:
			f = open(fn, "rb", 0)
			# print fn
			bpc = f.read(1024)
			f.close()
			tm = time.localtime((ord(bpc[7]) << 24) + (ord(bpc[6]) << 16) + (ord(bpc[5]) << 8) + (ord(bpc[4])))
			# print "BackupInfo: ", unicode(bpc[24:536], 'gb2312')			
			# print "FullSize: ", ((ord(bpc[23]) << 24) + (ord(bpc[22]) << 16) + (ord(bpc[21]) << 8) + (ord(bpc[20])))
			str_uni = bpc[24:24+256].decode('UTF-16')
			str_utf8 = str_uni.encode("utf8")
			img_list.append(["%04d/%02d/%02d-%02d:%02d:%02d" % (tm.tm_year,  tm.tm_mon, tm.tm_mday, tm.tm_hour, tm.tm_min, tm.tm_sec),
							 str_utf8,
							 (repr(bpc[8]) == repr('\0')),
							 ((ord(bpc[23]) << 24) + (ord(bpc[22]) << 16) + (ord(bpc[21]) << 8) + (ord(bpc[20]))),
							 fn,
							 bpc[0:4],
							 bpc[8:12]
							 ])
			print "--"
		return img_list

	def get_full_backup(self, delta_img):
		full_bpc = [1024]
		delta_bpc = [1024]

		full_backup_img = None

		f = open(delta_img, "rb", 0)
		delta_bpc = f.read(1024)
		f.close()

		file_list = glob.glob(RECOVER_IMG_DIR + "/" + "1*-*.bcf") + glob.glob(RECOVER_IMG_DIR + "/" + "2*-*.bcf")
		for fn in file_list:
			f = open(fn, "rb", 0)
			full_bpc = f.read(1024)
			f.close()
			if delta_bpc[8:12] == full_bpc[0:4]:
				full_backup_img = fn
				break
		return full_backup_img

	def __init__(self):
		pass

if __name__ == '__main__':
	util = ssc_win_sys_restore_sec_utils()
	util.get_image_list()
	print util.get_system_partition()
