#!/bin/bash

NORMAL="\E[0;39m"
RED="\E[1;31m"
GREEN="\E[1;32m"
YELLOW="\E[1;33m"
BLUG="\E[1;34m"

APP_TEMP_INST_PATH=/mnt/hidpart/install/apps

function install_application_task()
{
	echo -e "${RED}Install applications ... ${NORMAL}"
	for appname in /mnt/hidpart/install/apps/*; do
		NAME=`basename $appname`
		#find /appnament/hidpart/Data/apps/$NAME -name *.pyc | xargs rm
		cp -a $appname /mnt/hidpart/StarOS/apps/
		rm -rf $appname
	done
	
	return 0
}

function merge_application()
{
	echo -e "${RED}Merge applications ... ${NORMAL}"
	mkdir /opt ; umount /opt 1>/dev/null 2>/dev/null

	UNIONFS_BRANCH="/mnt/hidpart/StarOS/changes/"
	
	#unionfs initilization
	#just for StarCenter2.5 to adjust linux and windows applications
	[ -d /mnt/hidpart/Data/apps/sc25 ] && UNIONFS_BRANCH=$UNIONFS_BRANCH:/mnt/hidpart/Data/apps/sc25/opt=rw

	for i in /mnt/hidpart/StarOS/apps/*; do
		DIR_NAME=`basename $i`
	  	if [ -e /mnt/hidpart/StarOS/apps/$DIR_NAME/guid.conf ]; then
     		#只有在Linux下有客户端的插件,只有guid.conf文件的才当作插件
				if [ -e /mnt/hidpart/Data/apps/$DIR_NAME ]; then
					UNIONFS_BRANCH=$UNIONFS_BRANCH:/mnt/hidpart/Data/apps/$DIR_NAME/opt/=rw
				fi
				UNIONFS_BRANCH=$UNIONFS_BRANCH:/mnt/hidpart/StarOS/apps/$DIR_NAME/opt/=ro
      fi
	done

	echo "UNIONFS_BRANCH: $UNIONFS_BRANCH"
	mount -t unionfs -o dirs=$UNIONFS_BRANCH nont /opt
	
}

function update_application()
{
	UPDATED=NO
	for i in /mnt/hidpart/Data/Update/*tar.gz; do
	if [ -e $i ]; then
		TEMP_DIR=`mktemp -d /tmp/update.XXXXXX`
		tar xzf $i -C $TEMP_DIR
		cd $TEMP_DIR
		./update
		RESULT=$?
		cd -
		rm -rf $i
		rm -rf $TEMP_DIR
	#log
	TIME=`date  +"%Y-%m-%d %T"`
	if [ $RESULT -eq 1 ]; then
		RESULT=SUCCESSED
		UPDATED=YES
	else
		RESULT=FAILED
	fi
	UPDATE_PACKAGE_NAME=`basename $i`
	echo "$TIME $UPDATE_PACKAGE_NAME $RESULT" >> /mnt/hidpart/StarOS/Update.log

	fi #if exist
	done

	if [ "$UPDATED" = "YES" ]; then
		reboot
	fi
}


find /mnt/hidpart/ -name ".wh.*" -exec rm {} \;

python /mnt/hidpart/StarOS/scripts/shell/del_task_manager.py

#run install
install_application_task

#run updates
update_application

#merge application and data into runtime structure with unionfs
merge_application 

