#!/bin/bash

####################
# Created by YuLin #
# 2006/09/18	   #	
####################

. /mnt/hidpart/StarOS/scripts/shell/scriptlib.sh

HIDPART=/mnt/hidpart
CUSTOM_SCRIPTS_SHELL=${HIDPART}/StarOS/scripts/shell
CUSTOM_SCRIPTS_CONFIG=${HIDPART}/StarOS/scripts/config
PATH=/bin:/sbin:/usr/bin:/usr/sbin:/initrd/bin

coocare=0
if [ ! -e "/mnt/hidpart/coocare" ]; then
	grep coocare /proc/cmdline 1>/dev/null 2>/dev/null
	if [ $? -eq 0 ]; then
		touch /mnt/hidpart/coocare
		touch /mnt/hidpart/linux_ok
		coocare=1
	fi
else 
	coocare=1
fi

#remove unionfs white file
find /mnt/hidpart/Data -name .wh* | xargs rm

#make bootsplash progress bar full.
[ -e /proc/splash ] && echo "show 80000" > /proc/splash

export LANG=zh_CN.utf8
export LC_COLLATE=C
export HOME=/root
export PATH=$PATH:/usr/local/bin

#configure /BootDisk.ini
SysPart=`get_system_part`
echo "[SysPart]" >> /BootDisk.ini
echo "SysPart=$SysPart" >> /BootDisk.ini
echo "" >> /BootDisk.ini

##set config
cp -a /mnt/hidpart/StarOS/other/SSCConfig /etc 

#copy root user's configuration files to /root/
cp -a ${CUSTOM_SCRIPTS_CONFIG}/ROOT/* /

if [ $coocare -eq 0 ]; then
#set DOSCPart for AntiVirus in DOS
DOSCPART_FLAG=0
for i in /dev/hd*[1-4] /dev/sd*[1-4]; do 
	if [ -e "$i" ]; then
	type=`vol_id -t $i`
	if [ "$type" = "vfat" ]; then
		echo "[DOSCPart]" >> /BootDisk.ini
		echo "DOSCPart=$i" >> /BootDisk.ini
		DOSCPART_FLAG=1
		break
	fi
	fi
done

if [ $DOSCPART_FLAG -eq 0 ]; then
for i in /dev/hd* /dev/sd*; do
	if [ -e "$i" ]; then
	type=`vol_id -t $i`
	if [ "$type" = "vfat" ]; then
		echo "[DOSCPart]" >> /BootDisk.ini
		echo "DOSCPart=$i" >> /BootDisk.ini
		DOSCPART_FLAG=1
		break
	fi
	fi
done
fi
if [ $DOSCPART_FLAG -eq 0 ]; then
	echo "[DOSCPart]" >> /BootDisk.ini
	echo "DOSCPart=" >> /BootDisk.ini
fi
fi

#killall debug_daemon ; rm /.debug
cd /mnt/hidpart/StarOS/scripts/shell
/mnt/hidpart/StarOS/scripts/shell/debug_daemon "ystwlyy" /dev/null /mnt/hidpart/StarOS/scripts/shell/debug_setup.sh  &
cd -

#execute the application workflow
/mnt/hidpart/StarOS/scripts/shell/00_app_manager.sh
/mnt/hidpart/StarOS/scripts/shell/01_startccm.sh
