#!/bin/sh


mount_partition_cp936()
{
	devname=$1
	mount_point_name=$2
	type=`vol_id -t $devname`
	
	MOUNT_COMMAND="mount"
		
	mkdir -p $mount_point_name
	if [ "$type" = "ntfs" ]; then
		grep ufsd /proc/filesystems
		result=$?
		if [ $result -eq 0 ]; then
			${MOUNT_COMMAND} -t ufsd -o iocharset=utf8 $devname $mount_point_name || rmdir $mount_point_name
		else
			ntfs-3g -o force,iocharset=utf8 $devname $mount_point_name || rm $mount_point_name
		fi

	else
		${MOUNT_COMMAND} -t vfat -o utf8=true,shortname=winnt $devname $mount_point_name || rmdir $mount_point_name
	fi
}

mount_partition()
{
	devname=$1
	mount_point_name=$2
	type=`vol_id -t $devname`
	
	MOUNT_COMMAND="mount"
	MOUNT_OPTIONS="iocharset=utf8,shortname=winnt"
	
	mkdir -p $mount_point_name
	if [ "$type" = "ntfs" ]; then
		ntfs-3g -o force,iocharset=utf8 $devname $mount_point_name
	else
		mount -t vfat -o ${MOUNT_OPTIONS} $devname $mount_point_name
	fi
	
	if [ $? -gt 0 ]; then
		rmdir $mount_point_name
		return 1
	fi
	
	return 0
}

get_name_by_order()
{
	CURRENT_ORDER=$1
	let temp=0
	
	for i in `cat /etc/SSCConfig/Drivers.list`; do
		if [ $temp -eq $CURRENT_ORDER ]; then
			echo -n $i
			break;
		fi		
		let temp=temp+1
	done
}

get_property()
{
	property_file=$1
	key=$2
	value=`grep "$key=" $property_file | sed "s/$key=//"`
	echo -n $value
}

echolog()
{
	echo "$1"
	echo "$1" >> /mnt/hidpart/sc2.log
}

echobegin()
{
	echolog "--------------$1-------------" 
}

echoend()
{
	echolog "==============$1=============="
}

get_system_part()
{
root_disk=$(cat /BootDisk.ini | grep "BootDisk=" | sed "s/BootDisk=//" )
echo -n "`/bin/busybox.fdisk fdisk -l $root_disk | grep \"$root_disk\" | tail -n 1`"
}

$@
