/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.io.filefilter.FileFilterUtils;

class GenerateClasspathCommand
implements Command {
    private final IO io;

    GenerateClasspathCommand(IO iO) {
        this.io = iO;
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.createClassPathTxt(file, installFlowControlHandler);
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.createClassPathTxt(file, installFlowControlHandler);
    }

    private void createClassPathTxt(File file, InstallFlowControlHandler installFlowControlHandler) throws InterruptedException {
        File file2 = new File(new File(file, "toolbox"), "local");
        File[] fileArray = this.io.listFiles(new File(file2, "classpath"), (FilenameFilter)FileFilterUtils.suffixFileFilter((String)".jcp"));
        File file3 = new File(file2, "classpath.txt");
        this.io.deleteFile(file3);
        if (fileArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder("# DO NOT MODIFY THIS FILE.  IT IS AN AUTOGENERATED FILE.");
            String string = System.getProperty("line.separator");
            stringBuilder.append(string);
            stringBuilder.append("$matlabroot/java/patch").append(string);
            try {
                for (File file4 : fileArray) {
                    stringBuilder.append(this.io.readFileToString(file4).trim());
                    stringBuilder.append(string);
                }
                this.io.writeStringToFile(stringBuilder.toString(), file3, System.currentTimeMillis(), 420, new IOObserver[0]);
            }
            catch (IOException iOException) {
                this.io.deleteFile(file3);
                installFlowControlHandler.exitImmediately(iOException);
            }
        }
    }
}

