/*
 * Decompiled with CFR 0.152.
 */
package p.rn.asm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;
import p.rn.ClassInfo;

public class ScanLibVisitor
extends EmptyVisitor {
    private ClassInfo clz;
    private Map<String, ClassInfo> map = new HashMap<String, ClassInfo>();

    public Map<String, ClassInfo> getClassMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.clz = new ClassInfo();
        this.clz.access = access;
        this.clz.name = name;
        if (superName != null) {
            this.clz.parent.add(superName);
        }
        if (interfaces != null) {
            this.clz.parent.addAll(Arrays.asList(interfaces));
        }
        this.map.put(name, this.clz);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        ClassInfo.MemberInfo f = new ClassInfo.MemberInfo();
        this.clz.members.put(name, f);
        f.name = name;
        f.desc = desc;
        f.access = access;
        f.value = value;
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name) || "<cinit>".equals(name)) {
            return null;
        }
        ClassInfo.MemberInfo m = new ClassInfo.MemberInfo();
        this.clz.members.put(name + desc, m);
        m.name = name;
        m.desc = desc;
        m.access = access;
        return null;
    }
}

