/*
 * Decompiled with CFR 0.152.
 */
package p.rn.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import p.rn.util.FileOut;

public class FileWalker {
    private StreamHandler handler;

    public void setStreamHandler(StreamHandler handler) {
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walk(File dirORzip) throws IOException {
        if (dirORzip.isDirectory()) {
            this.walkDir("", dirORzip, new FileStreamOpener());
        } else {
            final ZipInputStream zis = new ZipInputStream(FileUtils.openInputStream((File)dirORzip));
            try {
                StreamOpener opener = new StreamOpener(){

                    @Override
                    public InputStream get() {
                        return zis;
                    }
                };
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    this.handler.handle(entry.isDirectory(), entry.getName(), entry.isDirectory() ? null : opener, entry);
                    zis.closeEntry();
                    entry = zis.getNextEntry();
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)zis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void walkDir(String s, File dir, FileStreamOpener current) throws IOException {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.handler.handle(true, s + file.getName() + '/', null, file);
                this.walkDir(file.getName() + '/', file, current);
                continue;
            }
            current.setFile(file);
            try {
                this.handler.handle(false, s + file.getName(), current, file);
            }
            finally {
                IOUtils.closeQuietly((Closeable)current);
            }
        }
    }

    public FileWalker withStreamHandler(StreamHandler handler) {
        this.handler = handler;
        return this;
    }

    public static class OutAdapter
    implements StreamHandler {
        protected FileOut.OutHandler outHandler;

        public OutAdapter(FileOut.OutHandler outHandler) {
            this.outHandler = outHandler;
        }

        @Override
        public void handle(boolean isDir, String name, StreamOpener current, Object nameObject) throws IOException {
            this.outHandler.write(isDir, name, current == null ? null : current.get(), nameObject);
        }
    }

    public static interface StreamOpener {
        public InputStream get() throws IOException;
    }

    public static interface StreamHandler {
        public void handle(boolean var1, String var2, StreamOpener var3, Object var4) throws IOException;
    }

    private static final class FileStreamOpener
    implements StreamOpener,
    Closeable {
        private File file;
        private FileInputStream fis;

        private FileStreamOpener() {
        }

        @Override
        public void close() {
            IOUtils.closeQuietly((InputStream)this.fis);
        }

        @Override
        public InputStream get() throws IOException {
            this.fis = FileUtils.openInputStream((File)this.file);
            return this.fis;
        }

        public void setFile(File file) {
            this.file = file;
            this.fis = null;
        }
    }
}

