/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.DexOpcodes;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.reader.DexDebugInfoReader;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.reader.DexOpcodeAdapter;
import com.googlecode.dex2jar.reader.OpcodeFormat;
import com.googlecode.dex2jar.reader.io.DataIn;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import java.util.Map;
import java.util.TreeMap;

class DexCodeReader
implements DexOpcodes {
    private DexFileReader dex;
    private DataIn in;
    Map<Integer, DexLabel> labels = new TreeMap<Integer, DexLabel>();
    private boolean isStatic;
    private Method method;

    DexCodeReader(DexFileReader dex, DataIn in, boolean isStatic, Method method) {
        this.dex = dex;
        this.in = in;
        this.method = method;
        this.isStatic = isStatic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void findLabels(DataIn in, int instruction_size) {
        baseOffset = in.getCurrentPosition();
        currentOffset = 0;
        while (currentOffset < instruction_size) {
            block26: {
                opcode = in.readUShortx();
                uOpcodeH = opcode >> 8;
                uOpcodeL = opcode & 255;
                if (uOpcodeL != 255) {
                    opcode = uOpcodeL;
                }
                format = OpcodeFormat.get(opcode, this.dex.apiLevel);
                try {
                    block2 : switch (opcode) {
                        case 40: {
                            this.order(currentOffset + (byte)uOpcodeH);
                            break;
                        }
                        case 41: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: {
                            this.order(currentOffset + in.readShortx());
                            break;
                        }
                        case 42: {
                            this.order(currentOffset + DexCodeReader.xInt(in));
                            break;
                        }
                        case 43: 
                        case 44: {
                            offset = DexCodeReader.xInt(in);
                            in.push();
                            try {
                                in.skip((offset - 3) * 2);
                                switch (opcode) {
                                    case 44: {
                                        in.skip(2);
                                        switch_size = in.readUShortx();
                                        in.skip(4 * switch_size);
                                        for (j = 0; j < switch_size; ++j) {
                                            this.order(currentOffset + in.readIntx());
                                        }
                                        this.order(currentOffset + 3);
                                        ** break;
lbl36:
                                        // 1 sources

                                        break block26;
                                    }
                                    case 43: {
                                        in.skip(2);
                                        switch_size = in.readUShortx();
                                        in.skip(4);
                                        for (j = 0; j < switch_size; ++j) {
                                            targetOffset = in.readIntx();
                                            this.order(currentOffset + targetOffset);
                                        }
                                        this.order(currentOffset + 3);
                                        break block26;
                                    }
                                    ** default:
lbl48:
                                    // 1 sources

                                    break block26;
                                }
                            }
                            finally {
                                in.pop();
                            }
                        }
                        case 0: {
                            switch (uOpcodeH) {
                                case 0: {
                                    break block2;
                                }
                                case 1: {
                                    switch_size = in.readUShortx();
                                    in.skip(switch_size * 4 + 4);
                                    break block2;
                                }
                                case 2: {
                                    switch_size = in.readUShortx();
                                    in.skip(switch_size * 8);
                                    break block2;
                                }
                                case 3: {
                                    element_width = in.readUShortx();
                                    size = in.readUIntx();
                                    in.skip(size * element_width + 1 & -2);
                                    break block2;
                                }
                            }
                            break;
                        }
                        default: {
                            in.skip(2 * format.getSize() - 2);
                        }
                    }
                }
                catch (Exception e) {
                    throw new DexException(e, String.format("while scan for label, Posotion :%04x", new Object[]{currentOffset}), new Object[0]);
                }
            }
            currentOffset = (in.getCurrentPosition() - baseOffset) / 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findTryCatch(DataIn in, DexCodeVisitor dcv, int tries_size) {
        int encoded_catch_handler_list = in.getCurrentPosition() + tries_size * 8;
        for (int i = 0; i < tries_size; ++i) {
            int start_addr = in.readUIntx();
            int insn_count = in.readUShortx();
            int handler_offset = in.readUShortx();
            this.order(start_addr);
            int end = start_addr + insn_count;
            this.order(end);
            in.pushMove(encoded_catch_handler_list + handler_offset);
            try {
                boolean catchAll = false;
                int listSize = (int)in.readLeb128();
                if (listSize <= 0) {
                    listSize = -listSize;
                    catchAll = true;
                }
                for (int k = 0; k < listSize; ++k) {
                    int type_id = (int)in.readULeb128();
                    int handler = (int)in.readULeb128();
                    this.order(handler);
                    String type = this.dex.getType(type_id);
                    dcv.visitTryCatch(this.labels.get(start_addr), this.labels.get(end), this.labels.get(handler), type);
                }
                if (!catchAll) continue;
                int handler = (int)in.readULeb128();
                this.order(handler);
                dcv.visitTryCatch(this.labels.get(start_addr), this.labels.get(end), this.labels.get(handler), null);
                continue;
            }
            finally {
                in.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(DexCodeVisitor dcv, int config) {
        int args_index;
        int[] args;
        DataIn in = this.in;
        int total_registers_size = in.readUShortx();
        int in_register_size = in.readUShortx();
        in.skip(2);
        int tries_size = in.readUShortx();
        int debug_off = in.readUIntx();
        int instruction_size = in.readUIntx();
        DexDebugInfoReader.LocalVariable[] localVariables = new DexDebugInfoReader.LocalVariable[total_registers_size];
        int i = total_registers_size - in_register_size;
        String[] parameterTypes = this.method.getParameterTypes();
        if (!this.isStatic) {
            args = new int[parameterTypes.length + 1];
            localVariables[i] = new DexDebugInfoReader.LocalVariable(i, 0, -1, "this", this.method.getOwner(), null);
            args[0] = i++;
            args_index = 1;
        } else {
            args = new int[parameterTypes.length];
            args_index = 0;
        }
        for (String type : parameterTypes) {
            localVariables[i] = new DexDebugInfoReader.LocalVariable(i, 0, -1, "arg" + args_index, type, null);
            args[args_index++] = i++;
            if (!"D".equals(type) && !"J".equals(type)) continue;
            ++i;
        }
        dcv.visitArguments(total_registers_size, args);
        if (tries_size > 0) {
            in.push();
            try {
                in.skip(instruction_size * 2);
                if ((instruction_size & 1) != 0) {
                    in.skip(2);
                }
                this.findTryCatch(in, dcv, tries_size);
            }
            finally {
                in.pop();
            }
        }
        if (debug_off != 0 && 0 == (config & 1)) {
            in.pushMove(debug_off);
            try {
                new DexDebugInfoReader(in, this.dex, instruction_size, this, localVariables, args).accept(dcv);
            }
            finally {
                in.pop();
            }
        }
        in.push();
        try {
            this.findLabels(in, instruction_size);
        }
        finally {
            in.pop();
        }
        DexOpcodeAdapter n = new DexOpcodeAdapter(this.dex, this.labels, dcv);
        this.acceptInsn(in, instruction_size, n);
        dcv.visitEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void acceptInsn(DataIn in, int instruction_size, DexOpcodeAdapter n) {
        labelOffsetIterator = this.labels.keySet().iterator();
        nextLabelOffset = labelOffsetIterator.hasNext() != false ? labelOffsetIterator.next() : null;
        baseOffset = in.getCurrentPosition();
        currentOffset = 0;
        while (true) {
            if (currentOffset < instruction_size) {
                currentOffsetVisited = false;
            } else {
                while (nextLabelOffset != null) {
                    n.offset(nextLabelOffset);
                    if (!labelOffsetIterator.hasNext()) break;
                    nextLabelOffset = labelOffsetIterator.next();
                }
                return;
            }
            while (nextLabelOffset != null && (_intNextLabelOffset = nextLabelOffset.intValue()) <= currentOffset) {
                if (_intNextLabelOffset == currentOffset) {
                    currentOffsetVisited = true;
                    n.offset(currentOffset);
                    nextLabelOffset = labelOffsetIterator.hasNext() != false ? labelOffsetIterator.next() : null;
                    break;
                }
                n.offset(_intNextLabelOffset);
                nextLabelOffset = labelOffsetIterator.hasNext() != false ? labelOffsetIterator.next() : null;
            }
            if (!currentOffsetVisited) {
                n.offset(currentOffset);
            }
            opcode = in.readUShortx();
            uOpcodeH = opcode >> 8;
            uOpcodeL = opcode & 255;
            if (uOpcodeL != 255) {
                opcode = uOpcodeL;
            }
            format = OpcodeFormat.get(opcode, this.dex.apiLevel);
            block1 : switch (1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[format.ordinal()]) {
                case 1: {
                    n.x0t(opcode, (byte)uOpcodeH);
                    break;
                }
                case 2: {
                    switch (opcode) {
                        case 0: {
                            switch (uOpcodeH) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    switch_size = in.readUShortx();
                                    in.skip(switch_size * 4 + 4);
                                    break;
                                }
                                case 2: {
                                    switch_size = in.readUShortx();
                                    in.skip(switch_size * 8);
                                    break;
                                }
                                case 3: {
                                    element_width = in.readUShortx();
                                    size = in.readUIntx();
                                    in.skip(size * element_width + 1 & -2);
                                    break;
                                }
                            }
                            break;
                        }
                    }
                    n.x0x(opcode);
                    break;
                }
                case 3: {
                    VV = (byte)uOpcodeH;
                    B = VV >> 4;
                    n.x1n(opcode, VV & 15, B);
                    break;
                }
                case 4: {
                    n.x1x(opcode, uOpcodeH);
                    break;
                }
                case 5: {
                    n.x2x(opcode, uOpcodeH & 15, uOpcodeH >> 4);
                    break;
                }
                case 6: {
                    n.x0bc(opcode, uOpcodeH, in.readUShortx());
                    break;
                }
                case 7: {
                    n.x0t(opcode, in.readShortx());
                    break;
                }
                case 8: {
                    n.x1c(opcode, uOpcodeH, in.readUShortx());
                    break;
                }
                case 9: {
                    n.x1h(opcode, uOpcodeH, in.readShortx());
                    break;
                }
                case 10: {
                    n.x1s(opcode, uOpcodeH, in.readShortx());
                    break;
                }
                case 11: {
                    n.x1t(opcode, uOpcodeH, in.readShortx());
                    break;
                }
                case 12: {
                    tmp = in.readShortx();
                    n.x2b(opcode, uOpcodeH, tmp & 255, tmp >> 8);
                    break;
                }
                case 13: {
                    n.x2c(opcode, uOpcodeH & 15, uOpcodeH >> 4, in.readUShortx());
                    break;
                }
                case 14: {
                    n.x2cs(opcode, uOpcodeH & 15, uOpcodeH >> 4, in.readUShortx());
                    break;
                }
                case 15: {
                    n.x2s(opcode, uOpcodeH & 15, uOpcodeH >> 4, in.readShortx());
                    break;
                }
                case 16: {
                    n.x2t(opcode, uOpcodeH & 15, uOpcodeH >> 4, in.readShortx());
                    break;
                }
                case 17: {
                    n.x2x(opcode, uOpcodeH, in.readUShortx());
                    break;
                }
                case 18: {
                    tmp = in.readUShortx();
                    n.x3x(opcode, uOpcodeH, tmp & 255, tmp >> 8);
                    break;
                }
                case 19: {
                    n.x0t(opcode, DexCodeReader.xUint(in));
                    break;
                }
                case 20: {
                    n.x1c(opcode, uOpcodeH, DexCodeReader.xUint(in));
                    break;
                }
                case 21: {
                    n.x1i(opcode, uOpcodeH, DexCodeReader.xInt(in));
                    break;
                }
                case 22: {
                    BBBBBBBB = DexCodeReader.xInt(in);
                    switch (opcode) {
                        case 38: 
                        case 43: 
                        case 44: {
                            in.push();
                            try {
                                in.skip((BBBBBBBB - 3) * 2);
                                switch (opcode) {
                                    case 44: {
                                        in.skip(2);
                                        switch_size = in.readUShortx();
                                        cases = new int[switch_size];
                                        label = new int[switch_size];
                                        for (j = 0; j < switch_size; ++j) {
                                            cases[j] = in.readIntx();
                                        }
                                        for (j = 0; j < switch_size; ++j) {
                                            label[j] = in.readIntx();
                                        }
                                        n.visitLookupSwitchStmt(opcode, uOpcodeH, 3, cases, label);
                                        ** break;
lbl140:
                                        // 1 sources

                                        break block1;
                                    }
                                    case 43: {
                                        in.skip(2);
                                        switch_size = in.readUShortx();
                                        first_case = in.readIntx();
                                        last_case = first_case - 1 + switch_size;
                                        _labels = new int[switch_size];
                                        for (j = 0; j < switch_size; ++j) {
                                            _labels[j] = targetOffset = in.readIntx();
                                        }
                                        n.visitTableSwitchStmt(opcode, uOpcodeH, 3, first_case, last_case, _labels);
                                        ** break;
lbl152:
                                        // 1 sources

                                        break block1;
                                    }
                                    case 38: {
                                        in.skip(2);
                                        elemWidth = in.readUShortx();
                                        initLength = in.readUIntx();
                                        values = new Object[initLength];
                                        switch (elemWidth) {
                                            case 1: {
                                                for (j = 0; j < initLength; ++j) {
                                                    values[j] = (byte)in.readByte();
                                                }
                                                break;
                                            }
                                            case 2: {
                                                for (j = 0; j < initLength; ++j) {
                                                    values[j] = (short)in.readShortx();
                                                }
                                                break;
                                            }
                                            case 4: {
                                                for (j = 0; j < initLength; ++j) {
                                                    values[j] = in.readIntx();
                                                }
                                                break;
                                            }
                                            case 8: {
                                                for (j = 0; j < initLength; ++j) {
                                                    values[j] = (long)in.readIntx() & 0xFFFFFFFFL | (long)in.readIntx() << 32;
                                                }
                                                break;
                                            }
                                        }
                                        n.visitFillArrayStmt(opcode, uOpcodeH, elemWidth, initLength, values);
                                        break block1;
                                    }
                                }
                                break block1;
                            }
                            finally {
                                in.pop();
                            }
                        }
                    }
                    n.x1t(opcode, uOpcodeH, BBBBBBBB);
                    break;
                }
                case 23: {
                    n.x2s(opcode, uOpcodeH, in.readUByte(), in.readShortx());
                    break;
                }
                case 24: {
                    n.x2x(opcode, in.readUShortx(), in.readUShortx());
                    break;
                }
                case 25: {
                    tmp = in.readUShortx();
                    n.x3x(opcode, tmp & 255, tmp >> 8, in.readUShortx());
                    break;
                }
                case 26: {
                    g = uOpcodeH & 15;
                    a = uOpcodeH >> 4;
                    bbbb = in.readUShortx();
                    vvvv = in.readUShortx();
                    c = vvvv & 15;
                    d = vvvv >> 4 & 15;
                    e = vvvv >> 8 & 15;
                    f = vvvv >> 12;
                    n.x5c(opcode, a, c, d, e, f, g, bbbb);
                    break;
                }
                case 27: {
                    g = uOpcodeH & 15;
                    a = uOpcodeH >> 4;
                    bbbb = in.readUShortx();
                    vvvv = in.readUShortx();
                    c = vvvv & 15;
                    d = vvvv >> 4 & 15;
                    e = vvvv >> 8 & 15;
                    f = vvvv >> 12;
                    n.x5mi(opcode, a, c, d, e, f, g, bbbb);
                    break;
                }
                case 28: {
                    g = uOpcodeH & 15;
                    a = uOpcodeH >> 4;
                    bbbb = in.readUShortx();
                    vvvv = in.readUShortx();
                    c = vvvv & 15;
                    d = vvvv >> 4 & 15;
                    e = vvvv >> 8 & 15;
                    f = vvvv >> 12;
                    n.x5ms(opcode, a, c, d, e, f, g, bbbb);
                    break;
                }
                case 29: {
                    n.xrc(opcode, uOpcodeH, in.readUShortx(), in.readUShortx());
                    break;
                }
                case 30: {
                    n.xrmi(opcode, uOpcodeH, in.readUShortx(), in.readUShortx());
                    break;
                }
                case 31: {
                    n.xrms(opcode, uOpcodeH, in.readUShortx(), in.readUShortx());
                    break;
                }
                case 32: {
                    bbbb_bbbb = DexCodeReader.xUint(in);
                    aaaa = in.readUShortx();
                    n.x0sc(opcode, aaaa, bbbb_bbbb);
                    break;
                }
                case 33: {
                    bbbb_bbbb = DexCodeReader.xUint(in);
                    aaaa = in.readUShortx();
                    n.x1c(opcode, aaaa, bbbb_bbbb);
                    break;
                }
                case 34: {
                    n.x1l(opcode, uOpcodeH, DexCodeReader.xLong(in));
                    break;
                }
                case 35: {
                    cccc_cccc = DexCodeReader.xUint(in);
                    aaaa = in.readUShortx();
                    bbbb = in.readUShortx();
                    n.x2c(opcode, aaaa, bbbb, cccc_cccc);
                    break;
                }
                case 36: {
                    bbbb_bbbb = DexCodeReader.xUint(in);
                    aaaa = in.readUShortx();
                    cccc = in.readUShortx();
                    n.xrc(opcode, aaaa, bbbb_bbbb, cccc);
                    break;
                }
            }
            currentOffset = (in.getCurrentPosition() - baseOffset) / 2;
        }
    }

    private static long xLong(DataIn in) {
        long rs = in.readUShortx();
        rs |= (long)in.readUShortx() << 16;
        rs |= (long)in.readUShortx() << 32;
        return rs |= (long)in.readUShortx() << 48;
    }

    private static int xInt(DataIn in) {
        return in.readUShortx() | in.readUShortx() << 16;
    }

    private static int xUint(DataIn in) {
        return in.readUShortx() | in.readUShortx() << 16;
    }

    void order(int offset) {
        if (!this.labels.containsKey(offset)) {
            this.labels.put(offset, new DexLabel(offset));
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat;

        static {
            $SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat = new int[OpcodeFormat.values().length];
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F10t.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F10x.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F11n.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F11x.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F12x.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F20bc.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F20t.ordinal()] = 7;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F21c.ordinal()] = 8;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F21h.ordinal()] = 9;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F21s.ordinal()] = 10;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F21t.ordinal()] = 11;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F22b.ordinal()] = 12;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F22c.ordinal()] = 13;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F22cs.ordinal()] = 14;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F22s.ordinal()] = 15;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F22t.ordinal()] = 16;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F22x.ordinal()] = 17;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F23x.ordinal()] = 18;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F30t.ordinal()] = 19;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F31c.ordinal()] = 20;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F31i.ordinal()] = 21;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F31t.ordinal()] = 22;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F32s.ordinal()] = 23;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F32x.ordinal()] = 24;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F33x.ordinal()] = 25;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F35c.ordinal()] = 26;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F35mi.ordinal()] = 27;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F35ms.ordinal()] = 28;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F3rc.ordinal()] = 29;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F3rmi.ordinal()] = 30;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F3rms.ordinal()] = 31;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F40sc.ordinal()] = 32;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F41c.ordinal()] = 33;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F51l.ordinal()] = 34;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F52c.ordinal()] = 35;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$googlecode$dex2jar$reader$OpcodeFormat[OpcodeFormat.F5rc.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

