/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.expr;

import com.googlecode.dex2jar.ir.ToStringUtil;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import org.objectweb.asm.Type;

public class InvokeExpr
extends Value.EnExpr {
    public Type[] argmentTypes;
    public String methodName;
    public Type methodOwnerType;
    public Type methodReturnType;

    public InvokeExpr(Value.VT type, ValueBox[] args, Type ownerType, String methodName, Type[] argmentTypes, Type returnType) {
        super(type, args);
        this.methodReturnType = returnType;
        this.methodName = methodName;
        this.methodOwnerType = ownerType;
        this.argmentTypes = argmentTypes;
    }

    @Override
    public Value clone() {
        ValueBox[] nOps = new ValueBox[this.ops.length];
        for (int i = 0; i < nOps.length; ++i) {
            nOps[i] = new ValueBox(this.ops[i].value.clone());
        }
        return new InvokeExpr(this.vt, nOps, this.methodOwnerType, this.methodName, this.argmentTypes, this.methodReturnType);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.vt == Value.VT.INVOKE_NEW) {
            sb.append("new ").append(ToStringUtil.toShortClassName(this.methodOwnerType)).append('(');
        } else {
            sb.append(this.vt == Value.VT.INVOKE_STATIC ? ToStringUtil.toShortClassName(this.methodOwnerType) : this.ops[0]).append('.').append(this.methodName).append('(');
        }
        boolean first = true;
        int n = i = this.vt == Value.VT.INVOKE_STATIC || this.vt == Value.VT.INVOKE_NEW ? 0 : 1;
        while (i < this.ops.length) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(this.ops[i]);
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }
}

