/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.stmt;

import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import java.util.Map;

public class LookupSwitchStmt
extends Stmt.E1Stmt {
    public LabelStmt defaultTarget;
    public int[] lookupValues;
    public LabelStmt[] targets;

    public LookupSwitchStmt(ValueBox key, int[] lookupValues, LabelStmt[] targets, LabelStmt defaultTarget) {
        super(Stmt.ST.LOOKUP_SWITCH, key);
        this.lookupValues = lookupValues;
        this.targets = targets;
        this.defaultTarget = defaultTarget;
    }

    @Override
    public Stmt clone(Map<LabelStmt, LabelStmt> map) {
        LabelStmt[] nTargets = new LabelStmt[this.targets.length];
        for (int i = 0; i < nTargets.length; ++i) {
            nTargets[i] = this.cloneLabel(map, this.targets[i]);
        }
        int[] nLookupValues = new int[this.lookupValues.length];
        System.arraycopy(this.lookupValues, 0, nLookupValues, 0, nLookupValues.length);
        return new LookupSwitchStmt(new ValueBox(this.op.value.clone()), nLookupValues, nTargets, this.cloneLabel(map, this.defaultTarget));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("switch(").append(this.op).append(") {");
        for (int i = 0; i < this.lookupValues.length; ++i) {
            sb.append("\n case ").append(this.lookupValues[i]).append(": GOTO ").append(this.targets[i].getDisplayName()).append(";");
        }
        sb.append("\n default : GOTO ").append(this.defaultTarget.getDisplayName()).append(";");
        sb.append("\n}");
        return sb.toString();
    }
}

