/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    public static final String LINE_SEPARATOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileToByteArray(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = FileUtils.openInputStream(file);
            byte[] byArray = IOUtils.toByteArray(in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IOException("File '" + file + "' could not be created");
            }
        }
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(File file, String encoding, Collection<String> lines) throws IOException {
        if (lines == null) {
            return;
        }
        FileOutputStream output = null;
        try {
            output = FileUtils.openOutputStream(file);
            for (String line : lines) {
                if (line != null) {
                    ((OutputStream)output).write(line.toString().getBytes(encoding));
                }
                ((OutputStream)output).write(LINE_SEPARATOR.getBytes(encoding));
            }
        }
        finally {
            IOUtils.closeQuietly(output);
        }
    }

    public static Collection<File> listFiles(File dir, String[] exts, boolean r) {
        if (exts.length == 0) {
            return Collections.EMPTY_LIST;
        }
        HashSet<String> set = new HashSet<String>(exts.length);
        for (String ext : exts) {
            set.add("." + ext);
        }
        ArrayList<File> list = new ArrayList<File>();
        FileUtils.doFind(dir, set, list, r);
        return list;
    }

    private static void doFind(File dir, Set<String> exts, List<File> list, boolean r) {
        block0: for (File f : dir.listFiles()) {
            if (f.isFile()) {
                String name = f.getName();
                for (String ext : exts) {
                    if (!name.endsWith(ext)) continue;
                    list.add(f);
                    continue block0;
                }
                continue;
            }
            if (!r) continue;
            FileUtils.doFind(f, exts, list, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByteArrayToFile(File file, byte[] data) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream(file);
            ((OutputStream)out).write(data);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public static void writeStringToFile(File file, String str, String encoding) throws IOException {
        FileUtils.writeByteArrayToFile(file, str.getBytes(encoding));
    }

    public static String readFileToString(File file, String charset) throws IOException {
        return new String(FileUtils.readFileToByteArray(file), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file, String encoding) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)FileUtils.openInputStream(file), encoding));
        try {
            ArrayList<String> list = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                list.add(line);
                line = reader.readLine();
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    static {
        StringWriter buf = new StringWriter(4);
        PrintWriter out = new PrintWriter(buf);
        out.println();
        LINE_SEPARATOR = buf.toString();
        out.close();
    }
}

