/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.v3.Dex2jar;
import com.googlecode.dex2jar.v3.DexExceptionHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class Main {
    public static void doData(byte[] data, File destJar) throws IOException {
        Main.doData(data, destJar, true);
    }

    public static void doData(byte[] data, File destJar, boolean handleException) throws IOException {
        Map<Method, Exception> exceptions;
        DexFileReader reader = new DexFileReader(data);
        DexExceptionHandlerImpl handler = handleException ? new DexExceptionHandlerImpl() : null;
        Dex2jar.from(reader).withExceptionHandler(handler).to(destJar);
        if (handleException && (exceptions = handler.getExceptions()) != null && exceptions.size() > 0) {
            File errorFile = new File(destJar.getParentFile(), FilenameUtils.getBaseName((String)destJar.getName()) + ".error.zip");
            handler.dumpException(reader, errorFile);
            System.err.println("Detail Error Information in File " + errorFile);
            System.err.println("Please report this file to http://code.google.com/p/dex2jar/issues/entry if possible.");
        }
    }

    public static void doFile(File srcDex) throws IOException {
        Main.doFile(srcDex, new File(srcDex.getParentFile(), FilenameUtils.getBaseName((String)srcDex.getName()) + "_dex2jar.jar"));
    }

    public static void doFile(File srcDex, File distJar) throws IOException {
        Main.doData(DexFileReader.readDex((File)srcDex), distJar);
    }

    public static void main(String ... args) {
        System.out.println("dex2jar version: translator-" + Main.class.getPackage().getImplementationVersion());
        if (args.length == 0) {
            System.err.println("dex2jar file1.dexORapk file2.dexORapk ...");
            return;
        }
        String jreVersion = System.getProperty("java.specification.version");
        if (jreVersion.compareTo("1.6") < 0) {
            System.err.println("A JRE version >=1.6 is required");
            return;
        }
        boolean containsError = false;
        for (String file : args) {
            File dex = new File(file);
            File gen = new File(dex.getParentFile(), FilenameUtils.getBaseName((String)file) + "_dex2jar.jar");
            System.out.println("dex2jar " + dex + " -> " + gen);
            try {
                Main.doFile(dex, gen);
            }
            catch (Exception e) {
                containsError = true;
                Main.niceExceptionMessage((Throwable)new DexException((Throwable)e, "while process file: [%s]", new Object[]{dex}), 0);
            }
        }
        System.out.println("Done.");
        System.exit(containsError ? -1 : 0);
    }

    public static void niceExceptionMessage(Throwable t, int deep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < deep + 1; ++i) {
            sb.append(".");
        }
        sb.append(' ');
        if (t instanceof DexException) {
            sb.append(t.getMessage());
            System.err.println(sb.toString());
            if (t.getCause() != null) {
                Main.niceExceptionMessage(t.getCause(), deep + 1);
            }
        } else if (t != null) {
            System.err.println(sb.append("ROOT cause:").toString());
            t.printStackTrace(System.err);
        }
    }
}

