/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.Constant;
import com.googlecode.dex2jar.ir.ET;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Local;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ZeroTransformer
implements Transformer {
    private static final Integer ZERO = 0;

    @Override
    public void transform(IrMethod irMethod) {
        ZeroAnalyze za = new ZeroAnalyze(irMethod);
        za.analyze();
        block6: for (Stmt p = irMethod.stmts.getFirst(); p != null; p = p.getNext()) {
            Phi[] frame = (Phi[])p._ls_forward_frame;
            p._ls_forward_frame = null;
            if (frame == null || !p._cfg_visited) continue;
            switch (p.et) {
                case E0: {
                    continue block6;
                }
                case E1: {
                    Stmt.E1Stmt e1 = (Stmt.E1Stmt)p;
                    this.replace(e1.op, frame);
                    continue block6;
                }
                case E2: {
                    Stmt.E2Stmt e2 = (Stmt.E2Stmt)p;
                    if (e2.st != Stmt.ST.ASSIGN && e2.st != Stmt.ST.IDENTITY) {
                        this.replace(e2.op1, frame);
                    }
                    this.replace(e2.op2, frame);
                    continue block6;
                }
                case En: {
                    Stmt.EnStmt en = (Stmt.EnStmt)p;
                    for (ValueBox vb : en.ops) {
                        this.replace(vb, frame);
                    }
                    continue block6;
                }
            }
        }
    }

    private void replace(ValueBox op, Phi[] frame) {
        if (op == null) {
            return;
        }
        Value value = op.value;
        switch (value.et) {
            case E0: {
                Value.E0Expr e0 = (Value.E0Expr)value;
                if (e0.vt != Value.VT.LOCAL) break;
                Local local = (Local)e0;
                Phi phi = frame[local._ls_index];
                if (!Boolean.TRUE.equals(phi.isZero)) break;
                op.value = Constant.nInt(0);
                break;
            }
            case E1: {
                Value.E1Expr e1 = (Value.E1Expr)value;
                this.replace(e1.op, frame);
                break;
            }
            case E2: {
                Value.E2Expr e2 = (Value.E2Expr)value;
                this.replace(e2.op1, frame);
                this.replace(e2.op2, frame);
                break;
            }
            case En: {
                Value.EnExpr en = (Value.EnExpr)value;
                for (ValueBox vb : en.ops) {
                    this.replace(vb, frame);
                }
                break;
            }
        }
    }

    private static class ZeroAnalyze {
        IrMethod method;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Stmt stmt = this.method.stmts.getFirst(); stmt != null; stmt = stmt.getNext()) {
                Phi[] frame = (Phi[])stmt._ls_forward_frame;
                if (frame != null) {
                    for (Phi p : frame) {
                        if (p == null) {
                            sb.append("_");
                            continue;
                        }
                        sb.append(p.toString());
                    }
                    sb.append(" | ");
                }
                sb.append(stmt.toString()).append('\n');
            }
            return sb.toString();
        }

        public ZeroAnalyze(IrMethod irMethod) {
            this.method = irMethod;
        }

        private void init() {
            int i = 0;
            for (Local local : this.method.locals) {
                local._ls_index = i++;
            }
        }

        public void analyze() {
            this.init();
            this.analyze0();
        }

        private void analyze0() {
            Cfg.createCFG(this.method);
            final int localSize = this.method.locals.size();
            final Phi[] tmp = new Phi[localSize];
            final ArrayList<Phi> phis = new ArrayList<Phi>();
            Cfg.Forward(this.method, new Cfg.FrameVisitor<Phi[]>(){

                private Phi newPhi() {
                    Phi phi = new Phi();
                    phis.add(phi);
                    return phi;
                }

                @Override
                public Phi[] exec(Stmt stmt) {
                    Phi[] frame = (Phi[])stmt._ls_forward_frame;
                    if (frame == null) {
                        frame = new Phi[localSize];
                        stmt._ls_forward_frame = frame;
                    }
                    System.arraycopy(frame, 0, tmp, 0, localSize);
                    if (stmt.et == ET.E2) {
                        Stmt.E2Stmt e2 = (Stmt.E2Stmt)stmt;
                        Value op1 = e2.op1.value;
                        Value op2 = e2.op2.value;
                        block0 : switch (stmt.st) {
                            case ASSIGN: {
                                if (op1.vt != Value.VT.LOCAL) break;
                                Local a = (Local)op1;
                                switch (op2.vt) {
                                    case CONSTANT: {
                                        Constant c = (Constant)op2;
                                        Phi phi = this.newPhi();
                                        phi.isZero = c.value instanceof Integer && ZERO.equals(c.value) ? Boolean.TRUE : Boolean.FALSE;
                                        tmp[a._ls_index] = phi;
                                        break block0;
                                    }
                                    case LOCAL: {
                                        Local b = (Local)op2;
                                        tmp[a._ls_index] = tmp[b._ls_index];
                                        break block0;
                                    }
                                }
                                Phi phi = this.newPhi();
                                phi.isZero = Boolean.FALSE;
                                tmp[a._ls_index] = phi;
                                break;
                            }
                            case IDENTITY: {
                                Local a = (Local)op1;
                                Phi phi = this.newPhi();
                                phi.isZero = Boolean.FALSE;
                                tmp[a._ls_index] = phi;
                            }
                        }
                    }
                    return tmp;
                }

                @Override
                public void merge(Phi[] frame, Stmt dist) {
                    if (dist._cfg_froms.size() == 1) {
                        dist._ls_forward_frame = new Phi[localSize];
                        System.arraycopy(frame, 0, dist._ls_forward_frame, 0, localSize);
                    } else {
                        Phi[] distFrame = (Phi[])dist._ls_forward_frame;
                        if (distFrame == null) {
                            distFrame = new Phi[localSize];
                            dist._ls_forward_frame = distFrame;
                        }
                        for (int i = 0; i < localSize; ++i) {
                            Phi a;
                            Phi b = distFrame[i];
                            if (b == null) {
                                distFrame[i] = b = this.newPhi();
                                phis.add(b);
                            }
                            if ((a = frame[i]) == null) continue;
                            a.children.add(b);
                        }
                    }
                }
            });
            ZeroAnalyze.markNotZeroes(phis);
            for (Phi p : phis) {
                if (p.isZero != null) continue;
                p.isZero = Boolean.TRUE;
            }
            phis.clear();
        }

        static void markNotZeroes(List<Phi> phis) {
            HashSet<Phi> notZeroSet = new HashSet<Phi>();
            for (Phi p : phis) {
                if (p.isZero == null || !p.isZero.equals(Boolean.FALSE)) continue;
                ZeroAnalyze.notZero(p, notZeroSet);
            }
        }

        static void notZero(Phi p, Set<Phi> notZeroSet) {
            if (!notZeroSet.contains(p)) {
                notZeroSet.add(p);
                if (p.isZero != null && Boolean.TRUE.equals(p.isZero)) {
                    throw new RuntimeException();
                }
                p.isZero = Boolean.FALSE;
                for (Phi s : p.children) {
                    ZeroAnalyze.notZero(s, notZeroSet);
                }
            }
        }
    }

    static class Phi {
        public Boolean isZero = null;
        public Set<Phi> children = new HashSet<Phi>();

        Phi() {
        }

        public String toString() {
            if (this.isZero == null) {
                return "?";
            }
            return this.isZero != false ? "Z" : ".";
        }
    }
}

