/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import p.rn.util.FileOut;
import p.rn.util.FileWalker;

public class ApkSign
extends BaseCmd {
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .apk file, default is $current_dir/[apk-name]-signed.apk", argName="out-apk-file")
    private File output;
    @BaseCmd.Opt(opt="w", longOpt="sign-whole", hasArg=false, description="Sign whole apk file")
    private boolean signWhole = false;

    public static void main(String[] args) {
        new ApkSign().doMain(args);
    }

    public ApkSign() {
        super("d2j-apk-sign [options] <apk>", "Sign an android apk file use a test certificate.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommandLine() throws Exception {
        Class<?> clz;
        File realJar;
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        File apkIn = new File(this.remainingArgs[0]);
        if (!apkIn.exists()) {
            System.err.println(apkIn + " is not exists");
            this.usage();
            return;
        }
        if (this.output == null) {
            this.output = apkIn.isDirectory() ? new File(apkIn.getName() + "_signed.apk") : new File(FilenameUtils.getBaseName((String)apkIn.getName()) + "_signed.apk");
        }
        if (this.output.exists() && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            this.usage();
            return;
        }
        if (apkIn.isDirectory()) {
            realJar = File.createTempFile("d2j", ".jar");
            realJar.deleteOnExit();
            System.out.println("zipping " + apkIn + " -> " + realJar);
            FileOut.OutHandler out = FileOut.create((File)realJar, (boolean)true);
            try {
                new FileWalker().withStreamHandler((FileWalker.StreamHandler)new FileWalker.OutAdapter(out)).walk(apkIn);
            }
            finally {
                IOUtils.closeQuietly((Closeable)out);
            }
        } else {
            realJar = apkIn;
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(ApkSign.class.getResourceAsStream("ApkSign.cer"));
        KeyFactory rSAKeyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = rSAKeyFactory.generatePrivate(new PKCS8EncodedKeySpec(IOUtils.toByteArray((InputStream)ApkSign.class.getResourceAsStream("ApkSign.private"))));
        try {
            clz = Class.forName("com.android.signapk.SignApk");
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("please run d2j-apk-sign in a sun compatible JRE (contains sun.security.*)");
            return;
        }
        Method m = clz.getMethod("sign", X509Certificate.class, PrivateKey.class, Boolean.TYPE, File.class, File.class);
        m.setAccessible(true);
        System.out.println("sign " + realJar + " -> " + this.output);
        m.invoke(null, cert, privateKey, this.signWhole, realJar, this.output);
    }
}

