/*
 * Decompiled with CFR 0.152.
 */
package p.rn.owner;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import p.rn.owner.ReOwner;

public class WebApp {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("webapp pathToWebApp config [ignoreJarConfig]");
            return;
        }
        File webApp = new File(args[0]);
        File config = new File(args[1]);
        File jarIgnore = args.length > 2 ? new File(args[2]) : null;
        File clz = new File(webApp, "WEB-INF/classes");
        File tmpClz = new File(webApp, "WEB-INF/tmp-classes");
        ReOwner ro = new ReOwner().withConfig(config);
        if (tmpClz.exists()) {
            FileUtils.deleteDirectory((File)tmpClz);
        }
        FileUtils.copyDirectory((File)clz, (File)tmpClz);
        System.out.println("ReOwner from [" + tmpClz + "] to [" + clz + "]");
        ro.reOwner(tmpClz, clz);
        FileUtils.deleteDirectory((File)tmpClz);
        File lib = new File(webApp, "WEB-INF/lib");
        File tmpLib = new File(webApp, "WEB-INF/Nlib");
        HashSet ignores = new HashSet();
        if (jarIgnore != null && jarIgnore.exists()) {
            ignores.addAll(FileUtils.readLines((File)jarIgnore, (String)"UTF-8"));
        } else {
            System.out.println("ignoreJarConfig ignored");
        }
        if (tmpLib.exists()) {
            FileUtils.deleteDirectory((File)tmpLib);
        }
        FileUtils.copyDirectory((File)lib, (File)tmpLib);
        for (File jar : FileUtils.listFiles((File)tmpLib, (String[])new String[]{"jar"}, (boolean)false)) {
            String s = jar.getName();
            boolean ignore = false;
            for (String i : ignores) {
                if (!s.startsWith(i)) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            File nJar = new File(lib, s);
            System.out.println("ReOwner from [" + jar + "] to [" + nJar + "]");
            ro.reOwner(jar, nJar);
        }
        FileUtils.deleteDirectory((File)tmpLib);
    }
}

