/*
 * Decompiled with CFR 0.152.
 */
package p.rn.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileOut {
    public static OutHandler create(File dirORzip) throws IOException {
        return FileOut.create(dirORzip, dirORzip.exists() ? dirORzip.isFile() : true);
    }

    public static OutHandler create(File dirORzip, boolean isZip) throws IOException {
        if (isZip) {
            return new ZipOutHandler(FileUtils.openOutputStream((File)dirORzip));
        }
        return new FileOutHandler(dirORzip);
    }

    private static class ZipOutHandler
    implements OutHandler {
        private Set<String> dirs = new HashSet<String>();
        private ZipOutputStream zos;

        public ZipOutHandler(OutputStream os) {
            this.zos = new ZipOutputStream(os);
        }

        private void check(String dir) {
            if (this.dirs.contains(dir)) {
                return;
            }
            this.dirs.add(dir);
            int i = dir.lastIndexOf(47);
            if (i > 0) {
                this.check(dir.substring(0, i));
            }
        }

        @Override
        public void close() {
            IOUtils.closeQuietly((OutputStream)this.zos);
        }

        @Override
        public void write(boolean isDir, String name, byte[] data, Object nameObject) throws IOException {
            this.zos.putNextEntry(this.buildEntry(name, nameObject));
            if (!isDir) {
                this.zos.write(data);
            }
            this.zos.closeEntry();
        }

        @Override
        public void write(boolean isDir, String name, InputStream is, Object nameObject) throws IOException {
            this.zos.putNextEntry(this.buildEntry(name, nameObject));
            if (!isDir) {
                IOUtils.copy((InputStream)is, (OutputStream)this.zos);
            }
            this.zos.closeEntry();
        }

        private ZipEntry buildEntry(String name, Object nameObject) {
            ZipEntry ze;
            int i = name.lastIndexOf(47);
            if (i > 0) {
                this.check(name.substring(0, i));
            }
            if (nameObject instanceof ZipEntry && name.equals((ze = (ZipEntry)nameObject).getName())) {
                ZipEntry nZe = new ZipEntry(name);
                nZe.setComment(ze.getComment());
                nZe.setTime(ze.getTime());
                return nZe;
            }
            return new ZipEntry(name);
        }

        @Override
        public OutputStream openOutput(String name, Object nameObject) throws IOException {
            this.zos.putNextEntry(this.buildEntry(name, nameObject));
            return new FilterOutputStream(this.zos){

                @Override
                public void close() throws IOException {
                    this.flush();
                    ZipOutHandler.this.zos.closeEntry();
                }
            };
        }
    }

    private static class FileOutHandler
    implements OutHandler {
        File dir;

        @Override
        public void close() throws IOException {
        }

        public FileOutHandler(File dir) {
            this.dir = dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(boolean isDir, String name, InputStream is, Object nameObject) throws IOException {
            if (!isDir) {
                FileOutputStream fos = null;
                try {
                    fos = FileUtils.openOutputStream((File)new File(this.dir, name));
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }

        @Override
        public void write(boolean isDir, String name, byte[] data, Object nameObject) throws IOException {
            if (!isDir) {
                FileUtils.writeByteArrayToFile((File)new File(this.dir, name), (byte[])data);
            }
        }

        @Override
        public OutputStream openOutput(String name, Object nameObject) throws IOException {
            return FileUtils.openOutputStream((File)new File(this.dir, name));
        }
    }

    public static interface OutHandler
    extends Closeable {
        public void write(boolean var1, String var2, InputStream var3, Object var4) throws IOException;

        public void write(boolean var1, String var2, byte[] var3, Object var4) throws IOException;

        public OutputStream openOutput(String var1, Object var2) throws IOException;
    }
}

