<?php
/**
 * Copyright (c) 2010-2013 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : MysqlDriver.php  2013-4-3
 */

class MySQLDriver
{
	public $querycount = 0;
	protected $options = array();
	protected $tablepre = 'pc_';
	protected $charset = 'UTF8';
	protected $pconnect = 1;
	protected $dbname = '';
	protected $driver = 'mysql';
	private $transactions = false;
	private $dbconn = null;
	private $result = null;
	private $version = null;
	private static $instance = null;

	public function __construct($options = null)
	{
		if(!empty($options)){
			$this->setOptions($options);
			$this->connect($options['dsn']['host'], $options['username'], $options['password']);
		}
	}

	protected function setOptions($options)
	{
		$this->options = &$options;
		$this->tablepre = empty($options['tablepre']) ? 'pc_' : trim($options['tablepre']);
		$this->charset = empty($options['charset']) ? 'utf8' : trim($options['charset']);
		$this->pconnect = empty($options['pconnect']) ? 0 : 1;
		$this->dbname = empty($options['dsn']['dbname']) ? '' : $options['dsn']['dbname'];
		$this->driver = empty($options['driver']) ? 'mysql' : trim($options['driver']);
	}

	public function connect($host, $username, $password) {
		$this->dbconn = $this->pconnect ? mysql_pconnect($host, $username, $password) : mysql_connect($host, $username, $password, true);
		if(!$this->dbconn){
			die('Can not connect to MySQL server');
		}else{
			if (version_compare($this->version(), '4.1.0', '>=')) {
				if($dbcharset = $this->charset) {
					mysql_query("SET character_set_connection=$dbcharset, character_set_results=$dbcharset, character_set_client=binary", $this->dbconn);
				}
				if (version_compare($this->version(), '5.0.2', '>=')) {
					mysql_query("SET sql_mode=''", $this->dbconn);
				}
				if($this->dbname) {
					mysql_select_db($this->dbname, $this->dbconn);
				}
			}
		}
	}

	public function selectdb($dbname)
	{
		return mysql_select_db($dbname, $this->dbconn);
	}

	public function getQueryCount()
	{
		return $this->querycount;
	}

	public function query($sql)
	{
		$this->querycount++;
		if($query = mysql_query($sql, $this->dbconn)){
			return new MySQLStatement($query);
		}
		return false;
	}

	public function execQuery($sql, $column_number = null)
	{
		if(null === $column_number){
			return $this->query($sql)->fetch();
		}else{
			return $this->query($sql)->fetchColumn($column_number);
		}
	}

	public function exec($sql)
	{
		if(function_exists('mysql_unbuffered_query')){
			if($query = mysql_unbuffered_query($sql, $this->dbconn)){
				return mysql_affected_rows();
			}
		}else{
			if($query = mysql_query($sql, $this->dbconn)){
				return mysql_affected_rows();
			}
		}
		return 0;
	}

	public function version()
	{
		if (empty($this->version)) {
			list($version) = explode('-', mysql_get_server_info($this->dbconn));
			$this->version = $version;
		}
		return $this->version;
	}

	public function beginTransaction()
	{
		if($this->transactions === false){
			if($this->exec("BEGIN") !== false){
				$this->transactions = true;
			}
		}
		return true;
	}

	public function commit()
	{
		if($this->transactions){
			if($this->exec("COMMIT") !== false){
				$this->transactions = false;
			}
		}
		return true;
	}

	public function rollBack()
	{
		if($this->transactions){
			if($this->exec("ROLLBACK") !== false){
				$this->transactions = false;
			}
		}
		return true;
	}
	
	public function quote($string)
	{
		if (function_exists('mysql_real_escape_string') && is_resource($this->dbconn)){
			return mysql_real_escape_string($string, $this->dbconn);
		}elseif (function_exists('mysql_escape_string')){
			return mysql_escape_string($string);
		}
		return addslashes($string);
	}
	
	public static function getInstance($options = null)
	{
		if (self::$instance == null) {
			self::$instance = new self($options);
		}

		return self::$instance;
	}
}

class MySQLStatement implements Iterator
{
	private $result;
	private $position;
	private $row_data;

	public function __construct($result)
	{
		$this->result = $result;
		$this->position = 0;
	}

	public function __destruct() {
		if(is_resource($this->result)){
			mysql_free_result($this->result);
			$this->result = null;
		}
	}
	
	public function current()
	{
		return $this->row_data;
	}
	
	public function key()
	{
		return $this->position;
	}
	
	public function next()
	{
		$this->position++;
		$this->row_data = mysql_fetch_assoc($this->result);
	}
	
	public function rewind()
	{
		$this->position = 0;
		mysql_data_seek($this->result, 0);
		$this->row_data = mysql_fetch_assoc($this->result);
	}
	
	public function valid()
	{
		return (boolean)$this->row_data;
	}
	
	public function fetch($result_type = MYSQL_ASSOC)
	{
		return mysql_fetch_array($this->result, $result_type);
	}

	public function fetchAll($result_type = MYSQL_ASSOC)
	{
		$data = array();
		while($row = mysql_fetch_array($this->result, $result_type)){
			$data[] = $row;
		}
		return $data;
	}

	public function fetchObject($class_name = "stdClass", $params = array())
	{
		return mysql_fetch_object($this->result, $class_name, $params);
	}

	public function fetchColumn($column_number = 0)
	{
		$row = mysql_fetch_row($this->result);
		return isset($row[$column_number]) ? $row[$column_number] : false;
	}

	public function rowCount()
	{
		return mysql_num_rows($this->result);
	}

	public function columnCount()
	{
		return mysql_num_fields($this->result);
	}

	public function closeCursor()
	{
		if(is_resource($this->result)){
			return mysql_free_result($this->result);
		}
		return true;
	}

	public function errorCode()
	{
		return mysql_errno();
	}

	public function errorInfo()
	{
		return mysql_error();
	}
}