<?php
/**
 * Copyright (c) 2010-2013 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : MysqlDB.php  2013-4-4
 */

class MysqlDB
{
	public static function delete($table, $condition, $index = 0, $limit = 0) {
		if (empty($condition)) {
			$where = '1';
		} elseif (is_array($condition)) {
			$where = self::implode_field_value($condition, ' AND ');
		} else {
			$where = $condition;
		}
		$sql = "DELETE FROM " . self::table($table, $index) . " WHERE $where" . ($limit ? "LIMIT $limit" : '');
		return self::exec($sql);
	}
	
	public static function update($table, $data, $condition, $index = 0, $low_priority = FALSE) {
		$sql = self::implode_field_value($data);
		$cmd = "UPDATE" . ($low_priority ? ' LOW_PRIORITY' : '');
		$table = self::table($table, $index);
		$where = '';
		$return = 0;
		if (empty($condition)) {
			$where = '1';
		} elseif (is_array($condition)) {
			$where = self::implode_field_value($condition, ' AND ');
		} else {
			$where = $condition;
		}
		try {
			return self::exec("$cmd $table SET $sql WHERE $where");
		} catch (Exception $e) {
			return false;
		}
	}
	
	public static function insert($table, $data, $return_insert_id = FALSE, $replace = FALSE, $index = 0) {
		$sql = self::implode_field_value($data);
		$cmd = $replace ? 'REPLACE INTO' : 'INSERT INTO';
		$table = self::table($table, $index);
		$return = 0;
		try {
			$return = self::exec("$cmd $table SET $sql");
		} catch (Exception $e) {
			//print_r("$cmd $table SET $sql");
			//print_r($data);
			//exit($e->getMessage());
			return false;
		}
		
		return $return_insert_id ? self::lastInsertId() : $return;
	}
	
	public static function implode_field_value($array, $separator = ',') {
		$sql = $comma = '';
		if (is_array($array)) {
			foreach ($array as $k => $v) {
				$sql .= $comma . "`$k`='".self::getInstance()->quote($v)."'";
				$comma = $separator;
			}
		} else {
			$sql = $array;
		}
		return $sql;
	}
	
	public static function table($table, $index = 0)
	{
		$table .= $index ? "_$index" : '';
		return self::getInstance()->tableName($table);
	}
	
	public static function selectdb($dbname)
	{
		return self::getInstance()->selectdb($dbname);
	}
	
	public static function query($sql)
	{
		return self::getInstance()->query($sql);
	}
	
	public static function execQuery($sql, $column_number = null)
	{
		return self::getInstance()->execQuery($sql, $column_number);
	}
	
	public static function exec($sql)
	{
		return self::getInstance()->exec($sql);
	}
	
	public static function lastInsertId($name = null)
	{
		return self::getInstance()->lastInsertId($name);
	}
	
	public static function version()
	{
		return self::getInstance()->version();
	}
	
	public static function quote($string)
	{
		return self::getInstance()->quote($string);
	}
	
	public static function &getInstance() 
	{
		static $db;
		global $db_config;
		if (empty($db)) {
			$db = new PdoDriver($db_config['db']);
		}
		return $db;
	}
}
?>