<?php
/**
 * Copyright (c) 2010-2013 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : DataAccessMysql.php  2013-4-4
 */
class MysqlDataConvert
{
	protected $chanid = 0;
	protected $uid = 0;
	protected $username = '';
	protected $tableindex = 0;
	protected $charset = 'gbk';
	public static $channelid = 1;
	public static $tid = 0;
	public static $module = 'article';
	
	public function __construct($chanid = 0) 
	{
		$this->chanid = $chanid;
	}
	
	public function setUid($uid)
	{
		$this->uid = $uid;
	}
	
	public function setUserName($username)
	{
		$this->username = $username;
	}
	
	public function setCharSet($charset)
	{
		$this->charset = $charset;
	}
	
	public function threads($modules, $data, $fields = array(), $subjects = array(), $messages = array(), $images = array())
	{
		if(!empty($data['catid'])){
			$data['catid'] = intval($data['catid']);
			$data['rootid'] = $this->getRootID($data['catid']);
			if(empty($data['rootid'])) return 0;
			$subjects['catid'] = $data['catid'];
			$subjects['rootid'] = $data['rootid'];
		}else{
			return false;
		}
		$chanid = intval($data['chanid']);
		$tableindex = $this->tableindex;
		$data['lastdate'] = TIMESTAMP;
		$data['tableindex'] = $tableindex;
		$subjects['chanid'] = $chanid;
		$subjects['dateline'] = $data['dateline'];
		if(!isset($data['status'])) $data['status'] = 1;
		if(!empty($data['url'])){
			$data['url'] = $this->addUrlScheme($data['url']);
		}
		if(empty($data['uid'])){
			$data['uid'] = $this->uid;
		}
		$this->fieldTryParse(array('hits', 'bancomment', 'recommend', 'istop'), $data, 'int', 0);
		$this->fieldTryParse(array('voteup', 'votedown', 'credits'), $fields, 'int', 0);
		
		if($tid = MysqlDB::insert('threads', $data, true)){
			$fields['tid'] = $tid;
			$fields['isupdate'] = 1;
			MysqlDB::insert('thread_field', $fields);
			if(!empty($images)){
				$images['tid'] = $tid;
				if(!isset($images['attachment'])) $images['attachment'] = '';
				if(!isset($images['attachimg'])) $images['attachimg'] = '';
				MysqlDB::insert('thread_image', $images);
			}
			if(isset($subjects['summary'])){
				$content = isset($messages['content']) ? trim($messages['content']) : '';
				$subjects['summary'] = $this->formatSummary($subjects['summary'], $messages['content'], trim($data['title']));
			}
			if(isset($messages['content'])){
				$messages['content'] = $this->formatContent($messages['content']);
				$messages['content'] = $this->parserAttachImage($messages['content'], $chanid, $tid, $modules);
			}
			
			$subjects['tid'] = $tid;
			if(empty($subjects['uid'])){
				$subjects['uid'] = $this->uid;
			}
			if(empty($subjects['editor'])){
				$subjects['editor'] = $this->username;
			}
			$subjects['tableindex'] = $tableindex;
			$tablename = $modules . '_thread';
			$tableid = $modules . 'id';
			$returnid = MysqlDB::insert($tablename, $subjects, true);
			$messages['tid'] = $tid;
			$messages[$tableid] = $returnid;
			if(isset($messages['tags']) && !empty($messages['tags'])){
				$messages['tags'] = $this->insertTags($messages['tags'], $tid, $this->chanid);
			}
			$tablename = $modules . '_content';
			MysqlDB::insert($tablename, $messages, FALSE, FALSE, FALSE, $tableindex);
			return array('tid' => $tid, "$tableid" => $returnid);
		}
		return false;
	}
	
	public function getParentRootId($parentid = 0)
	{
		if($query = MysqlDB::query("SELECT catid, depth, parentid FROM " . MysqlDB::table('category') . " WHERE catid='$parentid'")->fetch()){
			if($query['depth'] == 0){
				return $query['catid'];
			}else{
				return $this->getParentRootId($query['parentid']);
			}
		}
		return 0;
	}
	
	public function updateRootId()
	{
		if($query = MysqlDB::query("SELECT catid, parentid FROM " . MysqlDB::table('category') . " WHERE depth>'1'")){
			while($row = $query->fetch()){
				$rootid = $this->getParentRootId($row['parentid']);
				MysqlDB::update('category', array('rootid' => $rootid), array('catid' => $row['catid']));
			}
		}
	}
	
	public function category($category)
	{
		$data = array();
		$category['parentstr'] = trim($category['parentstr'], " ,\t");
		$data['catid'] = $category['classid'];
		$data['chanid'] = $category['channelid'];
		$data['depth'] = $category['depth'];
		if($category['depth'] == 0){
			$data['rootid'] = $category['classid'];
		}elseif($category['depth'] == 1){
			$data['rootid'] = $category['parentid'];
		}elseif($category['depth'] == 2){
			$parents = explode(',', $category['parentstr']);
			$parentid = $parents[0];
			foreach($parents as $pid){
				if(intval($pid) && intval($pid) != intval($category['parentid'])){
					$parentid = $pid;
					break;
				}
			}
			$data['rootid'] = intval($parentid);
		}else{
			$parents = explode(',', $category['parentstr']);
			$data['rootid'] = intval($parents[0]);
		}
		$data['parentid'] = $category['parentid'];
		$data['child'] = $category['child'];
		$data['basic'] = 0;
		$data['catname'] = trim($category['classname']);
		$data['subname'] = trim($category['classname']);
		$data['codename'] = trim($category['classdir']);
		$data['remote'] = 0;
		$data['sortord'] = trim($category['orders']);
		$data['pagesize'] = 0;
		$data['target'] = 0;
		$data['counts'] = uintval($category['showcount']);
		$data['setting'] = '';
		MysqlDB::insert('category', $data);
	}
	
	public function member($member)
	{
		
	}
	
	public function comments($comment)
	{
		
	}
	
	public function insertTags($tags, $tid = 0, $chanid = 0)
	{
		if(!($tags = trim(strip_tags($tags)))) return '';
		$tagarray = array();
		$tags = str_replace(array(chr(0xa3) . chr(0xac), chr(0xa1) . chr(0x41), chr(0xef) . chr(0xbc) . chr(0x8c)), ',', $tags);
		if (strpos($tags, ',') !== false) {
			$tagarray = array_unique(explode(',', $tags));
		} else {
			$tags = str_replace(array(chr(0xa1) . chr(0xa1), chr(0xa1) . chr(0x40), chr(0xe3) . chr(0x80) . chr(0x80)), ' ', $tags);
			$tagarray = array_unique(explode(' ', $tags));
		}
		$count = $tagid = 0;
		$tagids = $tagsdata = array();
		foreach ($tagarray as $tagname) {
			$tagname = trim($tagname);
			if (preg_match('/^([\x7f-\xff_-]|\w|\s){2,28}$/', $tagname)) {
				$result = MysqlDB::query("SELECT tagid FROM " . MysqlDB::table('tags') . " WHERE tagname='$tagname'")->fetch();
				if ($result['tagid']) {
					$tagid = $result['tagid'];
				} else {
					MysqlDB::query("INSERT INTO " . MysqlDB::table('tags') . " (tagname, tagnum, ishot) VALUES ('$tagname', '0', '0')");
					$tagid = MysqlDB::lastInsertId();
				}
				if ($tagid && $tid) {
					$tagids[] = $tagid;
					MysqlDB::query("INSERT INTO " . MysqlDB::table('tagdata') . " (tagid, tagname, tid, chanid) VALUES ('$tagid', '$tagname', '$tid', '$chanid')");
					$count++;
					$tagsdata[] = "$tagid,$tagname";
				}
				if ($count > 4) {
					unset($tagarray);
					break;
				}
			}
		}
		if ($updateids = implodeids($tagids)) {
			MysqlDB::update('tags', 'tagnum=tagnum+1', "tagid IN($updateids)");
		}
		return empty($tagsdata) ? '' : addslashes(implode("\t", $tagsdata));
	}
	
	public function parserAttachImage($content, $chanid = 1, $tid = 0, $module = 'article')
	{
		if($module != 'article' && $module != 'soft') return $content;
		MysqlDataConvert::$channelid = $chanid;
		MysqlDataConvert::$tid = $tid;
		MysqlDataConvert::$module = $module;
		if (strpos($content, "[InstallDir_ChannelDir]") !== false) {
			$content = preg_replace_callback("#\[img\]\s*\[InstallDir_ChannelDir\]([a-zA-Z0-9\x2d-\x2f\x5f\x7e]{20,80})\[\/img\]#is", 'MysqlDataConvert::callbackAttachImage', $content, -1, $count);
			if($count){
				MysqlDB::exec("UPDATE ".MysqlDB::table('threads')." SET attached='2' WHERE tid='$tid'");
			}
		}
		return $content;
	}
	
	public static function callbackAttachImage($matches)
	{
		$chanid = MysqlDataConvert::$channelid;
		$tid = MysqlDataConvert::$tid;
		$module = MysqlDataConvert::$module;
		if($attachimg = substr($matches[1], strpos($matches[1], '/') + 1)){
			if($attachid = MysqlDataConvert::saveAttachImage($attachimg, $chanid, $tid, $module)){
				return "[attach]{$attachid}[/attach]";
			}
		}
		return $matches[0];
	}
	
	public static function saveAttachImage($attachment, $chanid, $tid = 0, $module = 'article')
	{
		if(empty($attachment))  return false;
		$attachid = MysqlDB::insert('attachment', array(
				'chanid' => $chanid,
				'tid' => $tid,
				'uid' => 1,
				'tableid' => $module == 'article' ? 1 : 2,
		), true);
		if(empty($attachid)) return false;
		$data = array(
				'attachid' => $attachid,
				'chanid' => $chanid,
				'tid' => $tid,
				'uid' => 1,
				'attachment' => $attachment);
		$data['filename'] = basename($attachment);
		$data['filesize'] = 0;
		$data['description'] = '';
		$data['dateline'] = time();
		$data['image'] = 1;
		$data['width'] = 300;
		MysqlDB::insert("attachment_$module", $data);
		return $attachid;
	}
	
	public function getRootID($catid)
	{
		$rootid = (int)MysqlDB::query("SELECT rootid FROM " . MysqlDB::table('category') . " WHERE catid='$catid'")->fetchColumn();
		return $rootid;
	}
	
	public function addUrlScheme($url) {
		if(empty($url)) return '';
		$needle = array('http://', 'https://', 'ftp://', 'http:', 'https:', 'ftp:', 'http');
		foreach ($needle as $value){
			if (strcasecmp($string, $value) == 0) {
				return '';
			}
		}
		if($url = trim(strip_tags($url))){
			if(parse_url($url, PHP_URL_SCHEME)){
				return $url;
			}
			return "http://$url";
		}
		return '';
	}
	
	public function fieldTryParse($fields, &$data, $type = 'varchar', $defvalue = null)
	{
		if(!empty($fields)){
			if(!is_array($fields)) $fields = array($fields);
			foreach($fields as $key){
				if(!isset($data[$key]) && $defvalue !== null){
					$data[$key] = $defvalue;
				}elseif(isset($data[$key])){
					if($type == 'int'){
						$data[$key] = intval(trim($data[$key]));
					}elseif($type == 'varchar'){
						$data[$key] = trim(strip_tags($data[$key]));
					}else{
						$data[$key] = trim($data[$key]);
					}
				}
			}
			return true;
		}
		return false;
	}
	
	public function formatRunSystem($runsystem)
	{
		if(empty($runsystem)){
			return 'WinXP, Win7, Win8';
		}
		do{
			$runsystem = preg_replace('/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F]+/S', '', $runsystem, -1, $count);
		}while($count);
		$runsystem = str_replace(array("'", '"'), '', $runsystem);
		$runsystem = str_replace(array(chr(0xa3) . chr(0xdc), chr(0xa3) . chr(0xaf), chr(0xa1) . chr(0xa2), '/', '&nbsp;', '|'), ',', $runsystem);
		$runsystem = str_replace(array(chr(0xa3) . chr(0xac), chr(0xa1) . chr(0x41), chr(0xef) . chr(0xbc) . chr(0x8c)), ',', $runsystem);
		$runsysarray = array_unique(explode(',', $runsystem));
		$systemnew = array();
		$count = 0;
		foreach ($runsysarray as $platform) {
			if (preg_match('/^([\x7f-\xff_-]|\.|\w|\s){2,30}$/', $platform)) {
				$systemnew[] = trim($platform);
				$count++;
				if($count >=10){
					break;
				}
			}
		}
		return $systemnew ? implode(', ', $systemnew) : 'WinXP, Win7, Win8';
	}
	
	public function formatContent($content)
	{
		if($content = trim($content)){
			do{
				$content = preg_replace('/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F]+/S', '', $content, -1, $count);
			}while($count);
			$content = MysqlDataConvert::htmlToCode($content);
			$content = str_replace(array('[attachimg]', '[/attachimg]', "\r\n"), array('[attach]', '[/attach]', "\n"), $content);
			$content = str_replace(array('<!-- pagebreak -->', '[NextPage]', '[page_break]'), '[pagebreak]', $content);
			$content = preg_replace("/<(p|div)(\s+[^>]*)?>\s*\[pagebreak\]\s*<\/(p|div)>/i", '[pagebreak]', $content);
			$content = preg_replace("/\[pagebreak\]\s*<\/(p|div)>/i", "</\\1>\n[pagebreak]", $content);
			$content = preg_replace("/<(p|div)(\s+[^>]*)?>\s*\[pagebreak\]/i", "[pagebreak]<\\1\\2>", $content);
			if(substr($content, -10) == "<br/><br/>"){
				$content = substr($content, 0, -10);
			}
		}
		return trim($content);
	}
	
	public function formatSummary($summary, $content, $defvalue = "")
	{
		if(empty($summary) && $content){
			$length = 100;
			$content = trim(strip_tags($content));
			$content = str_replace('[pagebreak]', '', $content);
			$content = str_replace('&nbsp;', '', $content);
			$content = preg_replace("/&(quot|#34);/i", '"', $content);
			$content = preg_replace("/&(amp|#38);/i", "&", $content);
			$content = preg_replace("/\[attachimg\](\d*)\[\/attachimg\]/i", "", $content);
			$content = preg_replace("/\[attach\](\d*)\[\/attach\]/i", "", $content);
			if($content = trim($content)){
				$summary = mb_substr($content, 0, $length, $this->charset);
			}
		}else{
			$summary = trim(strip_tags($summary));
			$summary = str_replace('&nbsp;', '', $summary);
			$summary = preg_replace("/\[attachimg\](\d*)\[\/attachimg\]/i", "", $summary);
			$summary = preg_replace("/\[attach\](\d*)\[\/attach\]/i", "", $summary);
		}
		$summary = $summary ? $summary : $defvalue;
		$summary = str_replace(array("\r", "\n", "\t"), '', $summary);
		if (strcasecmp($this->charset, 'utf-8') === 0) {
			$summary = str_replace(chr(0xe3) . chr(0x80) . chr(0x80), '', $summary);
		}else{
			$summary = str_replace(chr(0xa1) . chr(0xa1), '', $summary);
		}
		return str_replace('"', '&quot;', $summary);
	}
	
	public static function htmlToCode($html, $flag = true)
	{
		$html = preg_replace(array("/<style.*?>.*?<\/style>[\n\r\t]*/is", "/<script[^>]*?>.*?<\/script>[\n\r\t]*/is"), "", $html);
		if($flag){
			$html = preg_replace("/<(\/?)(b|u|i|s)(\s+[^>]+)?>/is", "[\\1\\2]", $html);
			$html = preg_replace("/\[(\/?)(b|u|i|s)\]/is", "[\\1\\2]", $html);
			$html = str_replace(array('[B]', '[/B]'), array('[b]', '[/b]'), $html);
			$html = str_replace(array('[U]', '[/U]'), array('[u]', '[/u]'), $html);
			$html = str_replace(array('[I]', '[/I]'), array('[i]', '[/i]'), $html);
			$html = str_replace(array('[S]', '[/S]'), array('[s]', '[/s]'), $html);
			$html = preg_replace("/<(\/?)strong(\s+[^>]+)?>/is", "[\\1b]", $html);
			$html = preg_replace("/<(\/?)em(\s+[^>]+)?>/is", "[\\1i]", $html);
			$html = preg_replace("/<font\s+color=[\'\"]?([#\w]+?)[\'\"]?[^>]*?>(.*?)<\/font>/i", "[color=\\1]\\2[/color]", $html);
			$html = preg_replace("/<font\s+size=[\'\"]?(\d{1,2}?)[\'\"]?[^>]*?>(.*?)<\/font>/i", "[size=\\1]\\2[/size]", $html);
			$html = preg_replace_callback("/<span(?:\s+[^>]+)?\s+style=[\'\"]+([^\"\<]+)[\'\"]?[^>]*?>(.*?)<\/span>/i", "MysqlDataConvert::parserSpanTags", $html);
			$html = preg_replace("/<center>([\s\S]+?)<\/center>/i", "[align=center]\\1[/align]", $html);
			$html = preg_replace("/\[size=2\]([\s\S]+?)\[\/size\]/i", "\\1", $html);
			$html = preg_replace("/<p\s+align=[\'\"]?(left|center|right|justify)[\'\"]?[^>]*?>(.*?)<\/p>/i", "[align=\\1]\\2[/align]", $html);
			$html = preg_replace("/<div\s+align=[\'\"]?(left|center|right|justify)[\'\"]?[^>]*?>(.*?)<\/div>/i", "[align=\\1]\\2[/align]", $html);
			$html = preg_replace("/<p(?:\s+[^>]+)?\s+style=[\'\"]?text-align\s*:\s*(left|center|right|justify);?[\'\"]?[^>]*?>(.*?)<\/p>/is", "[align=\\1]\\2[/align]", $html);
			$html = preg_replace("/<div(?:\s+[^>]+)?\s+style=[\'\"]?text-align\s*:\s*(left|center|right|justify);?[\'\"]?[^>]*?>(.*?)<\/div>/is", "[align=\\1]\\2[/align]", $html);
			$html = preg_replace("/\s*<blockquote[^>]*>([\s\S]+?)<\/blockquote>/i", "[quote]\\1[/quote]", $html);
			$html = preg_replace("/\s*<(span|em|div)\s+class=\"(codeStyle|quoteStyle|blockcodeStyle)\">([\s\S]+?)<\/(span|em|div)>/i", "[quote]\\3[/quote]", $html);
			$html = preg_replace("/<div class=\"syntax\">([\s\S]+?)<\/div>/i", "\\1", $html);
			$html = preg_replace("/\s*<pre\s+class=\"brush:\s*([A-Za-z0-9_#]+);.*?>([\s\S]+?)<\/pre>/is", "\n[code=\\1]\\2[/code]", $html);
			$html = preg_replace("/<img\s+[^>]*?src\s*=\s*(\'|\")(.*?)\\1[^>]*?\/?>/i", "[img]\\2[/img]", $html);
			$html = preg_replace("/<img\s+[^>]*?src=\s*([^>]+)?\/?>/i", "[img]\\1[/img]", $html);
			$html = preg_replace("/<span.*?>([\s\S]+?)<\/span>/is", "\\1", $html);
			$html = preg_replace("/<font.*?>([\s\S]+?)<\/font>/is", "\\1", $html);
			$html = preg_replace("/<p[^>]*?>\s*([\s\S]+?)<\/p>/is", "[___P___]\\1[/___P___]", $html);
			$html = preg_replace("/<div[^>]*?>\s*([\s\S]+?)<\/div>/is", "[___P___]\\1[/___P___]", $html);
			$html = preg_replace("/(<(p|div)[^>]*?>|<\/(p|div)\>)/i", "", $html);
			$html = str_replace(array('[___P___]', '[/___P___]'), array('<p>', '</p>'), $html);
			$html = preg_replace("/((&nbsp;){8,8}|( &nbsp;){4,4}|(&nbsp; ){4,4})/", "\\t", $html);
			$html = str_replace("&nbsp;", " ", $html);
			$html = preg_replace("#\[img\]([a-zA-Z0-9\x2d-\x2f\x5f\x3a]+)?\[InstallDir_ChannelDir\]([a-zA-Z0-9\x2d-\x2f\x5f\x7e]{20,60})\[\/img\]#i", "[img][InstallDir_ChannelDir]\\2[/img]", $html);

		}
		$html = preg_replace("/<a.*?>(.*?)<\/a>/is", "\\1", $html);
		$html = preg_replace("/(<iframe.*?>(.*?)<\/iframe>|<iframe.*?>)[\n\r\t]*/is", "", $html);
		$html = preg_replace("/<form.*?>(.*?)<\/form>[\n\r\t]*/is", "\\1", $html);
		$html = preg_replace("/<br.*?>/is", "<br/>", $html);
		$html = preg_replace("/&(quot|#34);/i", '"', $html);
		$html = preg_replace("/&(amp|#38);/i", "&", $html);
		$html = str_replace("\r\n", "\n", $html);
		$html = str_replace("</object></object>", "</object>", $html);
		return $html;
	}
	
	public static function parserSpanTags($matches)
	{
		$text = $matches[2];
		$attr = $matches[1];
		if(preg_match("/background-color\s*:\s*(.*?);/is", $attr, $tmp)){
			if($val = trim($tmp[1])){
				$text = "[bgcolor=$val]{$text}[/bgcolor]";
				$attr = preg_replace("/background-color\s*:\s*(.*?);/is", "", $attr);
			}
		}
		if(preg_match("/color\s*:\s*(.*?);/is", $attr, $tmp)){
			if($val = trim($tmp[1])) $text = "[color=$val]{$text}[/color]";
		}
		if(preg_match("/font-style\s*:\s*italic/i", $attr)) $text = "[i]{$text}[/i]";
		if(preg_match("/text-decoration\s*:\s*underline/i", $attr)) $text = "[i]{$text}[/i]";
		if(preg_match("/text-decoration\s*:\s*line-through/i", $attr)) $text = "[u]{$text}[/u]";
		if(preg_match("/font-weight\s*:\s*(bold|700)/i", $attr)) $text = "[b]{$text}[/b]";
		return $text;
	}
}
?>