<?php
/**
 * Copyright (c) 2010-2013 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : PdoDriver.php  2013-4-2
 */

class PdoDriver extends PDO {
	public $querycount = 0;
	protected $options = array();
	protected $tablepre = 'pc_';
	protected $driver = 'mysql';
	private $transactions = false;
	private $errorCode = 0;
	private static $instance = null;
	
	public function __construct($options = null)
	{
		if(!empty($options)){
			$this->setOptions($options);
		}
		$dsn = $this->parseDsn($this->driver, $options['dsn']);
		$driver_options = array(PDO::ATTR_ERRMODE => PDO::ERRMODE_SILENT);
		if(!empty($options['pconnect'])){
			$driver_options[PDO::ATTR_PERSISTENT] = true;
		}
		if(!empty($options['charset']) && strcasecmp($this->driver, 'mysql') == 0){
			$driver_options[PDO::MYSQL_ATTR_INIT_COMMAND] = "SET NAMES '{$options['charset']}'";
		}
		try{
			parent::__construct($dsn, $options['username'], $options['password'], $driver_options);
			if(!empty($options['charset']) && strcasecmp($this->driver, 'mysql') == 0){
				$this->exec("SET NAMES '{$options['charset']}'");
			}
			$this->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
			$this->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
			$this->setAttribute(PDO::ATTR_CASE, PDO::CASE_LOWER);
			$this->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		}catch(PDOException $e){
			die('Connection database Error: ' . $e->getMessage());
		}
	}
	
	protected function setOptions($options)
	{
		$this->options = &$options;
		$this->tablepre = empty($options['tablepre']) ? 'pc_' : trim($options['tablepre']);
		$this->driver = empty($options['driver']) ? 'mysql' : trim($options['driver']);
	}
	
	public function parseDsn($driver, $dsn_options = array())
	{
		$dsn = "${driver}:" ;
		foreach ($dsn_options as $k => $v){
			$dsn .= "${k}=${v};";
		}
		return $dsn;
	}
	
	public function selectdb($dbname)
	{
		return $this->exec("use `$dbname`");
	}
	
	public function tableName($tablename) 
	{
		return $this->tablepre . $tablename;
	}
	
	public function getQueryCount()
	{
		return $this->querycount;
	}
	
	public function query($sql)
	{
		$this->querycount++;
		try {
			return parent::query($sql);
		} catch (Exception $e) {
			return false;
		}
		
	}
	
	public function execQuery($sql, $column_number = null)
	{
		if(null === $column_number){
			return $this->query($sql)->fetch(PDO::FETCH_ASSOC);
		}else{
			return $this->query($sql)->fetchColumn($column_number);
		}
	}
	
	public function lastInsertId($name = null)
	{
		if(strcasecmp($this->driver, 'pgsql')){
			return parent::lastInsertId($name);
		}else{
			return $this->execQuery('SELECT LASTVAL() as ins_id', 0);
		}
	}
	
	public function beginTransaction()
	{
		$this->transactions = parent::beginTransaction();
		return true;
	}
	
	public function commit()
	{
		if($this->transactions){
			if(parent::commit()){
				$this->transactions = false;
			}
		}
		return true;
	}
	
	public function rollBack()
	{
		if($this->transactions){
			if(parent::rollBack()){
				$this->transactions = false;
			}
		}
		return true;
	}
	
	public function version()
	{
		return $this->getAttribute(PDO::ATTR_SERVER_VERSION);
	}
	
	public function clientVersion()
	{
		return $this->getAttribute(PDO::ATTR_CLIENT_VERSION);
	}
	
	public function setCode($code)
	{
		$this->errorCode = $code;
	}
	
	public function errorCode()
	{
		return $this->errorCode;
	}
	
	public function quote($string, $paramtype_type = PDO::PARAM_STR)
	{
		if(is_null($string)){
			return "NULL";
		}
		$string = parent::quote($string, $paramtype_type);
		if (strpos($string, "'") === 0){
			$string = substr($string, 1, -1);
		}
		return $string;
	}
	
	public static function getInstance($options = null)
	{
		if(self::$instance == null){
			self::$instance = new self($options);
		}
		return self::$instance;
	}
}

class DbException extends Exception{
	public function __construct($message = null){
		echo $message;
	}
}
?>