<?php
/**
 * Copyright (c) 2010-2013 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : Function.php  2013-4-2
 */

function maketime($format = '0') 
{
	$timestamp = '';
	switch ($format) {
		case 'd': $timestamp = mktime(0, 0, 0, date("m"), date("d"), date("Y")); break;
		case 'w': $timestamp = strtotime("last Sunday"); break;
		case 'm': $timestamp = mktime(0, 0, 0, date("m"), 1, date("Y")); break;
		case 'y': $timestamp = mktime(0, 0, 0, 1, 1, date("Y")); break;
		case 'D': $timestamp = mktime(0, 0, 0, date("m"), date("d") + 1, date("Y")); break;
		case 'W': $timestamp = strtotime("next Sunday"); break;
		case 'M': $timestamp = mktime(0, 0, 0, date("m") + 1, 1, date("Y")); break;
		case 'Y': $timestamp = mktime(0, 0, 0, 1, 1, date("Y") + 1); break;
		case '0': $timestamp = strtotime(0); break;
		default:
			$time = 8 * 3600;
			$timestamp = time() + $time;
			break;
	}
	return $timestamp;
}

function debug($var = null) 
{
	echo '<pre>';
	if ($var === null) {
		print_r($GLOBALS);
	} else {
		print_r($var);
	}
	exit('</pre>');
}

function convertlog($log)
{
	if($fp = @fopen('log.txt', 'a')){
		@flock($fp, 2);
		fwrite($fp, "$log\r\n");
		fclose($fp);
	}
}

function formatsize($size) 
{
	static $unit = array(' bytes', ' KB', ' MB', ' GB', ' TB', ' PB');
	$i = 0;
	while ($size > 1024 && ++$i < 6) {
		$size /= 1024;
	}
	$i && $size = round($size, 2);
	return $size . $unit[$i];
}

function str_rand($length = 16) {
	$hash = '';
	$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz';
	$max = strlen($chars) - 1;
	for($i = 0; $i < $length; $i++) {
		$hash .= $chars[mt_rand(0, $max)];
	}
	return $hash;
}

function rate_rand($weight = 1, $max = 500){
	if($max && $weight){
		$max = min(3000, max(30, $max));
		$num = mt_rand(30, $max);
		$min = $weight == 2 ? 4 : 3;
		$score = 0;
		for ($i = 0; $i < $num; $i++) {
			$score += mt_rand($min, 5) * 2;
		}
		return array('voter' => $num, 'total' => $score);
	}
	return null;
}

function T($key){
	return isset($GLOBALS['lang'][$key]) ? $GLOBALS['lang'][$key] : $key;
}

function md5salt($string, $salt = '') 
{
	return md5(substr(md5($string), 8, 16) . $salt);
}

function md5convert($md5str, $salt = null)
{
	return md5($md5str, $salt);
}

function htmlcharsdecode($string){
	if (is_array($string)) {
		foreach($string as $k => $v){
			$string[$k] = htmlcharsdecode($v);
		}
	}else{
		$string = str_replace(array('&apos;', '&#039;', '&quot;', '&lt;', '&gt;', '&amp;'), array("'", "'", '"', '<', '>', '&'), $string);
	}
	return $string;
}

/**
 * comparison string is exist
 * 
 * @param string $haystack
 * @param string $needle
 * @param integer $offset
 * @param boolean $return
 * @return Ambigous string|boolean
 */
function str_exists($haystack, $needle, $offset = 0, $return = false) 
{
	if (is_array($needle)) {
		foreach ($needle as $string) {
			if (strpos($haystack, $string, $offset) !== false) return $return ? $string : true;
		}
		return false;
	}else {
		return !(strpos($haystack, $needle, $offset) === false);
	}
}
/**
 * Binary safe case-insensitive string comparison
 *
 * @param string $string
 * @param mixed $needle string|array
 * @return boolean
 */
function stricmp($string, $needle, $return = false, $default = false)
{
	if(is_array($needle)){
		foreach ($needle as $value){
			if (strcasecmp($string, $value) == 0) {
				return $return ? $value : true;
			}
		}
		return $default;
	}else{
		return (strcasecmp($string, $needle) == 0);
	}
}

/**
 * remove invalid characters
 * 
 * @param string $string
 * @param boolean $is_urlencode
 * @return string
 */
function removeinvalidchars($string, $is_urlencode = true) 
{
	$patterns = array('/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F]+/S');
	if($is_urlencode){
		$patterns[] = '/%0[0-8bcef]/';
		$patterns[] = '/%1[0-9a-f]/';
	}

	do{
		$string = preg_replace($patterns, '', $string, -1, $count);
	}while($count);

	return $string;
}

function checkinvalidchars($string, $length = 0, $defaultmsg = null)
{
	if($string = trim(strip_tags($string))){
		do{
			$string = preg_replace('/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F]+/S', '', $string, -1, $count);
		}while($count);
		if(parse_url($string, PHP_URL_SCHEME)){
			if(is_numeric($defaultmsg)){
				$string = $defaultmsg;
			}elseif(is_string($defaultmsg)){
				$string = isset($lang[$defaultmsg]) ? $lang[$defaultmsg] : '';
			}else{
				$string = '';
			}
		}
		if($length && mb_strlen($string, 'gbk') > $length){
			$string = mb_substr($string, 0, $length, 'gbk');
		}
		$string = str_replace(array("laser@zhengmai.com.cn", '룺'), '', $string);
	}
	return trim($string);
}

function implodeids($array, $glue = "','", $limit = 0) {
	if (!empty($array)) {
		$glue = $glue ? $glue : "','";
		$data = array();
		$array = is_array($array) ? $array : explode(",", $array);
		$i = 0;
		foreach ($array as $val) {
			if (is_array($val)) {
				foreach($val as $v){
					if (is_numeric($v)){
						$i++;
						$data[] = intval($v);
						if($limit && $i >= $limit){
							break;
						}
					}
				}
			}elseif (is_numeric($val)){
				$i++;
				$data[] = intval($val);
				if($limit && $i >= $limit){
					break;
				}
			}
		}
		$data = array_unique($data);
		return $data ? "'" . implode($glue, $data) . "'" : '';
	} else {
		return '';
	}
}

function addurlscheme($url) {
	if(empty($url)) return '';
	if($url = trim(strip_tags($url))){
		if(parse_url($url, PHP_URL_SCHEME)){
			return $url;
		}
		return "http://$url";
	}
	return '';
}

function uintval($value) {
	if(($value = intval($value)) > 0){
		return $value;
	}
	return 0;
}

function iconv_addslashes($string, $charset = 'gbk') {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = iconv_addslashes($val, $charset);
		}
	}else{
		if(is_numeric($string)) return $string;
		$string = @iconv('GB2312', 'GBK//TRANSLIT//IGNORE', $string);
		if(strcasecmp($charset, 'gbk')){
			$string = @iconv('GBK', 'UTF-8//TRANSLIT//IGNORE', $string);
		}
		do{
			$string = preg_replace('/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F]+/S', '', $string, -1, $count);
		}while($count);
		$string = trim($string);
	}
	return $string;
}

function addslashesex($string, $force = 1) {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = addslashesex($val, $force);
		}
	} else {
		$string = addslashes($string);
	}
	return $string;
}

function stripslashesex($string) {
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = stripslashesex($val);
		}
	} else {
		$string = stripslashes($string);
	}
	return $string;
}

function dirwriteable($dir) {
	$writeable = 0;
	if(!is_dir($dir)) {
		@mkdir($dir, 0777);
	}
	if(is_dir($dir)) {
		if($fp = @fopen("$dir/test.txt", 'w')) {
			@fclose($fp);
			@unlink("$dir/test.txt");
			$writeable = 1;
		} else {
			$writeable = 0;
		}
	}
	return $writeable;
}

function implode_field_value($array, $glue = ',') {
	$sql = $comma = '';
	foreach ($array as $k => $v) {
		$sql .= $comma."`$k`='$v'";
		$comma = $glue;
	}
	return $sql;
}

function setconfigarray($array, $default = NULL) {
	if (is_array($default)) {
		foreach ($default as $k => $v) {
			if (!isset($array[$k])) {
				$array[$k] = $default[$k];
			} elseif (is_array($v)) {
				$array[$k] = setconfigarray($array[$k], $default[$k]);
			}
		}
	}
	return $array;
}

function exportconfigarray($array, $level = 0, $keyname = null, $varname = '$_config') {
	$result = null;
	if (is_array($array)) {
		foreach ($array as $key => $value) {
			if ($level == 0) {
				$tokens = str_pad('  CONFIG ' . strtoupper($key) . '  ', 70, '-', STR_PAD_BOTH);
				$result .= "\r\n/* $tokens */\r\n";
			}
			if (is_array($value)) {
				$kname = $keyname . "['$key']";
				$result .= exportconfigarray($value, $level + 1, $kname, $varname);
			} else {
				$value = is_string($value) || strlen($value) > 12 || !preg_match("/^\-?[1-9]\d*$/", $value) ? '\'' . addcslashes($value, '\'\\') . '\'' : $value;
				$result .= $varname . $keyname . "['$key'] = $value;\r\n";
			}
		}
	}
	return $result;
}

function get_clientip() {
	$clientip = '';
	switch (true) {
		case !empty($_SERVER['HTTP_CLIENT_IP']):
			$clientip = htmlspecialchars((string)$_SERVER['HTTP_CLIENT_IP']);
			if($clientip = check_clientip($clientip)){
				break;
			}
		case !empty($_SERVER['HTTP_X_FORWARDED_FOR']):
			$clientip = htmlspecialchars((string)$_SERVER['HTTP_X_FORWARDED_FOR']);
			if($clientip = check_clientip($clientip)){
				break;
			}
		case !empty($_SERVER['REMOTE_ADDR']):
			$clientip = htmlspecialchars((string) $_SERVER['REMOTE_ADDR']);
			$clientip = check_clientip($clientip);
			break;
	}
	return $clientip ? $clientip : 'unknown';
}

function check_clientip($xip) {
	static $ipv4expression = '#^(?:(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$#';
	static $ipv6expression = '#^(?:(?:(?:[\dA-F]{1,4}:){1,6}(?:[\dA-F]{1,4}:[\dA-F]{1,4}|(?:(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])))|(?:::(?:[\dA-F]{1,4}:){0,5}(?:[\dA-F]{1,4}(?::[\dA-F]{1,4})?|(?:(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])))|(?:(?:[\dA-F]{1,4}:):(?:[\dA-F]{1,4}:){4}(?:[\dA-F]{1,4}:[\dA-F]{1,4}|(?:(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])))|(?:(?:[\dA-F]{1,4}:){1,2}:(?:[\dA-F]{1,4}:){3}(?:[\dA-F]{1,4}:[\dA-F]{1,4}|(?:(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])))|(?:(?:[\dA-F]{1,4}:){1,3}:(?:[\dA-F]{1,4}:){2}(?:[\dA-F]{1,4}:[\dA-F]{1,4}|(?:(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])))|(?:(?:[\dA-F]{1,4}:){1,4}:(?:[\dA-F]{1,4}:)(?:[\dA-F]{1,4}:[\dA-F]{1,4}|(?:(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])))|(?:(?:[\dA-F]{1,4}:){1,5}:(?:[\dA-F]{1,4}:[\dA-F]{1,4}|(?:(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.){3}(?:\d{1,2}|1\d\d|2[0-4]\d|25[0-5])))|(?:(?:[\dA-F]{1,4}:){1,6}:[\dA-F]{1,4})|(?:(?:[\dA-F]{1,4}:){1,7}:)|(?:::))$#i';

	$clientip = '';
	if (!empty($xip) && strcasecmp($xip, 'unknown')) {
		$xip = preg_replace('# {2,}#', ' ', str_replace(array(',', ';', '%'), ' ', $xip));
		$ips = explode(' ', $xip);
		foreach ($ips as $ip) {
			if (preg_match($ipv4expression, $ip)) {
				$clientip = $ip;
			} else if (preg_match($ipv6expression, $ip)) {
				if (stripos($ip, '::ffff:') === 0) {
					$ipv4 = substr($ip, 7);
					if (preg_match($ipv4expression, $ipv4)) {
						$ip = $ipv4;
					}
				}
				$clientip = $ip;
			} else {
				break;
			}
		}
		return $clientip;
	} else {
		return null;
	}
}
?>