<?php
/**
 * Copyright (c) 2010-2013 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : index.php  2013-4-2
 */
error_reporting(E_ERROR | E_WARNING | E_PARSE);
//error_reporting(E_ALL);
//@ini_set('display_errors', 'On');
//@ini_set('display_startup_errors', 'On');
@set_time_limit(0);
if(! @ini_get('date.timezone')){
	ini_set('date.timezone','Asia/Shanghai');
}
date_default_timezone_set('Etc/GMT+8');
define('MAGIC_QUOTES_GPC', function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc());
if(version_compare(PHP_VERSION, '5.3.0', '<')){
	set_magic_quotes_runtime(0);
}
@ini_set('magic_quotes_runtime', '0');
header("Content-Type: text/html; charset=gbk");
define('IN_PHPCOM', TRUE);
define('TIMESTAMP', time());
define('DEFAULT_TABLEPRE', 'pc_');
define('APP_ROOT_PATH', dirname(__FILE__). DIRECTORY_SEPARATOR);
$version = '1.3.0';
require './inc/language.php';
require './inc/function.php';
require './inc/common.php';
require './inc/PdoDriver.php';
require './inc/MysqlDB.php';
require './inc/MssqlDB.php';
require './inc/AccessDB.php';
require './inc/MysqlDataConvert.php';
$db_config = @include('./data/db_config.php');

ob_start();
if(!MAGIC_QUOTES_GPC){
	$_GET = addslashesex($_GET);
	$_POST = addslashesex($_POST);
}
$step = isset($_GET['step']) ? intval($_GET['step']) : 0;

page_header();
if($step == 1){
	if(!extension_loaded('pdo_mysql')){
		show_message('undefine_function', 'pdo_mysql_unsupported');
	}
	if(!extension_loaded('pdo_odbc')){
		show_message('undefine_function', 'pdo_odbc_unsupported');
	}
	if(!dirwriteable('data')){
		show_message('undefine_function', 'data_dir_unwriteable');
	}
	page_nav();
	$dbname = $db_config['db']['dsn']['dbname'];
	$mssql_items = array('server' => array('value' => $db_config['mssql']['dsn']['Server'], 'error' => 0),
			'database' => array('value' => $db_config['mssql']['dsn']['Database'], 'error' => 0),
			'username' => array('value' => $db_config['mssql']['username'], 'error' => 0),
			'password' => array('value' => $db_config['mssql']['password'], 'error' => 0),
			'tablepre' => array('value' => $db_config['mssql']['tablepre'], 'error' => 0),
			'first' => array('value' => array(
					'soft' => 'soft',
					'article' => ''
			), 'error' => 0, 'type' => 'radio'),
	);
	$s = show_mssql_info($mssql_items);
	
	$db_items = array('dbhost' => array('value' => $db_config['db']['dsn']['host'], 'error' => 0),
			'dbport' => array('value' => $db_config['db']['dsn']['port'], 'error' => 0),
			'dbname' => array('value' => $db_config['db']['dsn']['dbname'], 'error' => 0),
			'dbuser' => array('value' => $db_config['db']['username'], 'error' => 0),
			'dbpass' => array('value' => $db_config['db']['password'], 'error' => 0),
			'tablepre' => array('value' => $db_config['db']['tablepre'], 'error' => 0),
			'dbcharset' => array('value' => array(
					'gbk' => $db_config['db']['charset'],
					'utf8' => $db_config['db']['charset']
			), 'error' => 0, 'type' => 'radio'),
	);
	$s .= show_database_info($db_items);
	$website = trim('http://' . $_SERVER['HTTP_HOST'], '/\ ');
	$admin_items = array(
			'username' => array('value' => 'admin', 'error' => 0),
			'password' => array('value' => '', 'error' => 0),
			'password2' => array('value' => '', 'error' => 0),
			'email' => array('value' => 'admin@domain.com', 'error' => 0),
			'webname' => array('value' => 'PHPcom', 'error' => 0),
			'website' => array('value' => $website, 'error' => 0)
	);
	$s .= show_admin_info($admin_items);
	page_body($s);
	
}elseif($step == 2){
	page_nav();
	$submitted = true;
	page_body('<div id="notice"><ul id="noticeinner"></ul></div>');
	if($_SERVER['REQUEST_METHOD'] == 'POST'){
		$dbconfig = $_POST['dbconfig'];
		$tablepre = trim($dbconfig['db']['tablepre'], "`-_ \r\n\t"). '_';
		$db_items = array('dbhost' => array(), 'dbname' => array(), 'dbuser' => array(), 'dbpass' => array(), 'tablepre' => array());
		foreach(array('dbhost', 'dbname', 'dbuser', 'tablepre') as $key){
			$db_items[$key]['value'] = $dbconfig['db'][$key];
			$db_items[$key]['error'] = $dbconfig['db'][$key] ? 0 : 'config_'.$key.'_invalid';
			if(empty($dbconfig['db'][$key])){
				$submitted = false;
			}
		}
		$adminuser = $_POST['adminuser'];
		$username = empty($adminuser['username']) ? 'admin' : trim($adminuser['username']);
		$password = empty($adminuser['password']) ? 'admin' : trim($adminuser['password']);
		$email = empty($adminuser['email']) ? 'admin@domain.com' : trim($adminuser['email']);
		$webname = trim($adminuser['webname']);
		$website = trim($adminuser['website'], " \r\n\t\\/");
		
		$db_config['db']['username'] = trim($dbconfig['db']['dbuser']);
		$db_config['db']['password'] = trim($dbconfig['db']['dbpass']);
		$db_config['db']['charset'] = trim($dbconfig['db']['dbcharset']);
		$db_config['db']['tablepre'] = trim($dbconfig['db']['tablepre']);
		$db_config['db']['dsn']['host'] = trim($dbconfig['db']['dbhost']);
		$db_config['db']['dsn']['port'] = trim($dbconfig['db']['dbport']);
		$db_config['db']['dsn']['charset'] = trim($dbconfig['db']['dbcharset']);
		$db_config['db']['dsn']['dbname'] = trim($dbconfig['db']['dbname']);
		
		$db_config['mssql']['username'] = trim($dbconfig['mssql']['username']);
		$db_config['mssql']['password'] = trim($dbconfig['mssql']['password']);
		$db_config['mssql']['tablepre'] = trim($dbconfig['mssql']['tablepre']);
		$db_config['mssql']['dsn']['Server'] = trim($dbconfig['mssql']['server']);
		$db_config['mssql']['dsn']['Database'] = trim($dbconfig['mssql']['database']);
		$db_config['charset'] = strcasecmp($dbconfig['db']['dbcharset'], 'gbk') ? 'utf-8' : 'gbk';
		$db_config['table'] = array();
		if(isset($dbconfig['mssql']['table'])){
			$db_config['table'] = $dbconfig['mssql']['table'];
		}
		$db_config['table']['first'] = trim($dbconfig['mssql']['first']);
		save_dbconfig($db_config);
		if($submitted){
			$authkey = str_rand();
			$config = getwebconfig();
			if(extension_loaded('pdo_mysql')){
				$config['db']['type'] = 'pdomysql';
			}elseif(function_exists('mysqli_connect')){
				$config['db']['type'] = 'mysqli';
			}else{
				$config['db']['type'] = 'mysql';
			}
			$config['db']['1']['dbhost'] = $dbconfig['db']['dbhost'];
			$config['db']['1']['dbuser'] = $dbconfig['db']['dbuser'];
			$config['db']['1']['dbpass'] = $dbconfig['db']['dbpass'];
			$config['db']['1']['dbname'] = $dbconfig['db']['dbname'];
			$config['db']['1']['charset'] = $dbconfig['db']['dbcharset'];
			$config['db']['1']['tablepre'] = $tablepre;
			$config['cache']['prefix'] = str_rand(6).'_';
			$config['cookie']['prefix'] = str_rand(8).'_';
			$config['security']['key'] = $authkey;
			$config['output']['charset'] = strcasecmp($dbconfig['db']['dbcharset'], 'gbk') ? 'utf-8' : 'gbk';
			$config['admincp']['founder'] = '1';
			if(($datadir = realpath("../data")) && !file_exists("$datadir/config.php")){
				save_webconfig($datadir . '/config.php', $config);
				@touch($datadir . '/install.lock');
			}else{
				save_webconfig(APP_ROOT_PATH . 'config.php', $config);
				@touch(APP_ROOT_PATH . 'install.lock');
			}
			unset($db_config);
			$db_config = include(APP_ROOT_PATH . 'data/db_config.php');
			$dbname = $db_config['db']['dsn']['dbname'];
			$tablepre = $db_config['db']['tablepre'];
			$dbcharset = $db_config['db']['charset'];
			unset($db_config['db']['dsn']['dbname']);
			$db = MysqlDB::getInstance();
			$db->exec("CREATE DATABASE IF NOT EXISTS `$dbname` DEFAULT CHARACTER SET $dbcharset");
			$db->selectdb($dbname);
			
			$installsql = file_get_contents(APP_ROOT_PATH . 'data/install.sql');
			$installsql = str_replace("\r\n", "\n", $installsql);
			$message = executesql($installsql, $tablepre, $dbcharset);
			shownoticeinner(trim($message, " |\t"));
			flush();
			ob_flush();
			if(strcasecmp($dbcharset, 'gbk')){
				$sqlfile = APP_ROOT_PATH. 'data/utf8_data.sql';
				$webname = iconv('GBK', 'UTF-8//TRANSLIT//IGNORE', $webname);
			}else{
				$sqlfile = APP_ROOT_PATH. 'data/gbk_data.sql';
			}
			$installsql = file_get_contents($sqlfile);
			$installsql = str_replace("\r\n", "\n", $installsql);
			executesql($installsql, $tablepre, $dbcharset);
			
			$db->exec("REPLACE INTO {$tablepre}setting (skey, svalue, stype) VALUES ('authkey', '$authkey', 'string')");
			$db->exec("REPLACE INTO {$tablepre}setting (skey, svalue, stype) VALUES ('version', '$version', 'string')");
			$db->exec("REPLACE INTO {$tablepre}setting (skey, svalue, stype) VALUES ('instdir', '/', 'string')");
			$db->exec("REPLACE INTO {$tablepre}setting (skey, svalue, stype) VALUES ('website', '$website', 'string')");
			$db->exec("REPLACE INTO {$tablepre}setting (skey, svalue, stype) VALUES ('webname', '$webname', 'string')");
			$db->exec("REPLACE INTO {$tablepre}setting (skey, svalue, stype) VALUES ('adminmail', '$email', 'string')");
			$db->exec("REPLACE INTO {$tablepre}setting (skey, svalue, stype) VALUES ('absoluteurl', '0', 'string')");
			
			$uid = 1;
			$salt = substr(uniqid(rand()), -6);
			$password = md5salt($password, $salt);
			$clientip = get_clientip();
			$db->exec("REPLACE INTO {$tablepre}members (uid, username, password, adminid, groupid, email, salt, regdate, allowadmin, pmnew) VALUES
			('$uid', '$username', '$password', '1', '1', '$email', '$salt', '".time()."', '1', '0');");
			$db->exec("REPLACE INTO {$tablepre}member_count (uid, money) VALUES ('$uid', '0');");
			$db->exec("REPLACE INTO {$tablepre}member_info (uid, birthday) VALUES ('$uid', '0000-00-00');");
			$db->exec("REPLACE INTO {$tablepre}member_status (uid, regip, lastip, groupterms) VALUES ('$uid', '$clientip', '$clientip', '');");
			//sleep(1);
		}
	}
}elseif($step == 3){
	page_nav();
	$module = isset($_GET['module']) ? trim($_GET['module']) : null;
	$startid = isset($_GET['startid']) ? intval($_GET['startid']) : 0;
	$tablefirst = $db_config['table']['first'];
	$s = '<div class="msg"><p><img style="vertical-align:middle;" src="images/indicator.gif" /> '.$lang['convert_processed'].'</p></div>';
	page_body($s);
	if(isset($_GET['submit']) && $_GET['submit'] == 'yes'){
		$charset = $db_config['charset'];
		$channelids = array(1 => 1, 2 => 2);
		$convert = new MysqlDataConvert();
		
		$sql = "SELECT * FROM " . MssqlDB::table('channel') . " WHERE channelid>9 AND modules IN(1,2)";
		if($query = MssqlDB::query($sql)){
			foreach($query as $row){
				if($row['modules'] != 1 && $row['modules'] != 2) continue;
				$chanid = $row['modules'] == 1 ? 1 : 2;
				$channelids[$row['channelid']] = $row['channelid'];
				$channel = array();
				$channel['channelid'] = $row['channelid'];
				$channel['parentid'] = $row['modules'];
				$channel['sortord'] = $row['channelid'];
				$channel['type'] = 'expand';
				$channel['modules'] = $row['modules'] == 1 ? 'article' : 'soft';
				$channel['channelname'] = iconv_addslashes($row['channelname'], $charset);
				$channel['subname'] = iconv_addslashes($row['modulename'], $charset);
				$channel['codename'] = addslashes(trim($row['channeldir'], "/\\ \t"));
				$channel['setting'] = MysqlDB::query("SELECT setting FROM " . MysqlDB::table('channel') . " WHERE channelid='$chanid'")->fetchColumn();
				MysqlDB::insert('channel', $channel);
			}
			$query->closeCursor();
		}
		
		$sql = "SELECT * FROM " . MssqlDB::table('classify') . " ORDER BY classid";
		if($query = MssqlDB::query($sql)){
			foreach($query as $row){
				if(!isset($channelids[$row['channelid']])) continue;
				$row = iconv_addslashes($row, $charset);
				$convert->category($row);
			}
			$query->closeCursor();
			$convert->updateRootId();
		}
		
		$sql = "SELECT * FROM " . MssqlDB::table('downserver');
		if($query = MssqlDB::query($sql)){
			if($rows = $query->rowCount()){
				MysqlDB::exec("TRUNCATE TABLE " . MysqlDB::table('downserver'));
			}
			foreach($query as $row){
				if($row['channelid'] == 5) continue;
				$downserver = array('servid' => $row['downid']);
				$downserver['chanid'] = $row['channelid'];
				$downserver['depth'] = $row['depth'];
				$downserver['rootid'] = $row['rootid'];
				/*if($row['depth']){
					$downserver['rootid'] = $row['parentid'];
				}else{
					$downserver['rootid'] = $row['downid'];
				}*/
				$downserver['servname'] = iconv_addslashes($row['downloadname'], $charset);
				$downserver['servurl'] = iconv_addslashes($row['downloadpath'], $charset);
				$downserver['parentid'] = $row['parentid'];
				$downserver['child'] = $row['child'];
				$downserver['sortord'] = $row['orders'];
				$downserver['lastdate'] = time();
				$downserver['expires'] = 0;
				MysqlDB::insert('downserver', $downserver);
			}
			$query->closeCursor();
		}
		if($tablefirst == 'soft' && !empty($db_config['table']['soft'])){
			if(($sid = convert_soft_data(1, $startid)) > 0){
				redirect("index.php?step=3&module=soft&startid=$sid");
			}else{
				redirect("index.php?step=3&module=article&startid=0");
			}
		}elseif($tablefirst == 'article' && !empty($db_config['table']['article'])){
			if(($sid = convert_article_data(1, $startid)) > 0){
				redirect("index.php?step=3&module=article&startid=$sid");
			}else{
				redirect("index.php?step=3&module=soft&startid=0");
			}
		}elseif(!empty($db_config['table']['soft'])){
			redirect("index.php?step=3&module=soft&startid=0");
		}elseif(!empty($db_config['table']['article'])){
			redirect("index.php?step=3&module=article&startid=0");
		}elseif(!empty($db_config['table']['member'])){
			redirect("index.php?step=3&module=member&startid=0");
		}elseif(!empty($db_config['table']['comment'])){
			redirect("index.php?step=3&module=comment&startid=0");
		}else{
			redirect("index.php?step=4");
		}
	}elseif($module == 'soft' && !empty($db_config['table']['soft'])){
		$first = $tablefirst == 'soft' ? 1 : 0;
		if(($sid = convert_soft_data($first, $startid)) > 0){
			redirect("index.php?step=3&module=soft&startid=$sid");
		}else{
			if($tablefirst == 'soft'){
				redirect("index.php?step=3&module=article&startid=0");
			}else{
				redirect("index.php?step=3&module=member&startid=0");
			}
		}
	}elseif($module == 'article' && !empty($db_config['table']['article'])){
		$first = $tablefirst == 'article' ? 1 : 0;
		if(($sid = convert_article_data($first, $startid)) > 0){
			redirect("index.php?step=3&module=article&startid=$sid");
		}else{
			if($tablefirst == 'article'){
				redirect("index.php?step=3&module=soft&startid=0");
			}else{
				redirect("index.php?step=3&module=member&startid=0");
			}
		}
	}elseif($module == 'member'){
		redirect("index.php?step=4");
	}
	redirect("index.php?step=4");
}elseif($step == 4){
	page_nav();
	$s = '<div class="msg"><p>'.$lang['convert_succeed'].'</p></div>';
	page_body($s);
}else{
	page_nav();
	$license = '<div class="licenseblock"><div class="license">'.$lang['help_docs']. '</div></div>';
	page_body($license);
}

show_button();
page_footer();

function show_mssql_info($db_items = array()){
	global $lang;
	$s = showhtmlsetting('config_mssql_caption', 'start');
	foreach($db_items as $key => $result){
		$type = empty($result['type']) ? 'text' : trim($result['type']);
		$s .= showhtmlsetting("config_mssql_$key", "dbconfig[mssql][$key]", $result['value'], $type, $result['error']);
	}
	$s .= showhtmlsetting("config_mssql_table", array(
			'article' => 'dbconfig[mssql][table][article]',
			'soft' => 'dbconfig[mssql][table][soft]',
			'tags' => 'dbconfig[mssql][table][tags]'
	), array(
			'article' => 1,
			'soft' => 1,
			'tags' => 0
	), 'checkbox', $result['error']);
	$s .= '</table>';
	return $s;
}

function show_database_info($db_items = array()){
	global $lang;
	$s = showhtmlsetting('config_db_caption', 'start');
	foreach($db_items as $key => $result){
		$type = empty($result['type']) ? 'text' : trim($result['type']);
		$s .= showhtmlsetting("config_$key", "dbconfig[db][$key]", $result['value'], $type, $result['error']);
	}
	$s .= '</table>';
	return $s;
}

function show_admin_info($admin_items = array()){
	global $lang;
	$s = showhtmlsetting('config_admin_caption', 'start');
	foreach($admin_items as $key => $result){
		if($key == 'password' || $key == 'password2'){
			$type = 'password';
		}else{
			$type = 'text';
		}
		$s .= showhtmlsetting("config_admin_$key", "adminuser[$key]", $result['value'], $type, $result['error']);
	}
	$s .= '</table>';
	return $s;
}

function convert_article_data($first = 0, $startid = 0){
	global $db_config, $lang;
	$charset = $db_config['charset'];
	$convert = new MysqlDataConvert();
	$convert->setUid(1);
	$convert->setCharSet($charset);
	if($startid == -1) return -1;
	$sql = "SELECT TOP 500 * FROM " . MssqlDB::table('article') . " WHERE articleid>$startid";
	if($query = MssqlDB::query($sql)){
		$startid = -1;
		foreach($query as $row){
			$startid = $row['articleid'];
			if(empty($row['channelid'])) continue;
			$data = $fields = $subjects = $messages = $images = array();
			if($first){
				$data['tid'] = $row['articleid'];
			}
			$row['title'] = checkinvalidchars($row['title'], 98);
			$row['username'] = checkinvalidchars($row['username'], 30);
			if(empty($row['description'])){
				$row['description'] = '';
			}else{
				$row['description'] = checkinvalidchars($row['description'], 120);
			}
			if(empty($row['title'])) continue;
			$data['chanid'] = $row['channelid'];
			$data['catid'] = $row['classid'];
			$data['title'] = iconv_addslashes($row['title'], $charset);
			$data['recommend'] = $row['isbest'];
			$data['hits'] = uintval($row['allhits']);
			$data['dateline'] = strtotime($row['writetime']);
			$data['status'] = empty($row['isaccept']) ? 0 : 1;
			$subjects['articleid'] = $row['articleid'];
			if(!empty($row['subtitle'])){
				$subjects['subtitle'] = iconv_addslashes($row['subtitle'], $charset);
			}
			$subjects['summary'] = iconv_addslashes($row['description'], $charset);
			$row['author'] = checkinvalidchars($row['author'], 30, 'default_author');
			$row['comefrom'] = checkinvalidchars($row['comefrom'], 45, 'default_source');
			$subjects['author'] = iconv_addslashes($row['author'], $charset);
			$subjects['source'] = iconv_addslashes($row['comefrom'], $charset);
			$subjects['editor'] = iconv_addslashes($row['username'], $charset);
			$messages['content'] = iconv_addslashes($row['content'], $charset);
			$fields['voteup'] = uintval($row['good']);
			$fields['votedown'] = uintval($row['bad']);
			$rates = rate_rand(1);
			$fields['voters'] = intval($rates['voter']);
			$fields['totalscore'] = intval($rates['total']);
			if(!empty($row['imageurl'])){
				if(strncasecmp($row['imageurl'], 'UploadPic/', 10) === 0){
					$images['attachment'] = substr($row['imageurl'], 10);
				}else{
					$images['attachment'] = $row['imageurl'];
				}
				$images['remote'] = 0;
				$data['image'] = 1;
			}
			
			if(!empty($row['taglist']) && !empty($db_config['table']['tags'])){
				$taglist = explode('|', $row['taglist']);
				if(isset($taglist[1])){
					$taglist[1] = checkinvalidchars($taglist[1], 28);
					$messages['tags'] = iconv_addslashes($taglist[1], $charset);
				}
			}
			
			$convert->threads('article', $data, $fields, $subjects, $messages, $images);
		}
		$query->closeCursor();
		return $startid;
	}
	return -1;
}

function convert_soft_data($first = 0, $startid = 0){
	global $db_config, $lang;
	$charset = $db_config['charset'];
	$convert = new MysqlDataConvert();
	$convert->setUid(1);
	$convert->setCharSet($charset);
	$threads = array();
	if($startid == -1) return -1;
	$sql = "SELECT TOP 500 * FROM " . MssqlDB::table('softlist') . " WHERE softid>$startid";
	if($query = MssqlDB::query($sql)){
		$softid = $startid = -1;
		foreach($query as $row){
			$softid = $startid = $row['softid'];
			if(empty($row['channelid'])) continue;
			$data = $fields = $subjects = $messages = $images = array();
			if($first){
				$data['tid'] = $row['softid'];
			}
			$row['softname'] = checkinvalidchars($row['softname'], 90);
			$row['softver'] = checkinvalidchars($row['softver'], 50);
			$row['languages'] = checkinvalidchars($row['languages'], 50);
			$row['softtype'] = checkinvalidchars($row['softtype'], 50);
			$row['runsystem'] = $convert->formatRunSystem(checkinvalidchars($row['runsystem'], 80));
			$row['impower'] = checkinvalidchars($row['impower'], 50);
			$row['homepage'] = checkinvalidchars($row['homepage'], 100);
			$row['contact'] = checkinvalidchars($row['contact'], 100);
			$row['author'] = checkinvalidchars($row['author'], 50);
			$row['username'] = checkinvalidchars($row['username'], 30);
			if(empty($row['description'])){
				$row['description'] = '';
			}else{
				$row['description'] = checkinvalidchars($row['description'], 120);
			}
			if(empty($row['softname'])) continue;
			$subjects['softid'] = $row['softid'];
			$subjects['softname'] = iconv_addslashes($row['softname'], $charset);
			$subjects['softversion'] = iconv_addslashes($row['softver'], $charset);
			if(!empty($row['subtitle'])){
				$subjects['subtitle'] = iconv_addslashes($row['subtitle'], $charset);
			}
			$data['chanid'] = $row['channelid'];
			$data['catid'] = $row['classid'];
			$data['title'] = checkinvalidchars(trim($subjects['softname'] . ' ' . $subjects['softversion']), 100);
			$data['recommend'] = $row['isbest'];
			$data['hits'] = uintval($row['allhits']);
			$data['dateline'] = strtotime($row['softtime']);
			$data['status'] = empty($row['isaccept']) ? 0 : 1;
			$fields['voteup'] = uintval($row['good']);
			$fields['votedown'] = uintval($row['bad']);
			$rates = rate_rand(1);
			$fields['voters'] = intval($rates['voter']);
			$fields['totalscore'] = intval($rates['total']);
			$subjects['summary'] = iconv_addslashes($row['description'], $charset);
			$subjects['softsize'] = intval($row['softsize']);
			$subjects['star'] = intval($row['star']);
			$subjects['softlang'] = iconv_addslashes($row['languages'], $charset);
			$subjects['softtype'] = iconv_addslashes($row['softtype'], $charset);
			$subjects['runsystem'] = iconv_addslashes($row['runsystem'], $charset);
			$subjects['license'] = iconv_addslashes($row['impower'], $charset);
			$subjects['homepage'] = addurlscheme(iconv_addslashes($row['homepage'], $charset));
			$subjects['contact'] = iconv_addslashes($row['contact'], $charset);
			$subjects['author'] = iconv_addslashes($row['author'], $charset);
			$subjects['editor'] = iconv_addslashes($row['username'], $charset);
			$subjects['testsoft'] = "1,3,6,5,8,10";
			$messages['content'] = iconv_addslashes($row['content'], $charset);
			if(!empty($row['softimage'])){
				if(strncasecmp($row['softimage'], 'UploadPic/', 10) === 0){
					$images['attachment'] = substr($row['softimage'], 10);
				}else{
					$images['attachment'] = $row['softimage'];
				}
				$images['remote'] = 0;
				$images['thumb'] = 0;
				$data['image'] = 1;
			}
			if(!empty($row['previewimg'])){
				if(strncasecmp($row['previewimg'], 'UploadPic/', 10) === 0){
					$images['attachimg'] = substr($row['previewimg'], 10);
				}else{
					$images['attachimg'] = $row['previewimg'];
				}
				$images['preview'] = 0;
				$data['image'] = 1;
			}
			if(!empty($row['taglist']) && !empty($db_config['table']['tags'])){
				$taglist = explode('|', $row['taglist']);
				if(isset($taglist[1])){
					$taglist[1] = checkinvalidchars($taglist[1], 28);
					$messages['tags'] = iconv_addslashes($taglist[1], $charset);
				}
			}
			if($thread = $convert->threads('soft', $data, $fields, $subjects, $messages, $images)){
				$threads[] = $thread;
			}
			
		}
		$query->closeCursor();
		if(!empty($threads) && is_array($threads)){
			foreach($threads as $thread){
				$sql = "SELECT * FROM " . MssqlDB::table('downaddress') . " WHERE softid={$thread['softid']}";
				if($address = MssqlDB::query($sql)){
					foreach($address as $down){
						$softdown = array('id' => $down['id']);
						$softdown['tid'] = $thread['tid'];
						$softdown['softid'] = $thread['softid'];
						$softdown['servid'] = getDownServId($down['downid']);
						$down['downtext'] = checkinvalidchars($down['downtext'], 150);
						$softdown['dname'] = iconv_addslashes($down['downtext'], $charset);
						$softdown['downurl'] = iconv_addslashes($down['downfilename'], $charset);
						MysqlDB::insert('soft_download', $softdown);
					}
				}
			}
		}
		
		if($softid == -1) updateDownRootId();
		return $startid;
	}
	return -1;
}

function getDownServId($rootid)
{
	static $serverids = array();
	if($rootid && empty($serverids[$rootid])){
		$sql = "SELECT servid FROM " . MysqlDB::table('downserver') . " WHERE depth='0' AND rootid='$rootid'";
		$serverids[$rootid] = (int)MysqlDB::query($sql)->fetchColumn();
		return $serverids[$rootid];
	}elseif(!empty($serverids[$rootid])){
		return $serverids[$rootid];
	}
	return 0;
}

function updateDownRootId()
{
	$sql = "SELECT servid, depth, parentid FROM " . MysqlDB::table('downserver');
	if($query = MysqlDB::query($sql)){
		foreach ($query as $row){
			if($row['depth'] == 0){
				MysqlDB::update('downserver', array('rootid' => $row['servid']), "servid='{$row['servid']}'");
			}else{
				MysqlDB::update('downserver', array('rootid' => $row['parentid']), "servid='{$row['servid']}'");
			}
		}
	}
}

function convert_member_data($startid) {
	return $startid;
}
?>