﻿/**
 * @fileoverview
 * This file contains a lookup table of css properties, the value of the
 * property contains the initial value ( default value is defined in the browser.css ) 
 * used by Opera if ther is no CSS defined
 * by the author. This is used in the CSS inspector
 * @see stylesheets
 */

css_initial_values =
{
"-apple-dashboard-region": "",
"-o-border-image": "",
"-o-link": "",
"-o-link-source": "",
"-o-object-fit": "auto", // this is 'fill' according to new spec, update when the imlementation changes
"-o-object-position": "50% 50%",
"-o-table-baseline": "",
"-o-text-overflow": "",
"-o-transform": "none",
"-o-transform-origin": "0px 0px",
"-o-transition": "",
"-o-transition-delay": "0",
"-o-transition-duration": "0",
"-o-transition-property": "all",
"-o-transition-timing-function": "ease",
"-wap-accesskey": "",
"-wap-input-format": "",
"-wap-input-required": "",
"-wap-marquee-dir": "",
"-wap-marquee-loop": "",
"-wap-marquee-speed": "",
"-wap-marquee-style": "",
"-xv-interpret-as": "",
"-xv-phonemes": "",
"-xv-voice-balance": "",
"-xv-voice-duration": "",
"-xv-voice-pitch": "",
"-xv-voice-pitch-range": "",
"-xv-voice-rate": "",
"-xv-voice-stress": "",
"-xv-voice-volume": "",
"alignment-baseline": "auto",
"audio-level": "1",
"background": "transparent none repeat scroll 0% 0%",
"background-attachment": "scroll",
"background-clip": "border-box",
"background-color": "transparent",
"background-image": "none",
"background-origin": "padding-box",
"background-position": "0% 0%",
"background-repeat": "repeat",
"background-size": "auto",
"baseline-shift": "baseline",
"border": "0px #000000",
"border-bottom": "0px #000000",
"border-bottom-color": "#000000",
"border-bottom-style": "none",
"border-bottom-width": "0px",
"border-collapse": "separate",
"border-color": "#000000",
"border-left": "0px #000000",
"border-left-color": "#000000",
"border-left-style": "none",
"border-left-width": "0px",
"border-right": "0px #000000",
"border-right-color": "#000000",
"border-right-style": "none",
"border-right-width": "0px",
"border-spacing": "0px",
"border-style": "none",
"border-top": "0px #000000",
"border-top-color": "#000000",
"border-top-style": "none",
"border-top-width": "0px",
"border-width": "0px",
"bottom": "auto",
"box-decoration-break": "slice",
"box-sizing": "content-box",
"box-shadow": "none",
"break-after": "auto",
"break-before": "auto",
"break-inside": "auto",
"caption-side": "top",
"clear": "none",
"clip": "rect(0px, 0px, 0px, 0px)",
"clip-path": "none",
"clip-rule": "nonzero",
"color": "#000000",
"color-interpolation": "sRGB",
"color-interpolation-filters": "linearRGB",
"color-profile": "auto",
"color-rendering": "auto",
"column-count": "auto",
"column-fill": "balance",
"column-gap": "16px",
"column-rule": "0px #000000",
"column-rule-color": "#000000",
"column-rule-style": "none",
"column-rule-width": "0px",
"column-span": "none",
"column-width": "auto",
"columns": "auto",
"content": "none",
"counter-increment": "none",
"counter-reset": "none",
"cue": "",
"cue-after": "none",
"cue-before": "none",
"cursor": "auto",
"direction": "ltr",
"display": "inline",
"display-align": "auto",
"dominant-baseline": "auto",
"empty-cells": "show",
"enable-background": "accumulate",
"fill": "#000000",
"fill-opacity": "1",
"fill-rule": "nonzero",
"filter": "none",
"float": "none",
"flood-color": "#000000",
"flood-opacity": "1",
"font": "shorthand",
"font-family": "",
"font-size": "16px",
"font-size-adjust": "none",
"font-stretch": "normal",
"font-style": "normal",
"font-variant": "normal",
"font-weight": "400",
"glyph-orientation-horizontal": "0",
"glyph-orientation-vertical": "auto",
"height": "0px",
"image-rendering": "auto",
"kerning": "auto",
"left": "auto",
"letter-spacing": "0px",
"lighting-color": "#ffffff",
"line-height": "normal",
"line-increment": "auto",
"list-style": "disc outside none",
"list-style-image": "none",
"list-style-position": "outside",
"list-style-type": "disc",
"margin": "0px",
"margin-bottom": "0px",
"margin-left": "0px",
"margin-right": "0px",
"margin-top": "0px",
"mark": "",
"mark-after": "",
"mark-before": "",
"marker": "none",
"marker-end": "none",
"marker-mid": "none",
"marker-offset": "",
"marker-start": "none",
"marks": "none",
"mask": "none",
"max-height": "-1px",
"max-width": "-1px",
"max-zoom": "auto",
"min-height": "0px",
"min-width": "0px",
"min-zoom": "auto",
"nav-down": "auto",
"nav-index": "auto",
"nav-left": "auto",
"nav-right": "auto",
"nav-up": "auto",
"opacity": "1",
"orphans": "2",
"outline": "3px",
"outline-color": "invert",
"outline-offset": "0",
"outline-style": "none",
"outline-width": "3px",
"overflow": "visible",
"overflow-x": "visible",
"overflow-y": "visible",
"padding": "0px",
"padding-bottom": "0px",
"padding-left": "0px",
"padding-right": "0px",
"padding-top": "0px",
"page": "auto",
"page-break-after": "auto",
"page-break-before": "auto",
"page-break-inside": "auto",
"pause": "",
"pause-after": "",
"pause-before": "",
"pointer-events": "visiblePainted",
"position": "static",
"quotes": "none",
"rest": "",
"rest-after": "",
"rest-before": "",
"right": "auto",
"row-span": "",
"scrollbar-3dlight-color": "",
"scrollbar-arrow-color": "",
"scrollbar-base-color": "",
"scrollbar-darkshadow-color": "",
"scrollbar-face-color": "",
"scrollbar-highlight-color": "",
"scrollbar-shadow-color": "",
"scrollbar-track-color": "",
"shape-rendering": "auto",
"size": "portrait",
"solid-color": "#000000",
"solid-opacity": "1",
"speak": "",
"stop-color": "#000000",
"stop-opacity": "1",
"stroke": "none",
"stroke-dasharray": "none",
"stroke-dashoffset": "0",
"stroke-linecap": "butt",
"stroke-linejoin": "miter",
"stroke-miterlimit": "4",
"stroke-opacity": "1",
"stroke-width": "1",
"table-layout": "auto",
"text-align": "left",
"text-anchor": "start",
"text-decoration": "none",
"text-indent": "0px",
"text-overflow": "clip",
"text-rendering": "auto",
"text-shadow": "none",
"text-transform": "none",
"top": "auto",
"unicode-bidi": "normal",
"user-zoom": "zoom",
"vector-effect": "none",
"vertical-align": "baseline",
"viewport-fill": "none",
"viewport-fill-opacity": "1",
"visibility": "visible",
"voice-family": "",
"white-space": "normal",
"widows": "2",
"width": "0px",
"word-spacing": "0px",
"word-wrap": "normal",
"writing-mode": "lr-tb",
"zoom": "auto",
"z-index": "auto"
};
