<?php
/**
 * Copyright (c) 2010-2012 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : ThreadList.php  2012-8-6
 */
!defined('IN_PHPCOM') && exit('Access denied');

class Article_ThreadList extends Controller_ThreadList
{
	public function loadActionIndex()
	{
		$datalist = $tableIndexs = array();
		$tplname = 'article/category';
		$category = $this->threadCategory();
		$chanid = $this->chanid;
		$pageurl = $category['pageurl'];
		$firsturl = $category['firsturl'];
		$caturl = $category['caturl'];
		$catname = $category['catname'];
		$catdir = $category['codename'];
		$prefixurl = $category['prefixurl'];
		$imageurl = $category['imageurl'];
		$banner = $category['banner'];
		$name = $category['subname'];
		$rootid = $this->rootid;
		$catid = $this->catid;
		$classid = 0;
		if ($category['basic']) {
			$datalist = $this->getFirstCategory($category['rootid']);
		}else{
			$condition = "t.status='1' AND t.chanid='$chanid'";
			if ($catid) {
				if ($category['depth'] == 0) {
					$condition .= " AND t.rootid='$rootid'";
				} else {
					$condition .= " AND t.catid='$catid'";
				}
			}
			
			$count = $category['counts'];
			$pagenum = intval(phpcom::$G['channel'][$chanid]['pagenum']);
			$pageinput = phpcom::$G['channel'][$chanid]['pageinput'];
			$pagestats = phpcom::$G['channel'][$chanid]['pagestats'];
			$pagesize = $category['pagesize'];
			$pagecount = @ceil($count / $pagesize);
			$pagenow = max(1, min($pagecount, intval($this->page)));
			$pagestart = floor(($pagenow - 1) * $pagesize);
			$sql = DB::buildlimit("SELECT t.*,a.*,c.depth,c.basic,c.catname,c.subname,c.codename,c.prefixurl,c.prefix,c.caturl,c.color,
				ti.attachment,ti.remote,ti.thumb,ti.preview,ti.attachimg
				FROM " . DB::table('threads') . " t
		 		LEFT JOIN " . DB::table('article_thread') . " a USING(tid)
         		LEFT JOIN " . DB::table('category') . " c ON c.catid=t.catid
				LEFT JOIN " . DB::table('thread_image') . " ti USING(tid)
				WHERE $condition ORDER BY t.istop DESC,t.dateline DESC", $pagesize, $pagestart);
			$query = DB::query($sql);
			$i = 0;
			while ($row = DB::fetch_array($query)) {
				$i++;
				$row['index'] = $i;
				$row['alt'] = $i % 2 == 0 ? 2 : 1;
				$this->processThreadListData($row);

				$tableIndexs[$row['tableindex']] = $row['tableindex'];
				
				$datalist[] = $row;
			}
			$showpage = $this->paging($pagenow, $pagecount, $pagesize, $count, $pageurl, $pagenum, $pagestats, $pageinput, $firsturl);
			$tplname = 'article/threadlist';
		}
		if ($this->templateName) {
			$tplname = checktplname($tplname, $this->templateName);
		} else {
			$tplname = checktplname($tplname, $this->chanid);
		}
		include template($tplname);
		return 1;
	}
}
?>