<?php
/**
 * Copyright (c) 2010-2012 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : Comment.php  2012-8-29
 */
!defined('IN_PHPCOM') && exit('Access denied');

class Special_Comment extends Controller_SpecialAbstract
{
	protected $topicid = 0, $cmntmaxlen = 0, $iscaptcha = 0;
	protected $topical = array();
	protected $permission = false;
	protected $paramextra = array('type' => 'alert', 'showdialog' => true, 'location' => false);

	public function loadActionIndex()
	{
		$this->cmntmaxlen = intval(phpcom::$G['group']['commentlen']);
		$this->iscaptcha = isset(phpcom::$setting['captchastatus'][4]) ? intval(phpcom::$setting['captchastatus'][4]) : 0;
		$operation = strtolower(trim($this->request->getPost('operation', $this->request->getPost('do'))));
		$this->gorupid = phpcom::$G['group']['groupid'];
		$this->permission = (phpcom::$G['group']['delcomment'] && phpcom::$G['group']['type'] == 'system');
		$topicid = intval($this->request->getPost('topicid', $this->request->getQuery(0)));
		if (!$this->topical = DB::fetch_first("SELECT t.*, s.name,s.depth,s.subject,s.domain as domains FROM " . DB::table('topical') . " t LEFT JOIN " . DB::table('special') . " s USING(specid) WHERE t.topicid='$topicid'")) {
			showmessage('undefined_action', NULL, NULL, $this->paramextra);
		}
		$this->topicid = $this->topical['topicid'];
		if($this->topical['domain'] || $this->topical['domains']){
			define('DOMAIN_ENABLED', true);
		}
		$this->initialize();
		$this->topical['domain'] = $this->topical['domain'] ? $this->topical['domain'] : $this->topical['domains'];
		$this->topical['domain'] = $this->topical['domain'] ? $this->topical['domain'] . '/' : $this->domain;
		$this->keyword = strip_tags($this->topical['keyword'] ? $this->topical['keyword'] : $this->keyword);
		$this->description = strip_tags($this->topical['description'] ? $this->topical['description'] : $this->description);
		$this->title = lang('common', 'comment') .':'. strip_tags($this->topical['title']);

		if ($this->request->isPost() && $operation == 'post') {
			return $this->postComments();
		}elseif($this->request->isGet() && $operation == 'del'){
			return $this->deleteComments();
		}elseif($this->request->isGet() && in_array($operation, array('voteup', 'votedown'))){
			return $this->voteComments($operation);
		}elseif($operation == 'reply'){
			return $this->replyComments();
		}else{
			return $this->loadCommentsResult();
		}
	}

	protected function loadCommentsResult()
	{
		$this->page = intval($this->request->query('page', $this->request->getQuery('page')));
		$formtoken = formtoken();
		$domain = $this->domain;
		$gorupid = $this->groupid;
		$topicid = $this->topical['topicid'];
		$specid = $this->topical['specid'];
		$commentnum = $this->topical['comments'];
		$depth = isset($this->topical['depth']) ? $this->topical['depth'] : 0;
		$iscaptcha = $this->iscaptcha;
		$title = $this->topical['title'];
		$domain = $this->topical['domain'];
		$urlargs = array('name' => $this->topical['codename'], 'tid' => $topicid, 'sid' => $specid, 'special' => $this->topical['name'], 'page' => 1);
		$this->topical['url'] = geturl('topic', $urlargs, $this->topical['domain'], 'special');
		$urlargs['name'] = $this->topical['name'];
		$this->topical['surl'] = geturl('index', $urlargs, $this->topical['domain'], 'special');
		$showpage = $pageurl = '';
		$replycount = 0;
		$datalist = $replydata = $commentids = array();
		$type = $this->request->query('t');
		$condition = $type ? 'commentid ASC' : 'lastdate DESC';
		$table = DB::table('topic_comment');
		$count = DB::result_first("SELECT COUNT(*) FROM $table WHERE first='1' AND tid='$topicid' AND status='1'");
		$pagesize = 20;
		$pagecount = @ceil($count / $pagesize);
		$pagenow = max(1, min($pagecount, intval($this->page)));
		$pagestart = floor(($pagenow - 1) * $pagesize);
		$urlargs['tid'] = $topicid;
		$urlargs['page'] = '{%d}';
		$pageurl = geturl('comment', $urlargs, $this->topical['domain'], 'special');

		$sql = DB::buildlimit("SELECT * FROM " . DB::table('topic_comment') . "
				WHERE first='1' AND tid='$topicid' AND status='1' ORDER BY $condition", $pagesize, $pagestart);
		$query = DB::query($sql);
		$i = 0;
		while ($row = DB::fetch_array($query)) {
			$i++;
			$row['index'] = $i;
			$row['alt'] = $i % 2;
			$row['content'] = bbcode::output($row['content']);
			$row['date'] = fmdate($row['lastdate']);
			$row['datetime'] = fmdate($row['dateline']);
			$row['lastauthor'] = $row['lastauthor'] == 'guest' ? lang('common', 'guest') : $row['lastauthor'];
			$row['username'] = $row['lastauthor'];
			$row['author'] = $row['author'] == 'guest' ? lang('common', 'guest') : $row['author'];
			$datalist[$row['commentid']] = $row;
			$commentids[] = $row['commentid'];
		}
		if($replyids = implodeids($commentids)){
			$sql = "SELECT * FROM " . DB::table('topic_comment') . "
			WHERE first='0' AND status='1' AND fid IN($replyids)";
			$query = DB::query($sql);
			while ($row = DB::fetch_array($query)) {
				$row['content'] = bbcode::output($row['content']);
				$row['date'] = fmdate($row['dateline']);
				if ($row['author'] == 'guest') {
					$row['author'] = lang('common', 'guest');
				}
				$row['index'] = $replycount;
				$replydata[$row['fid']][$row['commentid']] = $row;
				++$replycount;
			}
		}
		$firsturl = $this->formatPageUrl($pageurl);
		$showpage = $this->paging($pagenow, $pagecount, $pagesize, $count, $pageurl, 7, 0, 0, $firsturl);

		$currenturl =  $pagenow > 1 ? str_replace('{%d}', $pagenow, $pageurl) : str_replace('{%d}', 1, $firsturl);
		$this->checkRequestUri($currenturl);
		$tplname = checktplname('special/comment',  $this->topical['codename']);
		include template($tplname);
		return 1;
	}

	protected function deleteComments()
	{
		if(!$this->permission){
			showmessage('comment_permission_delete_denied', NULL, NULL, $this->paramextra);
		}
		$commentid = intval($this->request->query('commentid', $this->request->query('cid')));
		$this->deleteTopicComment($commentid);
		$backurl = $this->getReferer();
		$this->paramextra['type'] = 'succeed';
		showmessage('comment_delete_succeed', $backurl, NULL, $this->paramextra);
		return 0;
	}

	protected function deleteTopicComment($commentid)
	{
		if ($result = DB::fetch_first("SELECT commentid,tid,fid,first FROM " . DB::table('topic_comment') . " WHERE commentid='$commentid'")) {
			$commentid = $result['commentid'];
			$tid = $result['tid'];
			$fid = $result['fid'];
			if($result['first']){
				$deleteids = array();
				$query = DB::query("SELECT commentid FROM " . DB::table('topic_comment') . " WHERE first>='0' AND status>='0' AND fid='$commentid'");
				while ($row = DB::fetch_array($query)) {
					$deleteids[] = $row['commentid'];
				}
				foreach ($deleteids as $cid) {
					DB::delete('topic_comment', "commentid='$cid'");
					DB::query("UPDATE " . DB::table('topical') . " SET comments=comments-1 WHERE topicid='$tid'");
				}
			}else{
				DB::delete('topic_comment', "commentid='$commentid'");
				DB::query("UPDATE " . DB::table('topic_comment') . " SET num=num-1 WHERE commentid='$fid'");
				DB::query("UPDATE " . DB::table('topical') . " SET comments=comments-1 WHERE topicid='$tid'");
			}
		}
		return 0;
	}

	protected function voteComments($action = 'voteup')
	{
		$commentid = intval($this->request->query('commentid', $this->request->query('cid')));
		$key = $action == 'votedown' ? 'votedown' : 'voteup';
		$votekey = 'topic_comment_'.$key.'_'. $commentid;
		if (isset(phpcom::$G['cookie'][$votekey]) && phpcom::$G['cookie'][$votekey]) {
			showmessage('comment_have_to_vote', NULL, NULL, $this->paramextra);
		} else {
			phpcom::setcookie($votekey, encryptstring(TIMESTAMP), 86400);
		}

		if ($vote = DB::fetch_first("SELECT commentid, voteup, votedown FROM " . DB::table('topic_comment') . " WHERE commentid='$commentid'")) {
			DB::query("UPDATE " . DB::table('topic_comment') . " SET $key=$key+1 WHERE commentid='$commentid'");
			$this->loadAjaxHeader();
			echo $vote[$key] + 1;
			$this->loadAjaxFooter();
		} else {
			showmessage('undefined_action', NULL, NULL, $this->paramextra);
		}
		return 0;
	}

	protected function replyComments()
	{
		$type = strtolower(trim($this->request->getPost('type')));
		$iscaptcha = $this->iscaptcha;
		$domain = $this->topical['domain'];
		$topicid = $this->topicid;
		$commentid = intval($this->request->query('commentid', $this->request->query('cid')));
		$uid = phpcom::$G['uid'];
		$key = $topicid . '_' . $commentid;
		$this->loadAjaxHeader();
		include template('special/reply');
		$this->loadAjaxFooter();
		return 0;
	}

	protected function postComments()
	{
		$topicid = $this->topicid;
		$uid = phpcom::$G['uid'];
		if (!phpcom::$G['group']['comment'] || $this->topical['bancomment']) {
			showmessage('comment_permission_denied', NULL, NULL, $this->paramextra);
		}

		$lifetime = TIMESTAMP - 10;
		if ($dateline = DB::result_first("SELECT dateline FROM " . DB::table('topic_comment') . " WHERE first>='0' AND uid='$uid' AND dateline>'$lifetime' LIMIT 1")) {
			showmessage('comment_post_lifetime_denied', NULL, NULL, $this->paramextra);
		}
		if (checksubmit(array('postsubmit', 'btnsubmit', 'submit'), 1, $this->iscaptcha)) {
			$commentid = intval($this->request->getPost('commentid', $this->request->getPost('cid')));
			$content = $this->request->post('content');
			if (strlength($content) > $this->cmntmaxlen) {
				showmessage('comment_string_length_limit', NULL, NULL, $this->paramextra);
			}
			if (empty($content)) {
				showmessage('comment_post_undefined', NULL, NULL, $this->paramextra);
			}
			$backurl = $this->getReferer();
			$username = stripstring($this->request->post('username'));
			$author = phpcom::$G['username'] ? phpcom::$G['username'] : $username;
			$author = empty($author) ? 'guest' : $author;
			$author = strcut($author, 28, '');
			$content = checkinput($content);
			$status = phpcom::$G['group']['commentnoaudit'] ? 1 : 0;
			$data = array(
					'tid' => $topicid,
					'uid' => phpcom::$G['uid'],
					'author' => $author,
					'content' => $content,
					'dateline' => TIMESTAMP,
					'lastdate' => TIMESTAMP,
					'userip' => phpcom::$G['clientip'],
					'status' => $status
			);
			if ($row = DB::fetch_first("SELECT commentid,num FROM " . DB::table('topic_comment') . " WHERE first='1' AND tid='$topicid' AND status='1' AND commentid='$commentid'")) {
				$data['fid'] = $commentid;
				$data['first'] = 0;
				if ($row['num'] > 50) {
					showmessage('comment_reply_limit', NULL, NULL, $this->paramextra);
				}
				DB::insert('topic_comment', $data);
				$updata = array();
				$updata['num'] = $row['num'] + 1;
				$updata['lastdate'] = TIMESTAMP;
				$updata['lastauthor'] = $author;
				DB::update('topic_comment', $updata, "commentid='$commentid'");
			}else{
				$data['first'] = 1;
				$data['fid'] = 0;
				$data['lastauthor'] = $author;
				$commentid = DB::insert('topic_comment', $data, TRUE);
				DB::update('topic_comment', array('fid' => $commentid), "commentid='$commentid'");
			}
			DB::query("UPDATE " . DB::table('topical') . " SET comments=comments+1 WHERE topicid='$topicid'");
			if (phpcom::$G['uid']) {
				update_creditbyaction('comment', phpcom::$G['uid']);
			}
			$this->paramextra['type'] = 'succeed';
			showmessage('comment_post_succeed', $backurl, NULL, $this->paramextra);
		}
		return 0;
	}
}
?>