<?php
/**
 * Copyright (c) 2010-2012 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : ThreadList.php  2012-8-30
 */
!defined('IN_PHPCOM') && exit('Access denied');

class Special_ThreadList extends Controller_SpecialAbstract
{
	protected $topicid = 0;
	protected $topical = array();
	protected $paramextra = array('type' => 'alert', 'showdialog' => true, 'location' => false);
	
	public function loadActionIndex()
	{
		$topicid = intval($this->request->query('topicid', $this->request->getQuery(0)));
		$condition = "t.topicid='$topicid'";
		if($topicid < 1){
			$name = stripstring($this->request->query('name', $this->request->getQuery(0)));
			$condition = "t.codename='$name'";
			if(empty($name)){
				showmessage('undefined_action', NULL, NULL, $this->paramextra);
			}
		}
		if (!$topical = DB::fetch_first("SELECT t.*, s.name,s.depth,s.subject as subjects,s.domain as domains
				FROM " . DB::table('topical') . " t
				LEFT JOIN " . DB::table('special') . " s USING(specid) WHERE $condition LIMIT 1")) {
					showmessage('undefined_action', NULL, NULL, $this->paramextra);
		}
		
		$this->topicid = $topicid = $topical['topicid'];
		if($topical['domain'] || $topical['domains']){
			!defined('DOMAIN_ENABLED') && define('DOMAIN_ENABLED', true);
		}
		$this->initialize();
		$topical['domain'] = $topical['domain'] ? $topical['domain'] : $topical['domains'];
		$topical['domain'] = $topical['domain'] ? $topical['domain'] . '/' : $this->domain;
		$this->keyword = strip_tags($topical['keyword'] ? $topical['keyword'] : $this->keyword);
		$this->description = strip_tags($topical['description'] ? $topical['description'] : $this->description);
		$this->title = strip_tags($topical['title']);
		$commentnum = $topical['comments'];
		$commenturl = geturl('comment', array('tid' => $topicid, 'page' => 1), $topical['domain'], 'special');
		$listurl = $url = geturl('topic', array('tid' => $topicid, 'sid' => $topical['specid'], 'name' => $topical['codename'],
				'special' => $topical['name'], 'page' => 1), $topical['domain'], 'special');
		$bancomment = $topical['bancomment'];
		$this->topical = &$topical;
		$datalist = array();
		$urlargs = array('page' => 1);
		$chanid = $this->request->getQuery(2) ? $this->request->getQuery(1) : 0;
		$this->chanid = $chanid = intval($this->request->query('chanid', $chanid));
		$this->page = intval($this->request->query('page', $this->request->getQuery('page')));
		
		$condition = $chanid ? " AND t.chanid='$chanid'" : " AND t.chanid>='0'";
		$count = DB::result_first("SELECT COUNT(*) FROM " . DB::table('threads') . " t
				INNER JOIN " . DB::table('topic_data') . " td ON td.tid=t.tid WHERE t.status='1' $condition AND td.topicid='$topicid'");
		$pagesize = 30;
		$pagecount = @ceil($count / $pagesize);
		$pagenow = max(1, min($pagecount, intval($this->page)));
		$pagestart = floor(($pagenow - 1) * $pagesize);
		$sql = DB::buildlimit("SELECT t.*,c.depth,c.basic,c.catname,c.subname,c.codename,c.prefixurl,c.prefix,c.caturl,c.target,c.color,
				ti.attachment,ti.remote,ti.thumb,ti.preview,ti.attachimg,d.topicid
			FROM " . DB::table('threads') . " t
			LEFT JOIN " . DB::table('category') . " c ON c.catid=t.catid
			LEFT JOIN " . DB::table('thread_image') . " ti USING(tid)
			INNER JOIN " . DB::table('topic_data') . " d ON t.tid=d.tid
			WHERE t.status='1' $condition AND d.topicid='$topicid' ORDER BY d.dateline DESC", $pagesize, $pagestart);
		$query = DB::query($sql);
		$i = 0;
		while ($row = DB::fetch_array($query)) {
			$i++;
			$row['highlight'] = $this->threadHighlight($row['highlight']);
			$urlargs['chanid'] = $row['chanid'];
			$urlargs['tid'] = $row['tid'];
			$urlargs['catdir'] = $row['codename'];
			$urlargs['catid'] = $row['catid'];
			$urlargs['prefix'] = empty($row['prefix']) ? '' : trim($row['prefix']);
			$row['index'] = $i;
			$row['alt'] = $i % 2 == 0 ? 2 : 1;
			
			if (empty(phpcom::$G['channel'][$row['chanid']]['domain']) && empty($row['prefixurl'])) {
				$row['domain'] = $this->domain;
			} elseif(empty($row['prefixurl'])) {
				$row['domain'] = phpcom::$G['channel'][$row['chanid']]['domain'] . '/';
			}else{
				$row['domain'] = $row['prefixurl'] . '/';
			}
			
			if (empty($row['url'])) {
				$urlargs['name'] = empty($row['htmlname']) ? '' : trim($row['htmlname']);
				$row['url'] = geturl('threadview',$urlargs, $row['domain']);
			}
			if (empty($row['caturl'])) {
				$urlargs['name'] = $row['codename'];
				$row['curl'] = geturl($row['basic'] ? 'category' : 'threadlist',$urlargs, $row['domain']);
			}else{
				$row['curl'] = $row['caturl'];
			}
			$row['topic'] = "<a href=\"{$row['url']}\"{$row['highlight']}>{$row['title']}</a>";
			$row['istoday'] = $row['dateline'] + $this->timeoffset >= $this->todaytime ? 1 : 0;
			if ($row['istoday']) {
				$row['datestyle'] = 'new';
				$row['date'] = '<em class="new">'. fmdate($row['dateline']) . '</em>';
			} else {
				$row['datestyle'] = 'old';
				$row['date'] = '<em class="old">'. fmdate($row['dateline']) . '</em>';
			}
			$row['purl'] = $row['url'];
			if(isset($row['attachment']) && $row['image'] == 1){
				$this->processImageRowData($row, phpcom::$G['channel'][$row['chanid']]['modules']);
			}else{
				$row['thumburl'] = $row['previewurl'] = $row['imageurl'] = $this->domain . 'misc/images/noimage.jpg';
				$row['pixurl'] = $row['url'];
			}
			if(isset($row['attached']) && $row['attached'] == 2){
				$row['pixurl'] = geturl('preview', array(
						'chanid' => $row['chanid'],
						'catdir' => $row['codename'],
						'tid' => $row['tid'],
						'page' => 1
				), $this->domain);
			}
			$datalist[] = $row;
		}
		$urlargs = array('cid' => $chanid, 'tid' => $topicid, 'sid' => $topical['specid'],
				'name' => $topical['codename'], 'special' => $topical['name'], 'page' => '{%d}');
		$pageurl = geturl('list', $urlargs, $topical['domain'], 'special');
		$firsturl = $this->formatPageUrl($pageurl);
		$showpage = $this->paging($pagenow, $pagecount, $pagesize, $count, $pageurl, 7, 0, 0, $firsturl);

		$currenturl =  $pagenow > 1 ? str_replace('{%d}', $pagenow, $pageurl) : str_replace('{%d}', 1, $firsturl);
		$this->checkRequestUri($currenturl);
		$tplname = 'special/list';
		if(!empty($topical['tplname'])){
			$tplname = checktplname($tplname,  'special/' . $topical['tplname'] . '_list');
		}
		include template($tplname);
		return 1;
	}
	
	protected function getTopicListUrl($chanid = 0)
	{
		return geturl('list', array('cid' => $chanid,'tid' => $this->topicid, 'name' => $this->topical['codename'], 'page' => 1), $this->topical['domain'], 'special');
	}
}
?>