<?php
/**
 * Copyright (c) 2010-2012 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : Topic.php  2012-8-30
 */
!defined('IN_PHPCOM') && exit('Access denied');

class Special_Topic extends Controller_SpecialAbstract
{
	protected $topicid = 0;
	protected $topical = array();
	protected $paramextra = array('type' => 'alert', 'showdialog' => true, 'location' => false);
	
	public function loadActionIndex()
	{
		$topicid = intval($this->request->query('topicid', $this->request->getQuery(0)));
		$condition = "t.topicid='$topicid'";
		if($topicid < 1){
			$name = stripstring($this->request->query('name', $this->request->getQuery(0)));
			$condition = "t.codename='$name'";
			if(empty($name)){
				showmessage('undefined_action', NULL, NULL, $this->paramextra);
			}
		}
		if (!$topical = DB::fetch_first("SELECT t.*, s.name,s.depth,s.subject as subjects,s.domain as domains
				FROM " . DB::table('topical') . " t
				LEFT JOIN " . DB::table('special') . " s USING(specid) WHERE $condition LIMIT 1")) {
			showmessage('undefined_action', NULL, NULL, $this->paramextra);
		}
		$this->topicid = $topicid = $topical['topicid'];
		if($topical['domain'] || $topical['domains']){
			!defined('DOMAIN_ENABLED') && define('DOMAIN_ENABLED', true);
		}
		$this->initialize();
		$topical['domain'] = $topical['domain'] ? $topical['domain'] : $topical['domains'];
		$topical['domain'] = $topical['domain'] ? $topical['domain'] . '/' : $this->domain;
		$this->keyword = strip_tags($topical['keyword'] ? $topical['keyword'] : $this->keyword);
		$this->description = strip_tags($topical['description'] ? $topical['description'] : $this->description);
		$this->title = empty($topical['subject']) ? strip_tags($topical['title']) : $topical['subject'];
		$commentnum = $topical['comments'];
		$commenturl = geturl('comment', array('tid' => $topicid, 'page' => 1), $topical['domain'], 'special');
		$listurl = geturl('list', array('cid' => 0,'tid' => $topicid, 'sid' => $topical['specid'],
				'name' => $topical['codename'], 'special' => $topical['name'], 'page' => 1), $topical['domain'], 'special');
		$this->htmlFile = geturl('topic', array('tid' => $topicid, 'sid' => $topical['specid'],
				'name' => $topical['codename'], 'special' => $topical['name'], 'page' => 1), '', 'special');
		$currenturl = $topical['domain'] . $this->htmlFile;
		$this->checkRequestUri($currenturl);
		$bancomment = $topical['bancomment'];
		$this->topical = &$topical;
		$tplname = 'special/topic';
		if(!empty($topical['tplname'])){
			$tplname = checktplname($tplname, 'special/' . $topical['tplname']);
		}
		include template($tplname);
		return 1;
	}
	
	protected function getTopicListUrl($chanid = 0)
	{
		return geturl('list', array('cid' => $chanid,'tid' => $this->topicid, 'name' => $this->topical['codename'], 'page' => 1), $this->topical['domain'], 'special');
	}
	
	protected function topicComments($topicid, $type = 0, $limit = 10, &$commentids = array()) {
		$condition = $type;
		if (empty($type)) {
			$condition = 'ORDER BY lastdate DESC';
		} elseif ($type == 1) {
			$condition = 'ORDER BY commentid ASC';
		}
		$data = array();
		$sql = DB::buildlimit("SELECT * FROM " . DB::table('topic_comment') . "
				WHERE first='1' AND tid='$topicid' AND status='1' $condition", $limit, 0);
		$query = DB::query($sql);
		$i = 0;
		while ($row = DB::fetch_array($query)) {
			$i++;
			$row['index'] = $i;
			$row['alt'] = $i % 2;
			$row['content'] = bbcode::output($row['content']);
			$row['date'] = fmdate($row['lastdate']);
			$row['datetime'] = fmdate($row['dateline']);
			$row['username'] = $row['lastauthor'] == 'guest' ? lang('common', 'guest') : $row['lastauthor'];
			if ($row['author'] == 'guest') {
				$row['author'] = lang('common', 'guest');
			}
			$row['id'] = $row['commentid'];
			$data[$row['commentid']] = $row;
			$commentids[] = $row['commentid'];
		}
		return $data;
	}
	
	protected function replyComments($cids) {
		$data = array();
		if($replyids = implodeids($cids)){
			$sql = "SELECT * FROM " . DB::table('topic_comment') . "
			WHERE first='0' AND status='1' AND fid IN($replyids) ORDER BY commentid ASC";
			$query = DB::query($sql);
			while ($row = DB::fetch_array($query)) {
				$row['content'] = bbcode::output($row['content']);
				$row['date'] = fmdate($row['dateline']);
				if ($row['author'] == 'guest') {
					$row['author'] = lang('common', 'guest');
				}
				$row['id'] = $row['commentid'];
				$data[$row['fid']][$row['commentid']] = $row;
			}
		}
		return $data;
	}
}
?>