<?php

/**
 * Copyright (c) 2010-2011  phpcom.cn - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of phpcom.cn.
 * This File   : category.php    2011-5-31 17:44:51
 */
if(!defined('IN_PHPCOM') || !defined('IN_ADMINCP')) {
	exit('Access Denied');
}
phpcom::$G['lang']['admin'] = 'misc';
$chanid = isset(phpcom::$G['gp_chanid']) ? intval(phpcom::$G['gp_chanid']) : $chanid;
phpcom::$G['channelid'] = $chanid;
phpcom::$G['cache']['channel'] = &phpcom::$G['channel'][$chanid];
$module = 'article';
$subname = '';
if(isset(phpcom::$G['cache']['channel']['modules'])){
	$module = phpcom::$G['cache']['channel']['modules'];
	$subname = phpcom::$G['cache']['channel']['subname'];
}
admin_header('menu_category', in_array($action, array('edit', 'edit', 'addsub')) ? "menu_category_$action" : '');
$navarray = array(
		array('title' => 'menu_category', 'url' => "?m=category&chanid=$chanid", 'name' => 'first'),
		array('title' => 'menu_category_add', 'url' => "?m=category&action=add&chanid=$chanid", 'name' => 'add'),
		array('title' => 'menu_content_admin', 'url' => "?m=$module&chanid=$chanid", 'name' => 'content'),
		array('title' => 'menu_thread_class', 'url' => "?m=category&action=class&chanid=$chanid&more=1", 'name' => 'class')
);

$adminhtml = phpcom_adminhtml::instance();
$adminhtml->vars = array('name' => $subname, 'chanid' => $chanid, 'module' => $module);
if($action != 'select'){
	$adminhtml->activetabs('topic');
	$adminhtml->navtabs($navarray, stricmp($action, array('first', 'add', 'class'), true, 'first'));
}

if($chanid) phpcom_cache::load("thread_class");

if ($action == 'addsub') {
	$catid = isset(phpcom::$G['gp_catid']) ? intval(phpcom::$G['gp_catid']) : 0;
	if (!checksubmit(array('submit', 'btnsubmit'))) {
		$adminhtml->table_header('category_addsub', 6);
		$adminhtml->table_td(array(
				array('category_comments', FALSE, ' colspan="6"')
		), NULL, FALSE, NULL, NULL, FALSE);
		$adminhtml->table_end();
		$adminhtml->count = 0;
		$adminhtml->form("m=category&action=addsub&catid=$catid&chanid=$chanid");
		$adminhtml->table_header();
		$adminhtml->table_th(array(
				array('category_order', 'width="5%" align="center" noWrap="noWrap"'),
				array('category_name', 'width="18" class="left"'),
				array('category_subname', 'width="15%" class="left"'),
				array('category_codename', 'width="15%" class="left"'),
				array('category_description', 'width="30%" class="left"'),
				array('category_keyword', 'width="17%" class="left"')
		));
		$newcatid = makenewcatid() - 1;
		$sortord = (int)DB::result_first("SELECT MAX(sortord) FROM " . DB::table('category') . " WHERE chanid='$chanid' AND parentid='$catid'");
		for ($i = 1; $i < 11; $i++) {
			$codename = $newcatid + $i;
			$adminhtml->table_td(array(
					array('<input class="input sortord" size="1" name="categorys['. $i .'][sortord]" type="text" value="' . ($sortord + $i) . '" />', TRUE, 'align="center"'),
					array('<input class="input" size="20" name="categorys['. $i .'][catname]" type="text" />', TRUE),
					array('<input class="input" size="15" name="categorys['. $i .'][subname]" type="text" />', TRUE),
					array('<input class="input" size="15" name="categorys['. $i .'][codename]" type="text" value="sort' . sprintf('%03d', $codename) . '" />', TRUE),
					array('<input class="input" size="35" name="categorys['. $i .'][description]" type="text" />', TRUE),
					array('<input class="input" size="20" name="categorys['. $i .'][keyword]" type="text" />', TRUE)
			));
		}
		$btnsubmit = $adminhtml->submit_button();
		$adminhtml->table_td(array(
				array($btnsubmit, TRUE, 'align="center" colspan="6"')
		), NULL, FALSE, NULL, NULL, FALSE);
		$adminhtml->table_end('</form>');
	}else{
		$categorys = striptags(phpcom::$G['gp_categorys']);
		$depth = $parentid = $rootid = $addcomplete = 0;
		$chanid = $chanid;
		if($cat = DB::fetch_first("SELECT catid, chanid, depth, rootid FROM " . DB::table('category') . " WHERE catid='$catid'")){
			$depth = $cat['depth'] + 1;
			$parentid = $cat['catid'];
			$rootid = $cat['rootid'];
			$chanid = $cat['chanid'];
		}else{
			admin_message('category_add_failed');
		}
		if ($depth > 3)  admin_message('category_depth');
		$newcatid = makenewcatid();
		foreach ($categorys as $data) {
			if(!empty($data['catname']) && !empty($data['codename'])){
				$data['catid'] = $newcatid++;
				$data['chanid'] = $chanid;
				$data['parentid'] = $parentid;
				$data['depth'] = $depth;
				$data['rootid'] = $rootid;
				$data['child'] = $data['target'] = 0;
				$data['setting'] = '';
				if(empty($data['subname'])) $data['subname'] = $data['catname'];
				DB::insert('category', $data);
				$addcomplete = 1;
			}
		}
		if($addcomplete && $catid){
			$child = intval(DB::result_first("SELECT COUNT(*) FROM " . DB::table('category') . " WHERE parentid='$catid'"));
			DB::update('category', array('child' => $child), "catid='$catid'");
		}
		update_categorys_cache($chanid);
		@header("Location: " . ADMIN_SCRIPT . "?m=category&chanid=$chanid");
	}
}elseif ($action == 'class') {
	if (!checksubmit(array('submit', 'btnsubmit'))) {
		echo <<<EOT
<script type="text/javascript">
var rowtypedata = ['&nbsp;',
'<input name="threadclassnew[ordinal][]" type="text" class="input sortord" value="0"/>',
'<input name="threadclassnew[name][]" type="text" class="input t15"/>',
'<input name="threadclassnew[alias][]" type="text" class="input t15"/>',
'<input name="threadclassnew[about][]" type="text" class="input t30"/>',
'<input name="threadclassnew[icon][]" type="text" class="input t30"/>'];
</script>
EOT;
		$adminhtml->form("m=category&action=class&chanid=$chanid");
		$adminhtml->table_header('thread_class');
		$adminhtml->table_td(array(
				array('deletecheckbox', FALSE, 'width="5%" noWrap="noWrap"'),
				array('thread_class_ordinal', FALSE, 'width="5%"'),
				array('thread_class_name', FALSE, 'width="15%"'),
				array('thread_class_alias', FALSE, 'width="15%"'),
				array('thread_class_about', FALSE, 'width="30%"'),
				array('thread_class_icon', FALSE, 'width="30%"')
		), '', FALSE, ' tablerow', NULL, FALSE);
		$sql = "SELECT * FROM " . DB::table('thread_class') . " WHERE chanid='$chanid' AND catid='0' ORDER BY ordinal, classid";
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$classid = $row['classid'];
			$adminhtml->table_td(array(
					array('<input type="checkbox" class="checkbox" name="delete[' . $classid . ']" value="' . $classid . '" />', TRUE),
					array('<input name="threadclass[' . $classid . '][ordinal]" title="classid: '.$classid.'" type="text" class="input sortord" value="'.$row['ordinal'].'" />', TRUE),
					array('<input name="threadclass[' . $classid . '][name]" title="classid: '.$classid.'" type="text" class="input t15" value="'.htmlcharsencode($row['name']).'" />', TRUE),
					array('<input name="threadclass[' . $classid . '][alias]" type="text" class="input t15" value="'.htmlcharsencode($row['alias']).'" />', TRUE),
					array('<input name="threadclass[' . $classid . '][about]" type="text" class="input t30" value="'.htmlcharsencode($row['about']).'" />', TRUE),
					array('<input name="threadclass[' . $classid . '][icon]" type="text" class="input t30" value="'.htmlcharsencode($row['icon']).'" />', TRUE)
			));
		}
		$adminhtml->table_td(array(
				array('thread_class_add', FALSE, 'colspan="6"')
		));
		$btnsubmit = $adminhtml->submit_button();
		$adminhtml->table_td(array(
				array($btnsubmit, TRUE, 'align="center" colspan="6"')
		), NULL, FALSE, NULL, NULL, FALSE);
		$adminhtml->table_end('</form>');
	}else{
		add_update_threadclass(0, $chanid);
		admin_succeed('thread_class_succeed', "m=category&action=class&chanid=$chanid");
	}
}elseif ($action == 'add' || $action == 'edit') {
	$catid = isset(phpcom::$G['gp_catid']) ? intval(phpcom::$G['gp_catid']) : 0;
	$categorys = array('catid' => 0, 'chanid' => $chanid, 'depth' => 0, 'rootid' => 0, 'catname' => '', 'subname' => '', 'codename' => '',
			'prefixurl' => '', 'prefix' => '', 'color' => '', 'icons' => '', 'subject' => '', 'description' => '','keyword' => '', 'basic' => 0,
			'template' => '', 'banner' => '', 'sortord' => 0, 'num' => 0, 'pagesize' => 0, 'parentid' => 0, 'child' => 0, 'target' => 0, 'caturl' => '');
	if ($action == 'edit' && $catid) {
		if(!($categorys = DB::fetch_first("SELECT * FROM " . DB::table('category') . " WHERE catid='$catid'"))){
			admin_message('undefined_action');
		}
	}
	if (!checksubmit(array('submit', 'btnsubmit'))) {
		$chanid = intval($categorys['chanid']);
		$adminhtml->form("m=category&action=$action&catid=$catid&chanid=$chanid", array(
				array('imagetmpid', 0, 'imagetmpid')
		));
		$adminhtml->table_header('tips');
		$adminhtml->table_td(array(
				array('category_comments', FALSE, 'colspan="3"')
		), NULL, FALSE, NULL, NULL, FALSE);
		$adminhtml->table_th(array(
				array("category_$action", 'class="left" colspan="3"')
		));

		$adminhtml->table_td(array(
				array('category_name', FALSE, 'width="12%"', '', TRUE),
				array('<input class="input t70" size="60" name="categorys[catname]" type="text" value="' . htmlcharsencode($categorys['catname']) . '" />', TRUE, 'width="38%"'),
				array($adminhtml->textcolor('categorys[color]', $categorys['color']), TRUE, 'width="60%"')
		));
		$othercheckbox = " <button class=\"button\" type=\"button\" onclick=\"uploadingWindow('catimage','image',$chanid,$catid);\"> " . adminlang('imageupload') . " </button>";
		$adminhtml->table_td(array(
				array('category_subname', FALSE, '', '', TRUE),
				array('<input class="input t30" size="30" name="categorys[subname]" type="text" value="' . htmlcharsencode($categorys['subname']) . '" />' . $othercheckbox, TRUE),
				array('category_subname_tips', FALSE, '', '', 'tips')
		));
		$apptochild = '';
		if($action == 'edit'){
			$apptochild = '&nbsp; <label class="c1"><input type="checkbox" name="codenametochild" class="checkbox" value="1" /> '.adminlang('category_apptochild').'</label>';
		}
		$adminhtml->table_td(array(
				array('category_codename', FALSE, '', '', TRUE),
				array('<input class="input t30" size="30" name="categorys[codename]" type="text" value="' . htmlcharsencode($categorys['codename']) . '" /> ' . $apptochild, TRUE),
				array('category_codename_tips', FALSE, '', '', 'tips')
		));
		$adminhtml->table_td(array(
				array('category_basic', FALSE, '', '', TRUE),
				array($adminhtml->radio(array('category_basic_default', 'category_basic_primary'), 'categorys[basic]', intval($categorys['basic'])), TRUE),
				array('category_basic_tips', FALSE, '', '', 'tips')
		));
		$adminhtml->table_td(array(
				array('category_subject', FALSE, '', '', TRUE),
				array('<input class="input t70" size="60" name="categorys[subject]" type="text" value="' . htmlcharsencode($categorys['subject']) . '" />', TRUE),
				array('category_subject_tips', FALSE, '', '', 'tips')
		));
		$adminhtml->table_td(array(
				array('category_description', FALSE, '', '', TRUE),
				array('<textarea rows="6" title="%s" name="categorys[description]" class="textarea" style="width:375px;">' . htmlcharsencode($categorys['description']) . '</textarea>', TRUE),
				array('category_description_tips', FALSE, '', '', 'tips')
		));
		$adminhtml->table_td(array(
				array('category_keyword', FALSE, '', '', TRUE),
				array('<input class="input t70" size="60" name="categorys[keyword]" type="text" value="' . htmlcharsencode($categorys['keyword']) . '" />', TRUE),
				array('category_keyword_tips', FALSE, '', '', 'tips')
		));
		$adminhtml->table_td(array(
				array('category_prefixurl', FALSE, '', '', TRUE),
				array('<input class="input t70" size="60" name="categorys[prefixurl]" type="text" value="' . htmlcharsencode($categorys['prefixurl']) . '" />', TRUE),
				array('category_prefixurl_tips', FALSE, '', '', 'tips')
		));
		$adminhtml->table_td(array(
				array('category_caturl', FALSE, '', '', TRUE),
				array('<input class="input t70" size="60" name="categorys[caturl]" type="text" value="' . htmlcharsencode($categorys['caturl']) . '" />', TRUE),
				array('category_caturl_tips', FALSE, '', '', 'tips')
		));
		$adminhtml->table_td(array(
				array('category_banner', FALSE, '', '', TRUE),
				array('<input class="input t70" size="60" name="categorys[banner]" type="text" value="' . htmlcharsencode($categorys['banner']) . '" />', TRUE),
				array('category_banner_tips', FALSE, '', '', 'tips')
		));
		$apptochild = '';
		if($action == 'edit'){
			$apptochild = '&nbsp; <label class="c1"><input type="checkbox" name="apptochild" class="checkbox" value="1" /> '.adminlang('category_apptochild').'</label>';
		}
		$adminhtml->table_td(array(
				array('category_template', FALSE, '', '', TRUE),
				array('<input class="input t30" size="30" name="categorys[template]" type="text" value="' . htmlcharsencode($categorys['template']) . '" /> ' . $apptochild, TRUE),
				array('category_template_tips', FALSE, '', '', 'tips')
		));
		$adminhtml->table_td(array(
				array('category_prefix', FALSE, '', '', TRUE),
				array('<input class="input t30" size="30" name="categorys[prefix]" type="text" value="' . htmlcharsencode($categorys['prefix']) . '" />', TRUE),
				array('category_prefix_tips', FALSE, '', '', 'tips')
		));
		$adminhtml->table_td(array(
				array('category_pagesize', FALSE, '', '', TRUE),
				array('<input class="input t30" size="30" name="categorys[pagesize]" type="text" value="' . intval($categorys['pagesize']) . '" />', TRUE),
				array('category_pagesize_tips', FALSE, '', '', 'tips')
		));
		$target = adminlang('targets');
		$target_select = '<select name="categorys[target]" class="select t30">';
		foreach ($target as $key => $value) {
			$target_select .= "<option value=\"$key\"";
			$target_select .= ( $key == $categorys['target']) ? ' SELECTED' : '';
			$target_select .=">$value</option>";
		}
		$target_select .= '</select>';
		$adminhtml->table_td(array(
				array('category_target', FALSE, '', '', TRUE),
				array($target_select, TRUE),
				array('category_target_tips', FALSE, '', '', 'tips')
		));
		$parentid_select = '<select name="categorys[parentid]" class="select t70">';
		$parentid_select .= '<option value="0">' . adminlang('category_select_default') . '</option>';
		$parentid_select .= category_select_option($chanid, intval($categorys['parentid']));
		$parentid_select .= '</select>';
		$adminhtml->table_td(array(
				array('category_parent', FALSE, '', '', TRUE),
				array($parentid_select, TRUE),
				array('category_parent_tips', FALSE, '', '', 'tips')
		));
		$adminhtml->table_td(array(
				array('category_order', FALSE, '', '', TRUE),
				array('<input class="input sortord" size="1" name="categorys[sortord]" type="text" value="' . intval($categorys['sortord']) . '" />' . 
					' <input class="input sortord" size="1" name="categorys[num]" type="text" value="' . intval($categorys['num']) . '" />', TRUE),
				array('category_order_tips', FALSE, '', '', 'tips')
		));
		$btnsubmit = $adminhtml->submit_button();
		$adminhtml->table_td(array(
				array($btnsubmit, TRUE, 'align="center" colspan="6"')
		), NULL, FALSE, NULL, NULL, FALSE);
		if(empty($categorys['depth']) && $catid){
			$adminhtml->table_end();

			echo <<<EOT
<script type="text/javascript">
var rowtypedata = ['&nbsp;',
'<input name="threadclassnew[ordinal][]" type="text" class="input sortord" value="0"/>',
'<input name="threadclassnew[name][]" type="text" class="input t15"/>',
'<input name="threadclassnew[alias][]" type="text" class="input t15"/>',
'<input name="threadclassnew[about][]" type="text" class="input t30"/>',
'<input name="threadclassnew[icon][]" type="text" class="input t30"/>'];
</script>
EOT;
			$adminhtml->table_header('thread_class');
			$adminhtml->table_td(array(
					array('deletecheckbox', FALSE, 'width="5%" noWrap="noWrap"'),
					array('thread_class_ordinal', FALSE, 'width="5%"'),
					array('thread_class_name', FALSE, 'width="15%"'),
					array('thread_class_alias', FALSE, 'width="15%"'),
					array('thread_class_about', FALSE, 'width="30%"'),
					array('thread_class_icon', FALSE, 'width="30%"')
			), '', FALSE, ' tablerow', NULL, FALSE);
			$sql = "SELECT * FROM " . DB::table('thread_class') . " WHERE catid='$catid' ORDER BY ordinal, classid";
			$query = DB::query($sql);
			while ($row = DB::fetch_array($query)) {
				$classid = $row['classid'];
				$adminhtml->table_td(array(
						array('<input type="checkbox" class="checkbox" name="delete[' . $classid . ']" value="' . $classid . '" />', TRUE),
						array('<input name="threadclass[' . $classid . '][ordinal]" title="classid: '.$classid.'" type="text" class="input sortord" value="'.$row['ordinal'].'" />', TRUE),
						array('<input name="threadclass[' . $classid . '][name]" title="classid: '.$classid.'" type="text" class="input t15" value="'.htmlcharsencode($row['name']).'" />', TRUE),
						array('<input name="threadclass[' . $classid . '][alias]" type="text" class="input t15" value="'.htmlcharsencode($row['alias']).'" />', TRUE),
						array('<input name="threadclass[' . $classid . '][about]" type="text" class="input t30" value="'.htmlcharsencode($row['about']).'" />', TRUE),
						array('<input name="threadclass[' . $classid . '][icon]" type="text" class="input t30" value="'.htmlcharsencode($row['icon']).'" />', TRUE)
				));
			}
			$adminhtml->table_td(array(
					array('thread_class_add', FALSE, 'colspan="6"')
			));
		}
		$adminhtml->table_end('</form>');
	}else{
		$categorys = striptags(phpcom::$G['gp_categorys']);
		$categorys['chanid'] = $chanid;
		if (empty($categorys['catname'])) admin_message('category_name');
		if (empty($categorys['codename'])) admin_message('category_codename');
		if (empty($categorys['subname'])) {
			$categorys['subname'] = $categorys['catname'];
		}
		$categorys['parentid'] = intval($categorys['parentid']);
		$categorys['target'] = intval($categorys['target']);
		$categorys['pagesize'] = empty($categorys['pagesize']) ? 0 : intval($categorys['pagesize']);
		$categorys['num'] = empty($categorys['num']) ? 0 : intval($categorys['num']);
		$categorys['prefix'] = empty($categorys['prefix']) ? '' : trim($categorys['prefix']);
		$prefixurl = empty($categorys['prefixurl']) ? '' : rtrim(trim($categorys['prefixurl']), '/\\');
		if($prefixurl && !parse_url($prefixurl, PHP_URL_SCHEME)){
			$prefixurl = "http://$prefixurl";
		}
		$categorys['prefixurl'] = $prefixurl;
		$categorys['subject'] = trim(strip_tags($categorys['subject']));
		$categorys['description'] = trim(strip_tags($categorys['description']));
		$categorys['keyword'] = trim(strip_tags($categorys['keyword']));
		$rootid = $child = 0;
		if ($action == 'edit') {
			if ($categorys['parentid'] == $catid) {
				admin_message('category_update_failed');
			}
			//ѯǰϢ
			if($row = DB::fetch_first("SELECT catid,depth,rootid,parentid,child FROM " . DB::table('category') . " WHERE catid='$catid'")){
				$rootid = $row['rootid'];
				$child = $row['child'];
				//Ҫƶܷ࣬ƶ
				if ($row['parentid'] != $categorys['parentid']) {
					//˷ӷ࣬׳
					if ($row['child']) {
						admin_message('category_moved_failed');
					}else{
						if(DB::fetch_first("SELECT classid FROM " . DB::table('thread_class') . " WHERE catid='$catid'")){
							admin_message('category_exist_thread_class');
						}
					}
					//˷һ࣬׳
					//if ($row['depth'] == 0) {
					//	admin_message('category_update_depth_failed');
						//}
						//ȡĿϢ
						if ($categorys['parentid']) {
							$parentrow = DB::fetch_first("SELECT catid,depth,rootid FROM " . DB::table('category') . " WHERE catid='{$categorys['parentid']}'");
							if ($parentrow) {
								if ($parentrow['depth'] > 2) {
									admin_error('errors');
								}
								$rootid = $parentrow['rootid'];
								$categorys['depth'] = $parentrow['depth'] + 1;
								$categorys['rootid'] = $rootid;
							} else {
								//ȡĿϢ׳
								admin_error('errors');
							}
						} else {
							//ƶΪһ࣬÷ depth=0
							$categorys['depth'] = 0;
							$categorys['rootid'] = $catid;
							$categorys['child'] = 0;
							$rootid = $catid;
						}
				}
				//ȡǰID
				$parentid = (int)DB::result_first("SELECT parentid FROM " . DB::table('category') . " WHERE catid='$catid'");
				//·Ϣ
				DB::update('category', $categorys, array('catid' => $catid));
				if ($parentid) {
					//µǰӷϢ
					$child = (int)DB::result_first("SELECT COUNT(*) FROM " . DB::table('category') . " WHERE parentid='$parentid'");
					DB::update('category', array('child' => $child), "catid='$parentid'");
				}
				$parentid = intval($categorys['parentid']);
				//жǷࣻƶķΪһ࣬²
				if ($parentid && $row['parentid'] != $parentid) {
					$child = (int)DB::result_first("SELECT COUNT(*) FROM " . DB::table('category') . " WHERE parentid='$parentid'");
					DB::update('category', array('child' => $child), "catid='$parentid'");
				}
				if($child && !empty(phpcom::$G['gp_apptochild'])){
					DB::update('category', array('template' => $categorys['template']), "parentid='$catid'");
				}
				if($child && !empty(phpcom::$G['gp_codenametochild'])){
					DB::update('category', array('codename' => $categorys['codename']), "parentid='$catid'");
				}
				updatecategoryimage($catid);
				add_update_threadclass($catid, $chanid);
				update_categorys_cache($chanid);
			}
			admin_succeed('category_succeed', "m=category&action=edit&chanid=$chanid&catid=$catid");
		} elseif ($action == 'add') {
			//µķ
			$parentid = intval($categorys['parentid']);
			$rootid = $catid = makenewcatid();
			$categorys['catid'] = $catid;
			$categorys['imageurl'] = '';
			//ѯϢ
			if ($parentid) {
				$row = DB::fetch_first("SELECT catid,depth,rootid,child FROM " . DB::table('category') . " WHERE catid='$parentid'");
				$categorys['depth'] = $row['depth'] + 1;
				$categorys['rootid'] = $row['rootid'];
				$rootid = $row['rootid'];
				//ѡ೬3׳Ϣ
				if ($row['depth'] > 2) {
					admin_message('category_insert_failed');
				}
			} else {
				//һ࣬ĬϢ
				$categorys['depth'] = 0;
				$categorys['rootid'] = $categorys['catid'];
				$categorys['parentid'] = 0;
				$categorys['child'] = 0;
			}
			//
			if ($categorys['sortord'] < 1) {
				$sortord = (int)DB::result_first("SELECT MAX(sortord) FROM " . DB::table('category') . " WHERE parentid='$parentid'");
				$categorys['sortord'] = $sortord + 1;
			}
			$categorys['setting'] = '';
			//
			DB::insert('category', $categorys);
			//Ϣ
			if ($parentid) {
				$child = (int) DB::result_first("SELECT COUNT(*) FROM " . DB::table('category') . " WHERE parentid='$parentid'");
				DB::update('category', array('child' => $child), 'catid=' . $parentid);
			}
			updatecategoryimage($catid);
		}
		update_categorys_cache($chanid);
		admin_succeed('category_succeed', "m=category&chanid=$chanid");
	}
}elseif ($action == 'select') {
	$catid = isset(phpcom::$G['gp_catid']) ? intval(phpcom::$G['gp_catid']) : null;
	$adminhtml->table_header('thread_class_select', 5);
	$adminhtml->table_td(array(
			array('thread_class_select_input', FALSE, 'colspan="5" align="left"')
	), NULL, FALSE, NULL, NULL, FALSE);
	$condition = " catid>'0' AND";
	if($catid && ($category = DB::fetch_first("SELECT rootid FROM " . DB::table('category') . " WHERE catid='$catid'"))){
		$condition = "catid='{$category['rootid']}' AND";
	}
	$query1 = DB::query("SELECT * FROM " . DB::table('thread_class') . " WHERE catid='0' AND chanid='$chanid' ORDER BY ordinal, classid");
	$query = DB::query("SELECT * FROM " . DB::table('thread_class') . " WHERE $condition chanid='$chanid' ORDER BY ordinal, classid");
	$i = $n = $m = 0;
	while (($row = DB::fetch_array($query1)) || ($row = DB::fetch_array($query))) {
		$classid = $row['classid'];
		$m = ($i % 2 == 0) ? 2 : 1;
		if ($i === 0) {
			echo '<tr>';
		}
		echo '<td class="tablerow', $m, '" width="20%" title="'.$row['name'].'">';
		echo '<div class="item"><label class="txt">';
		echo '<input class="checkbox" type="checkbox" id="checkbox_'.$classid.'" name="classidnew[]" onclick="topicalAdd(this, \'classidstr\')" value="'.$classid.'" />';
		echo "&nbsp;{$row['name']}</label></div>";
		echo '</td>';
		$i++;
		if ($i % 5 == 0) {
			echo '</tr><tr>';
		}
	}
	if($ii = $i % 5){
		for ($index = 1; $index <= (5 - $ii); $index++) {
			$m = ($index % 2 == 0) ? 2 : 1;
			echo '<td class="tablerow', $m, '" width="20%">&nbsp;</td>';
		}
		echo '</tr>';
	}
	$adminhtml->table_end();
	echo <<<EOT
<style type="text/css">
    html {padding-top:0;}
</style>
<script type="text/javascript">
if($('crumbnav')){
    $('crumbnav').style.display='none';
}
initTopicSelect('classidstr');
</script>
EOT;
	exit('</body></html>');
}elseif ($action == 'del') {
	$catid = intval(phpcom::$G['gp_catid']);
	delete_category($catid, $chanid);
}elseif ($action == 'firstadd') {
	if (checksubmit(array('submit', 'btnsubmit'))) {
		$categorys = striptags(phpcom::$G['gp_categorys']);
		if (empty($categorys['catname'])) admin_message('category_name');
		if (empty($categorys['codename'])) admin_message('category_codename');
		if (empty($categorys['subname'])) {
			$categorys['subname'] = trim($categorys['catname']);
		}
		$categorys['catid'] = makenewcatid();

		if ($categorys['sortord'] < 1) {
			$sortord = (int) DB::result_first("SELECT MAX(sortord) FROM " . DB::table('category') . " WHERE chanid='$chanid' AND depth='0'");
			$categorys['sortord'] = $sortord + 1;
		}
		$categorys['chanid'] = $chanid;
		$categorys['depth'] = 0;
		$categorys['rootid'] = $categorys['catid'];
		$categorys['target'] = $categorys['child'] = $categorys['parentid'] = 0;
		$categorys['setting'] = '';
		DB::insert('category', $categorys);
		update_categorys_cache($chanid);
		phpcom::header("Location: " . ADMIN_SCRIPT . "?m=category&chanid=$chanid");
	}
}else{
	if (!checksubmit(array('submit', 'btnsubmit'))) {
		phpcom::$G['gp_more'] = isset(phpcom::$G['gp_more']) ? trim(phpcom::$G['gp_more']) : null;
		$adminhtml->form("m=category&action=firstadd&chanid=$chanid", null, 'name="addform"');
		$adminhtml->table_header('shortcut_operate');
		$adminhtml->table_td(array(
				array('category_tips', FALSE, '')
		), NULL, FALSE, NULL, NULL, FALSE);
		$s = '<b>' . adminlang('category_add1') . '</b> ';
		$s .= adminlang('ordinal');
		$s .= ' <input class="input sortord" size="1" name="categorys[sortord]" type="text" value="0" /> ';
		$s .= adminlang('category_name');
		$s .= ' <input class="input" size="30" name="categorys[catname]" type="text" /> ';
		$s .= adminlang('category_subname');
		$s .= ' <input class="input" size="15" name="categorys[subname]" type="text" value="" /> ';
		$s .= adminlang('category_codename');
		$s .= ' <input class="input" size="15" name="categorys[codename]" type="text" value="sort001" /> ';
		$s .= ' <input type="hidden" name="categorys[chanid]" value="' . $chanid . '" /> ';
		$s .= ' <input type="hidden" name="categorys[parentid]" value="0" /> ';
		$s .=$adminhtml->submit_button(null, null, 'button');
		$adminhtml->table_td(array(
				array($s, TRUE, '')
		), NULL, FALSE, NULL, NULL, FALSE);
		$adminhtml->table_end('</form>');

		$adminhtml->form("m=category&chanid=$chanid&more=" . phpcom::$G['gp_more'], null, 'name="adminform" id="adminform"');
		$adminhtml->table_header('category_toggle', array('chanid' => $chanid));
		$classtitle = adminlang('order') . ' | ' . adminlang('catname');
		if(!empty(phpcom::$G['gp_more'])){
			$classtitle .= ' | ' . adminlang('category_codename') . ' | ' . adminlang('category_pagesize') . ' | ' . adminlang('category_prefix') . ' | ' . adminlang('category_prefixurl');
		}
		if(empty(phpcom::$G['gp_more'])){
			$adminhtml->table_td(array(
					array('catid', FALSE, 'width="5%" align="center" noWrap="noWrap"'),
					array($classtitle, TRUE, 'width="60%"'),
					array('operation', FALSE, 'width="35%"')
			), '', FALSE, ' tablerow');
		}else{
			$adminhtml->table_td(array(
					array('catid', FALSE, 'width="5%" align="center" noWrap="noWrap"'),
					array($classtitle, TRUE, 'width="85%"'),
					array('operation', FALSE, 'width="10%" noWrap="noWrap"')
			), '', FALSE, ' tablerow');
		}
		$count = 0;
		$catarray = array();
		$addsubcategory = adminlang('category_add_subcategory');
		$sql = "SELECT * FROM " . DB::table('category') . " WHERE chanid='$chanid' ORDER BY sortord, catid";
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$catarray[$row['parentid']][$row['catid']] = $row;
			$count++;
		}
		$lastrow = 0;
		if(!isset($catarray[0])){
			$catarray[0] = array();
		}
		foreach ($catarray[0] as $key => $row) {
			showcategory($adminhtml, $row, $chanid, $addsubcategory, $count);
			echo "<tbody id=\"groupbody_{$row['catid']}\">\r\n";
			if(isset($catarray[$row['catid']])) {
				foreach ($catarray[$row['catid']] as $key => $row) {
					showcategory($adminhtml, $row, $chanid, $addsubcategory, $count);
					if(isset($catarray[$row['catid']])){
						foreach ($catarray[$row['catid']] as $key => $row) {
							showcategory($adminhtml, $row, $chanid, $addsubcategory, $count);
							if(isset($catarray[$row['catid']])){
								foreach ($catarray[$row['catid']] as $key => $row) {
									showcategory($adminhtml, $row, $chanid, '', $count);
								}
							}
						}
					}
				}
			}
			echo '</tbody>';
		}
		$btnsubmit = $adminhtml->submit_button();
		$adminhtml->table_td(array(
				array($btnsubmit, TRUE, 'align="center" colspan="3"')
		), NULL, FALSE, NULL, NULL, FALSE);
		$adminhtml->table_end('</form>');
	}else{
		$more = isset(phpcom::$G['gp_more']) ? phpcom::$G['gp_more'] : '';
		$categorys = striptags(phpcom::$G['gp_categorys']);

		foreach ($categorys as $catid => $category) {
			if(!empty($category['catname'])){
				$category['sortord'] = intval($category['sortord']);
				if(isset($category['prefixurl'])){
					$prefixurl = rtrim(trim($category['prefixurl']), "/\\");
					if($prefixurl && !parse_url($prefixurl, PHP_URL_SCHEME)){
						$prefixurl = "http://$prefixurl";
					}
					$category['prefixurl'] = $prefixurl;
				}
				if(isset($category['pagesize'])) $category['pagesize'] = intval($category['pagesize']);
				DB::update('category', $category, "catid='$catid'");
			}
		}
		update_categorys_cache($chanid);
		admin_succeed('update_succeed', "m=category&more=$more&chanid=$chanid");
	}
}
admin_footer();

function add_update_threadclass($catid = 0, $chanid = 0){
	$threadclassnew = isset(phpcom::$G['gp_threadclassnew']) ? phpcom::$G['gp_threadclassnew'] : null;
	$threadclass = isset(phpcom::$G['gp_threadclass']) ? phpcom::$G['gp_threadclass'] : null;
	$delete = isset(phpcom::$G['gp_delete']) ? phpcom::$G['gp_delete'] : null;
	$updatecache = false;
	if(!empty($threadclass)){
		$updatecache = true;
		foreach ($threadclass as $classid => $classes) {
			if($delete && isset($delete[$classid]) && $delete[$classid] == $classid){
				DB::delete('thread_class', "classid='$classid'");
				DB::delete('thread_class_data', "classid='$classid'");
			}else{
				DB::update('thread_class', $classes, "classid='$classid'");
			}
		}
	}
	if(!empty($threadclassnew) && isset($threadclassnew['name'])){
		foreach ($threadclassnew['name'] as $key => $value) {
			if(!empty($value)){
				DB::insert('thread_class', array(
				'chanid' => $chanid,
				'catid' => $catid,
				'name' => trim($value),
				'alias' => trim($threadclassnew['alias'][$key]),
				'about' => trim($threadclassnew['about'][$key]),
				'icon' => trim($threadclassnew['icon'][$key]),
				'ordinal' => intval($threadclassnew['ordinal'][$key])
				));
				$updatecache = true;
			}
		}
	}
	if($updatecache){
		phpcom_cache::updater('thread_class', $chanid);
	}
}

function updatecategoryimage($catid) {
	if($catid && !empty(phpcom::$G['gp_imagetmpid'])){
		$tmpid = intval(phpcom::$G['gp_imagetmpid']);
		$images = array();
		$flag = false;
		if($tmpid > 0 && ($tmp = Attachment::getUploadTemp($tmpid))){
			if(!empty($tmp['attachment']) && phpcom::$G['uid'] == $tmp['uid']){
				$images['imageurl'] = $tmp['attachment'];
				$images['remote'] = Attachment::ftpOneUpload($tmp);
				DB::delete('upload_temp', "tmpid='{$tmp['tmpid']}'");
				$flag = true;
			}
		}else{
			$flag = ($tmpid == -1);
		}

		if($img = DB::fetch_first("SELECT catid,remote,imageurl FROM " . DB::table('category') . " WHERE catid='$catid' LIMIT 1")){
			if(!empty($images)){
				DB::update('category', $images, "catid='$catid'");
			}
			$unlinks = array('dirname' => 'image');
			if($flag && !empty($img['imageurl'])){
				$unlinks['attachment'] = trim($img['imageurl']);
				$unlinks['thumb'] = 0;
				$unlinks['remote'] = $img['remote'];
				Attachment::uploadUnlink($unlinks);
			}
		}

	}
}

function showcategory($adminhtml, $row, $chanid, $addsubcategory='', $max=0) {
	static $index = 0;
	$index++;
	$varname = "categorys[{$row['catid']}]";
	$editurl = "m=category&action=edit&catid={$row['catid']}&chanid=$chanid";
	$edit = '<input type="hidden" name="catid[]" value="' . $row['catid'] . '" />';
	$edit .= $adminhtml->edit_word('edit', $editurl, ' | ');
	$edit .= $adminhtml->del_word('delete', 'action=del&m=category&catid=' . $row['catid'] . '&chanid=' . $chanid);
	$add_subcategory = $addsubcategory ? '</span>&nbsp;<i class="add-link"><b>+</b> <a href="?action=addsub&m=category&catid=' . $row['catid'] . '&chanid=' . $chanid . '" id="addlinks_' . $row['catid'] . '" style="display:none;" class="links">' . $addsubcategory . '</a></i>' : '</span>';
	if(!empty(phpcom::$G['gp_more'])){
		$add_subcategory = ' <input class="input" size="15" name="'.$varname.'[codename]" type="text" value="' . htmlcharsencode($row['codename']) . '" />';
		$add_subcategory .= ' <input class="input sortord" size="1" name="'.$varname.'[pagesize]" type="text" value="' . intval($row['pagesize']) . '" />';
		$add_subcategory .= ' <input class="input" size="15" name="'.$varname.'[prefix]" type="text" value="' . htmlcharsencode($row['prefix']) . '" />';
		$add_subcategory .= ' <input class="input" size="30" name="'.$varname.'[prefixurl]" type="text" value="' . htmlcharsencode($row['prefixurl']) . '" /></span>';
	}
	$row['color'] = $row['color'] ? ' style="color:' . $row['color'] . '"' : '';
	if ($row['depth'] == 1) {
		$depth = $index >= $max ? '<i class="tdline1 tdlast"></i>' : '<i class="tdline1"></i>';
	} elseif ($row['depth'] == 2) {
		$depth = $index >= $max ? '<i class="tdline2 tdlast"></i>' : '<i class="tdline2"></i>';
	} elseif ($row['depth'] == 3) {
		$depth = $index >= $max ? '<i class="tdline3 tdlast"></i>' : '<i class="tdline3"></i>';
	} else {
		$depth = "<i id=\"toggle_{$row['catid']}\" class=\"toggle hide-icon\" onclick=\"toggle_display('{$row['catid']}')\"></i>";
	}
	$adminhtml->table_td(array(
			array('<em class="tiny"><a href="?'.$editurl.'"' . $row['color'] . '>' . $row['catid'] . '</a></em>', TRUE, 'align="center"'),
			array($depth . '<span class="span-input"><input class="input sortord" size="1" name="'.$varname.'[sortord]" type="text" value="' . $row['sortord'] . '" />
					<input class="input" size="15" name="'.$varname.'[catname]" type="text" value="' . htmlcharsencode($row['catname']) . '" />' . $add_subcategory, TRUE),
			array($edit, TRUE)
	), '', FALSE, ' tdborder', $row['depth'] == 3 ? '' : ' onmouseover="toggleDisplay(\'addlinks_' . $row['catid'] . '\',\'show\')" onmouseout="toggleDisplay(\'addlinks_' . $row['catid'] . '\',\'hide\')"');
}

function delete_category($catid, $chanid = 0) {
	if(!phpcom_admincp::permission('category_delete')){
		admin_message('action_delete_denied');
	}
	//⸸Ƿڣ0=
	$parentid = (int) DB::result_first("SELECT COUNT(*) FROM " . DB::table('category') . " WHERE parentid='$catid'");
	//ڸ࣬׳Ϣ
	if ($parentid) {
		admin_message('category_delete_failed');
	}
	//ȡҪɾĸID
	$parentid = (int) DB::result_first("SELECT parentid FROM " . DB::table('category') . " WHERE catid='$catid'");
	//ʼɾ
	if ($catid) {
		DB::delete('category', array('catid' => $catid));
	}
	// $parentid=0ɾһ࣬Ͳø
	// $parentid>0¸
	if ($parentid) {
		$child = (int) DB::result_first("SELECT COUNT(*) FROM " . DB::table('category') . " WHERE parentid='$parentid'");
		DB::update('category', array('child' => $child), 'catid=' . $parentid);
	}
	update_categorys_cache($chanid);
	admin_succeed('delete_succeed', "m=category&chanid=$chanid");
}

function update_categorys_cache($chanid) {
	phpcom_cache::updater('category', $chanid);
}

function makenewcatid() {
	$catid = (int) DB::result_first("SELECT MAX(catid) FROM " . DB::table('category') . " WHERE 1=1");
	return $catid + 1;
}

function category_select_option($chanid, $parentid = 0) {
	phpcom_cache::load('category_' . $chanid);
	$data = phpcom::$G['cache']['category_' . $chanid];
	$option = '';
	if(isset($data[0])){
		foreach ($data[0] as $key => $row) {
			$option .= '<option value="' . $row['catid'] . '"';
			$option .= ( $row['catid'] == $parentid) ? ' SELECTED' : '';
			$option .= ">{$row['catname']}</option>";
			if (isset($data[$row['catid']])){
				foreach ($data[$row['catid']] as $key => $row) {
					$option .= '<option value="' . $row['catid'] . '"';
					$option .= ( $row['catid'] == $parentid) ? ' SELECTED' : '';
					$option .= "> &nbsp; &nbsp;|- {$row['catname']}</option>";
					if(isset($data[$row['catid']])){
						foreach ($data[$row['catid']] as $key => $row) {
							$option .= '<option value="' . $row['catid'] . '"';
							$option .= ( $row['catid'] == $parentid) ? ' SELECTED' : '';
							$option .= "> &nbsp; &nbsp; &nbsp; &nbsp;|- {$row['catname']}</option>";
						}
					}
				}
			}
		}
	}
	return $option;
}

?>
