<?php

/**
 * Copyright (c) 2010-2011  phpcom.cn - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of phpcom.cn.
 * This File   : list.php    2012-2-9
 */
!defined('IN_ADMINCP') && exit('Access denied');
if (!checksubmit(array('btnsubmit', 'submit_button'))) {
    $adminhtml->form("m=soft&action=list&chanid=$chanid", null, 'onkeydown="return formdown()"');
    $adminhtml->table_header();
    $adminhtml->table_th(array(
        array('', 'width="2%" align="center" noWrap="noWrap"'),
        array('soft_title', 'width="63%" class="left" noWrap="noWrap"'),
        array('adminoption', 'width="15%"'),
        array('dateline', 'width="10%"'),
        array('soft_softsize', 'width="10%"')
    ));
    $adminhtml->table_td(array(
        array(' ', TRUE, 'colspan="5" align="left" id="showpage"')
            ), NULL, FALSE, NULL, NULL, FALSE);
    $word = isset(phpcom::$G['gp_word']) ? phpcom::$G['gp_word'] : '';
    $catid = isset(phpcom::$G['gp_catid']) ? intval(phpcom::$G['gp_catid']) : 0;
    $rootid = isset(phpcom::$G['gp_rootid']) ? intval(phpcom::$G['gp_rootid']) : 0;
    $condition = $status == 2 ? "status>='0'" : "status='$status'";
    
    $queryurl = '';
    if ($catid) {
    	$queryurl = "&catid=$catid&status=$status";
    	$condition .= " AND catid=$catid";
    }elseif($rootid){
    	$queryurl = "&rootid=$rootid&status=$status";
    	$condition .= " AND rootid=$rootid";
    }else{
    	$condition .= " AND chanid='$chanid'";
    }
    if ($action == 'search' && $word) {
        $word = str_replace('_', '\_', $word);
        $condition .= " AND title LIKE '%$word%'";
        $queryurl = implodeurl(array('action' => 'search', 'word' => $word), '&');
    }
    
    $todaytime = strtotime(fmdate(TIMESTAMP, 'Ymd'));
    $page = phpcom::$G['page'];
    $totalrec = isset(phpcom::$G['gp_count']) ? intval(phpcom::$G['gp_count']) : 0;
    !$totalrec && $totalrec = DB::result_first("SELECT COUNT(*) FROM " . DB::table('threads') . " WHERE $condition");
    $pagesize = intval(phpcom::$config['admincp']['pagesize']);
    $pagecount = @ceil($totalrec / $pagesize);
    $pagenow = max(1, min($pagecount, intval($page)));
    $pagestart = floor(($pagenow - 1) * $pagesize);
    $pagesql = "INNER JOIN (" . DB::buildlimit("SELECT tid FROM " . DB::table('threads') . " WHERE $condition ORDER BY dateline DESC", $pagesize, $pagestart) . ") AS p USING(tid)";
    $sql = "SELECT t.*,c.basic,c.catname,c.codename,c.prefixurl,c.prefix,c.color,s.softsize
    		FROM " . DB::table('threads') . " t $pagesql
			LEFT JOIN " . DB::table('category') . " c USING(catid)
			LEFT JOIN " . DB::table('soft_thread') . " s USING(tid)";
    $query = DB::query($sql);
    while ($row = DB::fetch_array($query)) {
        $tid = $row['tid'];
        $edit = $adminhtml->edit_word('edit', "m=soft&action=edit&chanid=$chanid&tid=$tid", ' | ');
        $edit .= $adminhtml->edit_word('recommend', "m=soft&action=recommend&chanid=$chanid&tid=$tid&act={$row['recommend']}", ' | ');
        //$edit .= $adminhtml->edit_word('istop', "action=istop&m=soft&chanid=$chanid&tid=$tid&act={$row['istop']}", ' | ');
        $edit .= $adminhtml->del_word('delete', "m=soft&action=del&chanid=$chanid&tid=$tid");
        
        $row['color'] = $row['color'] ? ' style="color:' . $row['color'] . '"' : '';
        
        if ($row['highlight']) {
            $string = sprintf('%02d', $row['highlight']);
            $row['highlight'] = ' style="';
            $row['highlight'] .= $string[0] ? phpcom::$setting['fontvalue'][$string[0]] : '';
            $row['highlight'] .= $string[1] ? 'color: ' . phpcom::$setting['colorvalue'][$string[1]] : '';
            $row['highlight'] .= '"';
        } else {
            $row['highlight'] = '';
        }
        $row['icons'] = 'txt.gif';
        if ($row['polled']) {
        	$row['icons'] = 'vote.gif';
        }
        if ($row['image']) {
        	$row['icons'] = 'thumb.gif';
        }elseif ($row['attached']) {
        	$row['icons'] = 'pic.gif';
        }
        $urlargs = array('chanid' => $row['chanid'], 'catdir' => $row['codename'], 'tid' => $row['tid'],
        		'date' => $row['dateline'], 'cid' => $row['catid'], 'catid' => $row['catid'], 'page' => 1);
        $urlargs['prefix'] = empty($row['prefix']) ? '' : trim($row['prefix']);
        $urlargs['name'] = empty($row['htmlname']) ? '' : trim($row['htmlname']);
        
        if (empty(phpcom::$G['channel'][$row['chanid']]['domain']) && empty($row['prefixurl'])) {
        	$row['domain'] = phpcom::$G['instdir'];
        } elseif(empty($row['prefixurl'])) {
        	$row['domain'] = phpcom::$G['channel'][$row['chanid']]['domain'] . '/';
        }else{
        	$row['domain'] = $row['prefixurl'] . '/';
        }
        
        $row['viewurl'] = "?m=soft&action=view&chanid=$chanid&tid=$tid";
        if (empty($row['url'])) {
        	$row['url'] = geturl('threadview', $urlargs, $row['domain']);
        }else{
        	$row['icons'] = 'link.gif';
        }
        if ($row['istop']) {
        	$row['icons'] = 'pin.gif';
        }
        $row['weeknew'] = TIMESTAMP - 604800 <= $row['dateline'];
        $row['istoday'] = $row['dateline'] > $todaytime ? 1 : 0;
        if ($row['weeknew']) {
            $row['weeknew'] = '<em class="new">New</em>';
        } else {
            $row['weeknew'] = '';
        }
        $row['recommend'] = $row['recommend'] ? '<img src="misc/images/icons/recommend.gif" />' : '';
        $row['focus'] = $row['focus'] ? '<img src="misc/images/icons/focus.gif" />' : '';
        $row['topline'] = $row['topline'] ? '<img src="misc/images/icons/topline.gif" />' : '';
        $row['digest'] = $row['digest'] ? '<img src="misc/images/icons/digest.gif" />' : '';
        $row['auditicon'] = $row['status'] == 1 ? '' : '<a href="?m=soft&action=audit&tid='.$tid.'&chanid='.$chanid.'"><img src="misc/images/icons/audit.gif" /></a>';

        $row['sizehits'] = formatbytes(intval($row['softsize']) * 1024);
        $adminhtml->table_td(array(
            array('<input type="checkbox" class="checkbox" name="delete[]" value="' . $tid . '" />', TRUE),
            array('<a href="' . $row['url'] .'" target="_blank"><img src="misc/images/icons/' . $row['icons'] . '" /></a> <a class="lst" href="?m=soft&action=list&chanid=' . $chanid . '&catid=' . $row['catid'] . '"' . $row['color'] . '>' . $row['catname'] . '</a>
					&#8226; <a class="lst" href="' . $row['viewurl'] .'"'. $row['highlight'] . '>' . $row['title'] . '</a> ' . $row['recommend'] . $row['digest'] . $row['focus'] . $row['topline'] . $row['auditicon'], TRUE),
            array($edit, TRUE, 'align="center" noWrap="noWrap"'),
            array('<em class="f10">' . fmdate($row['dateline'], 'dt', 'd') . '</em>', TRUE, 'align="center" noWrap="noWrap"'),
            array('<em class="f10">' . $row['sizehits'] . '</em>', TRUE, 'align="center" noWrap="noWrap"')
        ));
    }
    $adminhtml->table_td(array(
        array($adminhtml->checkall() . ' ' . $adminhtml->del_submit(), TRUE, 'colspan="5"')
    ));
    $showpage = '<var class="morePage">' . showpage($pagenow, $pagecount, $pagesize, $totalrec, ADMIN_SCRIPT . "?m=soft&action=list&chanid=$chanid$queryurl") . '</var>';
    $adminhtml->table_td(array(
        array($showpage, TRUE, 'colspan="5" align="right" id="pagecode"')
            ), NULL, FALSE, NULL, NULL, FALSE);
    $adminhtml->table_end('</form>');
    $adminhtml->showpagescript();
} else {
	if(!phpcom_admincp::permission('thread_delete')){
		admin_message('action_delete_denied');
	}
    include_once loadlibfile('delete');
    $tids = isset(phpcom::$G['gp_delete']) ? phpcom::$G['gp_delete'] : null;
    if (delete_softinfo_thread($tids)) {
    	phpcom_cache::updater('syscount', $chanid);
        admin_succeed('threads_delete_succeed', "m=soft&action=list&chanid=$chanid");
    } else {
        admin_message('threads_delete_failed', "m=soft&action=list&chanid=$chanid");
    }
}
?>