<?php
/**
 * Copyright (c) 2010-2012 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : special.php  2012-8-13
 */
!defined('IN_PHPCOM') && exit('Access denied');

phpcom::$G['lang']['admin'] = 'misc';
admin_header('menu_special');
$adminhtml = phpcom_adminhtml::instance();
if($action != 'select'){
	$adminhtml->activetabs('topic');
}

$navarray = array(
	array('title' => 'menu_special','url' => '?m=special','id' => 'special'),
	array('title' => 'menu_special_add','url' => '?m=special&action=add','id' => 'special_add'),
	array('title' => 'menu_special_column','url' => '?m=special&action=column','id' => 'special_column')
);
$activation = stricmp($action, array('column', 'columnedit', 'columnadd', 'columndel')) ? 'special_column' : 'special';
$activation = stricmp($action, array('add')) ? 'special_add' : $activation;
if($action != 'select'){
	$adminhtml->navtabs($navarray, $activation, 'nav_tabs', 'special');
}

if ($action == 'column') {
	if (!checksubmit(array('submit', 'btnsubmit'))) {
		$adminhtml->form('m=special&action=columnadd', null, 'name="addform"');
		$adminhtml->table_header('special_column_add');
		$adminhtml->table_td(array(
				array('special_column_tips', FALSE, '')
		));
		$s = '<strong>';
		$s .= adminlang('ordinal');
		$s .= '</strong> <input class="input sortord" size="1" name="specialnew[sortord]" type="text" value="0" /> <strong>';
		$s .= adminlang('special_column_subject');
		$s .= '</strong> <input class="input t20" name="specialnew[subject]" type="text" /> <strong>';
		$s .= adminlang('special_column_name');
		$s .= '</strong> <input class="input t15" name="specialnew[name]" type="text" value="special001" /> ';
		$s .=$adminhtml->submit_button('new', null, 'button');
		$adminhtml->table_td(array(
				array($s, TRUE, '')
		), NULL, FALSE, NULL, NULL, FALSE);
		$adminhtml->table_end('</form>');

		$adminhtml->form('m=special&action=column');
		$adminhtml->table_header();
		$columntitle = adminlang('order') . '/' . adminlang('special_column_subject') . '/' . adminlang('special_column_name');
		$adminhtml->table_th(array(
				array('special_id', 'width="5%" align="center" noWrap="noWrap"'),
				array($columntitle, 'width="60%" class="left"'),
				array('detail', 'width="35%" class="left"')
		));
		$count = 0;
		$specialArray = array();
		$sql = "SELECT * FROM " . DB::table('special') . " ORDER BY sortord";
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$row['color'] = $row['color'] ? ' style="color:' . $row['color'] . '"' : '';
			$specialArray[$row['parentid']][$row['specid']] = $row;
			$count++;
		}
		if(isset($specialArray[0])){
			foreach ($specialArray[0] as $specid => $special) {
				showcolumnitem($adminhtml, $special, $count);
				echo "<tbody id=\"groupbody_{$specid}\">\r\n";
				if(isset($specialArray[$specid])){
					foreach ($specialArray[$specid] as $subrow) {
						showcolumnitem($adminhtml, $subrow, $count);
					}
				}
				echo '</tbody>';
			}
		}

		$adminhtml->table_td(array(
				array('&nbsp;', TRUE),
				array($adminhtml->submit_button(), TRUE, 'colspan="2"')
		), NULL, FALSE, NULL, NULL, FALSE);
		$adminhtml->table_end('</form>');
	}else{
		$specids = phpcom::$G['gp_specid'];
		$subjects = phpcom::$G['gp_subject'];
		$sortords = phpcom::$G['gp_sortord'];
		if($specids && $subjects && $sortords){
			foreach ($specids as $specid => $special) {
				if($subjects[$specid]){
					DB::update('special', array(
						'sortord' => intval($sortords[$specid]),
						'subject' => htmlstrip($subjects[$specid])
					), "specid='$specid'");
				}
			}
		}
		phpcom_cache::updater('special');
		admin_succeed('special_column_update_succeed', 'm=special&action=column');
	}
}elseif ($action == 'columnedit' || $action == 'columnadd') {
	$specid = isset(phpcom::$G['gp_specid']) ? intval(phpcom::$G['gp_specid']) : 0;
	$special = array('specid' => 0, 'parentid' => 0, 'subject' => '', 'color' => '', 'name' => '',
			'description' => '', 'keyword' => '', 'domain' => '');
	if($specid && !$special = DB::fetch_first("SELECT * FROM " . DB::table('special') . " WHERE specid='$specid'")){
		admin_message('undefined_action');
	}

	if (!checksubmit(array('submit', 'btnsubmit'))) {
		$adminhtml->form("m=special&action=$action&specid=$specid");
		$adminhtml->table_header('special_column_' . ($action == 'columnedit' ? 'edit' : 'add'));
		$adminhtml->table_td(array(
				array('special_column_subject', FALSE, 'width="15%"', '', TRUE),
				array($adminhtml->textinput('specialnew[subject]', $special['subject'], 60), TRUE, 'width="35%"'),
				array('special_column_name', FALSE, 'width="15%"', '', TRUE),
				array($adminhtml->textinput('specialnew[name]', $special['name'], 30), TRUE, 'width="35%"')
		));
		$adminhtml->table_td(array(
				array('special_select_column', FALSE, '', '', TRUE),
				array(select_special_column($special['parentid']), TRUE),
				array('special_color', FALSE, '', '', TRUE),
				array($adminhtml->textcolor('specialnew[color]', $special['color'], 15), TRUE, 'width="35%"')
		));
		$adminhtml->textarea('special_description', $special['description'], 'specialnew[description]', '', 3);
		$adminhtml->table_td(array(
				array('special_keyword', FALSE, '', '', TRUE),
				array($adminhtml->textinput('specialnew[keyword]', $special['keyword'], 70), TRUE, 'colspan="3"')
		));
		$adminhtml->table_td(array(
				array('special_domain', FALSE, '', '', TRUE),
				array($adminhtml->textinput('specialnew[domain]', $special['domain'], 50), TRUE),
				array('special_domain_comments', FALSE, 'colspan="2"', '', 'tips')
		));
		$adminhtml->table_td(array(
				array($adminhtml->submit_button(), TRUE, 'align="center" colspan="4"')
		), NULL, FALSE, NULL, NULL, FALSE);
		$adminhtml->table_end('</form>');
	}else{
		$specialnew = phpcom::$G['gp_specialnew'];
		$message = 'special_column_add_succeed';
		$specialnew['subject'] = htmlstrip($specialnew['subject']);
		if(empty($specialnew['subject'])){
			admin_message('special_title_invalid');
		}
		$specialnew['name'] = htmlstrip($specialnew['name']);
		if(empty($specialnew['name']) || preg_match("/[^\w]/", $specialnew['name'])){
			admin_message('special_name_invalid');
		}
		if(!stricmp($specialnew['name'], $special['name'])){
			if(DB::fetch_first("SELECT specid FROM " . DB::table('special') . " WHERE name='{$specialnew['name']}'")){
				admin_message('special_name_repeated');
			}
		}
		if($parentid = isset($specialnew['parentid']) ? intval($specialnew['parentid']) : 0){
			$parent = DB::fetch_first("SELECT specid, depth FROM " . DB::table('special') . " WHERE specid='$parentid'");
			if($parent['depth']){
				$parentid = 0;
			}
		}
		if($parentid){
			$specialnew['depth'] = 1;
			$specialnew['parentid'] = $parentid;
		}else{
			$specialnew['depth'] = 0;
			$specialnew['parentid'] = 0;
		}
		$fields = array('color' => '', 'description' => '', 'keyword' => '', 'domain' => '');
		foreach ($fields as $k => $v){
			if(isset($specialnew[$k])){
				$specialnew[$k] = htmlstrip($specialnew[$k]);
			}else{
				$specialnew[$k] = $v;
			}
		}
		if($action == 'columnadd'){
			$specid = (int)DB::result_first("SELECT MAX(specid) FROM " . DB::table('special') . " WHERE 1=1");
			$specialnew['specid'] = $specid + 1;
			if (!isset($specialnew['sortord']) || $specialnew['sortord'] < 1) {
				$sortord = (int)DB::result_first("SELECT MAX(sortord) FROM " . DB::table('special') . " WHERE 1=1");
				$specialnew['sortord'] = $sortord + 1;
			}
			$specialnew['child'] = 0;
			DB::insert('special', $specialnew);
		}else{
			if ($specialnew['parentid'] == $specid) {
				admin_message('special_update_failed');
			}
			if ($special['parentid'] != $parentid && $special['child']) {
				admin_message('special_moved_failed');
			}
			DB::update('special', $specialnew, "specid='$specid'");
			if($special['parentid']){
				$child = intval(DB::result_first("SELECT COUNT(*) FROM " . DB::table('special') . " WHERE parentid='{$special['parentid']}'"));
				DB::update('special', array('child' => $child), "specid='{$special['parentid']}'");
			}
			$message = 'special_column_edit_succeed';
		}
		if($parentid){
			$child = intval(DB::result_first("SELECT COUNT(*) FROM " . DB::table('special') . " WHERE parentid=$parentid"));
			DB::update('special', array('child' => $child), "specid='$parentid'");
		}
		phpcom_cache::updater('special');
		admin_succeed($message, 'm=special&action=column');
	}
}elseif ($action == 'columndel') {
	if(!phpcom_admincp::permission('special_delete')){
		admin_message('action_delete_denied');
	}
	$specid = isset(phpcom::$G['gp_specid']) ? intval(phpcom::$G['gp_specid']) : 0;
	if(!$special = DB::fetch_first("SELECT specid, depth, parentid, child, subject FROM " . DB::table('special') . " WHERE specid='$specid'")){
		admin_message('undefined_action');
	}
	if($special['child']){
		admin_message('special_delete_exist_child');
	}
	$specid = $special['specid'];
	if (!checksubmit(array('submit', 'btnsubmit'))) {
		$msgargs = array(
			'form' => TRUE,
			'submit' => TRUE,
			'cancel' => TRUE,
			'action' => "?m=special&action=columndel&specid=$specid"
		);
		admin_showmessage('special_delete_message', array('title' => $special['subject']), $msgargs);
	}else{
		$parentid = $special['parentid'];
		$topicids = array();
		$query = DB::query("SELECT topicid, specid FROM " . DB::table('topical') . " WHERE specid='$specid'");
		while ($row = DB::fetch_array($query)) {
			$topicids[] = $row['topicid'];
		}
		if($deleteids = implodeids($topicids)){
			$condition = "topicid in($deleteids)";
			DB::delete('topical', $condition);
			DB::delete('topic_data', $condition);
			DB::delete('topic_comment', "tid in($deleteids)");
		}
		DB::delete('special', "specid='$specid'");
		if($parentid){
			$child = intval(DB::result_first("SELECT COUNT(*) FROM " . DB::table('special') . " WHERE parentid=$parentid"));
			DB::update('special', array('child' => $child), 'specid=' . $parentid);
		}
		phpcom_cache::updater('special');
		admin_succeed('special_column_del_succeed', 'm=special&action=column');
	}

}elseif ($action == 'add' || $action == 'edit') {
	$topicid = isset(phpcom::$G['gp_topicid']) ? intval(phpcom::$G['gp_topicid']) : 0;
	$topic = array('topicid' => 0, 'title' => '', 'specid' => 0, 'subname' => '', 'color' => '', 'codename' => '',
			'subject' => '', 'message' => '', 'description' => '', 'keyword' => '', 'tags' => '', 'logo' => '', 
			'banner' => '', 'background' => '', 'template' => '', 'domain' => '', 'tplname' => '',  
			'topline' => 0, 'focus' => 0,'recommend' => 0, 'hits' => 0, 'sortord' => 0);
	if($topicid && !$topic = DB::fetch_first("SELECT * FROM " . DB::table('topical') . " WHERE topicid='$topicid'")){
		admin_message('undefined_action');
	}
	$topicid = intval($topic['topicid']);
	if (!checksubmit(array('submit', 'btnsubmit'))) {
		if($topic['sortord'] < 1){
			$topic['sortord'] = intval(DB::result_first("SELECT MAX(sortord) FROM " . DB::table('topical') . " WHERE 1=1")) + 1;
		}
		$adminhtml->form("m=special&action=$action&topicid=$topicid", array(
				array('topictmpid', 0, 'topictmpid')
		));
		$adminhtml->table_header('special_topic_' . $action, 4);
		$adminhtml->table_td(array(
				array('special_title', FALSE, 'width="15%"', '', TRUE),
				array($adminhtml->textinput('topicnew[title]', $topic['title'], 60), TRUE, 'width="35%"'),
				array('special_select_column', FALSE, 'width="15%"', '', TRUE),
				array(select_special_column($topic['specid'], 'topicnew[specid]', 1), TRUE, 'width="35%"')
		));
		$adminhtml->table_td(array(
				array('special_topic_subname', FALSE, '', '', TRUE),
				array($adminhtml->textinput('topicnew[subname]', $topic['subname'], 15) . ' ~ ' . $adminhtml->textcolor('topicnew[color]', $topic['color'], 15), TRUE),
				array('special_topic_codename', FALSE, '', '', TRUE),
				array($adminhtml->textinput('topicnew[codename]', $topic['codename'], 20), TRUE)
		));
		$adminhtml->table_td(array(
				array('special_topic_logo', FALSE, '', '', TRUE),
				array($adminhtml->textinput('topicnew[logo]', $topic['logo'], 60, null, null, 'special_topic_logo_comments'), TRUE),
				array('special_topic_banner', FALSE, '', '', TRUE),
				array($adminhtml->textinput('topicnew[banner]', $topic['banner'], 50, null, null, 'special_topic_banner_comments'), TRUE)
		));
		$adminhtml->table_td(array(
				array('special_topic_subject', FALSE, '', '', TRUE),
				array($adminhtml->textinput('topicnew[subject]', $topic['subject'], 60, null, null, 'special_topic_subject_comments'), TRUE),
				array('special_topic_tags', FALSE, '', '', TRUE),
				array($adminhtml->textinput('topicnew[tags]', $topic['tags'], 50, null, null, 'special_topic_tags_comments'), TRUE)
		));
		$message = htmlcharsencode($topic['message']);
		$messagetitle = adminlang('special_topic_message_comments');
		$adminhtml->table_td(array(
				array('special_topic_message', FALSE, '', '', TRUE),
				array(sprintf('<textarea wrap="OFF" rows="8" title="%s" name="topicnew[message]" cols="120" class="textarea" style="width:720px;">%s</textarea>', $messagetitle, $message), TRUE, 'colspan="3"')
		));
		$adminhtml->textarea('special_description', $topic['description'], 'topicnew[description]', '', 3, null, null, "width:720px;");
		$adminhtml->table_td(array(
				array('special_keyword', FALSE, '', '', TRUE),
				array($adminhtml->textinput('topicnew[keyword]', $topic['keyword'], 60), TRUE),
				array('special_topic_sortord_hits', FALSE, '', '', TRUE),
				array($adminhtml->textinput('topicnew[sortord]', intval($topic['sortord']), 10) . ' ' .
						$adminhtml->textinput('topicnew[hits]', intval($topic['hits']), 10), TRUE)
		));
		$adminhtml->table_td(array(
				array('special_topic_domain', FALSE, '', '', TRUE),
				array($adminhtml->textinput('topicnew[domain]', $topic['domain'], 60), TRUE),
				//array('special_topic_domain_comments', FALSE, 'colspan="2"', '', 'tips')
				array('special_topic_tplname', FALSE, '', '', TRUE),
				array($adminhtml->textinput('topicnew[tplname]', trim($topic['tplname']), 20), TRUE)
		));
		$othercheckbox = $adminhtml->checkbox(
				array('topline','focus', 'recommend'),
				array('topicnew[topline]', 'topicnew[focus]', 'topicnew[recommend]'),
				array(intval($topic['topline']), intval($topic['focus']), intval($topic['recommend']))
				);
		$othercheckbox .= " <button class=\"button\" type=\"button\" onclick=\"uploadingWindow('topicimage','special',0,$topicid);\"> " . adminlang('imageupload') . " </button>";
		$adminhtml->table_td(array(
				array('special_topic_background', FALSE, '', '', TRUE),
				array($adminhtml->textinput('topicnew[background]', $topic['background'], 60, null, null, 'special_topic_background_comments'), TRUE),
				array('special_other_setting', FALSE, '', '', TRUE),
				array($othercheckbox, TRUE)
		));
		$templatecode = htmlcharsencode($topic['template']);
		$tmmplatetitle = adminlang('special_topic_template_comments');
		$adminhtml->table_td(array(
				array('special_topic_template', FALSE, '', '', TRUE),
				array(sprintf('<textarea wrap="OFF" rows="8" title="%s" name="topicnew[template]" cols="120" class="textarea" style="width:720px;">%s</textarea>', $tmmplatetitle, $templatecode), TRUE, 'colspan="3"')
		));
		$adminhtml->table_td(array(
				array($adminhtml->submit_button(), TRUE, 'align="center" colspan="4"')
		), NULL, FALSE, NULL, NULL, FALSE);
		$adminhtml->table_end('</form>');
	}else{
		$topicnew = phpcom::$G['gp_topicnew'];
		$topicnew['title'] = htmlstrip($topicnew['title']);
		if(empty($topicnew['title'])){
			admin_message('special_title_invalid');
		}
		if(!isset($topicnew['sortord']) && $topicnew['sortord'] < 1){
			$topicnew['sortord'] = intval(DB::result_first("SELECT MAX(sortord) FROM " . DB::table('topical') . " WHERE 1=1")) + 1;
		}
		$topicnew['codename'] = htmlstrip($topicnew['codename']);
		if(empty($topicnew['codename']) || preg_match("/[^\w]/", $topicnew['codename'])){
			$topicnew['codename'] = 'zt' . str_pad($topicnew['sortord'], 4, '0', STR_PAD_LEFT);
		}
		if(!stricmp($topicnew['codename'], $topic['codename'])){
			if(DB::fetch_first("SELECT topicid FROM " . DB::table('topical') . " WHERE codename='{$topicnew['codename']}'")){
				admin_message('special_name_repeated');
			}
		}
		$topicnew['specid'] = intval($topicnew['specid']);
		if($topicnew['specid'] < 1 || !DB::fetch_first("SELECT specid FROM " . DB::table('special') . " WHERE specid='{$topicnew['specid']}'")){
			admin_message('special_column_invalid');
		}
		$topicnew['topline'] = isset($topicnew['topline']) && $topicnew['topline'] ? 1 : 0;
		$topicnew['focus'] = isset($topicnew['focus']) && $topicnew['focus'] ? 1 : 0;
		$topicnew['recommend'] = isset($topicnew['recommend']) && $topicnew['recommend'] ? 1 : 0;
		$topicnew['subject'] = isset($topicnew['subject']) ? trim(strip_tags($topicnew['subject'])) : '';
		$topicnew['message'] = isset($topicnew['message']) ? trim($topicnew['message']) : '';
		$topicnew['tags'] = isset($topicnew['tags']) ? trim(strip_tags($topicnew['tags'])) : '';
		$topicnew['tags'] = '';

		$topicnew['subname'] = htmlstrip($topicnew['subname']);
		if (empty($topicnew['subname'])) {
			$topicnew['subname'] = $topicnew['title'];
		}
		$topicnew['hits'] = intval($topicnew['hits']);
		$fields = array('color' => '', 'description' => '', 'keyword' => '', 'domain' => '');
		foreach ($fields as $k => $v){
			if(isset($topicnew[$k])){
				$topicnew[$k] = htmlstrip($topicnew[$k]);
			}else{
				$topicnew[$k] = $v;
			}
		}
		$message = 'special_topic_add_succeed';
		if($action == 'edit'){
			DB::update('topical', $topicnew, array('topicid' => $topicid));
			$message = 'special_topic_edit_succeed';
		}else{
			$topicnew['dateline'] = TIMESTAMP;
			$topicid = DB::insert('topical', $topicnew, true);
		}
		if($topicid && !empty(phpcom::$G['gp_topictmpid'])){
			$tmpid = intval(phpcom::$G['gp_topictmpid']);
			$images = array();
			$flag = false;
			if($tmpid > 0 && ($tmp = Attachment::getUploadTemp($tmpid))){
				if(!empty($tmp['attachment']) && phpcom::$G['uid'] == $tmp['uid']){
					$images['imageurl'] = $tmp['attachment'];
					$images['thumb'] = $tmp['thumb'];
					$images['remote'] = Attachment::ftpOneUpload($tmp);
					$images['image'] = 1;
					DB::delete('upload_temp', "tmpid='{$tmp['tmpid']}'");
					$flag = true;
				}
			}else{
				$flag = ($tmpid == -1);
			}
			
			if($img = DB::fetch_first("SELECT topicid,remote,thumb,imageurl FROM " . DB::table('topical') . " WHERE topicid='$topicid' LIMIT 1")){
				if(!empty($images)){
					DB::update('topical', $images, "topicid='$topicid'");
				}
				$unlinks = array('dirname' => 'special');
				if($flag && !empty($img['imageurl'])){
					$unlinks['attachment'] = trim($img['imageurl']);
					$unlinks['thumb'] = $img['thumb'];
					$unlinks['remote'] = $img['remote'];
					Attachment::uploadUnlink($unlinks);
				}
			}
		}
		admin_succeed($message, "m=special&action=edit&topicid=$topicid");
	}
}elseif ($action == 'del') {
	if(!phpcom_admincp::permission('special_delete')){
		admin_message('action_delete_denied');
	}
	$topicid = isset(phpcom::$G['gp_topicid']) ? intval(phpcom::$G['gp_topicid']) : 0;
	if(!$topic = DB::fetch_first("SELECT topicid, title FROM " . DB::table('topical') . " WHERE topicid='$topicid'")){
		admin_message('undefined_action');
	}
	$topicid = $topic['topicid'];
	if (!checksubmit(array('submit', 'btnsubmit'))) {
		$msgargs = array(
				'form' => TRUE,
				'submit' => TRUE,
				'cancel' => TRUE,
				'action' => "?m=special&action=del&topicid=$topicid"
		);
		admin_showmessage('special_delete_message', array('title' => $topic['title']), $msgargs);
	}else{
		DB::delete('topical', array('topicid' => $topicid));
		DB::delete('topic_data', array('topicid' => $topicid));
		DB::delete('topic_comment', array('tid' => $topicid));
		admin_succeed('special_delete_succeed', 'm=special');
	}
}elseif ($action == 'select') {
	$topicids = isset(phpcom::$G['gp_topicids']) ? phpcom::$G['gp_topicids'] : null;
	$topicids = explode(',', $topicids);
	$adminhtml->table_header('special_select', 5);
	$adminhtml->table_td(array(
			array('special_select_input', FALSE, 'colspan="5" align="left"')
	), NULL, FALSE, NULL, NULL, FALSE);
	$totalrec = DB::result_first("SELECT COUNT(*) FROM " . DB::table('topical'));
	$pagesize = 100;
	$pagecount = @ceil($totalrec / $pagesize);  //ҳ
	$pagenow = max(1, min($pagecount, intval($page)));
	$pagestart = floor(($pagenow - 1) * $pagesize);
	$sql = DB::buildlimit("SELECT topicid,title,subname FROM " . DB::table('topical') . "
			WHERE 1=1 ORDER BY sortord DESC, topicid DESC", $pagesize, $pagestart);
	$query = DB::query($sql);
	$i = $n = $m = 0;
	while ($row = DB::fetch_array($query)) {
		$topicid = $row['topicid'];
		$m = ($i % 2 == 0) ? 2 : 1;
		if ($i === 0) {
			echo '<tr>';
		}
		if (in_array($topicid, $topicids)) {
			$checked = TRUE;
		} else {
			$checked = FALSE;
		}
		$extra = $checked ? ' checked="checked"' : '';
		echo '<td class="tablerow', $m, '" width="20%" title="'.$row['title'].'">';
		echo '<div class="item' . ($checked ? ' checked' : '') . '"><label class="txt">';
		echo '<input class="checkbox" type="checkbox" id="checkbox_'.$topicid.'" name="topicidnew[]" onclick="topicalAdd(this, \'topicidstr\')" value="'.$topicid.'"'.$extra.' />';
		echo "&nbsp;{$row['subname']}</label></div>";
		echo '</td>';
		$i++;
		if ($i % 5 == 0) {
			echo '</tr>';
			if ($i < $pagesize && $i < $totalrec) {
				echo '<tr>';
			}
		}
	}
	$ii = $i % 5;
	if ($ii > 0) {
		for ($index = 1; $index <= (5 - $ii); $index++) {
			$m = ($index % 2 == 0) ? 2 : 1;
			echo '<td class="tablerow', $m, '" width="20%">&nbsp;</td>';
		}
		echo '</tr>';
	}
	$showpage = '<var class="morePage">' . showpage($pagenow, $pagecount, $pagesize, $totalrec, ADMIN_SCRIPT . "?m=special&action=select") . '</var>';
	$adminhtml->table_td(array(
			array($showpage, TRUE, 'colspan="5" align="right" id="pagecode"')
	), NULL, FALSE, NULL, NULL, FALSE);
	$adminhtml->table_end();
	echo <<<EOT
<style type="text/css">
    html {padding-top:0;}
</style>
<script type="text/javascript">
if($('crumbnav')){
    $('crumbnav').style.display='none';
}
initTopicSelect('topicidstr');
</script>
EOT;
	exit('</body></html>');
}else{
	if (!checksubmit(array('submit', 'btnsubmit'))) {
		$adminhtml->form('m=special');
		$adminhtml->table_header('special');
		$adminhtml->table_td(array(
			array('special_tips', FALSE, 'colspan="5"')
		));
		$adminhtml->table_th(array(
			array('special_id', 'width="10%" align="center" noWrap="noWrap"'),
			array('special_select_column', 'width="15%" class="left"'),
			array('special_topic_sortord', 'width="8%" class="left"'),
			array('special_title', 'width="50%" class="left"'),
			array('operation', 'width="17%"')
		));
		$adminhtml->table_td(array(
				array(' ', TRUE, 'colspan="5" align="left" id="showpage"')
		), NULL, FALSE, NULL, NULL, FALSE);
		$word = isset(phpcom::$G['gp_word']) ? phpcom::$G['gp_word'] : '';
		$specid = isset(phpcom::$G['gp_specid']) ? intval(phpcom::$G['gp_specid']) : 0;
		$condition = '1=1';
		$queryurl = '';
		if ($action == 'search' && $word) {
			$word = str_replace('_', '\_', $word);
			$condition = "t.title LIKE '%$word%'";
			$queryurl = implodeurl(array('action' => 'search', 'word' => $word), '&');
		}
		if ($specid) {
			$queryurl = "&specid=$specid";
			$condition = "t.specid='$specid'";
		}
		// ȡܼ¼
		$totalrec = DB::result_first("SELECT COUNT(*) FROM " . DB::table('topical') . " t WHERE $condition");
		$pagesize = intval(phpcom::$config['admincp']['pagesize']);  // ÿҳС
		$pagecount = @ceil($totalrec / $pagesize);  //ҳ
		$pagenow = max(1, min($pagecount, intval($page)));
		$pagestart = floor(($pagenow - 1) * $pagesize);
		$sql = DB::buildlimit("SELECT t.*,s.specid,s.subject, s.color as colors FROM " . DB::table('topical') . " t
			LEFT JOIN " . DB::table('special') . " s USING(specid)
			WHERE $condition ORDER BY sortord DESC, topicid DESC", $pagesize, $pagestart);
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$edit = '<input type="hidden" name="topicids['.$row['topicid'].']" value="' . $row['topicid'] . '" />';
			$edit .= $adminhtml->edit_word('edit', 'm=special&action=edit&topicid=' . $row['topicid'], ' | ');
			$edit .= $adminhtml->del_word('delete', 'm=special&action=del&topicid=' . $row['topicid'], '', 0);

			$row['color'] = $row['color'] ? ' style="color:' . $row['color'] . '"' : '';
			$row['colors'] = $row['colors'] ? ' style="color:' . $row['colors'] . '"' : '';
			$row['recommend'] = $row['recommend'] ? '<img src="misc/images/icons/recommend.gif" />' : '';
			$row['focus'] = $row['focus'] ? '<img src="misc/images/icons/focus.gif" />' : '';
			$row['topline'] = $row['topline'] ? '<img src="misc/images/icons/topline.gif" />' : '';

			$adminhtml->table_td(array(
					array('<span' . $row['color'] . '>' . $row['topicid'] . '</span>', TRUE, 'align="center" noWrap="noWrap"', '', 'gray'),
					array('<a href="?m=special&specid=' . $row['specid'] . '"' . $row['colors'] . '>' . $row['subject'] . '</a>', TRUE),
					array('<input class="input t5" size="1" name="topicsortord[' . $row['topicid'] . ']" type="text" value="'.$row['sortord'].'" />', TRUE),
					array($adminhtml->inputedit("topictitle[{$row['topicid']}]", $row['title'], 60, 'left') . $row['recommend'] . $row['focus'] . $row['topline'], TRUE),
					array($edit, TRUE, 'align="center"')
			));
		}
		$showpage = '<var class="morePage">' . showpage($pagenow, $pagecount, $pagesize, $totalrec, ADMIN_SCRIPT . "?m=special$queryurl") . '</var>';
		$adminhtml->table_td(array(
				array($showpage, TRUE, 'colspan="5" align="right" id="pagecode"')
		), NULL, FALSE, NULL, NULL, FALSE);
		$adminhtml->table_td(array(
				array('&nbsp;', TRUE),
				array($adminhtml->submit_button(), TRUE, 'colspan="4"')
		), NULL, FALSE, NULL, NULL, FALSE);
		$adminhtml->table_end('</form>');
		$adminhtml->showpagescript();
	}else{
		$topicids = phpcom::$G['gp_topicids'];
		$topictitle = phpcom::$G['gp_topictitle'];
		$topicsortord = phpcom::$G['gp_topicsortord'];
		if($topicids && $topictitle && $topicsortord){
			foreach ($topicids as $topicid => $topic) {
				if($topictitle[$topicid]){
					DB::update('topical', array(
					'title' => htmlstrip($topictitle[$topicid]),
					'sortord' => intval($topicsortord[$topicid])
					), "topicid='$topicid'");
				}
			}
		}
		admin_succeed('special_update_succeed', 'm=special');
	}
}
admin_footer();

function select_special_column($parentid, $name = 'specialnew[parentid]', $isdepth = 0) {
	$specialdata = array();
	$s = '<select class="select t50" name="'.trim($name).'"><option value="0"';
	$s .= $parentid == 0 ? ' SELECTED' : '';
	$s .= '>' . adminlang('special_select_option') . '</option>';
	$sql = "SELECT specid, depth, parentid, subject, child FROM " . DB::table('special') . " WHERE depth".($isdepth ? '>=' : '=')."'0' ORDER BY sortord";
	$query = DB::query($sql);
	while ($row = DB::fetch_array($query)) {
		$specialdata[$row['parentid']][$row['specid']] = $row;
	}
	if(isset($specialdata[0])){
		foreach ($specialdata[0] as $specid => $special){
			if($isdepth && $special['child']){
				$s .= '<option value="0"';
			}else{
				$s .= "<option value=\"$specid\"";
			}
			$s .= $specid == $parentid ? ' SELECTED' : '';
			$s .= ">{$special['subject']}</option>\r\n";
			if(isset($specialdata[$specid])){
				foreach ($specialdata[$specid] as $specid => $special){
					$s .= "<option value=\"$specid\"" . ($specid == $parentid ? ' SELECTED' : '');
					$s .= "> &nbsp; &nbsp;|- {$special['subject']}</option>\r\n";
				}
			}
		}
	}
	$s .= "</select>\r\n";
	return $s;
}

function showcolumnitem(&$adminhtml, &$row, $max=0)
{
	static $index = 0;
	$index++;
	$edit = '<input type="hidden" name="specid['.$row['specid'].']" value="' . $row['specid'] . '" />';
	$edit .= $adminhtml->edit_word('edit', 'm=special&action=columnedit&specid=' . $row['specid'], ' | ');
	$edit .= $adminhtml->del_word('delete', 'm=special&action=columndel&specid=' . $row['specid'], '', 0);
	if ($row['depth'] == 1) {
		if ($index >= $max) {
			$depth = '<i class="tdline1 tdlast"></i>';
		} else {
			$depth = '<i class="tdline1"></i>';
		}
	}else{
		$depth = "<i id=\"toggle_{$row['specid']}\" class=\"toggle hide-icon\" onclick=\"toggle_display('{$row['specid']}')\"></i>";
	}
	$adminhtml->table_td(array(
			array('<em class="tiny"><span' . $row['color'] . '>' . $row['specid'] . '</span></em>', TRUE, 'align="center"'),
			array($depth . '<span class="span-input"><input class="input sortord" size="1" name="sortord[' . $row['specid'] . ']" type="text" value="' . $row['sortord'] . '" />
			<input class="input" size="15" name="subject[' . $row['specid'] . ']" type="text" value="' . htmlcharsencode($row['subject']) . '" /></span>', TRUE),
			array($edit, TRUE)
	), '', FALSE, ' tdborder');
}

function getaleph($input) {
	static $dict = array('A' => 0xB0C4, 'B' => 0xB2C0, 'C' => 0xB4ED, 'D' => 0xB6E9,
			'E' => 0xB7A1, 'F' => 0xB8C0, 'G' => 0xB9FD, 'H' => 0xBBF6, 'J' => 0xBFA5,
			'K' => 0xC0AB, 'L' => 0xC2E7, 'M' => 0xC4C2, 'N' => 0xC5B5, 'O' => 0xC5BD,
			'P' => 0xC6D9, 'Q' => 0xC8BA, 'R' => 0xC8F5, 'S' => 0xCBF9, 'T' => 0xCDD9,
			'W' => 0xCEF3, 'X' => 0xD188, 'Y' => 0xD4D0, 'Z' => 0xD7F9
	);
	$char = $input{0};
	if ($char >= chr(0x81) && $char <= chr(0xfe)) {
		$num = hexdec(bin2hex(substr($input, 0, 2)));
		foreach ($dict as $k => $v) {
			if ($v >= $num) break;
		}
		return $k;
	}else {
		return strtoupper($char);
	}
}
?>