<?php
/**
 * Copyright (c) 2010-2013 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : threads.php  2013-4-15
 */
!defined('IN_ADMINCP') && exit('Access denied');
phpcom::$G['lang']['admin'] = 'misc';

$chanid = isset(phpcom::$G['gp_chanid']) ? intval(phpcom::$G['gp_chanid']) : 0;
$uid = isset(phpcom::$G['gp_uid']) ? intval(phpcom::$G['gp_uid']) : 0;
$current = $action == 'audit' ? 'menu_threads_audit' : '';

$navarray = array(
		array('title' => 'menu_threads', 'url' => "?m=threads&chanid=$chanid", 'name' => 'first'),
		array('title' => 'menu_threads_audit', 'url' => "?m=threads&action=audit&chanid=$chanid&uid=$uid", 'name' => 'audit'),
		array('title' => 'menu_threads_my', 'url' => "?m=threads&chanid=$chanid&uid=" . phpcom::$G['uid'], 'name' => 'my'),
);

admin_header('menu_threads', $current);
$adminhtml = phpcom_adminhtml::instance();
$adminhtml->activetabs('topic');
$adminhtml->navtabs($navarray, $action == 'audit' ? 'audit' : 'first', 'nav_tabs');

if (!checksubmit(array('btnsubmit', 'submit'))) {
	$adminhtml->table_header();
	$adminhtml->table_th(array(
			array('title', 'width="65%" class="left" noWrap="noWrap"'),
			array('adminoption', 'width="15%"'),
			array('dateline', 'width="10%"'),
			array('count', 'width="10%"')
	));
	$adminhtml->table_td(array(
			array(' ', TRUE, 'colspan="4" align="left" id="showpage"')
	), NULL, FALSE, NULL, NULL, FALSE);
	
	$catid = isset(phpcom::$G['gp_catid']) ? intval(phpcom::$G['gp_catid']) : 0;
	$rootid = isset(phpcom::$G['gp_rootid']) ? intval(phpcom::$G['gp_rootid']) : 0;
	$condition = $action == 'audit' ? "status='0'" : "status='1'";
	$queryurl = '';
	if ($catid) {
		$queryurl = "&catid=$catid";
		$condition .= " AND catid=$catid";
	}elseif($rootid){
		$queryurl = "&rootid=$rootid";
		$condition .= " AND rootid=$rootid";
	}elseif($chanid){
		$condition .= " AND chanid='$chanid'";
	}
	if($uid){
		$queryurl = "&uid=$uid";
		$condition .= " AND uid='$uid'";
	}
	$todaytime = strtotime(fmdate(TIMESTAMP, 'Ymd'));
	$page = phpcom::$G['page'];
	
	$count = isset(phpcom::$G['gp_count']) ? intval(phpcom::$G['gp_count']) : 0;
	!$count && $count = DB::result_first("SELECT COUNT(*) FROM " . DB::table('threads') . " WHERE $condition");
	$pagesize = intval(phpcom::$config['admincp']['pagesize']);
	$pagecount = @ceil($count / $pagesize);
	$pagenow = max(1, min($pagecount, intval($page)));
	$pagestart = floor(($pagenow - 1) * $pagesize);
	$pagesql = "INNER JOIN (" . DB::buildlimit("SELECT tid FROM " . DB::table('threads') . " WHERE $condition ORDER BY dateline DESC", $pagesize, $pagestart) . ") AS p USING(tid)";
	$sql = "SELECT t.*,c.basic,c.catname,c.codename,c.prefixurl,c.prefix,f.attachment,f.attachimg
    		FROM " . DB::table('threads') . " t $pagesql
	    	LEFT JOIN " . DB::table('category') . " c USING(catid)
			LEFT JOIN " . DB::table('thread_image') . " f USING(tid)";
	$query = DB::query($sql);
	while ($row = DB::fetch_array($query)) {
		$row['highlight'] = threadhighlight($row['highlight']);
		$tid = $row['tid'];
		$channelid = $row['chanid'];
		if(!isset(phpcom::$G['channel'][$channelid]['modules'])) continue;
		$modules = phpcom::$G['channel'][$channelid]['modules'];
		$row['icons'] = 'txt.gif';
		if(!empty($row['attachimg'])){
			$row['icons'] = 'app.gif';
		}elseif ($row['image']) {
			$row['icons'] = 'thumb.gif';
		}elseif ($row['attached']) {
			$row['icons'] = 'pic.gif';
		}
		if ($row['istop']) {
			$row['icons'] = 'pin.gif';
		}elseif ($row['polled']) {
			$row['icons'] = 'vote.gif';
		}
		$row['weeknew'] = TIMESTAMP - 604800 <= $row['dateline'];
		$row['istoday'] = $row['dateline'] > $todaytime ? 1 : 0;
		if ($row['weeknew']) {
			$row['weeknew'] = '<em class="new">New</em>';
		} else {
			$row['weeknew'] = '';
		}
		$row['recommend'] = $row['recommend'] ? '<img src="misc/images/icons/recommend.gif" />' : '';
		$row['focus'] = $row['focus'] ? '<img src="misc/images/icons/focus.gif" />' : '';
		$row['topline'] = $row['topline'] ? '<img src="misc/images/icons/topline.gif" />' : '';
		$row['digest'] = empty($row['digest']) ? '' : '<img src="misc/images/icons/digest.gif" />';
		$row['auditicon'] = $row['status'] == 1 ? '' : '<a href="?m=article&action=audit&tid='.$tid.'&chanid='.$chanid.'"><img src="misc/images/icons/audit.gif" /></a>';
		
		$urlargs = array('chanid' => $row['chanid'], 'catdir' => $row['codename'], 'tid' => $row['tid'],
				'date' => $row['dateline'], 'cid' => $row['catid'], 'catid' => $row['catid'], 'page' => 1);
		$urlargs['prefix'] = empty($row['prefix']) ? '' : trim($row['prefix']);
		$urlargs['name'] = empty($row['htmlname']) ? '' : trim($row['htmlname']);
		if (empty(phpcom::$G['channel'][$row['chanid']]['domain']) && empty($row['prefixurl'])) {
			$row['domain'] = phpcom::$G['instdir'];
		} elseif(empty($row['prefixurl'])) {
			$row['domain'] = phpcom::$G['channel'][$row['chanid']]['domain'] . '/';
		}else{
			$row['domain'] = $row['prefixurl'] . '/';
		}
		if (empty($row['url'])) {
			$row['url'] = geturl('threadview', $urlargs, $row['domain']);
		}else{
			$row['icons'] = 'link.gif';
		}
		$row['viewurl'] = "?m=$modules&action=view&chanid=$channelid&tid=$tid";
		
		$edit = $adminhtml->edit_word('edit', "m=$modules&action=edit&chanid=$channelid&tid=$tid", ' | ');
		$edit .= $adminhtml->del_word('delete', "m=$modules&action=del&chanid=$channelid&tid=$tid");
		$adminhtml->table_td(array(
				array('<a href="' . $row['url'] .'" target="_blank"><img src="misc/images/icons/' . $row['icons'] . '" /></a> <a class="lst" href="?m=threads&chanid=' . $chanid . '&catid=' . $row['catid'] . '">' . $row['catname'] . '</a>
					&#8226; <a class="lst" href="' . $row['viewurl'] .'"'. $row['highlight'] . '>' . $row['title'] . '</a> ' . $row['recommend'] . $row['digest'] . $row['focus'] . $row['topline'] . $row['auditicon'], TRUE),
				array($edit, TRUE, 'align="center" noWrap="noWrap"'),
				array('<em class="f10">' . fmdate($row['dateline'], 'dt', 'd') . '</em>', TRUE, 'align="center" noWrap="noWrap"'),
				array('<em class="f10">' . $row['hits'] . '</em>', TRUE, 'align="center" noWrap="noWrap"')
		));
	}
	$showpage = '<var class="morePage">' . showpage($pagenow, $pagecount, $pagesize, $count, ADMIN_SCRIPT . "?m=threads&action=$action&chanid=$chanid$queryurl") . '</var>';
	$adminhtml->table_td(array(
			array($showpage, TRUE, 'colspan="4" align="right" id="pagecode"')
	), NULL, FALSE, NULL, NULL, FALSE);
	$adminhtml->table_end();
	$adminhtml->showpagescript();
}else{
	
}
admin_footer();
?>