<?php
/**
 * Copyright (c) 2010-2012 PHPcom - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of PHPcom.
 * This File   : MainAbstract.php  2012-7-25
 */
!defined('IN_PHPCOM') && exit('Access denied');

abstract class Controller_MainAbstract extends WebController
{
	public $regmodule, $registerurl, $loginurl, $memberurl, $attachurl, $specialurl;
	public $submissionurl, $postnewsurl, $postsofturl, $sitemapurl;
	protected $catid = 0, $rootid = 0, $parentid = 0;
	protected $_initialized = false;
	protected $_tagArray = array();

	public function __construct(Web_HttpRequest $request)
	{
		parent::__construct($request);
		$this->regmodule = phpcom::$setting['register']['modname'];
		$this->regmodule = $this->regmodule ? $this->regmodule : 'register';
		$this->chandomain = $this->domain;
	}

	protected function initialize()
	{
		if(!$this->_initialized){
			if (defined('DOMAIN_ENABLED') && empty(phpcom::$setting['absoluteurl'])) {
				$this->domain = $this->website . $this->instdir;
			}

			$this->registerurl = geturl('member', array('action' => $this->regmodule), $this->domain);
			$this->loginurl = geturl('member', array('action' => 'login'), $this->domain);
			$this->memberurl = geturl('member', array('action' => 'index'), $this->domain);
			$parse = parse_url(phpcom::$setting['attachurl']);
			$this->attachurl = !isset($parse['host']) ? $this->domain . phpcom::$setting['attachurl'] : phpcom::$setting['attachurl'];
			$this->specialurl = geturl('index', array('sid' => 0, 'name' => 'index', 'action' => ''), $this->domain, 'special');
			if($this->htmlstatus){
				$this->submissionurl = "{$this->domain}submission.html";
				$this->postnewsurl = "{$this->domain}submission-news.html";
				$this->postsofturl = "{$this->domain}submission-soft.html";
				$this->sitemapurl = "{$this->domain}sitemap.html";
			}else{
				$this->submissionurl = "{$this->domain}index.php?action=submission";
				$this->postnewsurl = "{$this->domain}index.php?action=submission&do=news";
				$this->postsofturl = "{$this->domain}index.php?action=submission&do=soft";
				$this->sitemapurl = "{$this->domain}index.php?action=sitemap";
			}
		}
		$this->_initialized = true;
	}

	final protected function hotAndNewMenu()
	{
		$menus = array();
		$menus['new']['index'] = 1;
		$menus['new']['url'] = geturl('hotnew', array('action' => 'new', 'name' => 'new', 'page' => 1), $this->domain);
		$menus['new']['title'] = lang('common', 'menu_new');
		$menus['hot']['index'] = 2;
		$menus['hot']['url'] = geturl('hotnew', array('action' => 'hot', 'name' => 'hot', 'page' => 1), $this->domain);
		$menus['hot']['title'] = lang('common', 'menu_hot');
		return $menus;
	}

	final protected function hotSearchWord()
	{
		phpcom_cache::load('searchword');
		$searchwordlist = isset(phpcom::$G['cache']['searchword']) ? phpcom::$G['cache']['searchword'] : array();
		return $searchwordlist;
	}

	final protected function getSysCount(array $options = array())
	{
		$name = isset($options['name']) ? trim($options['name']) : null;
		if(!isset(phpcom::$G['cache']['syscount'])){
			phpcom_cache::load('syscount');
		}
		$data = array();
		if(!empty($name) && isset(phpcom::$G['cache']['syscount'][$name])){
			$data = phpcom::$G['cache']['syscount'][$name];
		}else{
			$data = phpcom::$G['cache']['syscount'];
		}
		return $data;
	}

	final protected function fetchChannel(array $options = array())
	{
		$chanid = isset($options['chanid']) ? intval($options['chanid']) : $this->chanid;
		$limit = isset($options['limit']) ? intval($options['limit']) : 0;
		$menu = isset($options['menu']) ? intval($options['menu']) : 1;
		$channels = phpcom::$G['channel'];
		$data = array();$i = 0;
		foreach ($channels as $key => $channel) {
			if (is_numeric($key) && !$channel['closed']) {
				if(!$menu && $channel['type'] == 'menu') continue;
				$i++;
				$channel['index'] = $i;
				$channel['alt'] = $i % 2 == 0 ? 2 : 1;
				$channel['name'] = $channel['channelname'];
				$channel['chanid'] = $channel['channelid'];
				if ($channel['type'] == 'menu') {
					$channel['url'] = $channel['domain'];
					$channel['current'] = '';
				} else {
					$domain = $channel['domain'] ? '' : $channel['codename'];
					$channel['domain'] = $channel['domain'] ? $channel['domain'] . '/' : $this->domain;
					$codename = $channel['type'] == 'system' ? '' : $channel['codename'];
					$channel['url'] = geturl('index', array(
							'module' => $channel['modules'],
							'domain' => $domain,
							'action' => $codename,
							'channel' => $channel['codename'],
							'channelid' => $channel['chanid']
					),$channel['domain'], 'main');
					if ($channel['chanid'] == $chanid) {
						$channel['current'] = 'current';
					} else {
						$channel['current'] = '';
					}
				}
				$data[$channel['chanid']] = $channel;
				if($limit && $i >= $limit){
					break;
				}
			}
		}
		unset($channels);
		return $data;
	}

	final protected function processCategoryRowData(&$category)
	{
		$category['name'] = trim($category['catname']);
		if(!empty($category['color']) && strpos($category['color'], 'style') === false){
			$category['color'] = ' style="color:' . $category['color'] . '"';
		}
		if ($category['caturl']) {
			$category['url'] = $category['caturl'];
		} else {
			if (empty(phpcom::$G['channel'][$category['chanid']]['domain']) && empty($category['prefixurl'])) {
				$category['domain'] = $this->domain;
			} elseif(empty($category['prefixurl'])) {
				$category['domain'] = phpcom::$G['channel'][$category['chanid']]['domain'] . '/';
			}else{
				$category['domain'] = $category['prefixurl'] . '/';
			}
			$urlargs = array('chanid' => $category['chanid'], 'catdir' => $category['codename'],
					'name' => $category['codename'], 'catid' => $category['catid'], 'page' => 1);
				
			if(!empty($category['prefix'])){
				$urlargs['prefix'] = $category['prefix'];
			}
			if(!empty($category['prefixurl']) && $category['basic']){
				$category['url'] = $category['prefixurl'];
			}else{
				$category['url'] = geturl($category['basic'] ? 'category' : 'threadlist', $urlargs, $category['domain']);
			}
			if(!empty($row['imageurl'])){
				if(empty($row['remote'])){
					$row['imageurl'] = $this->attachurl . 'image/' . $row['imageurl'];
				}else{
					$row['imageurl'] = phpcom::$setting['ftp']['attachurl'] . 'image/' . $row['imageurl'];
				}
			}else{
				$row['imageurl'] = '';
			}
		}
	}

	final protected function baseCategory(array $options = array())
	{
		$options += array('chanid' => 0, 'limit' => 10, 'catid' => '', 'default' => 0, 'linked' => 1);
		$chanid = $options['chanid'] ? intval($options['chanid']) : intval($options['default']);
		$catid = trim($options['catid']);
		$limit = intval($options['limit']);
		$linked = intval($options['linked']);
		phpcom_cache::load('category');
		if(!isset(phpcom::$G['cache']['category'])){
			return array();
		}
		$data = $categorys = array();
		$categorys = phpcom::$G['cache']['category'];
		$catids = trim(implodeids($catid, ','), "'");
		$catids = $catids ? explode(',', $catids) : null;
		$i = 0;
		foreach ($categorys as $catid => $category) {
			if(!$catids && (($chanid && $category['chanid'] != $chanid) || ($category['caturl'] && !$linked))){
				continue;
			}elseif($catids){
				if(!in_array($catid, $catids)) continue;
			}
			$this->processCategoryRowData($category);
			$i++;
			$category['index'] = $i;
			$category['alt'] = $i % 2 == 0 ? 2 : 1;
			$data[] = $category;
			if($limit && $i >= $limit){
				break;
			}
		}
		unset($categorys);
		return $data;
	}

	final protected function fullCategory(array $options = array())
	{
		$options += array('default' => 1, 'depth' => 3, 'catid' => '');
		$chanid = isset($options['chanid']) ? intval($options['chanid']) : $this->chanid;
		$chanid = $chanid < 1 ? intval($options['default']) : $chanid;
		$limit = isset($options['limit']) ? intval($options['limit']) : 0;
		$first = isset($options['first']) ? intval($options['first']) : 0;
		$depth = intval($options['depth']);
		$catid = trim($options['catid']);
		phpcom_cache::load("category_$chanid");
		if(!isset(phpcom::$G['cache']["category_$chanid"])){
			return array();
		}
		$data = $urlargs = array();
		$catearray = phpcom::$G['cache']['category_' . $chanid];
		$catids = trim(implodeids($catid, ','), "'");
		$catids = $catids ? explode(',', $catids) : null;
		if(isset($catearray[0])){
			$i = 0;
			foreach ($catearray[0] as $category) {
				if($catids && !in_array($category['catid'], $catids)) continue;
				$i++;
				$this->processCategoryRowData($category);
				$category['index'] = $i;
				$category['alt'] = $i % 2 == 0 ? 2 : 1;
				$data[] = $category;
				if($first && $i >= $first) break;
				if(isset($catearray[$category['catid']]) && $depth >= 1){
					$n = 0;
					foreach ($catearray[$category['catid']] as $category1) {
						$n++;
						$this->processCategoryRowData($category1);
						$category1['index'] = $n;
						$data[] = $category1;
						if($limit && $n >= $limit) break;
						if(isset($catearray[$category1['catid']]) && $depth >= 2){
							foreach ($catearray[$category1['catid']] as $category2) {
								$n++;
								$this->processCategoryRowData($category2);
								$category2['index'] = $n;
								$data[] = $category2;
								if($limit && $n >= $limit) break;
								if(isset($catearray[$category2['catid']]) && $depth >= 3){
									foreach ($catearray[$category2['catid']] as $category3) {
										$n++;
										$this->processCategoryRowData($category3);
										$category3['index'] = $n;
										$data[] = $category3;
										if($limit && $n >= $limit) break;
									}
								}
								if($limit && $n >= $limit) break;
							}
						}
						if($limit && $n >= $limit) break;
					}
				}
			}
		}
		unset($catearray);
		return $data;
	}

	final protected function fetchCategory(array $options = array())
	{
		$options += array('default' => 1, 'rootid' => 0);
		$chanid = isset($options['chanid']) ? intval($options['chanid']) : $this->chanid;
		$chanid = $chanid < 1 ? intval($options['default']) : $chanid;
		$limit = isset($options['limit']) ? intval($options['limit']) : 0;
		$catid = isset($options['catid']) ? intval($options['catid']) : $this->catid;
		$parentid = isset($options['parentid']) ? intval($options['parentid']) : $this->parentid;
		phpcom_cache::load("category_$chanid");
		if(!isset(phpcom::$G['cache']["category_$chanid"])){
			return array();
		}
		$data = $urlargs = $catearray = array();
		$cachecategory = phpcom::$G['cache']["category_$chanid"];
		if(isset($cachecategory[$catid])){
			$catearray = $cachecategory[$catid];
		}elseif(!isset($cachecategory[$catid]) && isset($cachecategory[$parentid])){
			$catearray = $cachecategory[$parentid];
		}else{
			return array();
		}
		$i = 0;
		foreach ($catearray as $key => $category) {
			$this->processCategoryRowData($category);
			$i++;
			$category['index'] = $i;
			$category['alt'] = $i % 2 == 0 ? 2 : 1;
			$data[] = $category;
			if($limit && $i >= $limit){
				break;
			}
		}
		unset($catearray);
		return $data;
	}

	final function fetchCategoryNav(array $options = array())
	{
		static $navData = null;
		if(!empty($navData)) return $navData;
		$chanid = isset($options['chanid']) ? intval($options['chanid']) : $this->chanid;
		$catid = isset($options['catid']) ? intval($options['catid']) : $this->catid;
		$parentid = isset($options['parentid']) ? intval($options['parentid']) : $this->parentid;
		$classid = isset($options['classid']) ? intval($options['classid']) : 0;
		phpcom_cache::load('category_' . $chanid);
		if(!isset(phpcom::$G['cache']['category_' . $chanid])){
			return array();
		}
		$data = $urlargs = array();
		if($catid > 0){
			$cid = $catid;
			$catearray = phpcom::$G['cache']['category_' . $chanid];
			if(isset($catearray[$parentid][$catid]['depth'])){
				$depth = $catearray[$parentid][$catid]['depth'];
				$parentkey = $parentid;
				for($i = $depth; $i >= 0; --$i){
					if(!isset($catearray[$parentkey][$cid])) break;
					$category = $catearray[$parentkey][$cid];
					$parentkey = $category['parentkey'];
					$cid = $category['parentid'];
					$this->processCategoryRowData($category);
					$data = array_merge(array($category['catid'] => $category), $data);
				}
			}
		}
		$name = '';
		if($classid && !isset(phpcom::$G['cache']['thread_class'])){
			phpcom_cache::load('thread_class');
		}
		if($classid && isset(phpcom::$G['cache']['thread_class'][0][$chanid][$classid])){
			$name = phpcom::$G['cache']['thread_class'][0][$chanid][$classid]['name'];
		}
		if($catid && isset(phpcom::$G['cache']['thread_class'][$catid][$classid])){
			$name = phpcom::$G['cache']['thread_class'][$catid][$classid]['name'];
		}
		if($classid && $name){
			$data = array_merge($data, array(array('name' => $name, 'url' => '#')));
		}
		$navData = $data;
		return $navData;
	}

	final function fetchTypeName($tid, $limit = 10, $catid = 0)
	{
		if(!isset(phpcom::$G['cache']['threadclass'])){
			phpcom_cache::load('threadclass');
		}
		$data = array();
		$sql = DB::buildlimit("SELECT classid, catid FROM " . DB::table('thread_class_data') . " WHERE tid='$tid'", $limit);
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			if(!isset(phpcom::$G['cache']['threadclass'][$row['classid']])) continue;
			$types = phpcom::$G['cache']['threadclass'][$row['classid']];
			if (empty(phpcom::$G['channel'][$types['chanid']]['domain']) && empty($types['prefixurl'])) {
				$types['domain'] = $this->domain;
			} elseif(empty($types['prefixurl'])) {
				$types['domain'] = phpcom::$G['channel'][$types['chanid']]['domain'] . '/';
			}else{
				$types['domain'] = $types['prefixurl'] . '/';
			}
				
			$types['url'] = geturl('type', array(
					'chanid' => $types['chanid'],
					'type' => $types['classid'],
					'catid' => $row['catid'],
					'name' => $types['alias'],
					'catdir' => trim($types['codename']),
					'page' => 1
			), $types['domain']);
			$data[] = $types;
		}
		return $data;
	}

	final function fetchThreadClass(array $options = array())
	{
		$options += array('catid' => 0, 'rootid' => 0, 'limit' => 0, 'type' => '',
				'assign' => '0', 'catdir' => '', 'prefix' => '');
		$chanid = isset($options['chanid']) ? intval($options['chanid']) : $this->chanid;
		$catid = intval($options['catid']);
		$rootid = intval($options['rootid']);
		$limit = intval($options['limit']);
		$type = trim($options['type']);
		$assignid = intval($options['assign']);
		$catdir = trim($options['catdir']);
		$prefixurl = trim($options['prefix']);
		if(!isset(phpcom::$G['cache']['thread_class'])){
			phpcom_cache::load('thread_class');
		}
		$data = array();
		$thread_class = array();
		if($chanid && isset(phpcom::$G['cache']['thread_class'][0][$chanid])){
			$thread_class = phpcom::$G['cache']['thread_class'][0][$chanid];
		}
		if($catid && isset(phpcom::$G['cache']['thread_class'][$catid])){
			if($type == '1'){
				$thread_class = array_merge(phpcom::$G['cache']['thread_class'][$catid], $thread_class);
			}else{
				$thread_class = phpcom::$G['cache']['thread_class'][$catid];
			}
		}

		$i = 0;
		foreach($thread_class as $class){
			$i++;
			if($limit && $i > $limit) break;
			$class['index'] = $i;
			$class['alt'] = $i % 2 == 0 ? 2 : 1;
			if(empty($class['catid']) && $assignid){
				$class['catid'] = $assignid;
				$class['codename'] = $catdir;
				$class['prefixurl'] = $prefixurl;
			}
			if (empty(phpcom::$G['channel'][$class['chanid']]['domain']) && empty($class['prefixurl'])) {
				$class['domain'] = $this->domain;
			} elseif(empty($class['prefixurl'])) {
				$class['domain'] = phpcom::$G['channel'][$class['chanid']]['domain'] . '/';
			}else{
				$class['domain'] = $class['prefixurl'] . '/';
			}
				
			$class['url'] = geturl('type', array(
					'chanid' => $class['chanid'],
					'type' => $class['classid'],
					'catid' => $class['catid'],
					'name' => $class['alias'],
					'catdir' => trim($class['codename']),
					'page' => 1
			), $class['domain']);
			$data[] = $class;
		}
		return $data;
	}

	protected function fetchMember(array $options = array())
	{
		$options += array('uid' => 0, 'limit' => 10, 'type' => 0, 'groupid' => 0, 'adminid' => 1,'format' => 'Y-m-d');
		$uid = intval($options['uid']);
		$groupid = trim($options['groupid']);
		$adminid = trim($options['adminid']);
		$limit = intval($options['limit']);
		$format = trim($options['format']);
		$type = trim($options['type']);
		$memberid = isset($options['uid']) ? trim($options['uid']) : null;
		$condition = '1';

		if($groupid && strpos($groupid, ',') && ($groupids = implodeids($groupid))){
			$condition = " m.groupid IN($groupids)";
		}elseif(is_numeric($groupid) && ($groupid = intval($groupid))){
			$condition = " m.groupid='$groupid'";
		}elseif($memberid && ($uids = implodeids($memberid))){
			$condition = " m.uid IN($uids)";
		}
		if(isset($options['status'])){
			$status = intval($options['status']);
			$condition .= " AND m.status='$status'";
		}

		$condition = $uid ? "m.uid='$uid'" : $condition;
		$condition .= $adminid ? " AND m.adminid='0'" : '';

		$orderField = ''; $i = 0; $data = array();
		$typeArray = array('money', 'prestige', 'currency', 'praise', 'threads', 'friends', 'onlinetime', 'answers', 'askings');
		if($type == 'credits'){
			$orderField = "m.credits DESC,";
		}
		if($type && in_array($type, $typeArray)){
			$orderField = "c.$type DESC,";
		}
		$fields = "m.uid, m.username, m.email, m.adminid, m.groupid, m.face, m.gender, m.status, m.emailstatus, m.credits, m.allowadmin, m.regdate,";
		$fields .= "c.money, c.prestige, c.currency, c.praise, c.threads, c.onlinetime, c.friends, c.answers, c.askings";
		$sql = DB::buildlimit("SELECT * FROM " . DB::table('members') . " m
				LEFT JOIN " . DB::table('member_count') . " c USING(uid)
				WHERE $condition ORDER BY $orderField m.uid DESC", $limit);
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$i++;
			$row['date'] = fmdate($row['regdate'], $format);
			$row['url'] = $this->domain . "member.php?action=home&uid=" . $row['uid'];
			$row['title'] = phpcom::$G['usergroup'][$row['groupid']]['grouptitle'];
			$row['stars'] = phpcom::$G['usergroup'][$row['groupid']]['stars'];
			$row['index'] = $i;
			$row['alt'] = $i % 2 == 0 ? 2 : 1;
			$data[] = $row;
		}
		return $data;
	}

	protected function fetchSpecial(array $options = array())
	{
		$options += array('sid' => 0, 'limit' => 10, 'specid' => '');
		$parentid = intval($options['sid']);
		$limit = $options['limit'] ? intval($options['limit']) : 20;
		$specid = trim($options['specid']);
		$data = array();
		if(!isset(phpcom::$G['cache']['special'])){
			phpcom_cache::load('special');
		}
		if(isset(phpcom::$G['cache']['special'][$parentid])){
			$specids = trim(implodeids($specid, ','), "'");
			$specids = $specids ? explode(',', $specids) : null;
			$i = 0;
			foreach(phpcom::$G['cache']['special'][$parentid] as $special){
				if($specids && !in_array($special['specid'], $specids)) continue;
				$i++;
				$special['index'] = $i;
				$special['alt'] = $i % 2 == 0 ? 2 : 1;
				$special['color'] = $special['color'] ? ' style="color: ' . $special['color'] . '"' : '';
				$special['title'] = trim($special['subject']);
				$special['domain'] = $special['domain'] ? trim($special['domain'], "/\\ \t") . '/' : $this->domain;
				$special['url'] = geturl('index', array(
						'sid' => $special['specid'],
						'name' => $special['name']
				), $special['domain'], 'special');
				$data[] = $special;
				if($limit && $i >= $limit){
					break;
				}
			}
		}
		return $data;
	}

	protected function fetchTopical(array $options = array())
	{
		$options += array('sid' => 0, 'top' => '', 'limit' => 10, 'length' => 0, 'ellipsis' => '',
				'image' => 0, 'format' => 'm-d');
		$limit = $options['limit'] ? intval($options['limit']) : 20;
		$length = intval($options['length']);
		$ellipsis = rtrim($options['ellipsis']);
		$isimage = boolval($options['image']);
		$format = trim($options['format']);
		$specialid = trim($options['sid'], ", \r\n\t");
		$data = array();
		$condition = "t.hide='0'";
		$condition .= $isimage ? " AND t.image='1'" : '';
		$orderField = 't.sortord DESC,';
		switch (true) {
			case ($options['top'] == 'hot'):
				$orderField = 't.hits DESC,';
				break;
			case ($options['top'] == 'recommend'):
			case ($options['top'] == 'rcmd'):
				$condition .= " AND t.recommend='1'";
				break;
			case ($options['top'] == 'top'):
			case ($options['top'] == 'topline'):
				$condition .= " AND t.topline='1'";
				break;
			case ($options['top'] == 'slide'):
			case ($options['top'] == 'focus'):
				$condition .= " AND t.focus='1'";
				break;
		}
		if(strpos($specialid, ',')){
			$specids = implodeids($specialid);
			$condition .= $specids ? " AND t.specid IN($specids)" : '';
		}else{
			$specid = intval($specialid);
			$condition .= $specid ? " AND t.specid='$specid'" : '';
		}
		$i = 0;
		$sql = DB::buildlimit("SELECT t.*, s.name,s.depth,s.subject,s.color as colors,s.domain as domains
				FROM " . DB::table('topical') . " t
				LEFT JOIN " . DB::table('special') . " s USING(specid)
				WHERE $condition ORDER BY $orderField t.topicid DESC", $limit);
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$row['color'] = $row['color'] ? ' style="color: ' . $row['color'] . '"' : '';
			$row['colors'] = $row['colors'] ? ' style="color: ' . $row['colors'] . '"' : '';
			$urlargs = array('name' => $row['codename'], 'tid' => $row['topicid'], 'date' => $row['dateline'],
					'sid' => $row['specid'], 'special' => $row['name'],'page' => 1);
			$row['domain'] = $row['domain'] ? $row['domain'] : $row['domains'];
			$row['domain'] = $row['domain'] ? trim($row['domain'], "/\\ \t") . '/' : $this->domain;
			if(!empty($row['prefix'])){
				$urlargs['prefix'] = trim($row['prefix']);
			}
			$row['url'] = geturl('topic', $urlargs, $row['domain'], 'special');
			$row['surl'] = geturl('index', array(
					'sid' => $row['specid'],
					'name' => $row['name']
			), $row['domain'], 'special');
			if($length > 1){
				$row['title'] = strcut($row['title'], $length, $ellipsis);
			}
			$row['dateline'] = fmdate($row['dateline'], $format);
			$row['date'] = $row['dateline'];
			$row['istoday'] = ($row['dateline'] + $this->timeoffset >= $this->todaytime) ? 1 : 0;
			if ($row['istoday']) {
				$row['date'] = '<em class="new">' . $row['dateline'] . '</em>';
			} else {
				$row['date'] = '<em class="old">' . $row['dateline'] . '</em>';
			}

			if(!empty($row['imageurl']) && $row['image']){
				if(empty($row['remote'])){
					$row['imageurl'] = $this->attachurl . 'special/' . $row['imageurl'];
				}else{
					$row['imageurl'] = phpcom::$setting['ftp']['attachurl'] . 'special/' . $row['imageurl'];
				}
				$row['thumburl'] = $row['thumb'] ? generatethumbname($row['imageurl']) : $row['imageurl'];
			}else{
				$row['thumburl'] = $row['imageurl'] = $this->domain . 'misc/images/noimage.jpg';
			}
				
			$i++;
			$row['index'] = $i;
			$row['alt'] = $i % 2 == 0 ? 2 : 1;
			$data[] = $row;
		}

		return $data;
	}

	protected function fetchAnnounce(array $options = array())
	{
		$options += array('limit' => 10, 'length' => 40, 'ellipsis' => '');
		$limit = intval($options['limit']);
		$length = intval($options['length']);
		$ellipsis = trim($options['ellipsis']);
		$format = isset($options['format']) ? trim($options['format']) : '';
		$condition = '1=1';
		if(isset($options['type'])){
			$type = intval($options['type']);
			$condition = "type='$type'";
		}
		$data = array();
		$sql = DB::buildlimit("SELECT aid,title,dateline,author,type,highlight,hits
				FROM " . DB::table('announce') . "
				WHERE $condition ORDER BY aid DESC", $limit);
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$row['highlight'] = $this->threadHighlight($row['highlight']);
			$row['istoday'] = ($row['dateline'] + $this->timeoffset >= $this->todaytime) ? 1 : 0;
			if($format){
				$row['dateline'] = fmdate($row['dateline'], $format);
				$row['date'] = $row['dateline'];
				if ($row['istoday']) {
					$row['date'] = '<em class="new">' . $row['dateline'] . '</em>';
				} else {
					$row['date'] = '<em class="old">' . $row['dateline'] . '</em>';
				}
			}else{
				$row['date'] = '';
			}
			$row['subject'] = htmlcharsencode($row['title']);
			if ($length) {
				$row['title'] = strcut($row['title'], $length, $ellipsis);
			}
			$row['url'] = geturl('hotnew', array('action' => 'announce', 'name' => 'announce', 'page' => $row['aid'], 'aid' => $row['aid']), $this->domain);;
			$data[] = $row;
		}
		return $data;
	}

	protected function formatThread(array $options = array())
	{
		$options += array('limit' => 10, 'length' => 40, 'ellipsis' => '', 'rows' => 5, 'first' => 0,
				'target' => 0, 'start' => '', 'end' => ' ', 'type' => 0);
		$limit = intval($options['limit']);
		$length = intval($options['length']);
		$length = $length > 10 ? $length : 40;
		$rows = intval($options['rows']);
		$first = trim($options['first']);
		$type = intval($options['type']);
		unset($options['type']);
		$start = $options['start'];
		$end = $options['end'] ? $options['end'] : ' ';
		$target = $options['target'] ? ' target="_blank"' : '';
		$format = $ellipsis = '';
		$data = array();
		$i = $n = 0;
		$len = intval($length / 2);
		$strlen = $len;
		$s = '';
		$query = $this->threadList($options, $length, $format, $ellipsis);
		while ($row = DB::fetch_array($query)) {
			$this->processThreadRowData($row, $first && $length && $i == 0 ? $length - 6 : 0);
			$row['highlight'] = str_replace('font-weight:bold;', '', $row['highlight']);
			$l = strlength($row['title']);
			if($first && $i == 0){
				if($n == 0){
					$strlen = $l >= $length - 14 ? $length - 14 : $l;
					if($strlen > $length - 22){
						$first = $n = 0;
					}else{
						$n += $strlen;
					}
					$t = strcut($row['title'], $strlen, '');
					$data[$i]['title'] = "<a$target href=\"{$row['url']}\"{$row['highlight']}>$t</a> ";
					$data[$i]['index'] = 0;
					$data[$i]['alt'] = '';
				}else{
					$strlen = $l >= $length - $n - 16 ? $length - $n - 16 : $l;
					$first = $n = 0;
					$t = strcut($row['title'], $strlen, '');
					$data[$i]['title'] .= "<a$target href=\"{$row['url']}\"{$row['highlight']}>$t</a>";
				}
			}else{
				if($n == 0){
					$i++;
					$strlen = $type ? ($l >= $length ? $length : $l) : ($l >= $len ? $len : $l);
					$data[$i]['title'] = '';
					$data[$i]['index'] = $i;
					$data[$i]['alt'] = $i % 2 == 0 ? 2 : 1;
				}else{
					$strlen = $l >= $length - $n ? $length - $n: $l;
				}
				$class = 'a'.$row['chanid'];
				$t = strcut(trim($row['title']), $strlen, '');
				$data[$i]['title'] .= "$start<a$target href=\"{$row['url']}\"{$row['highlight']} class=\"$class\">$t</a>$end";
				$n += $strlen;
				$n += strlen($start.$end);
				if($n >= $length){
					$n = 0;
					$data[$i]['title'] = trim($data[$i]['title']);
				}

			}
			$data[$i]['name'] = $row['subname'];
			$data[$i]['curl'] = $row['curl'];
			if($n == 0 && $i >= $rows){
				break;
			}
		}
		return $data;
	}

	protected function fetchVideo(array $options = array())
	{
		$options += array('catid' => 0, 'rootid' => 0, 'limit' => 10, 'length' => 0, 'ellipsis' => '',
				'top' => 0, 'image' => 0, 'topicid' => '', 'address' => 0, 'where' => '');
		$chanid = isset($options['chanid']) ? intval($options['chanid']) : 5;
		$limit = intval($options['limit']);
		$limit = $limit ? $limit : 10;
		$rootid = trim($options['rootid'], ", \r\n\t");
		$catid = trim($options['catid'], ", \r\n\t");
		$topicid = trim($options['topicid'], ", \r\n\t");
		$classid = isset($options['classid']) ? trim($options['classid'], ", \r\n\t") : 0;
		$length = intval($options['length']);
		$format = isset($options['format']) ? trim($options['format']) : '';
		$ellipsis = rtrim($options['ellipsis']);
		$isimage = boolval($options['image']);
		$isaddress = boolval($options['address']);
		$where = trim($options['where']);
		if(isset($options['years']) && $options['years']){
			$years = intval($options['years']);
			$where .= " AND m.years='$years'";
		}
		if(isset($options['country']) && $options['country']){
			$country = addslashes($options['country']);
			$where .= " AND m.country='$country'";
		}
		if(isset($options['quality']) && $options['quality']){
			$quality = intval($options['quality']);
			$where .= " AND m.quality='$quality'";
		}
		if(isset($options['type']) && !$options['top']){
			$options['top'] = trim($options['type']);
		}
		$data = $player = array();
		$tablenames = array('tablename' => 'video_thread', 'thread_image' => 'thread_image', 'thread_field' => 'thread_field');
		if($isaddress){
			if(!isset(phpcom::$G['cache']['player'])){
				phpcom_cache::load('player');
			}
			$player = &phpcom::$G['cache']['player'];
			$tablenames['video_address'] = 'video_address';
		}
		$sql = DB::buildlimit($this->getThreadSql($chanid, $rootid, $catid, $topicid, $classid, $options, $isimage, $tablenames, $where), $limit);
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$this->processThreadRowData($row, $length, $format, $ellipsis);
			if(isset($row['address']) && !empty($row['address'])){
				list($address) = explode("\n", $row['address']);
				if(($pos = strpos($address, '$$')) !== false){
					$row['playurl'] = substr($address, $pos + 2);
				}else{
					$row['playurl'] = $address;
				}
				$row['player'] = isset($player[$row['playerid']]) ? $player[$row['playerid']]['name'] : '';
			}
			$data[] = $row;
		}
		return $data;
	}

	protected function getThreadSql($chanid = 0, $rootid = 0, $catid = 0, $topicid = 0, $classid = 0, $options = array(), $isimage = 0, $tables = array(), $where = '', $limit = 10, $order = null)
	{
		$field = $joinTable = '';
		$orderField = "ORDER BY t.dateline DESC";
		$condition = "WHERE t.status='1'";
		//$condition .= $chanid ? " AND t.chanid='$chanid'" : " AND t.chanid>='0'";
		if(!empty($rootid)){
			if(strpos($rootid, ',') && ($rootids = implodeids($rootid))){
				$condition .= " AND t.rootid IN($rootids)";
			}elseif($rootid = intval($rootid)){
				$condition .= " AND t.rootid='$rootid'";
			}
		}elseif(!empty($catid)){
			if(strpos($catid, ',') && ($catids = implodeids($catid))){
				$condition .= " AND t.catid IN($catids)";
			}elseif($catid = intval($catid)){
				$condition .= " AND t.catid='$catid'";
			}
		}else{
			$condition .= $chanid ? " AND t.chanid='$chanid'" : " AND t.chanid>='0'";
		}
		if(!empty($classid)){
			$orderField = "ORDER BY t2.dateline DESC";
		}
		
		switch (trim($options['top'])) {
			case "d": case "w": case "m": case "y":
				$time = maketime($options['top']);
				$condition .= " AND t.dateline>='$time'";
				$orderField = 'ORDER BY t.hits DESC, t.dateline DESC';
				break;
			case "D": case "W": case "M": case "Y":
				$time = maketime(strtolower($options['top']));
				$condition .= " AND t.lastdate>='$time'";
				$orderField = 'ORDER BY t.hits DESC, t.dateline DESC';
				break;
			case "hot":
				$hotminimum = phpcom::$setting['hotminimum'];
				$orderField = 'ORDER BY t.hits DESC, t.dateline DESC';
				$condition .= " AND t.hits>'$hotminimum'";
				break;
			case "recommend": case "rcmd": $condition .= " AND t.recommend='1'";
				break;
			case "topline": case "top": $condition .= " AND t.topline='1'";
				break;
			case "focus": $condition .= " AND t.focus='1'";
				break;
			case "digest": $condition .= " AND t.digest='1'";
				break;
			case "comment": $orderField = 'ORDER BY t.comments DESC';
				break;
			case "vote": $condition .= " AND t.polled='1'";
				break;
			case "voteup": $orderField = '';
				break;
			case "img": $isimage = true;
				break;
			case "yes": case "1":
				$condition .= " AND t.istop='1'";
				$orderField = "ORDER BY t.dateline DESC";
				break;
			default:
				break;
		}

		if(isset($options['topline']) && trim($options['topline']) === '1'){
			$condition .= " AND t.topline='1'";
		}elseif(isset($options['topline']) && trim($options['topline']) === '0'){
			$condition .= " AND t.topline='0'";
		}
		if(isset($options['focus']) && trim($options['focus']) === '1'){
			$condition .= " AND t.focus='1'";
		}elseif(isset($options['focus']) && trim($options['focus']) === '0'){
			$condition .= " AND t.focus='0'";
		}
		if(isset($options['digest']) && trim($options['digest']) === '1'){
			$condition .= " AND t.digest='1'";
		}elseif(isset($options['digest']) && trim($options['digest']) === '0'){
			$condition .= " AND t.digest='0'";
		}
		if(isset($options['recommend']) && trim($options['recommend']) === '1'){
			$condition .= " AND t.recommend='1'";
		}elseif(isset($options['recommend']) && trim($options['recommend']) === '0'){
			$condition .= " AND t.recommend='0'";
		}
		$condition .= $isimage ? " AND t.image='1'" : '';
		if(!empty($options['notid'])){
			$notid = trim($options['notid']);
			if(strpos($notid, ',') && ($notids = implodeids($notid))){
				$condition .= " AND t.tid NOT IN($notids)";
			}elseif($notid = intval($notid)){
				$condition .= " AND t.tid<>'$notid'";
			}
		}
		if($isimage || isset($tables['thread_image'])){
			$field .= ',ti.attachment,ti.remote,ti.thumb,ti.preview,ti.attachimg';
			$joinTable = "LEFT JOIN " . DB::table('thread_image') . " ti USING(tid) ";
		}
		if(trim($options['top']) === 'voteup' || isset($tables['thread_field'])){
			$field .= ',f.voteup,f.votedown,f.voters,f.totalscore,f.credits';
			$joinTable .= "LEFT JOIN " . DB::table('thread_field') . " f USING(tid) ";
			if(trim($options['top']) === 'voteup'){
				$joinTable .= "INNER JOIN (SELECT tid FROM " . DB::table('thread_field') . " ORDER BY voteup DESC LIMIT $limit) AS f2 USING(tid) ";
				$condition = '';
			}
		}
		if(isset($tables['tablename']) && $tables['tablename']){
			$field .= ',m.*';
			$joinTable .= "INNER JOIN " . DB::table($tables['tablename']) . " m ON t.tid=m.tid ";
		}
		if(isset($tables['video_address']) && $tables['video_address']){
			$field .= ',va.playerid,va.caption,va.address';
			$joinTable .= "INNER JOIN " . DB::table('video_address') . " va ON va.tid=t.tid ";
		}
		if(strpos($topicid, ',') && ($topicids = implodeids($topicid))){
			$field .= ',d.topicid';
			$condition .= " AND d.topicid IN($topicids)";
			$joinTable .= "INNER JOIN " . DB::table('topic_data') . " d ON t.tid=d.tid ";
		}elseif(is_numeric($topicid) && $topicid){
			$field .= ',d.topicid';
			$condition .= " AND d.topicid='$topicid'";
			$joinTable .= "INNER JOIN " . DB::table('topic_data') . " d ON t.tid=d.tid ";
		}
		if(!empty($classid)){
			$field .= ',t2.classid';
			if(strpos($classid, ',') && ($classids = implodeids($classid))){
				$condition .= " AND t2.classid IN($classids)";
			}elseif($classid = intval($classid)){
				$condition .= " AND t2.classid='$classid'";
			}
			$joinTable .= "INNER JOIN " . DB::table('thread_class_data') . " t2 ON t.tid=t2.tid ";
		}
		$orderField = $order ? $order : $orderField;
		if($order){
			$condition .= " AND m.chanid='$chanid'";
		}
		$sql = "SELECT t.*,c.depth,c.basic,c.catname,c.subname,c.codename,c.prefixurl,c.prefix,c.caturl,c.target,c.color $field
			FROM " . DB::table('threads') . " t
			LEFT JOIN " . DB::table('category') . " c USING(catid) $joinTable
			$condition $where $orderField";
		return $sql;
	}

	protected function fetchThreadArray(array $options = array())
	{
		$options += array('catid' => 0, 'rootid' => 0, 'limit' => 10, 'length' => 0, 'ellipsis' => '',
				'top' => 0, 'image' => 0, 'topicid' => '', 'where' => '', 'fulltext' => 0);
		$chanid = isset($options['chanid']) ? intval($options['chanid']) : $this->chanid;
		$limit = intval($options['limit']);
		$limit = $limit ? $limit : 10;
		$rootid = trim($options['rootid'], ", \r\n\t");
		$catid = trim($options['catid'], ", \r\n\t");
		$topicid = trim($options['topicid'], ", \r\n\t");
		$classid = isset($options['classid']) ? trim($options['classid'], ", \r\n\t") : 0;
		$length = intval($options['length']);
		$format = isset($options['format']) ? trim($options['format']) : '';
		$ellipsis = rtrim($options['ellipsis']);
		$isimage = boolval($options['image']);
		$fulltext = boolval($options['fulltext']);
		$module = isset($options['module']) ? trim($options['module']) : null;
		if(isset($options['type']) && !$options['top']){
			$options['top'] = trim($options['type']);
		}
		$where = trim($options['where']);
		$order = '';
		$data = array();
		$tableName = $module && isset($this->moduleTables[$module]) ? $this->moduleTables[$module] : null;
		$tableName = $chanid && isset(phpcom::$G['channel'][$chanid]['tablename']) ? phpcom::$G['channel'][$chanid]['tablename'] : $tableName;
		$tablenames = array('tablename' => $tableName, 'thread_image' => 'thread_image', 'thread_field' => 'thread_field');
		if($tableName === 'video_thread' && isset($options['years']) && $options['years']){
			$years = intval($options['years']);
			$where .= " AND m.years='$years'";
			$order = 'ORDER BY m.dateline DESC';
		}
		if($tableName === 'video_thread' && isset($options['country']) && $options['country']){
			$country = addslashes(trim($options['country']));
			$where .= " AND m.country='$country'";
			$order = 'ORDER BY m.dateline DESC';
		}
		if($tableName === 'video_thread' && isset($options['quality']) && $options['quality']){
			$quality = intval($options['quality']);
			$where .= " AND m.quality='$quality'";
			$order = 'ORDER BY m.dateline DESC';
		}
		if($tableName === 'soft_thread' && isset($options['softtype']) && $options['softtype']){
			$softtype = addslashes(trim($options['softtype']));
			$where .= " AND m.softtype='$softtype'";
			$order = 'ORDER BY m.dateline DESC';
		}
		if($tableName === 'soft_thread' && isset($options['license']) && $options['license']){
			$license = addslashes(trim($options['license']));
			$where .= " AND m.license='$license'";
			$order = 'ORDER BY m.dateline DESC';
		}
		if(isset($options['like']) && $options['like']){
			$where .= $this->getRelatedLike($options['like'], $fulltext);
		}
		$i = 0;
		$sql = DB::buildlimit($this->getThreadSql($chanid, $rootid, $catid, $topicid, $classid, $options, $isimage, $tablenames, $where, $limit, $order), $limit);
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$row['index'] = ++$i;
			$row['alt'] = $i % 2 == 0 ? 2 : 1;
			$this->processThreadRowData($row, $length, $format, $ellipsis);
			$data[] = $row;
		}
		return $data;
	}

	protected function threadList(array $options = array(), &$length, &$format, &$ellipsis)
	{
		$options += array('catid' => 0, 'rootid' => 0, 'limit' => 10, 'length' => 0, 'ellipsis' => '',
				'top' => 0, 'module' => '', 'image' => 0, 'field' => 0, 'topicid' => '', 'where' => '');

		$chanid = isset($options['chanid']) ? intval($options['chanid']) : $this->chanid;
		$limit = intval($options['limit']);
		$limit = $limit ? $limit : 10;
		$rootid = trim($options['rootid'], ", \r\n\t");
		$catid = trim($options['catid'], ", \r\n\t");
		$topicid = trim($options['topicid'], ", \r\n\t");
		$classid = isset($options['classid']) ? trim($options['classid'], ", \r\n\t") : 0;
		$length = intval($options['length']);
		$format = isset($options['format']) ? trim($options['format']) : '';
		$ellipsis = rtrim($options['ellipsis']);
		$module = trim($options['module']);
		$isimage = boolval($options['image']);
		$isfield = boolval($options['field']);
		if(isset($options['type']) && !$options['top']){
			$options['top'] = trim($options['type']);
		}
		$where = trim($options['where']);
		$tableName = $module && isset($this->moduleTables[$module]) ? $this->moduleTables[$module] : '';
		$tablenames = array('tablename' => $tableName);
		if($tableName === 'video_thread' && isset($options['years']) && $options['years']){
			$years = intval($options['years']);
			$where .= " AND m.years='$years'";
		}
		if($tableName === 'video_thread' && isset($options['country']) && $options['country']){
			$country = addslashes(trim($options['country']));
			$where .= " AND m.country='$country'";
		}
		if($tableName === 'video_thread' && isset($options['quality']) && $options['quality']){
			$quality = intval($options['quality']);
			$where .= " AND m.quality='$quality'";
		}
		if($tableName === 'soft_thread' && isset($options['softtype']) && $options['softtype']){
			$softtype = addslashes(trim($options['softtype']));
			$where .= " AND m.softtype='$softtype'";
		}
		if($tableName === 'soft_thread' && isset($options['license']) && $options['license']){
			$license = addslashes(trim($options['license']));
			$where .= " AND m.license='$license'";
		}
		if(isset($options['like']) && $options['like']){
			$where .= $this->getRelatedLike($options['like']);
		}
		$sql = DB::buildlimit($this->getThreadSql($chanid, $rootid, $catid, $topicid, $classid, $options, $isimage, $tablenames, $where), $limit);
		return DB::query($sql);
	}

	protected function processThreadRowData(&$row, $length = 0, $format = '', $ellipsis = '')
	{
		$row['color'] = $row['color'] ? ' style="color: ' . $row['color'] . '"' : '';
		$row['target'] = $row['target'] ? ' target="_blank"' : '';
		$row['highlight'] = $this->threadHighlight($row['highlight']);
		$urlargs = array('chanid' => $row['chanid'], 'catdir' => $row['codename'], 'tid' => $row['tid'],
				'catid' => $row['catid'], 'page' => 1, 'date' => $row['dateline']);
		if (empty(phpcom::$G['channel'][$row['chanid']]['domain']) && empty($row['prefixurl'])) {
			$row['domain'] = $this->domain;
		} elseif(empty($row['prefixurl'])) {
			$row['domain'] = phpcom::$G['channel'][$row['chanid']]['domain'] . '/';
		}else{
			$row['domain'] = $row['prefixurl'] . '/';
		}
		if(!empty($row['prefix'])){
			$urlargs['prefix'] = trim($row['prefix']);
		}

		if (empty($row['url'])) {
			$urlargs['name'] = empty($row['htmlname']) ? '' : trim($row['htmlname']);
			$row['url'] = geturl('threadview', $urlargs, $row['domain']);
		}
		if (empty($row['caturl'])) {
			$urlargs['name'] = $row['codename'];
			if(!empty($row['prefixurl']) && $row['basic']){
				$row['curl'] = $row['prefixurl'];
			}else{
				$row['caturl'] = geturl($row['basic']? 'category' : 'threadlist', $urlargs, $row['domain']);
			}
		}
		$row['curl'] = $row['caturl'];
		$row['istoday'] = ($row['dateline'] + $this->timeoffset >= $this->todaytime) ? 1 : 0;
		$row['time'] = $row['dateline'];
		if($format){
			$row['dateline'] = fmdate($row['dateline'], $format);
			$row['date'] = $row['dateline'];
			if ($row['istoday']) {
				$row['date'] = '<em class="new">' . $row['dateline'] . '</em>';
			} else {
				$row['date'] = '<em class="old">' . $row['dateline'] . '</em>';
			}
		}else{
			$row['date'] = '';
		}
		$row['subject'] = htmlcharsencode($row['title']);
		if ($length) {
			$row['title'] = strcut($row['title'], $length, $ellipsis);
		}
		$row['subtitle'] = isset($row['subtitle']) ? trim($row['subtitle']) : '';
		$row['summary'] = isset($row['summary']) ? trim($row['summary']) : '';
		$row['percentup'] = '0.00%';
		$row['scores'] = 0;
		if(isset($row['voteup'])){
			$voteup = intval($row['voteup']);
			$total = $voteup + $row['votedown'];
			$row['percentup'] = ($voteup ? round(($voteup / $total) * 100, 2) : '0.00') . '%';
			$scores = $row['voters'] ? $row['totalscore']  / $row['voters'] : 0;
			$row['scores'] = $scores < 10 ? sprintf( "%01.1f ", $scores) : 10;
		}
		if(phpcom::$G['channel'][$row['chanid']]['modules'] == 'video'){
			$row['purl'] = geturl('play', array(
					'chanid' => $row['chanid'],
					'catdir' => $row['codename'],
					'name' => $row['codename'],
					'tid' => $row['tid'],
					'id' => empty($row['aid']) ? '' : $row['aid'],
					'page' => 1
			), $row['domain']);
		}else{
			$row['purl'] = geturl('preview', array(
					'chanid' => $row['chanid'],
					'catdir' => $row['codename'],
					'name' => $row['codename'],
					'tid' => $row['tid'],
					'page' => 1
			), $row['domain']);
		}
		if(isset($row['attachment']) && $row['image'] == 1){
			$this->processImageRowData($row, phpcom::$G['channel'][$row['chanid']]['modules']);
		}else{
			$row['thumburl'] = $row['previewurl'] = $row['imageurl'] = $this->domain . 'misc/images/noimage.jpg';
			$row['purl'] = $row['url'];
		}
	}

	final protected function processImageRowData(&$row, $modules)
	{
		if(empty($row['attachment'])) $row['attachment'] = $row['attachimg'];
		if($row['remote']){
			$row['imageurl'] = phpcom::$setting['ftp']['attachurl'] . $modules . '/' . $row['attachment'];
		}else{
			if(parse_url($row['attachment'], PHP_URL_SCHEME)){
				$row['imageurl'] = $row['attachment'];
			}else{
				$row['imageurl'] = $this->attachurl . $modules . '/' . $row['attachment'];
			}
		}
		$row['thumburl'] = $row['thumb'] ? generatethumbname($row['imageurl']) : $row['imageurl'];
		if(empty($row['attachimg'])){
			$row['previewurl'] = $row['imageurl'];
		}else{
			if($row['preview']){
				$row['previewurl'] = phpcom::$setting['ftp']['attachurl'] . $modules . '/' . $row['attachimg'];
			}else{
				if(parse_url($row['attachimg'], PHP_URL_SCHEME)){
					$row['previewurl'] = $row['attachimg'];
				}else{
					$row['previewurl'] = $this->attachurl . $modules . '/' . $row['attachimg'];
				}
			}
			if(empty($row['thumburl'])){
				$row['thumburl'] = $row['previewurl'];
			}
		}
	}

	final protected function fetchPersons(array $options = array())
	{
		$options += array('chanid' => 0, 'tid' => 0, 'pid' => 0, 'name' => '', 'limit' => 10, 'type' => 0);
		$limit = intval($options['limit']);
		$chanid = isset($options['chanid']) ? intval($options['chanid']) : $this->chanid;
		$personid = trim($options['pid']);
		$pername = trim($options['name']);
	}
	final protected function fetchComments(array $options = array())
	{
		$options += array('chanid' => 0, 'tid' => 0, 'uid' => 0, 'limit' => 1, 'length' => 0, 'ellipsis' => '',
				'type' => 0, 'rootid' => '', 'catid' => '', 'strlen' => 0);
		$limit = intval($options['limit']);
		$limit = $limit ? $limit : 10;
		$chanid = intval($options['chanid']);
		$tid = intval($options['tid']);
		$uid = intval($options['uid']);
		$rootid = trim($options['rootid'], ", \r\n\t");
		$catid = trim($options['catid'], ", \r\n\t");
		$format = isset($options['format']) ? trim($options['format']) : '';
		$length = intval($options['length']);
		$ellipsis = rtrim($options['ellipsis']);
		$strlength = intval($options['strlen']);
		$data = array();
		$condition = $tid ? "t1.tid='$tid'" : "t1.tid>'0'";
		$condition .= $chanid ? " AND t3.chanid='$chanid'" : '';
		$condition .= $uid ? " AND t1.uid='$uid'" : '';
		if(!empty($rootid)){
			if(strpos($rootid, ',') && ($rootids = implodeids($rootid))){
				$condition .= " AND t3.rootid IN($rootids)";
			}elseif($rootid = intval($rootid)){
				$condition .= " AND t3.rootid='$rootid'";
			}
		}elseif(!empty($catid)){
			if(strpos($catid, ',') && ($catids = implodeids($catid))){
				$condition .= " AND t3.catid IN($catids)";
			}elseif($catid = intval($catid)){
				$condition .= " AND t3.catid='$catid'";
			}
		}
		$orderby = boolval($options['type']) ? 'ORDER BY t1.commentid ASC' : 'ORDER BY t1.lastdate DESC';
		$sql = DB::buildlimit("SELECT t1.*, t2.*, t3.chanid, t3.title, t3.highlight FROM " . DB::table('comments') . " t1
				INNER JOIN " . DB::table('comment_body') . " t2 ON t2.commentid=t1.commentid
				INNER JOIN " . DB::table('threads') . " t3 ON t3.tid=t1.tid
				WHERE $condition AND t2.first='1' AND t2.status='1' $orderby", $limit, 0);
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$row['highlight'] = $this->threadHighlight($row['highlight']);
			$row['content'] = bbcode::output($row['content']);
			if($strlength){
				$row['content'] = strcut(strip_tags($row['content']), $strlength, $ellipsis);
			}
			if ($length) {
				$row['title'] = strcut($row['title'], $length, $ellipsis);
			}
			if($format){
				$row['lastdate'] = fmdate($row['lastdate'], $format);
				$row['dateline'] = fmdate($row['dateline'], $format);
			}
			$row['date'] = $row['lastdate'];
			if ($row['username'] == 'guest') {
				$row['username'] = lang('common', 'guest');
			}
			if ($row['author'] == 'guest') {
				$row['author'] = lang('common', 'guest');
			}
			$row['homeurl'] = $this->domain . "member.php?action=home&uid=" . $row['authorid'];
			$row['url'] = geturl('comment', array('tid' => $row['tid'], 'page' => 1), $this->domain);
			$row['id'] = $row['bodyid'];
			$data[] = $row;
		}
		return $data;
	}

	final protected function topicalComments(array $options = array())
	{
		$options += array('tid' => 0, 'uid' => 0, 'limit' => 1, 'length' => 0, 'ellipsis' => '',
				'type' => 0, 'strlen' => 0, 'specid' => '');
		$limit = intval($options['limit']);
		$limit = $limit ? $limit : 10;
		$tid = intval($options['tid']);
		$uid = intval($options['uid']);
		$specid = trim($options['specid'], ", \r\n\t");
		$format = isset($options['format']) ? trim($options['format']) : '';
		$length = intval($options['length']);
		$ellipsis = rtrim($options['ellipsis']);
		$strlength = intval($options['strlen']);
		$tcondition = $tid ? "t1.tid='$tid'" : "t1.tid>'$tid'";
		$condition = $uid ? " AND t1.uid='$uid'" : '';
		if(!empty($specid)){
			if(strpos($specid, ',') && ($specids = implodeids($specid))){
				$condition .= " AND t2.specid IN($specids)";
			}elseif($specid = intval($specid)){
				$condition .= " AND t2.specid='$specid'";
			}
		}
		$orderby = boolval($options['type']) ? 'ORDER BY t1.commentid ASC' : 'ORDER BY t1.lastdate DESC';
		$data = array();
		$sql = DB::buildlimit("SELECT t1.*, t2.topicid, t2.specid, t2.title, t2.domain FROM " . DB::table('topic_comment') . " t1
				INNER JOIN " . DB::table('topical') . " t2 ON t2.topicid=t1.tid
				WHERE t1.first='1' AND $tcondition AND t1.status='1' $condition $orderby", $limit, 0);
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$row['domain'] = $row['domain'] ? $row['domain'] . '/' : $this->domain;
			$row['content'] = bbcode::output($row['content']);
			if($strlength){
				$row['content'] = strcut(strip_tags($row['content']), $strlength, $ellipsis);
			}
			if ($length) {
				$row['title'] = strcut($row['title'], $length, $ellipsis);
			}
			if($format){
				$row['lastdate'] = fmdate($row['lastdate'], $format);
				$row['dateline'] = fmdate($row['dateline'], $format);
			}
			$row['date'] = $row['lastdate'];
			$row['username'] = $row['lastauthor'] == 'guest' ? lang('common', 'guest') : $row['lastauthor'];
			if ($row['author'] == 'guest') {
				$row['author'] = lang('common', 'guest');
			}
			$row['homeurl'] = $this->domain . "member.php?action=home&uid=" . $row['uid'];
			$row['url'] = geturl('comment', array('tid' => $row['tid'], 'page' => 1), $row['domain'], 'special');
			$row['id'] = $row['commentid'];
			$data[] = $row;
		}
		return $data;
	}

	protected function fetchPollVote(array $options = array()){
		$options += array('tid' => 0, 'limit' => 1, 'length' => 0, 'ellipsis' => '', 'strlen' => 0);
		$limit = intval($options['limit']);
		$limit = $limit ? $limit : 1;
		$tid = intval($options['tid']);
		$length = intval($options['length']);
		$optlength = intval($options['strlen']);
		$ellipsis = rtrim($options['ellipsis']);
		$condition = $tid ? " WHERE tid='$tid'" : '';
		$data = array();
		$i = 0;
		$sql = DB::buildlimit("SELECT * FROM " . DB::table('pollvotes') . $condition, $limit);
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$i++;
			$row['index'] = $i;
			$row['alt'] = $i % 2 == 0 ? 2 : 1;
			$row['title'] = $length ? strcut($row['polltitle'], $length, $ellipsis) : $row['polltitle'];
			$row['pollurl'] = $row['url'] = geturl('vote', array('pid' => $row['pollid'], 'tid' => $row['tid']), $this->domain, 'main');
			$row['ajaxurl'] = $this->domain . "apps/ajax.php?action=pollvotes&tid={$row['tid']}&pollid={$row['pollid']}";
			$row['option'] = $this->polloptions($row['pollid'], $row['checkbox'], $optlength);
			$data[] = $row;
		}
		return $data;
	}

	final protected function showTags($tags) {
		$tagstr = '';
		if ($tags) {
			$tagarray = array_unique(explode("\t", $tags));
			foreach ($tagarray as $value) {
				$tagid = substr($value, 0, strpos($value, ','));
				$tagname = substr($value, strpos($value, ',') + 1);
				$url = geturl('tag', array('tagid' => $tagid, 'name' => rawurlencode($tagname), 'page' => 1), $this->domain);
				$tagstr .= '<a href="' . $url . '">' . $tagname . '</a> ';
			}
		}
		return $tagstr;
	}

	protected function relatedTags(array $options = array())
	{
		$options += array('catid' => 0, 'rootid' => 0, 'limit' => 10, 'length' => 0, 'ellipsis' => '',
				'format' => 'm-d', 'image' => 0, 'tags' => '');
		$tags = trim($options['tags']);
		$chanid = isset($options['chanid']) ? intval($options['chanid']) : 0;
		$limit = intval($options['limit']);
		$limit = $limit ? $limit : 10;
		$rootid = intval($options['rootid']);
		$catid = intval($options['catid']);
		$length = intval($options['length']);
		$format = trim($options['format']);
		$ellipsis = rtrim($options['ellipsis']);
		$isimage = boolval($options['image']);
		$tid = isset($options['tid']) ? intval($options['tid']) : 0;
		$tableName = $chanid && isset(phpcom::$G['channel'][$chanid]['tablename']) ? phpcom::$G['channel'][$chanid]['tablename'] : null;
		$conditions = $chanid ? "t.status='1' AND t.chanid='$chanid'" : "t.status='1'";
		$data = $tids = array();
		$leftTable = '';
		$field = ',c.depth,c.basic,c.catname,c.subname,c.codename,c.prefix,c.caturl,c.target,c.color';
		if($rootid > 0){
			$conditions .= " AND t.rootid='$rootid'";
		}else{
			$conditions .= $catid ? " AND t.catid='$catid'" : '';
		}
		if($isimage){
			$field .= ',ti.attachment,ti.remote,ti.thumb,ti.preview';
			$conditions .= " AND t.attached='2'";
			$leftTable = "LEFT JOIN " . DB::table('thread_image') . " ti USING(tid) ";
		}
		if($tableName){
			$field .= ',m.*';
			$leftTable .= "INNER JOIN " . DB::table($tableName) . " m ON m.tid=t.tid ";
		}
		$tagmd5 = md5($tags.'_'.$chanid);
		if(isset($this->_tagArray[$tagmd5])){
			$tids = $this->_tagArray[$tagmd5];
		}else{
			$tids = $this->getTagByThreadIds($tags, $chanid, $limit, $tid);
		}
		if($tids){
			$conditions .= " AND t.tid IN(".implodeids($tids).")";
			$sql = DB::buildlimit("SELECT t.*$field FROM " . DB::table('threads') . " t
					LEFT JOIN " . DB::table('category') . " c USING(catid) $leftTable
					WHERE $conditions", $limit);
			$query = DB::query($sql);
			$i = 0;
			while ($row = DB::fetch_array($query)) {
				$row['index'] = ++$i;
				$row['alt'] = $i % 2 == 0 ? 2 : 1;
				$this->processThreadRowData($row, $length, $format, $ellipsis);
				$data[] = $row;
			}
		}
		return $data;
	}

	protected function getRelatedLike($keyword, $fulltext = 0)
	{
		$likefield = "t.title LIKE '%{text}%'";
		$fulltext && $likefield .= " OR m.summary LIKE '%{text}%'";
		$field = "($likefield)";
		if($keyword){
			if(preg_match("(AND|\+|&)", $keyword) && !preg_match("(OR|\||,)", $keyword)) {
				$andor = ' AND ';
				$keywordsrch = '1';
				$keyword = preg_replace("/( AND |&| )/is", "+", $keyword);
			} else {
				$andor = ' OR ';
				$keywordsrch = '0';
				$keyword = preg_replace("/( OR |\||,| )/is", "+", $keyword);
			}
			$keyword = str_replace('*', '%', addcslashes($keyword, '%_'));
			foreach(explode('+', $keyword) as $text) {
				$text = trim($text);
				if($text) {
					$keywordsrch .= $andor;
					$keywordsrch .= str_replace('{text}', $text, $field);
				}
			}
			$keyword = " AND ($keywordsrch)";
		}
		return $keyword;
	}

	protected function getTagByThreadIds($tags, $chanid = 0, $limit = 10, $tid = 0)
	{
		$tids = $tagArray = array();
		$condition = '0';
		if(strpos($tags, "\t")){
			$array = array_unique(explode("\t", trim($tags)));
			foreach ($array as $tag) {
				$tagArray[] = substr($tag, 0, strpos($tag, ','));
			}
			if($instr = implodeids($tagArray)){
				$condition = "tagid IN($instr)";
			}
		}else{
			$tagArray = explode(",", trim($tags));
			if($instr = implodein($tagArray)){
				$condition = "tagname IN($instr)";
			}
		}
		$condition .= $chanid ? " AND chanid='$chanid'" : '';
		$sql = DB::buildlimit("SELECT DISTINCT tid FROM " . DB::table('tagdata') . "
				WHERE $condition ORDER BY tid DESC", $limit);
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			if($tid && $tid == $row['tid']) continue;
			$tids[] = $row['tid'];
		}
		return $tids;
	}

	final protected function friendLink($options = array())
	{
		$options += array('limit' => 10, 'type' => 0, 'category' => 0);
		$data = array();
		$chanid = isset($options['chanid']) ? intval($options['chanid']) : -1;
		$limit = intval($options['limit']);
		$type = intval($options['type']);
		$category = intval($options['category']);
		$conditions = " closed='0' AND type='$type' AND category='$category'";
		$conditions .= $chanid === -1 ? '' : " AND chanid='$chanid'";
		$i = 0;
		$sql = DB::buildlimit("SELECT * FROM " . DB::table('friendlinks') . " WHERE $conditions ORDER BY sortord ASC", $limit);
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$row['color'] = $row['color'] ? ' style="color:' . $row['color'] . '"' : '';
			if ($row['expires']) {
				$row['expired'] = $row['expires'] > $this->todaytime ? 0 : 1;
			} else {
				$row['expired'] = 0;
			}
			if (!$row['expired']) {
				$data[] = $row;
			} else {
				DB::update('friendlinks', array('closed' => 1), "linkid='{$row['linkid']}'");
			}
		}
		return $data;
	}

	final protected function fetchAttachment($options = array())
	{
		$options += array('tid' => '', 'chanid' => 0, 'image' => 1, 'limit' => 0);
		$tid = intval($options['tid']);
		$chanid = $options['chanid'] ? intval($options['chanid']) : $this->chanid;
		$image = intval($options['image']);
		$limit = intval($options['limit']);
		$pagemode = isset($options['pagemode']) ? intval($options['pagemode']) : 2;
		$limit = $limit ? " LIMIT $limit" : '';
		if(empty($chanid)){
			$chanid = DB::result_first("SELECT chanid FROM ".DB::table('attachment')." WHERE tid='$tid' LIMIT 1");
		}
		if(empty($chanid) && !isset(phpcom::$G['channel'][$chanid])) return array();
		$domain = $this->chandomain;
		$module = phpcom::$G['channel'][$chanid]['modules'];
		$urlargs = array('chanid' => $chanid, 'tid' => $tid, 'page' => 1);
		$data = array();
		$i = 0;
		$sql = "SELECT attachid, tid, sortord, attachment, description, dateline, thumb, preview, image, remote
				FROM " . DB::table("attachment_$module") . " WHERE tid='$tid' AND image='$image' ORDER BY sortord, attachid$limit";
		$query = DB::query($sql);
		$count = DB::num_rows($query);
		while ($attach = DB::fetch_array($query)) {
			++$i;
			$attach['i'] = $i;
			$attach['count'] = $count;
			$attach['index'] = str_pad($i, 2 , '0', STR_PAD_LEFT);
			$attach['module'] = $module;
			$attach['attachurl'] = ($attach['remote'] ? phpcom::$setting['ftp']['attachurl'] : $this->attachurl) . "$module/";
			$attach['date'] = fmdate($attach['dateline']);
			$attach['src'] = $attach['attachurl'] . $attach['attachment'];
			$urlargs['aid'] = $attach['attachid'];
			if(empty($attach['image'])){
				$attach['url'] = $attach['src'];
				$attach['pageurl'] = $attach['url'];
				$attach['previewurl'] = $attach['thumburl'] = '';
			}else{
				$urlargs['page'] = 1;
				$attach['url'] = geturl('preview', $urlargs, $domain);
				if(empty($pagemode)){
					$attach['pageurl'] = $attach['url'];
				}else{
					$urlargs['page'] = '{%d}';
					$pageurl = geturl('preview', $urlargs, $domain);
					$firsturl = $this->formatPageUrl($pageurl);
					if($i == 1){
						$attach['pageurl'] = str_replace('{%d}', 1, $firsturl);
					}else{
						$attach['pageurl'] = str_replace('{%d}', $i, $pageurl);
					}
				}
				$attach['previewurl'] = $attach['preview'] ? generatethumbname($attach['src'], '_small.jpg') : $attach['src'];
				$attach['thumburl'] = $attach['thumb'] ? generatethumbname($attach['src']) : $attach['previewurl'];
			}
			$data[$i] = $attach;
		}
		return $data;
	}

	final protected function fetchAadverts($options = array())
	{
		$options += array('name' => '', 'cid' => 0);
		$image = isset($options['image']) ? boolval($options['image']) : false;
		$name = trim($options['name']);
		$data = array();
		if(!isset(phpcom::$G['cache']['adcategory'])){
			phpcom_cache::load('adcategory');
		}
		if(isset(phpcom::$G['cache']['adcategory'][$name])){
			$adcategory = &phpcom::$G['cache']['adcategory'][$name];
			$cid = intval($adcategory['cid']);
			$display = intval($adcategory['display']);
			$limit = $display == 1 ? 1 : intval($adcategory['maxads']);
			$limit = $limit ? $limit : 50;
			$width = trim($adcategory['width']);
			$height = trim($adcategory['height']);
			$time = TIMESTAMP;
			$condition = "status='1'";
			$condition .= $image ? " AND type='1'" : '';
			$condition .= " AND (expires='0' OR expires>'$time') AND cid='$cid'";
			$displayorder = $display == 2 && $limit == 1 ? "rand()" : "displayorder ASC";
			$i = 0;
			$sql = DB::buildlimit("SELECT * FROM " . DB::table('adverts') . " WHERE $condition ORDER BY $displayorder", $limit);
			$query = DB::query($sql);
			while ($row = DB::fetch_array($query)) {
				$row['adname'] = $name;
				$row['highlight'] = $this->threadHighlight($row['highlight']);
				$row['color'] = $row['highlight'];
				$row['stylewidth'] = $row['width'] ? 'width:'. $row['width']. (strpos($row['width'], '%') ? '' : 'px').';' : '';
				$row['styleheight'] = $row['height'] ? 'height:'. $row['height']. (strpos($row['height'], '%') ? '' : 'px').';' : '';
				$row['style'] = !$row['stylewidth'] && !$row['styleheight'] ? '' : " style=\"{$row['stylewidth']}{$row['styleheight']}\"";

				if(!empty($row['attached'])){
					$row['attachurl'] = empty($row['remote']) ? $this->attachurl : phpcom::$setting['ftp']['attachurl'];
					$parseurl = parse_url($row['src']);
					$row['src'] = isset($parseurl['host']) ? $row['src'] : $row['attachurl'] .'image/'. $row['src'];
				}else{
					if(!parse_url($row['src'], PHP_URL_SCHEME)){
						$row['src'] = $this->domain . ltrim($row['src'], '/ ');
					}
				}

				$row['thumb'] = $row['src'];
				if($row['type'] == 1 && $row['src']){
					$row['thumb'] = generatethumbname($row['src']);
				}
				$i++;
				$row['index'] = $i;
				$row['alt'] = $i % 2 == 0 ? 2 : 1;
				$data[] = $row;
			}
			if($display == 2 && $limit > 1 && $data){
				shuffle($data);
			}
		}
		return $data;
	}

	final protected function getAdvertise($options = array())
	{
		$name = isset($options['name']) ? trim($options['name']) : 'NoAdvert';
		$ajax = isset($options['ajax']) ? boolval($options['ajax']) : 0;
		$querystring = isset($options['query']) ? '&query='.trim($options['query']) : '';
		if(!isset(phpcom::$G['cache']['adcategory'])){
			phpcom_cache::load('adcategory');
		}
		if(isset(phpcom::$G['cache']['adcategory'][$name])){
			$adcategory = &phpcom::$G['cache']['adcategory'][$name];
			$cid = intval($adcategory['cid']);
			$ctype = intval($adcategory['ctype']);
			if(empty($adcategory['status'])){
				return '';
			}
			if(!$ajax && $ctype == 0){
				$adurl = $this->domain . "apps/misc.php?action=advert&name=$name";
				return "<script type=\"text/javascript\" src=\"$adurl$querystring\"></script>\n";
			}elseif($ctype == 1 || $ajax){
				$ajaxid = "a_$name";
				$ajaxdiv = "<span id=\"$ajaxid\"></span>\n";
				if(isset($options['id']) && $options['id']){
					$ajaxid = trim($options['id']);
					$ajaxdiv = '';
				}
				$adurl = $this->domain . "apps/ajax.php?action=advert&name=$name$querystring";
				return "$ajaxdiv<script type=\"text/javascript\">ajaxget('$adurl', '$ajaxid');</script>\n";
			}else{
				if(isset(phpcom::$G['group']['noadverts']) && phpcom::$G['group']['noadverts']){
					return '';
				}
				$display = intval(phpcom::$G['cache']['adcategory'][$name]['display']);
				$limit = $display == 1 ? 1 : intval(phpcom::$G['cache']['adcategory'][$name]['maxads']);
				$limit = $limit ? $limit : 50;
				$content = $start = $end = '';
				if($limit > 1){
					$start = '<li>';
					$end = '</li>';
				}
				$adverts = $this->fetchAadverts(array('name' => $name));
				foreach ($adverts as $advert) {
					$s = $advert['content'];
					if($advert['type'] == 0){
						$s = "$start<a href=\"{$advert['url']}\"{$advert['highlight']} target=\"_blank\">{$advert['word']}</a>$end";
					}elseif($advert['type'] == 1){
						$s = "$start<a href=\"{$advert['url']}\" target=\"_blank\"><img src=\"{$advert['src']}\"{$advert['style']} /></a>$end";
					}elseif($advert['type'] == 2){
						$s = "$start<object{$advert['style']} data=\"{$advert['src']}\" type=\"application/x-shockwave-flash\">";
						$s .= "<param name=\"src\" value=\"{$advert['src']}\" /></object>$end";
					}else{
						$s = $start.$advert['content'].$end;
					}
					if($name === 'FixedBottomLeft'){
						$html = str_replace(array("'", "\r", "\n"), array("\'", "", ""), $s);
						$content .= "<script type=\"text/javascript\">displayFixedAdLayer('$html', '{$advert['width']}', '{$advert['height']}', 0);</script>";
					}elseif($name === 'FixedBottomRight'){
						$html = str_replace(array("'", "\r", "\n"), array("\'", "", ""), $s);
						$content .= "<script type=\"text/javascript\">displayFixedAdLayer('$html', '{$advert['width']}', '{$advert['height']}', 1);</script>";
					}elseif($name === 'CoupletAdLeft'){
						$html = str_replace(array("'", "\r", "\n"), array("\'", "", ""), $s);
						$content .= "<script type=\"text/javascript\">displayFixedAdLayer('$html', '{$advert['width']}', '{$advert['height']}', 2);</script>";
					}elseif($name === 'CoupletAdRight'){
						$html = str_replace(array("'", "\r", "\n"), array("\'", "", ""), $s);
						$content .= "<script type=\"text/javascript\">displayFixedAdLayer('$html', '{$advert['width']}', '{$advert['height']}', 3);</script>";
					}else{
						$content .= $s;
					}
				}
				return $limit > 1 ? "<ul>$content</ul>" : $content;
			}
		}
		return '';
	}

	public function polloptions($pollid, $checkbox = 0, $length = 0) {
		$pollid = intval($pollid);
		$data = array();
		$i = 0;
		$total = DB::result_first("SELECT SUM(votes) AS total FROM " . DB::table('polloption') . " WHERE pollid='$pollid'");
		$sql = "SELECT * FROM " . DB::table('polloption') . " WHERE pollid='$pollid'";
		$query = DB::query($sql);
		while ($row = DB::fetch_array($query)) {
			$i++;
			if ($checkbox) {
				$row['input'] = '<input type="checkbox" id="polloption_' . $i . '" name="pollanswers[]" value="'.$row['voteid'].'" />';
			} else {
				$row['input'] = '<input type="radio" id="polloption_' . $i . '" name="pollanswers[]" value="'.$row['voteid'].'"' . (($i === 1) ? ' checked="checked"' : '') . '/>';
			}
			$row['index'] = $i;
			$row['alt'] = $i % 2 == 0 ? 2 : 1;
			$row['total'] = $total;
			$row['title'] = $length ? strcut($row['voteoption'], $length, '') : $row['voteoption'];
			$row['width'] = $row['votes'] > 0 ? (@round($row['votes'] * 100 / $total, 2)) . '%' : '1px';
			$row['percent'] = @sprintf("%01.2f", $row['votes'] * 100 / $total);
			$data[] = $row;
		}
		return $data;
	}

}
?>