<?php

/**
 * Copyright (c) 2010-2011  phpcom.cn - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of phpcom.cn.
 * This File   : database.php    2011-7-5 23:50:19
 */
!defined('IN_PHPCOM') && exit('Access denied');

class DB {
    public static $checkaction = TRUE;
    /**
     * ɾ
     * @param string $table 
     * @param mixed $condition 
     * @param int $limit ִ
     * @param int $lp ȼ
     * @return int Ӱ
     */
    public static function delete($table, $condition, $index = 0, $limit = 0, $unbuffered = TRUE) {
        if (empty($condition)) {
            $where = '1';
        } elseif (is_array($condition)) {
            $where = self::implode_field_value($condition, ' AND ');
        } else {
            $where = $condition;
        }
        $sql = "DELETE FROM " . self::table($table, $index) . " WHERE $where" . ($limit ? "LIMIT $limit" : '');
        return self::exec($sql, ($unbuffered ? 'UNBUFFERED' : ''));
    }

    public static function update($table, $data, $condition, $index = 0, $unbuffered = FALSE, $low_priority = FALSE) {
        $sql = self::implode_field_value($data);
        $cmd = "UPDATE" . ($low_priority ? ' LOW_PRIORITY' : '');
        $table = self::table($table, $index);
        $where = '';
        if (empty($condition)) {
            $where = '1';
        } elseif (is_array($condition)) {
            $where = self::implode_field_value($condition, ' AND ');
        } else {
            $where = $condition;
        }
        return self::exec("$cmd $table SET $sql WHERE $where", ($unbuffered ? 'UNBUFFERED' : ''));
    }

    public static function insert($table, $data, $return_insert_id = FALSE, $replace = FALSE, $silent = FALSE, $index = 0) {
        $sql = self::implode_field_value($data);
        $cmd = $replace ? 'REPLACE INTO' : 'INSERT INTO';
        $table = self::table($table, $index);
        $silent = $silent ? 'SILENT' : '';
        $return = self::exec("$cmd $table SET $sql", $silent);
        return $return_insert_id ? self::insert_id() : $return;
    }

    public static function count($table, $condition, $index = 0) {
        if (empty($condition)) {
            $where = '1';
        } elseif (is_array($condition)) {
            $where = self::implode_field_value($condition, ' AND ');
        } else {
            $where = $condition;
        }
        $table = self::table($table, $index);
        $ret = intval(self::result_first("SELECT COUNT(*) AS num FROM $table WHERE $where"));
        return $ret;
    }

    public static function exists($table, $condition = '', $index = 0) {
        if (empty($condition)) {
            $where = '1';
        } elseif (is_array($condition)) {
            $where = self::implode_field_value($condition, ' AND ');
        } else {
            $where = $condition;
        }
        $table = self::table($table, $index);
        $query = self::query("SELECT * FROM $table WHERE $where LIMIT 1");
        $result = self::affected_rows();
        self::free_result($query);
        return $result ? TRUE : FALSE;
    }

    /**
     * ֶSQLѯ
     * @param array $array Ҫϵ
     * @param string $separator ָ
     * @return string ϺSQLѯ impload_sql_query
     */
    public static function implode_field_value($array, $separator = ',') {
        $sql = $comma = '';
        if (is_array($array)) {
            foreach ($array as $k => $v) {
                $sql .= $comma . "`$k`='$v'";
                $comma = $separator;
            }
        } else {
            $sql = $array;
        }
        return $sql;
    }

    /**
     * õǰ׺ı
     * @param string $tablename 
     * @return string ؼǰ׺ı
     */
    public static function table($table, $index = 0) {
        if ($index) {
            $table .= "_$index";
        }
        return self::execute('table_name', $table);
    }

    /**
     * ݿѯ
     * @param string $sql
     * @param string $type
     * @return resource زѯԴID
     */
    public static function query($sql, $type = '') {
        self::check_query($sql);
        return self::execute('query', $sql, $type);
    }

    /**
     * ִһSQL䷵Ӱ
     * @param string $sql SQL
     * @param int $lp ȼȣȼ
     * @return int Ӱ
     */
    public static function exec($sql, $lp = 1) {
        self::check_query($sql);
        return self::execute('exec', $sql, $lp);
    }

    /**
     * ()ؼ¼ݼ
     * @param resource $query SQLѯʶ
     * @return array ӽȡһΪ
     */
    public static function fetch_array($query) {
        return self::execute('fetch_array', $query);
    }

    /**
     * ()
     * @param resource $query SQLѯʶ
     * @return array ӽȡһΪö
     */
    public static function fetch_row($query) {
        return self::execute('fetch_row', $query);
    }

    /**
     * ()ص¼
     * @param string $sql SQLѯ
     * @return string صһ¼
     */
    public static function fetch_first($sql) {
        self::check_query($sql);
        return self::execute('fetch_first', $sql);
    }

    /**
     * ؽһֶεֵ
     * @param resource $query SQLѯʶ
     * @param int $row ָкţкŴ 0 ʼ
     * @return mixed ֵֶʧܣ򷵻 false
     */
    public static function result($query, $row = 0) {
        return self::execute('result', $query, $row);
    }

    /**
     * ȡõһ
     * @param string $sql SQLѯ
     * @return mixed ؽеһԪ
     */
    public static function result_first($sql) {
        self::check_query($sql);
        return self::execute('result_first', $sql);
    }

    /**
     * ȡýеĿ
     * @param resource $query SQLѯʶ
     * @return int ؽеĿ
     */
    public static function num_rows($query) {
        return self::execute('num_rows', $query);
    }

    /**
     * ȡýֶεĿ
     * @param resource $query SQLѯʶ
     * @return int ؽֶεĿ
     */
    public static function num_fields($query) {
        return self::execute('num_fields', $query);
    }

    /**
     * ӽȡϢΪ󷵻
     * @param resource $query SQLѯʶ
     * @return object һֶϢĶ
     */
    public static function fetch_fields($query) {
        return self::execute('fetch_fields', $query);
    }

    /**
     * ȡòѯӰļ¼
     * @return int ӰеĿѯʧܷ -1
     */
    public static function affected_rows() {
        return self::execute('affected_rows');
    }

    /**
     * ͷŽڴ
     * @param resource $query SQLѯʶ
     * @return bool ɹ򷵻 trueʧܣ򷵻 false
     */
    public static function free_result($query) {
        return self::execute('free_result', $query);
    }

    /**
     * ȡһβ¼IDֵ
     * @return int һβ¼IDֵ
     */
    public static function insert_id() {
        return self::execute('insert_id');
    }

    /**
     * ȡǰݿС
     * @return int ݿС
     */
    public static function size() {
        return self::execute('size');
    }

    /**
     * ȡһݿıϢ
     * @return string ıϢ
     */
    public static function error() {
        return self::execute('error');
    }

    /**
     * ȡݿĴ
     * @return int شϢ
     */
    public static function errno() {
        return self::execute('errno');
    }

    /**
     * ȡݿ汾Ϣ
     * @return string ݿ汾Ϣ
     */
    public static function version() {
        return self::execute('version');
    }

    /**
     * رݿ
     * @return bool ɹ򷵻 TRUEʧ򷵻 FALSE
     */
    public static function close() {
        return self::execute('close');
    }

    /**
     * תһַSQLѯ
     * @param string $str Ҫתַ
     * @return string תַ
     */
    public static function escape_string($str) {
        return self::execute('escape_string', $str);
    }
    
    /**
	 * ֹͣSQLϢ
	 * @param string $message
	 * @param string $sql
	 */
	public static function halt($message = '', $sql = '') {
		return self::execute('halt', $message, $sql);
	}
    
    /**
     *  LIMIT ѯ
     * @param string $sql SQL ѯ
     * @param int $offset 
     * @param int $start ʼ
     * @return string LIMIT ѯ
     */
    public static function buildlimit($sql, $offset, $start = 0) {
        $sql .=' LIMIT ' . ($start <= 0 ? '' : (int) $start . ',') . abs($offset);
        //$sql .=' LIMIT ' . (int) $start . ',' . abs($offset);
        return $sql;
    }

    /**
     * ִݿ
     * @param string $command 
     * @param mixed $arg1 һ
     * @param mixed $arg2 
     * @return mixed
     */
    private static function execute($command, $arg1 = '', $arg2 = '') {
        static $db;
        if (empty($db)) $db = self::instance();
        $res = $db->$command($arg1, $arg2);
        return $res;
    }

    /**
     * ʵݿ
     * @return object ݿ
     */
    public static function &instance() {
        static $db;
        if (empty($db)) {
            $dbclass = 'db_' . phpcom::$config['db']['type'];
            $db = new $dbclass();
        }
        return $db;
    }

    public static function check_query($sql) {
        static $status = NULL, $checkcmd = array('SELECT', 'UPDATE', 'INSERT', 'REPLACE', 'DELETE');
        if ($status === NULL) $status = phpcom::$config['security']['query']['status'];
        if ($status) {
            $cmd = trim(strtoupper(substr($sql, 0, strpos($sql, ' '))));
            if (in_array($cmd, $checkcmd)) {
                $test = self::do_query_safe($sql, $cmd);
                if ($test < 1) self::execute('halt', 'db_security_error', $sql);
            }
        }
    }

    private static function do_query_safe($sql, $cmd = '') {
        static $safeconfig = null;
        if ($safeconfig === null) {
            $safeconfig = array(
                'function' => array('load_file', 'hex', 'substring', 'if', 'ord', 'char'),
                'action' => array('unionall', 'uniondistinct', 'unionselect', 'intooutfile', 'intodumpfile'),
                'note' => array('/*', '*/', '#', '--', '"'),
                'afullnote' => phpcom::$config['security']['query']['afullnote'],
                'likehex' => phpcom::$config['security']['query']['likehex']
            );
        }
        $sql = str_replace(array('\\\\', '\\\'', '\\"', '\'\''), '', $sql);
        $mark = $clean = '';
        if (strpos($sql, '/') === FALSE && strpos($sql, '#') === FALSE && strpos($sql, '-- ') === FALSE) {
            $clean = preg_replace("/'(.+?)'/s", '', $sql);
        } else {
            $len = strlen($sql);
            $mark = $clean = '';
            for ($i = 0; $i < $len; $i++) {
                $str = $sql[$i];
                switch ($str) {
                    case '\'':
                        if (!$mark) {
                            $mark = '\'';
                            $clean .= $str;
                        } elseif ($mark == '\'') {
                            $mark = '';
                        }
                        break;
                    case '/':
                        if (empty($mark) && $sql[$i + 1] == '*') {
                            $mark = '/*';
                            $clean .= $mark;
                            $i++;
                        } elseif ($mark == '/*' && $sql[$i - 1] == '*') {
                            $mark = '';
                            $clean .= '*';
                        }
                        break;
                    case '#':
                        if (empty($mark)) {
                            $mark = $str;
                            $clean .= $str;
                        }
                        break;
                    case "\n":
                        if ($mark == '#' || $mark == '--') {
                            $mark = '';
                        }
                        break;
                    case '-':
                        if (empty($mark) && substr($sql, $i, 3) == '-- ') {
                            $mark = '-- ';
                            $clean .= $mark;
                        }
                        break;

                    default:

                        break;
                }
                $clean .= $mark ? '' : $str;
            }
        }

        $clean = preg_replace("/[^a-z0-9_\-\(\)#\*\/\"]+/is", "", strtolower($clean));

        if ($safeconfig['afullnote']) {
            $clean = str_replace('/**/', '', $clean);
        }

        if (is_array($safeconfig['function'])) {
            foreach ($safeconfig['function'] as $fun) {
                if (strpos($clean, $fun . '(') !== FALSE) return '-1';
            }
        }

        if (is_array($safeconfig['action'])) {
            $actconfig = $safeconfig['action'];
            $offset = 0;
            $cmd == 'SELECT' && $offset = strpos($clean, 'where');
            //$offset === FALSE && array_shift($actconfig);
            if($cmd == 'SELECT' && !self::$checkaction){
                unset($actconfig[0], $actconfig[1]);
            }
            foreach ($actconfig as $action) {
                if (strpos($clean, $action, $offset) !== FALSE) return '-3';
            }
        }

        if ($safeconfig['likehex'] && strpos($clean, 'like0x')) {
            return '-2';
        }

        if (is_array($safeconfig['note'])) {
            foreach ($safeconfig['note'] as $note) {
                if (strpos($clean, $note) !== FALSE) return '-4';
            }
        }


        return 1;
    }

}

?>
