<?php

/**
 * Copyright (c) 2010-2011  phpcom.cn - All rights reserved.
 * Our Website : www.phpcom.cn www.phpcom.net www.cnxinyun.com
 * Description : This software is the proprietary information of phpcom.cn.
 * This File   : pdomysql.php    2011-7-5 23:52:43
 */
!defined('IN_PHPCOM') && exit('Access denied');
define('RESULT_TYPE_ASSOC', PDO::FETCH_ASSOC);
define('RESULT_TYPE_NUM', PDO::FETCH_NUM);
define('RESULT_TYPE_BOTH', PDO::FETCH_BOTH);

class db_pdomysql {

	var $version = '';
	var $querycount = 0;
	var $curconn;
	var $query = false;
	var $conn = array();
    var $pconnect = 0;
	var $dbconfig = array();
	var $tablepre = '';
	var $map = array();
	var $dbsize = 0;

	/**
	 * 캯
	 * @param array $config ݿ
	 */
	function __construct($config = null) {
		if (!empty($config)) {
			$this->set_config($config);
		}
	}

	/**
	 * ݿ
	 * @param array $config ݿ
	 */
	function set_config($config) {
		$this->dbconfig = &$config;
		$this->tablepre = $config['1']['tablepre'];
		if (!empty($this->dbconfig['map'])) {
			$this->map = $this->dbconfig['map'];
		}
	}

	/**
	 * õǰ׺ı
	 * @param string $tablename 
	 * @return string ؼǰ׺ı
	 */
	function table_name($tablename) {
		if (!empty($this->map) && !empty($this->map[$tablename])) {
			$id = $this->map[$tablename];
			if (empty($this->conn[$id])) {
				$this->connect($id);
			}
			$this->curconn = $this->conn[$id];
		} else {
			$this->curconn = $this->conn[1];
		}
		return $this->tablepre . $tablename;
	}

	/**
	 * ݿ
	 * @param int $connid ݿID
	 */
	function connect($connid = 1) {
		if (empty($this->dbconfig) || empty($this->dbconfig[$connid])) {
			$this->halt('db_config_notfound');
		}

		$pdodsn = "mysql:host={$this->dbconfig[$connid]['dbhost']};dbname={$this->dbconfig[$connid]['dbname']}";
		$this->conn[$connid] = $this->connection(
						$pdodsn,
						$this->dbconfig[$connid]['dbuser'],
						$this->dbconfig[$connid]['dbpass'],
						$this->dbconfig[$connid]['pconnect'],
						$this->dbconfig[$connid]['charset']
		);
		$this->curconn = $this->conn[$connid];
	}

	/**
	 * һݿ
	 * @param string $pdodsn DSNԴ
	 * @param string $dbuser û
	 * @param string $dbpass û
	 * @param int $pconnect 򿪣־ã
	 * @param string $dbcharset ݿַ
	 * @return PDO һPDOӱʶ
	 */
	function connection($pdodsn, $dbuser, $dbpass, $pconnect, $dbcharset = 'gbk') {
        $this->pconnect = $pconnect;
		try {
			$persistent = $pconnect == '0' ? FALSE : TRUE;
			$conn = new PDO($pdodsn, $dbuser, $dbpass, array(PDO::ATTR_PERSISTENT => $persistent)); //PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES '$dbcharset';",
			$conn->exec("SET NAMES '$dbcharset';");
			$conn->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
			$conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
			//$conn->setAttribute(PDO::ATTR_CASE, PDO::CASE_LOWER);
			$conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			$this->curconn = $conn;
			return $conn;
		} catch (PDOException $e) {
			$this->halt("db_connect_failed");
		}
	}

	/**
	 * ݿѯ
	 * @param string $sql
	 * @param string $method
	 * @return PDO زѯPDO
	 */
	function query($sql, $method = '') {
		try {
			$this->query = $this->curconn->query($sql);
			$this->querycount++;
			return $this->query;
		} catch (PDOException $e) {
			$this->halt("db_query_error", $sql);
		}
	}

	/**
	 * ִһSQL䷵Ӱ
	 * @param string $sql SQL
	 * @param int $lp ȼȣȼ
	 * @return int Ӱ
	 */
	function exec($sql, $lp = 1) {
		if ($lp) {
			$tmpsql6 = substr($sql, 0, 6);
			if (strtoupper($tmpsql6 . 'E') == 'REPLACE') {
				$sql = 'REPLACE LOW_PRIORITY' . substr($sql, 7);
			} else {
				$sql = $tmpsql6 . ' LOW_PRIORITY' . substr($sql, 6);
			}
			return $this->curconn->exec($sql);
		}else{
			return $this->curconn->exec($sql);
		}
	}

	/**
	 * ()ؼ¼
	 * @deprecated   PDO::FETCH_ASSOC==2 PDO::FETCH_NUM==3 PDO::FETCH_BOTH==4 PDO::FETCH_OBJ==5
	 * @param PDO $query PDOѯ
	 * @param int $result_type ؽ
	 * @return array ӽȡһΪ
	 */
	function fetch_array($query, $result_type = PDO::FETCH_ASSOC) {
		$query->setFetchMode(($result_type) ? $result_type : PDO::FETCH_ASSOC);
		return $query->fetch();
	}
	
	function fetchColumn($query, $column_number = 0) {
		return $query->fetchColumn($column_number);
	}
	
	/**
	 * ()
	 * @param resource $query SQLѯʶ
	 * @return array ӽȡһΪö
	 */
	function fetch_row($query) {
		$query->setFetchMode(PDO::FETCH_NUM);
		return $query->fetch();
	}
	
	/**
	 * ()ص¼
	 * @param string $sql SQLѯ
	 * @return string صһ¼
	 */
	function fetch_first($sql, $result_type = PDO::FETCH_ASSOC) {
		$query = $this->query($sql);
		return $this->fetch_array($query, ($result_type) ? $result_type : PDO::FETCH_ASSOC);
	}

	/**
	 * ȡõһ
	 * @param string $sql SQLѯ
	 * @return mixed ؽеһԪ
	 */
	function result_first($sql) {
		return $this->result($this->query($sql), 0);
	}

	/**
	 * ȡòѯӰļ¼
	 * @return int ӰеĿѯʧܷ -1
	 */
	function affected_rows() {
		return $this->query == null ? 0 : $this->query->rowCount();
	}

	/**
	 * ؽһֶεֵ
	 * @param PDO $query PDOѯ
	 * @param int $row ָкţкŴ 0 ʼ
	 * @return mixed ֵֶ
	 */
	function result($query, $row = 0) {
		return $query->fetchColumn($row);
	}

	/**
	 * ȡýеĿ
	 * @param PDO $query PDOѯ
	 * @return int ؽеĿ
	 */
	function num_rows($query) {
		try {
			return $query->rowCount();
		} catch (PDOException $e) {
			return 0;
		}
	}

	/**
	 * ȡýֶεĿ
	 * @param PDO $query PDOѯ
	 * @return int ؽֶεĿ
	 */
	function num_fields($query) {
		try {
			$query = $query->columnCount();
			return $query;
		} catch (PDOException $e) {
			return 0;
		}
	}
    
    /**
     * ӽȡϢΪ󷵻
     * @param resource $query SQLѯʶ
     * @return object һֶϢĶ
     */
    function fetch_fields($query) {
        return NULL;
	}
    
	/**
	 * ͷŽڴ
	 * @param PDO $query PDOѯ
	 * @return bool ɹ򷵻 trueʧܣ򷵻 false
	 */
	function free_result($query) {
        $query->closeCursor();
		$this->query = null;
	}

	/**
	 * ȡһβ¼IDֵ
	 * @return int һβ¼IDֵ
	 */
	function insert_id() {
		$insertid = $this->curconn == null ? 0 : $this->curconn->lastInsertId();
		return $insertid >= 0 ? $insertid : $this->result($this->query('SELECT LAST_INSERT_ID()'));
	}

	/**
	 * ȡǰݿС
	 * @return int ݿС
	 */
	function size() {
		if (!$this->dbsize) {
			$query = $this->query('SHOW TABLE STATUS FROM ' . $this->dbconfig['1']['dbname']);
			while ($table = $this->fetch_array($query)) {
				$this->dbsize += $table['Data_length'] + $table['Index_length'];
			}
		}
		return intval($this->dbsize);
	}

	/**
	 * ȡһݿıϢ
	 * @return string ıϢ
	 */
	function error() {
		$err = $this->curconn->errorInfo();
		$msg = '';
		if (is_array($err)) {
			if ($err['0'] != '00000') {
				$msg = 'SQLSTATE error code: ' . $err['0'];
				$msg .= '<br/>error code: ' . $err['1'];
				$msg .= '<br/>error message: ' . $err['2'];
			}
		}
		return $msg;
	}

	/**
	 * ȡݿĴ
	 * @return int شϢ
	 */
	function errno() {
		return intval($this->curconn->errorCode());
	}

	/**
	 * ȡݿ汾Ϣ
	 * @return string ݿ汾Ϣ
	 */
	function version() {
		if (empty($this->version)) {
			list($version) = explode('-', $this->curconn->getAttribute(constant("PDO::ATTR_SERVER_VERSION")));
			$this->version = $version;
		}
		return $this->version;
	}

	/**
	 * رݿ
	 * @return bool ɹ򷵻 TRUEʧ򷵻 FALSE
	 */
	function close() {
		$this->query = null;
		$this->conn = null;
		return true;
	}

	/**
	 * תһַ  query
	 * @param string $str Ҫתַ
	 * @return string תַ
	 */
	function escape_string($str) {
		$str = $this->curconn->quote($str);
		if (strpos($str, "'") === 0){
			$str = substr($str, 1, -1);
		}
		return $str;
	}

	/**
	 * ֹͣSQLϢ
	 * @param <type> $message
	 * @param <type> $sql
	 */
	function halt($message = '', $sql = '') {
		throw new dbException($message, $sql);
	}
	
	public function __destruct() {
		if ($this->curconn) {
			$this->query = null;
			$this->conn = null;
			$this->curconn = null;
		}
	}
}
?>
