=begin
(c) 2013, Renderiza Studio

Permission to use, copy, modify, and distribute this software for
any purpose and without fee is hereby granted, provided the above
copyright notice appear in all copies.

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

== Information
Author:: Renderiza
Name:: GOSU
Version:: 1.1.1
SU Version:: 2013
Date:: 10/21/2013
Description:: Link components to websites, proxy, layers, scenes, sounds, files and folders.
=end

module RND_Extensions

	module RND_GOSU
		require 'sketchup.rb'
		require 'extensions.rb'

		unless file_loaded?( __FILE__ )
			file_loaded( __FILE__ )
			# Create the extension.
			ext = SketchupExtension.new 'GOSU', 'RND_GOSU/RND_GOSU_menus.rb'

			# Attach some nice info.
			ext.creator     = 'Renderiza'
			ext.version     = '1.1.1'
			ext.copyright   = '2013, Renderiza Studio.'
			ext.description = 'Link components to websites, proxy, layers, scenes, sounds, files and folders.'

			# Register and load the extension on startup.
			Sketchup.register_extension ext, true
		end

	end

end

file_loaded( __FILE__ )