=begin
(c) 2013, Renderiza Studio

Permission to use, copy, modify, and distribute this software for
any purpose and without fee is hereby granted, provided the above
copyright notice appear in all copies.

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

== Information
Author:: Renderiza
Name:: GOSU
Version:: 1.1.1
SU Version:: 2013
Date:: 10/21/2013
Description:: Link components to websites, proxy, layers, scenes, sounds, files and folders.
=end

module RND_Extensions

	module RND_GOSU

		class GOSU
			@@model = Sketchup.active_model
			@@ents = @@model.active_entities
			@@sel_all = @@model.selection
			@@sel = @@model.selection[0]
			@@path = File.dirname(__FILE__)
			@@rnd_gosu = "rnd_gosu.html"
			@@cursors = File.join(@@path, '/Images/Cursor/')
			@@gosu_files = File.join(@@path, '/GOSUFiles/')
			@@gosu_dlg = nil
			@@yesCursor = nil

			def initialize()
				@entities = {}
				@gosu_1_file =  File.join(@@path, @@rnd_gosu)

				if (!@gosu_1_file) then
					UI.messagebox("Cannot find file '#{@@rnd_gosu} in folder '#{@@path}'")
					return
				end

				if @@gosu_dlg == nil
					@@gosu_dlg = UI::WebDialog.new("GOSU v.1.1.1", false, "GOSU v.1.1.1", 210, 480, 70, 95, true)

					@@gosu_dlg.add_action_callback("push_frame") do |d,p|
					push_frame(d,p)
					end
				end

				@@gosu_dlg.set_size(210, 480)
				@@gosu_dlg.set_file(@gosu_1_file)
				@@gosu_dlg.show()
				@@go_su = true
			end #def



			def push_frame(dialog,data)
				@@gosu_dlg.execute_script("document.body.style.zoom = 0.80")
				params = query_to_hash(data)

				if params['add_mult'].to_s == "go"
					@@go_su = true
					@@set_name = false
					@@set_url = false
					@@set_proxy_box = false
					@@set_proxy_cline = false
					@@set_scene = false
					@@set_layer = false
					@@set_sound = false
					@@set_file = false
					@@set_folder = false
					@@set_empty = false
					@@folder_gosu_files = false
				end
				if params['add_mult'].to_s == "name"
					@@go_su = false
					@@set_name = true
					@@set_url = false
					@@set_proxy_box = false
					@@set_proxy_cline = false
					@@set_scene = false
					@@set_layer = false
					@@set_sound = false
					@@set_file = false
					@@set_folder = false
					@@set_empty = false
					@@folder_gosu_files = false
				end
				if params['add_mult'].to_s == "set"
					@@go_su = false
					@@set_name = false
					@@set_url = true
					@@set_proxy_box = false
					@@set_proxy_cline = false
					@@set_scene = false
					@@set_layer = false
					@@set_sound = false
					@@set_file = false
					@@set_folder = false
					@@set_empty = false
					@@folder_gosu_files = false
				end
				if params['add_mult'].to_s == "proxy_box"
					@@go_su = false
					@@set_name = false
					@@set_url = false
					@@set_proxy_box = true
					@@set_proxy_cline = false
					@@set_scene = false
					@@set_layer = false
					@@set_sound = false
					@@set_file = false
					@@set_folder = false
					@@set_empty = false
					@@folder_gosu_files = false
				end
				if params['add_mult'].to_s == "proxy_cline"
					@@go_su = false
					@@set_name = false
					@@set_url = false
					@@set_proxy_box = false
					@@set_proxy_cline = true
					@@set_scene = false
					@@set_layer = false
					@@set_sound = false
					@@set_file = false
					@@set_folder = false
					@@set_empty = false
					@@folder_gosu_files = false
				end
				if params['add_mult'].to_s == "scene"
					@@go_su = false
					@@set_name = false
					@@set_url = false
					@@set_proxy_box = false
					@@set_proxy_cline = false
					@@set_scene = true
					@@set_layer = false
					@@set_sound = false
					@@set_file = false
					@@set_folder = false
					@@set_empty = false
					@@folder_gosu_files = false
				end
				if params['add_mult'].to_s == "layer"
					@@go_su = false
					@@set_name = false
					@@set_url = false
					@@set_proxy_box = false
					@@set_proxy_cline = false
					@@set_scene = false
					@@set_layer = true
					@@set_sound = false
					@@set_file = false
					@@set_folder = false
					@@set_empty = false
					@@folder_gosu_files = false
				end
				if params['add_mult'].to_s == "sound"
					@@go_su = false
					@@set_name = false
					@@set_url = false
					@@set_proxy_box = false
					@@set_proxy_cline = false
					@@set_scene = false
					@@set_layer = false
					@@set_sound = true
					@@set_file = false
					@@set_folder = false
					@@set_empty = false
					@@folder_gosu_files = false
				end
				if params['add_mult'].to_s == "file"
					@@go_su = false
					@@set_name = false
					@@set_url = false
					@@set_proxy_box = false
					@@set_proxy_cline = false
					@@set_scene = false
					@@set_layer = false
					@@set_sound = false
					@@set_file = true
					@@set_folder = false
					@@set_empty = false
					@@folder_gosu_files = false
				end
				if params['add_mult'].to_s == "folder"
					@@go_su = false
					@@set_name = false
					@@set_url = false
					@@set_proxy_box = false
					@@set_proxy_cline = false
					@@set_scene = false
					@@set_layer = false
					@@set_sound = false
					@@set_file = false
					@@set_folder = true
					@@set_empty = false
					@@folder_gosu_files = false
				end
				if params['add_mult'].to_s == "empty"
					@@go_su = false
					@@set_name = false
					@@set_url = false
					@@set_proxy_box = false
					@@set_proxy_cline = false
					@@set_scene = false
					@@set_layer = false
					@@set_sound = false
					@@set_file = false
					@@set_folder = false
					@@set_empty = true
					@@folder_gosu_files = false
				end
				if params['add_mult'].to_s == "gosu_files"
					@@go_su = false
					@@set_name = false
					@@set_url = false
					@@set_proxy_box = false
					@@set_proxy_cline = false
					@@set_scene = false
					@@set_layer = false
					@@set_sound = false
					@@set_file = false
					@@set_folder = false
					@@set_empty = false
					@@folder_gosu_files = true
				end
				###############
				## Click Run ##
				###############
				if params['active'].to_s == "1"
					Sketchup.active_model.select_tool RND_Extensions::RND_GOSU::GOSU.new
					activate = 0
					script = "top.active = " + activate.to_s + ";"
					dialog.execute_script(script)
				end
				#################
				## Click Pause ##
				#################
				if params['pause'].to_s == "1"
					Sketchup.send_action('selectSelectionTool:')
					paused = 0 ;
					script = "top.pause = " + paused.to_s + ";"
					dialog.execute_script(script)
				end
				#################
				## Click Reset ##
				#################
				if params['reset_all'].to_s == "1"
					result = UI.messagebox "Do you want to remove the 'Set:: Attributes' of every component?", MB_YESNOCANCEL ;
					if result == 6 # Yes
						model=Sketchup.active_model
						model.definitions.each{|defn|
							name=defn.name
							puts "Defn Name= "+name
							name.gsub!(/[0-9]+$/,'')
							name='Doh!' if name==''
							defn.instances.each{|inst|
								inst.name=""
								puts "Inst Name= "+name
							}
						}
					end
					resetall = 0
					script = "top.reset_all = " + resetall.to_s + ";"
					dialog.execute_script(script)
				end
				################
				## Click Done ##
				################
				if params['done'].to_s == "1"
					@@close = true
					@@sel_all.clear
					Sketchup.send_action('selectSelectionTool:')
					@@gosu_dlg.close
				end
				dialog.set_on_close{ Sketchup.send_action('selectSelectionTool:') }
			end #def



			def unescape(string)
				if string != nil
					string = string.gsub(/\+/, ' ').gsub(/((?:%[0-9a-fA-F]{2})+)/n) do
						[$1.delete('%')].pack('H*')
					end
				end
				return string
			end #def



			def query_to_hash(query)
				param_pairs = query.split('&')
				param_hash = {}
				for param in param_pairs
					name, value = param.split('=')
					name = unescape(name)
					value = unescape(value)
					param_hash[name] = value
				end
				return param_hash
			end #def



			def onMouseMove(flags,x,y,view)
				###############
				## Best Pick ##
				###############
				ph=view.pick_helper
				ph.do_pick x,y
				@best=ph.best_picked
				#########################
				## Highlight Selection ##
				#########################
				@@sel_all.clear
				if @best.is_a?(Sketchup::ComponentInstance)
				@@sel_all.add(@best)
				end
				if @best.is_a?(Sketchup::ComponentInstance)  
					@name_def = @best.definition.name
					@layer_def = @best.definition.layer
					@name = @best.name
				else
					@name_def = nil
					@layer_def = nil
					@name = nil
				end
				#################
				## Status text ##
				#################
				if @name != "" && @best.is_a?(Sketchup::ComponentInstance)
					Sketchup.set_status_text(@name)
					#view.tooltip = @name
				else
					Sketchup.set_status_text("Left click on top of components.")
				end
				###########
				## Point ##
				###########
				ip1 = view.inputpoint x,y
				@point = ip1.position
				############
				## Cursor ##
				############
				if @name != "" && @best.is_a?(Sketchup::ComponentInstance) 
					cursorpath=File.join(@@cursors, "gosu.png")
					@@yesCursor=UI::create_cursor(cursorpath,0,0)
					def onSetCursor()
						cursor=UI::set_cursor(@@yesCursor)
					end #def
				end
				if @name == "" && @best.is_a?(Sketchup::ComponentInstance) 
					cursorpath=File.join(@@cursors, "none.png")
					@@yesCursor=UI::create_cursor(cursorpath,0,0)
					def onSetCursor()
						cursor=UI::set_cursor(@@yesCursor)
					end #def
				end
				if not @best.is_a?(Sketchup::ComponentInstance) 
					cursorpath=File.join(@@cursors, "empty.png")
					@@yesCursor=UI::create_cursor(cursorpath,0,0)
					def onSetCursor()
						cursor=UI::set_cursor(@@yesCursor)
					end #def
				end
			end #def



			def get_sound_file(title = "Choose a sound file")
				filepath = UI.openpanel( title, "*.wav" )
				if filepath
					@sound = filepath.gsub("\\",'/')
				else
					return nil
				end
			end #def



			def get_file(title = "Choose a file")
				filepath = UI.openpanel( title, "")
				if filepath
					@file = filepath.gsub("\\",'/')
				else
					return nil
				end
			end #def



			def get_folder(title = "Choose a folder")
				filepath = UI.openpanel( title, "" )
				if filepath
					file_path = filepath.gsub("\\",'/')
					@folder = File.dirname(file_path)
				else
					return nil
				end
			end #def



			def onLButtonDown(flags,x,y,view)
				@@sel = @@model.selection[0]
				model = Sketchup.active_model
				pages = model.pages
				layers = model.layers
				view = model.active_view
				refreshed_view = view.refresh
				refreshed_view
				
				if @best.is_a?(Sketchup::ComponentInstance)
					################
					## Set:: Name ##
					################
					if @@set_name == true
						results = inputbox(["Enter Name:"], [@@sel.name], "Set:: NAME")
						return if !results
						@@sel.name = results[0]
					end
					###############
					## Set:: URL ##
					###############
					if @@set_url == true
						results = inputbox(["Enter URL:"], [@@sel.name], "Set:: URL")
						return if !results
						@@sel.name = results[0]
					end
					#####################
					## Set:: PROXY BOX ##
					#####################
					if @@set_proxy_box == true
						model = Sketchup.active_model
						allsel = model.selection
						sel = model.selection[0]
						defm = model.definitions
						defs = sel.definition
						defn = defs.name
						ents = model.active_entities

							if allsel.length and sel.kind_of?(Sketchup::ComponentInstance)
								if defn[-7..-1] != "::proxy"
									proxy = defm[defn + "::proxy"]
									unless proxy
										proxy = defm.add(defn + "::proxy")
										pts = []
										for i in 0..8
											pts.push Geom::Point3d.new((i & 1)!=0 ? defs.bounds.min.x : defs.bounds.max.x,
																		   (i & 2)!=0 ? defs.bounds.min.y : defs.bounds.max.y,
																		   (i & 4)!=0 ? defs.bounds.min.z : defs.bounds.max.z)
										end
										faces = [
										[ pts[0], pts[1], pts[3], pts[2] ],
										[ pts[4], pts[5], pts[7], pts[6] ],
										[ pts[0], pts[1], pts[5], pts[4] ],
										[ pts[3], pts[2], pts[6], pts[7] ],
										[ pts[1], pts[3], pts[7], pts[5] ],
										[ pts[2], pts[0], pts[4], pts[6] ]
										]
										faces.each { |face|
										proxy.entities.add_face( face )
										color=proxy.entities.add_face( face )
										color.material = [255, 101, 101]
										color.back_material = [255, 101, 101]
										}
									end #unless
									# and replace
									model.start_operation("Replace with Proxy")
									allsel.each {|s|
										s.definition = proxy if s.kind_of?(Sketchup::ComponentInstance) and s.definition == defs
									}
									model.commit_operation
								else
									proxy = defs
									defs = defm[proxy.name[0...-7]]
									if defs
										model.start_operation("Replace with Original")
										allsel.each {|s|
											s.definition = defs if s.kind_of?(Sketchup::ComponentInstance) and s.definition == proxy
										}
										model.commit_operation
									end
								end
							end
						end
					#######################
					## Set:: PROXY CLINE ##
					#######################
					if @@set_proxy_cline == true
						model = Sketchup.active_model
						allsel = model.selection
						sel = model.selection[0]
						defm = model.definitions
						defs = sel.definition
						defn = defs.name

						if allsel.length and sel.kind_of?(Sketchup::ComponentInstance)
							if defn[-7..-1] != "::proxy"
								proxy = defm[defn + "::proxy"]
								unless proxy
									proxy = defm.add(defn + "::proxy")
									pts = []
									for i in 0..8
										pts.push Geom::Point3d.new((i & 1)!=0 ? defs.bounds.min.x : defs.bounds.max.x,
																	(i & 2)!=0 ? defs.bounds.min.y : defs.bounds.max.y,
																	(i & 4)!=0 ? defs.bounds.min.z : defs.bounds.max.z)
									end
									faces = [
									[ pts[0], pts[1] ],
									[ pts[1], pts[3] ],
									[ pts[3], pts[2] ],
									[ pts[2], pts[0] ],

									[ pts[4], pts[5] ],
									[ pts[5], pts[7] ],
									[ pts[7], pts[6] ],
									[ pts[6], pts[4] ],

									[ pts[0], pts[4] ],
									[ pts[1], pts[5] ],
									[ pts[2], pts[6] ],
									[ pts[3], pts[7] ]
									]
									faces.each { |face|
									proxy.entities.add_cline( face[0], face[1] )
									}
								end #unless
								#################
								## and replace ##
								#################
								model.start_operation("Replace with Proxy")
								allsel.each {|s|
									s.definition = proxy if s.kind_of?(Sketchup::ComponentInstance) and s.definition == defs
								}
								model.commit_operation
							else
								proxy = defs
								defs = defm[proxy.name[0...-7]]
								if defs
									model.start_operation("Replace with Original")
									allsel.each {|s|
										s.definition = defs if s.kind_of?(Sketchup::ComponentInstance) and s.definition == proxy
									}
									model.commit_operation
								end
							end
						end
					end
					#################
					## Set:: SCENE ##
					#################
					if @@set_scene == true
						results = inputbox(["Enter Scene Name:"], [@@sel.name], "Set:: SCENE")
						return if !results
						@@sel.name = results[0]
						pages.add results[0]
					end
					#################
					## Set:: LAYER ##
					#################
					if @@set_layer == true
						results = inputbox(["Enter Layer Name:"], [@@sel.name], "Set:: LAYER")
						return if !results
						@@sel.name = results[0]
						layers.add results[0]
						layer = Sketchup.active_model.layers.add results[0]
						@@sel.layer = results[0]
					end
					#################
					## Set:: Sound ##
					#################
					if @@set_sound == true
						get_sound_file(title = "Set:: SOUND")
						@best.name = @sound
					end
					#################
					## Set:: Files ##
					#################
					if @@set_file == true
						get_file(title = "Set:: FILES")
						@@sel.name = @file
					end
					##################
					## Set:: Folder ##
					##################
					if @@set_folder == true
						get_folder(title = "Set:: FOLDER")
						@@sel.name = @folder
					end
					#################
					## Set:: Empty ##
					#################
					if @@set_empty == true
						@@sel.name = ""
						UI.beep
					end
					#########################
					## Folder:: Gosu Files ##
					#########################
					if @@folder_gosu_files == true
						UI.openURL(@@gosu_files)
					end
					###################
					#### ::GOSU:: #####
					###################
					if @name == "" && @@go_su == true
						UI.messagebox("Please use the 'Set::' options first before using ::GOSU::")
					else
						if @@go_su == true
							if @@sel.name[-4..-1] != ".wav" #Don't Run if file is "*.wav"
								UI.openURL("#{@@sel.name}")
							end
							################
							## Play Sound ##
							################
							@sound_wav = @name
							if @@sel.name[-4..-1] == ".wav"
								UI.play_sound @sound_wav
							end
							################
							## Go:: Scene ##
							################
							rm1 = @@sel.name
							page_num = 0
							if @@sel.name
								pages.each do |e|
								  if e.name == rm1
									pages.selected_page = model.pages[page_num]
									break
								  end
								  page_num+=1
								end
							end
							################
							## Go:: Layer ##
							################
							if @@sel.name == @@sel.layer.name
								model.active_layer = @@sel.name
							end
						end
					end
				else
					UI.beep
				end
			end #def



			def onLButtonDoubleClick(flags,x,y,view)
				model = Sketchup.active_model
				pages = model.pages
				layers = model.layers
				if @best.is_a?(Sketchup::ComponentInstance)
					############################
					## Isolate Layer On & Off ##
					############################
					layer = []
					layers.each do | layer |
						if layer.visible? == true && layer.name != @@sel.name
							layer.visible = false
						else
							if layer.visible? == false && layer.name != @@sel.name
								layer.visible = true
							end
						end
					end
					#################
					## Set:: PROXY ##
					#################
					if @@set_proxy_box == true || @@set_proxy_cline == true
						model = Sketchup.active_model
						allsel = model.selection
						sel = model.selection[0]
						defm = model.definitions
						defs = sel.definition
						defn = defs.name
						ents = model.active_entities
						instances = []
						ents.each do |e|
							if e.is_a? Sketchup::ComponentInstance
									instances << e
							end
						end
						instances.each do |e|
							if e.definition.name == defn
									allsel.add e
							end
						end
						if allsel.length and sel.kind_of?(Sketchup::ComponentInstance)
							if defn[-7..-1] != "::proxy"
								proxy = defm[defn + "::proxy"]
								unless proxy
									proxy = defm.add(defn + "::proxy")
									pts = []
									for i in 0..8
										pts.push Geom::Point3d.new((i & 1)!=0 ? defs.bounds.min.x : defs.bounds.max.x,
																	(i & 2)!=0 ? defs.bounds.min.y : defs.bounds.max.y,
																	(i & 4)!=0 ? defs.bounds.min.z : defs.bounds.max.z)
									end
									faces = [
									[ pts[0], pts[1], pts[3], pts[2] ],
									[ pts[4], pts[5], pts[7], pts[6] ],
									[ pts[0], pts[1], pts[5], pts[4] ],
									[ pts[3], pts[2], pts[6], pts[7] ],
									[ pts[1], pts[3], pts[7], pts[5] ],
									[ pts[2], pts[0], pts[4], pts[6] ]
									]
									faces.each { |face|
									proxy.entities.add_face( face )
									color=proxy.entities.add_face( face )
									color.material = [255, 101, 101]
									color.back_material = [255, 101, 101]
									}
								end #unless
								#################
								## and replace ##
								#################
								model.start_operation("Set:: Proxy")
								allsel.each {|s|
									s.definition = proxy if s.kind_of?(Sketchup::ComponentInstance) and s.definition == defs
								}
								model.commit_operation
							else
								proxy = defs
								defs = defm[proxy.name[0...-7]]
								if defs
									model.start_operation("No:: Proxy")
									allsel.each {|s|
										s.definition = defs if s.kind_of?(Sketchup::ComponentInstance) and s.definition == proxy
									}
									model.commit_operation
								end
							end
						end
					end	
				end
			end #def

		end #class

	end #module

end #module

file_loaded( File.basename(__FILE__) )